/*
 * Decompiled with CFR 0.152.
 */
package com.tas.wp500.opc_ua_server;

import com.google.common.collect.Lists;
import com.tas.wp500.opc_ua_server.ExampleNamespace;
import com.tas.wp500.opc_ua_server.KeyStoreLoader;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.KeyPair;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.eclipse.milo.opcua.sdk.server.OpcUaServer;
import org.eclipse.milo.opcua.sdk.server.api.config.OpcUaServerConfig;
import org.eclipse.milo.opcua.sdk.server.api.config.OpcUaServerConfigBuilder;
import org.eclipse.milo.opcua.sdk.server.identity.CompositeValidator;
import org.eclipse.milo.opcua.sdk.server.identity.UsernameIdentityValidator;
import org.eclipse.milo.opcua.sdk.server.identity.X509IdentityValidator;
import org.eclipse.milo.opcua.sdk.server.util.HostnameUtil;
import org.eclipse.milo.opcua.stack.core.UaRuntimeException;
import org.eclipse.milo.opcua.stack.core.security.DefaultCertificateManager;
import org.eclipse.milo.opcua.stack.core.security.DefaultTrustListManager;
import org.eclipse.milo.opcua.stack.core.security.SecurityPolicy;
import org.eclipse.milo.opcua.stack.core.transport.TransportProfile;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.enumerated.MessageSecurityMode;
import org.eclipse.milo.opcua.stack.core.types.structured.BuildInfo;
import org.eclipse.milo.opcua.stack.core.util.CertificateUtil;
import org.eclipse.milo.opcua.stack.core.util.NonceUtil;
import org.eclipse.milo.opcua.stack.core.util.SelfSignedCertificateGenerator;
import org.eclipse.milo.opcua.stack.core.util.SelfSignedHttpsCertificateBuilder;
import org.eclipse.milo.opcua.stack.server.EndpointConfiguration;
import org.eclipse.milo.opcua.stack.server.security.DefaultServerCertificateValidator;

public class SimpleServer {
    private static final int TCP_BIND_PORT = 12686;
    private OpcUaServer server;
    private ExampleNamespace exampleNamespace;

    public void init() throws Exception {
        Path securityTempDir = Paths.get(System.getProperty("java.io.tmpdir"), "server", "security");
        Files.createDirectories(securityTempDir, new FileAttribute[0]);
        if (!Files.exists(securityTempDir, new LinkOption[0])) {
            throw new Exception("unable to create security temp dir: " + securityTempDir);
        }
        File pkiDir = securityTempDir.resolve("pki").toFile();
        KeyStoreLoader loader = new KeyStoreLoader().load(securityTempDir);
        DefaultCertificateManager certificateManager = new DefaultCertificateManager(loader.getServerKeyPair(), loader.getServerCertificateChain());
        DefaultTrustListManager trustListManager = new DefaultTrustListManager(pkiDir);
        DefaultServerCertificateValidator certificateValidator = new DefaultServerCertificateValidator(trustListManager);
        KeyPair httpsKeyPair = SelfSignedCertificateGenerator.generateRsaKeyPair(2048);
        SelfSignedHttpsCertificateBuilder httpsCertificateBuilder = new SelfSignedHttpsCertificateBuilder(httpsKeyPair);
        httpsCertificateBuilder.setCommonName(HostnameUtil.getHostname());
        HostnameUtil.getHostnames("0.0.0.0").forEach(httpsCertificateBuilder::addDnsName);
        X509Certificate httpsCertificate = httpsCertificateBuilder.build();
        UsernameIdentityValidator identityValidator = new UsernameIdentityValidator(false, authChallenge -> {
            String username = authChallenge.getUsername();
            String password = authChallenge.getPassword();
            boolean adminOk = "WP500".equals(username) && "wp500@123".equals(password);
            return adminOk;
        });
        X509IdentityValidator x509IdentityValidator = new X509IdentityValidator(c -> true);
        X509Certificate certificate = (X509Certificate)certificateManager.getCertificates().stream().findFirst().orElseThrow(() -> new UaRuntimeException(0x80890000L, "no certificate found"));
        String applicationUri = CertificateUtil.getSanUri(certificate).orElseThrow(() -> new UaRuntimeException(0x80890000L, "certificate is missing the application URI"));
        Set<EndpointConfiguration> endpointConfigurations = this.createEndpointConfigurations(certificate, 12686);
        OpcUaServerConfig serverConfig = ((OpcUaServerConfigBuilder)OpcUaServerConfig.builder().setApplicationUri(applicationUri).setApplicationName(LocalizedText.english("WP500 OPC UA Server")).setEndpoints((Set)endpointConfigurations)).setBuildInfo(new BuildInfo("urn:com:tas:WP500-server", "WP500", "WP500 OPC UA Server", OpcUaServer.SDK_VERSION, "", DateTime.now())).setCertificateManager(certificateManager).setTrustListManager(trustListManager).setCertificateValidator(certificateValidator).setHttpsKeyPair(httpsKeyPair).setHttpsCertificateChain(new X509Certificate[]{httpsCertificate}).setIdentityValidator(new CompositeValidator(identityValidator, x509IdentityValidator)).setProductUri("urn:com:tas:WP500-server").build();
        this.server = new OpcUaServer(serverConfig);
        this.exampleNamespace = new ExampleNamespace(this.server);
        this.exampleNamespace.startup();
    }

    private Set<EndpointConfiguration> createEndpointConfigurations(X509Certificate certificate, int bindPort) {
        LinkedHashSet<EndpointConfiguration> endpointConfigurations = new LinkedHashSet<EndpointConfiguration>();
        ArrayList<String> bindAddresses = Lists.newArrayList();
        bindAddresses.add("0.0.0.0");
        LinkedHashSet<String> hostnames = new LinkedHashSet<String>();
        hostnames.add(HostnameUtil.getHostname());
        hostnames.addAll(HostnameUtil.getHostnames("0.0.0.0"));
        for (String bindAddress : bindAddresses) {
            for (String hostname : hostnames) {
                EndpointConfiguration.Builder builder = EndpointConfiguration.newBuilder().setBindAddress(bindAddress).setHostname(hostname).setCertificate(certificate).addTokenPolicies(OpcUaServerConfig.USER_TOKEN_POLICY_USERNAME, OpcUaServerConfig.USER_TOKEN_POLICY_X509);
                EndpointConfiguration.Builder noSecurityBuilder = builder.copy().setSecurityPolicy(SecurityPolicy.None).setSecurityMode(MessageSecurityMode.None);
                endpointConfigurations.add(SimpleServer.buildTcpEndpoint(noSecurityBuilder, bindPort));
                endpointConfigurations.add(SimpleServer.buildTcpEndpoint(builder.copy().setSecurityPolicy(SecurityPolicy.Basic256Sha256).setSecurityMode(MessageSecurityMode.SignAndEncrypt), bindPort));
                EndpointConfiguration.Builder discoveryBuilder = builder.copy().setSecurityPolicy(SecurityPolicy.None).setSecurityMode(MessageSecurityMode.None);
                endpointConfigurations.add(SimpleServer.buildTcpEndpoint(discoveryBuilder, bindPort));
            }
        }
        return endpointConfigurations;
    }

    private static EndpointConfiguration buildTcpEndpoint(EndpointConfiguration.Builder base, int bindPort) {
        return base.copy().setTransportProfile(TransportProfile.TCP_UASC_UABINARY).setBindPort(bindPort).build();
    }

    public ExampleNamespace getName_space() {
        return this.exampleNamespace;
    }

    public OpcUaServer getServer() {
        return this.server;
    }

    public CompletableFuture<OpcUaServer> startup() {
        return this.server.startup();
    }

    public CompletableFuture<OpcUaServer> shutdown() {
        this.exampleNamespace.shutdown();
        return this.server.shutdown();
    }

    static {
        Security.addProvider(new BouncyCastleProvider());
        try {
            NonceUtil.blockUntilSecureRandomSeeded(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }
}

