/*
 * Decompiled with CFR 0.152.
 */
package com.tas.wp500.opc_ua_server;

import com.tas.wp500.App;
import com.tas.wp500.opc_ua_server.RestrictedAccessFilter;
import com.tas.wp500.protocol.startan.Tag;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;
import org.eclipse.milo.opcua.sdk.core.AccessLevel;
import org.eclipse.milo.opcua.sdk.core.Reference;
import org.eclipse.milo.opcua.sdk.server.Lifecycle;
import org.eclipse.milo.opcua.sdk.server.OpcUaServer;
import org.eclipse.milo.opcua.sdk.server.api.DataItem;
import org.eclipse.milo.opcua.sdk.server.api.ManagedNamespaceWithLifecycle;
import org.eclipse.milo.opcua.sdk.server.api.MonitoredItem;
import org.eclipse.milo.opcua.sdk.server.dtd.DataTypeDictionaryManager;
import org.eclipse.milo.opcua.sdk.server.model.nodes.objects.BaseEventTypeNode;
import org.eclipse.milo.opcua.sdk.server.model.nodes.objects.ServerTypeNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaFolderNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaVariableNode;
import org.eclipse.milo.opcua.sdk.server.nodes.filters.AttributeFilter;
import org.eclipse.milo.opcua.sdk.server.util.SubscriptionModel;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UShort;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;

public class ExampleNamespace
extends ManagedNamespaceWithLifecycle {
    public static final String NAMESPACE_URI = "urn:tas:advait:wp500:hello-world";
    private SimpleDateFormat f = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private final Logger logger = Logger.getLogger(ExampleNamespace.class);
    private final OpcUaServer server;
    private volatile Thread eventThread;
    private volatile boolean keepPostingEvents = true;
    private final DataTypeDictionaryManager dictionaryManager;
    private final SubscriptionModel subscriptionModel;
    public UaFolderNode folderNode;

    ExampleNamespace(OpcUaServer server) {
        super(server, NAMESPACE_URI);
        this.server = server;
        this.subscriptionModel = new SubscriptionModel(server, this);
        this.dictionaryManager = new DataTypeDictionaryManager(this.getNodeContext(), NAMESPACE_URI);
        this.getLifecycleManager().addLifecycle(this.dictionaryManager);
        this.getLifecycleManager().addLifecycle(this.subscriptionModel);
        this.getLifecycleManager().addStartupTask(this::createAndAddNodes);
        this.getLifecycleManager().addLifecycle(new Lifecycle(){

            @Override
            public void startup() {
                ExampleNamespace.this.startBogusEventNotifier();
            }

            @Override
            public void shutdown() {
                try {
                    ExampleNamespace.this.keepPostingEvents = false;
                    ExampleNamespace.this.eventThread.interrupt();
                    ExampleNamespace.this.eventThread.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        });
    }

    private void createAndAddNodes() {
        NodeId folderNodeId = this.newNodeId("Devices");
        this.folderNode = new UaFolderNode(this.getNodeContext(), folderNodeId, this.newQualifiedName("Devices"), LocalizedText.english("Devices"));
        this.getNodeManager().addNode(this.folderNode);
        this.folderNode.addReference(new Reference(this.folderNode.getNodeId(), Identifiers.Organizes, Identifiers.ObjectsFolder.expanded(), false));
    }

    private void startBogusEventNotifier() {
        UaNode serverNode = this.getServer().getAddressSpaceManager().getManagedNode(Identifiers.Server).orElse(null);
        if (serverNode instanceof ServerTypeNode) {
            ((ServerTypeNode)serverNode).setEventNotifier(Unsigned.ubyte(1));
            this.eventThread = new Thread(() -> {
                while (this.keepPostingEvents) {
                    try {
                        BaseEventTypeNode eventNode = this.getServer().getEventFactory().createEvent(this.newNodeId(UUID.randomUUID()), Identifiers.BaseEventType);
                        eventNode.setBrowseName(new QualifiedName(1, "foo"));
                        eventNode.setDisplayName(LocalizedText.english("foo"));
                        eventNode.setEventId(ByteString.of(new byte[]{0, 1, 2, 3}));
                        eventNode.setEventType(Identifiers.BaseEventType);
                        eventNode.setSourceNode(serverNode.getNodeId());
                        eventNode.setSourceName(serverNode.getDisplayName().getText());
                        eventNode.setTime(DateTime.now());
                        eventNode.setReceiveTime(DateTime.NULL_VALUE);
                        eventNode.setMessage(LocalizedText.english("event message!"));
                        eventNode.setSeverity(Unsigned.ushort(2));
                        this.getServer().getEventBus().post(eventNode);
                        eventNode.delete();
                    }
                    catch (Throwable e) {
                        this.logger.error("Error while creating EventNode : " + e.getMessage(), e);
                    }
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }, "bogus-event-poster");
            this.eventThread.start();
        }
    }

    public UaFolderNode createProtocolNode(String protocol_name, String folderName) {
        UaFolderNode folderNode1 = null;
        UaFolderNode folderNode2 = null;
        try {
            folderNode1 = new UaFolderNode(this.getNodeContext(), this.newNodeId("Devices/" + protocol_name), this.newQualifiedName(protocol_name), LocalizedText.english(protocol_name));
            this.getNodeManager().addNode(folderNode1);
            this.folderNode.addOrganizes(folderNode1);
            folderNode2 = new UaFolderNode(this.getNodeContext(), this.newNodeId("Devices/" + protocol_name + "/" + folderName), this.newQualifiedName(folderName), LocalizedText.english(folderName));
            this.getNodeManager().addNode(folderNode2);
            folderNode1.addOrganizes(folderNode2);
            return folderNode2;
        }
        catch (Exception e) {
            this.logger.error("Error while creating protocol node : " + e);
            return folderNode2;
        }
    }

    public void getAllNodeAndRemove(String protocolName) {
        List<NodeId> nodeIds = this.getNodeManager().getNodeIds();
        if (!nodeIds.isEmpty()) {
            nodeIds.forEach(e -> {
                String identifier = (String)e.getIdentifier();
                if (identifier.contains(protocolName)) {
                    App.simpleServer.getName_space().removeNodes(e.getIdentifier().toString());
                }
            });
            nodeIds.clear();
        }
    }

    public void removeNodes(String identifier_name) {
        try {
            NodeId node_id = new NodeId(this.getNamespaceIndex(), identifier_name);
            if (this.getNodeManager().containsNode(node_id)) {
                this.getNodeManager().removeNode(this.newNodeId(identifier_name));
            }
        }
        catch (Exception e) {
            this.logger.error("Error while removing nodes : ", e);
            e.printStackTrace();
        }
    }

    public boolean isNodeAvil(String identifier_name) {
        try {
            List<NodeId> nodeIds = this.getNodeManager().getNodeIds();
            if (!nodeIds.isEmpty()) {
                nodeIds.forEach(e -> {
                    String identifier = (String)e.getIdentifier();
                    this.logger.debug("Node Id's  : " + identifier);
                });
            }
            NodeId node_id = new NodeId(Integer.parseInt(identifier_name.split("\\$")[0]), identifier_name.split("\\$")[1]);
            if (this.getNodeManager().containsNode(node_id)) {
                return true;
            }
        }
        catch (Exception e2) {
            this.logger.error("Error while checking node : ", e2);
            e2.printStackTrace();
        }
        return false;
    }

    public UShort getNamespceIndex() {
        return this.getNamespaceIndex();
    }

    @Override
    public void onDataItemsCreated(List<DataItem> dataItems) {
    }

    @Override
    public void onDataItemsModified(List<DataItem> dataItems) {
    }

    @Override
    public void onDataItemsDeleted(List<DataItem> dataItems) {
    }

    @Override
    public void onMonitoringModeChanged(List<MonitoredItem> monitoredItems) {
    }

    public void addStartonDataOnOpcUaServer(ConcurrentHashMap<String, Tag> variableTagMap) {
        try {
            String protocol_name = "Starton";
            UaFolderNode startonFolder = new UaFolderNode(this.getNodeContext(), this.newNodeId("Devices/" + protocol_name), this.newQualifiedName(protocol_name), LocalizedText.english(protocol_name));
            this.getNodeManager().addNode(startonFolder);
            this.folderNode.addOrganizes(startonFolder);
            variableTagMap.entrySet().forEach(eachTag -> {
                try {
                    String key = (String)eachTag.getKey();
                    Tag tag = (Tag)eachTag.getValue();
                    if (tag != null) {
                        Variant variant = null;
                        NodeId typeId = null;
                        if (tag.getValue() instanceof Integer) {
                            variant = new Variant(tag.getValue());
                            typeId = Identifiers.Integer;
                        } else if (tag.getValue() instanceof Double) {
                            variant = new Variant(tag.getValue());
                            typeId = Identifiers.Double;
                        } else if (tag.getValue() instanceof String) {
                            variant = new Variant(tag.getValue());
                            typeId = Identifiers.String;
                        } else if (tag.getValue() instanceof Long) {
                            variant = new Variant(tag.getValue());
                            typeId = Identifiers.Double;
                        }
                        String finalNodeId = protocol_name + "/" + key;
                        String finalName = "" + key;
                        UaVariableNode node = new UaVariableNode.UaVariableNodeBuilder(this.getNodeContext()).setNodeId(this.newNodeId(finalNodeId)).setAccessLevel(AccessLevel.READ_WRITE).setBrowseName(this.newQualifiedName(finalName)).setDisplayName(LocalizedText.english(finalName)).setDataType(typeId).setTypeDefinition(Identifiers.BaseDataVariableType).build();
                        node.setValue(new DataValue(variant));
                        node.getFilterChain().addLast((AttributeFilter)new RestrictedAccessFilter(identity -> {
                            if ("ADVAIT".equals(identity)) {
                                return AccessLevel.READ_WRITE;
                            }
                            return AccessLevel.READ_ONLY;
                        }));
                        this.getNodeManager().addNode(node);
                        startonFolder.addOrganizes(node);
                    }
                }
                catch (Exception e) {
                    this.logger.error("Error while creating starton data on opcua server : " + e);
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error("Error while creating starton data on opcua server : " + e);
        }
    }
}

