/*
 * Decompiled with CFR 0.152.
 */
package com.tas.wp500.opc_ua_server;

import org.eclipse.milo.opcua.stack.core.UaSerializationException;
import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;
import org.eclipse.milo.opcua.stack.core.types.structured.Union;

public class CustomUnionType
extends Union
implements UaStructure {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse(String.format("nsu=%s;s=%s", "urn:tas:advait:wp500:hello-world", "DataType.CustomUnionType"));
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse(String.format("nsu=%s;s=%s", "urn:tas:advait:wp500:hello-world", "DataType.CustomUnionType.BinaryEncoding"));
    private final Type type;
    private final Object value;

    private CustomUnionType(Type type, Object value) {
        this.type = type;
        this.value = value;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return ExpandedNodeId.NULL_VALUE;
    }

    public UInteger asFoo() {
        return (UInteger)this.value;
    }

    public String asBar() {
        return (String)this.value;
    }

    public boolean isNull() {
        return this.type == Type.Null;
    }

    public boolean isFoo() {
        return this.type == Type.Foo;
    }

    public boolean isBar() {
        return this.type == Type.Bar;
    }

    public static CustomUnionType ofNull() {
        return new CustomUnionType(Type.Null, null);
    }

    public static CustomUnionType ofFoo(UInteger value) {
        return new CustomUnionType(Type.Foo, value);
    }

    public static CustomUnionType ofBar(String value) {
        return new CustomUnionType(Type.Bar, value);
    }

    public static class Codec
    extends GenericDataTypeCodec<CustomUnionType> {
        @Override
        public Class<CustomUnionType> getType() {
            return CustomUnionType.class;
        }

        @Override
        public CustomUnionType decode(SerializationContext context, UaDecoder decoder) {
            UInteger switchValue = decoder.readUInt32("SwitchValue");
            switch (switchValue.intValue()) {
                case 0: {
                    return CustomUnionType.ofNull();
                }
                case 1: {
                    UInteger foo = decoder.readUInt32("foo");
                    return CustomUnionType.ofFoo(foo);
                }
                case 2: {
                    String bar = decoder.readString("bar");
                    return CustomUnionType.ofBar(bar);
                }
            }
            throw new UaSerializationException(0x80070000L, "unknown field in Union CustomUnionType: " + switchValue);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, CustomUnionType value) {
            encoder.writeUInt32("SwitchValue", Unsigned.uint(value.type.ordinal()));
            switch (value.type) {
                case Null: {
                    break;
                }
                case Foo: {
                    encoder.writeUInt32("foo", value.asFoo());
                    break;
                }
                case Bar: {
                    encoder.writeString("bar", value.asBar());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unhandled type: " + (Object)((Object)value.type));
                }
            }
        }
    }

    static enum Type {
        Null,
        Foo,
        Bar;

    }
}

