/*
 * Decompiled with CFR 0.152.
 */
package com.tas.wp500.opc_ua_server;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.tas.wp500.opc_ua_server.CustomEnumType;
import org.eclipse.milo.opcua.stack.core.UaSerializationException;
import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;

public class CustomStructType
implements UaStructure {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse(String.format("nsu=%s;s=%s", "urn:tas:advait:wp500:hello-world", "DataType.CustomStructType"));
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse(String.format("nsu=%s;s=%s", "urn:tas:advait:wp500:hello-world", "DataType.CustomStructType.BinaryEncoding"));
    private final String foo;
    private final UInteger bar;
    private final boolean baz;
    private final CustomEnumType customEnumType;

    public CustomStructType() {
        this(null, Unsigned.uint(0), false, CustomEnumType.Field0);
    }

    public CustomStructType(String foo, UInteger bar, boolean baz, CustomEnumType customEnumType) {
        this.foo = foo;
        this.bar = bar;
        this.baz = baz;
        this.customEnumType = customEnumType;
    }

    public String getFoo() {
        return this.foo;
    }

    public UInteger getBar() {
        return this.bar;
    }

    public boolean isBaz() {
        return this.baz;
    }

    public CustomEnumType getCustomEnumType() {
        return this.customEnumType;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return ExpandedNodeId.NULL_VALUE;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CustomStructType that = (CustomStructType)o;
        return this.baz == that.baz && Objects.equal(this.foo, that.foo) && Objects.equal(this.bar, that.bar) && this.customEnumType == that.customEnumType;
    }

    public int hashCode() {
        return Objects.hashCode(this.foo, this.bar, this.baz, this.customEnumType);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("foo", this.foo).add("bar", this.bar).add("baz", this.baz).add("customEnumType", this.customEnumType).toString();
    }

    public static class Codec
    extends GenericDataTypeCodec<CustomStructType> {
        @Override
        public Class<CustomStructType> getType() {
            return CustomStructType.class;
        }

        @Override
        public CustomStructType decode(SerializationContext context, UaDecoder decoder) throws UaSerializationException {
            String foo = decoder.readString("Foo");
            UInteger bar = decoder.readUInt32("Bar");
            boolean baz = decoder.readBoolean("Baz");
            CustomEnumType customEnumType = decoder.readEnum("CustomEnumType", CustomEnumType.class);
            return new CustomStructType(foo, bar, baz, customEnumType);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, CustomStructType value) throws UaSerializationException {
            encoder.writeString("Foo", value.foo);
            encoder.writeUInt32("Bar", value.bar);
            encoder.writeBoolean("Baz", value.baz);
            encoder.writeEnum("CustomEnumType", value.customEnumType);
        }
    }
}

