/*
 * Decompiled with CFR 0.152.
 */
package com.tas.wp500.opc_ua_server;

import java.util.function.Predicate;
import org.eclipse.milo.opcua.sdk.server.nodes.filters.AttributeFilter;
import org.eclipse.milo.opcua.sdk.server.nodes.filters.AttributeFilterContext;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttributeLoggingFilter
implements AttributeFilter {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Predicate<AttributeId> attributePredicate;

    public AttributeLoggingFilter() {
        this(attributeId -> true);
    }

    public AttributeLoggingFilter(Predicate<AttributeId> attributePredicate) {
        this.attributePredicate = attributePredicate;
    }

    @Override
    public Object getAttribute(AttributeFilterContext.GetAttributeContext ctx, AttributeId attributeId) {
        Object value = ctx.getAttribute(attributeId);
        if (this.attributePredicate.test(attributeId) && ctx.getSession().isPresent()) {
            this.logger.debug("get nodeId={} attributeId={} value={}", new Object[]{ctx.getNode().getNodeId(), attributeId, value});
        }
        return value;
    }

    @Override
    public void setAttribute(AttributeFilterContext.SetAttributeContext ctx, AttributeId attributeId, Object value) {
        if (this.attributePredicate.test(attributeId) && ctx.getSession().isPresent()) {
            this.logger.info("set nodeId={} attributeId={} value={}", new Object[]{ctx.getNode().getNodeId(), attributeId, value});
        }
        ctx.setAttribute(attributeId, value);
    }
}

