/*
 * Decompiled with CFR 0.152.
 */
package com.tas.wp500.opc_ua_client;

import com.tas.wp500.fileLogSetting.FileBasedLogger;
import com.tas.wp500.opc_ua_client.ClientClass;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class OpcClientExecutorClass {
    private static Logger logger = Logger.getLogger(OpcClientExecutorClass.class);
    public static volatile HashMap<String, ClientClass> connections = new HashMap();

    public static void createAdvaitConnection() {
        ClientClass client = new ClientClass("opc.tcp://localhost:12686", "WP500", "wp500@123", "security", "WP500");
        try {
            if (client.setClient()) {
                connections.put("wp500", client);
                logger.info("wp500 client connected successfully to OPC UA server.");
                FileBasedLogger.info("Application", "wp500 client connected successfully to OPC UA server.", "system");
            }
        }
        catch (Exception e) {
            logger.error("Error while establishing connection to WP500 OPC UA server: ", e);
            FileBasedLogger.error("Appliaction", "Error while establishing connection to WP500 OPC UA server: " + e, "system");
        }
        logger.debug("Current number of connections: {" + connections.size() + " }");
    }

    public static void cancelConnection(String user) {
        try {
            if (connections.size() > 1) {
                ClientClass client = connections.get("wp500");
                connections.forEach((name, opcClient) -> {
                    if (!name.equals("wp500")) {
                        opcClient.getClient().disconnect();
                    }
                });
                connections.clear();
                connections.put("wp500", client);
            }
        }
        catch (Exception e) {
            logger.error("Error while client connection : " + e);
            FileBasedLogger.error("Application", "Error while client connection : " + e, user);
        }
    }
}

