/*
 * Decompiled with CFR 0.152.
 */
package com.tas.wp500.opc_ua_client;

import com.google.common.base.Predicate;
import com.tas.wp500.opc_ua_client.KeyStoreLoader;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.apache.log4j.Logger;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.api.identity.AnonymousProvider;
import org.eclipse.milo.opcua.sdk.client.api.identity.IdentityProvider;
import org.eclipse.milo.opcua.sdk.client.api.identity.UsernameProvider;
import org.eclipse.milo.opcua.stack.client.security.DefaultClientCertificateValidator;
import org.eclipse.milo.opcua.stack.core.security.DefaultTrustListManager;
import org.eclipse.milo.opcua.stack.core.security.SecurityPolicy;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;
import org.eclipse.milo.opcua.stack.core.types.structured.EndpointDescription;

public class ClientClass {
    private static Logger logger = Logger.getLogger(ClientClass.class);
    private OpcUaClient client;
    private final KeyStoreLoader loader = new KeyStoreLoader();
    private String url;
    private String user_name;
    private String password;
    private String security;
    private String opcName;

    public ClientClass(String url, String user_name, String password, String security, String opcName) {
        this.url = url;
        this.user_name = user_name;
        this.password = password;
        this.security = security;
        this.opcName = opcName;
    }

    SecurityPolicy getSecurityPolicy() {
        if (this.security.equalsIgnoreCase("Basic128Rsa15") || this.security.equalsIgnoreCase("Basic128Rsa15,Sign and Encrypt")) {
            return SecurityPolicy.Basic128Rsa15;
        }
        if (this.security.equalsIgnoreCase("Basic256") || this.security.equalsIgnoreCase("Basic256,Sign and Encrypt")) {
            return SecurityPolicy.Basic256;
        }
        if (this.security.equalsIgnoreCase("Basic256Sha256") || this.security.equalsIgnoreCase("Basic256Sha256,Sign and Encrypt")) {
            return SecurityPolicy.Basic256Sha256;
        }
        return SecurityPolicy.None;
    }

    IdentityProvider getIdentityProvider() {
        if (!this.user_name.equalsIgnoreCase("") && !this.password.equalsIgnoreCase("")) {
            return new UsernameProvider(this.user_name, this.password);
        }
        return new AnonymousProvider();
    }

    public Predicate<EndpointDescription> endpointFilter() {
        return e -> this.getSecurityPolicy().getUri().equals(e.getSecurityPolicyUri());
    }

    public OpcUaClient getClient() {
        return this.client;
    }

    public boolean setClient() {
        try {
            Path securityTempDir = Paths.get(System.getProperty("java.io.tmpdir"), "client1", "security1");
            Files.createDirectories(securityTempDir, new FileAttribute[0]);
            if (!Files.exists(securityTempDir, new LinkOption[0])) {
                throw new Exception("unable to create security dir: " + securityTempDir);
            }
            File pkiDir = securityTempDir.resolve("pki").toFile();
            KeyStoreLoader loader = new KeyStoreLoader().load(securityTempDir);
            DefaultTrustListManager trustListManager = new DefaultTrustListManager(pkiDir);
            DefaultClientCertificateValidator certificateValidator = new DefaultClientCertificateValidator(trustListManager);
            this.client = OpcUaClient.create(this.url, endpoints -> endpoints.stream().filter(this.endpointFilter()).findFirst(), configBuilder -> configBuilder.setApplicationName(LocalizedText.english("WP500 opc-ua client")).setApplicationUri("urn:wp500:tas:examples:client").setKeyPair(loader.getClientKeyPair()).setCertificate(loader.getClientCertificate()).setCertificateChain(loader.getClientCertificateChain()).setCertificateValidator(certificateValidator).setIdentityProvider(this.getIdentityProvider()).setRequestTimeout(Unsigned.uint(5000)).build());
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Error while setClient :", e);
            return false;
        }
    }

    public boolean setThirdPartyOpcClient() {
        try {
            Path securityTempDir = Paths.get(System.getProperty("java.io.tmpdir"), "client2", "security2");
            Files.createDirectories(securityTempDir, new FileAttribute[0]);
            if (!Files.exists(securityTempDir, new LinkOption[0])) {
                throw new Exception("unable to create security dir: " + securityTempDir);
            }
            File pkiDir = securityTempDir.resolve("pki").toFile();
            logger.debug("Opc Client Third party url:" + this.url);
            KeyStoreLoader loader = new KeyStoreLoader().load(securityTempDir);
            DefaultTrustListManager trustListManager = new DefaultTrustListManager(pkiDir);
            DefaultClientCertificateValidator certificateValidator = new DefaultClientCertificateValidator(trustListManager);
            try {
                this.client = OpcUaClient.create(this.url, endpoints -> endpoints.stream().filter(endpoint -> ClientClass.isValidIpAddress(endpoint.getEndpointUrl())).findFirst(), configBuilder -> configBuilder.setApplicationName(LocalizedText.english(this.opcName + " opc-ua client")).setApplicationUri("urn:tas:ind:wp500:client").setKeyPair(loader.getClientKeyPair()).setCertificate(loader.getClientCertificate()).setCertificateChain(loader.getClientCertificateChain()).setCertificateValidator(certificateValidator).setIdentityProvider(this.getIdentityProvider()).setRequestTimeout(Unsigned.uint(5000)).build());
                logger.info("Connecting to server with application name: " + this.opcName + " opc-ua client");
                this.client.connect();
                return true;
            }
            catch (Exception e) {
                logger.error("Error while set third party opc client : " + e);
                try {
                    this.client = OpcUaClient.create(this.url, endpoints -> endpoints.stream().filter(endpoint -> ClientClass.isValidIpAddress(endpoint.getEndpointUrl())).findFirst(), configBuilder -> configBuilder.setApplicationName(LocalizedText.english(this.opcName + " opc-ua client")).setApplicationUri("urn:tas:ind:wp500:client").setKeyPair(loader.getClientKeyPair()).setCertificate(loader.getClientCertificate()).setCertificateChain(loader.getClientCertificateChain()).setCertificateValidator(certificateValidator).setIdentityProvider(this.getIdentityProvider()).setRequestTimeout(Unsigned.uint(5000)).build());
                    logger.info("Connecting to server with application name: " + this.opcName + " opc-ua client");
                    this.client.connect();
                    return true;
                }
                catch (Exception e1) {
                    logger.error("Error while set third party opc client : " + e);
                    e1.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            logger.error("Error while set third party opc client : " + e);
            e.printStackTrace();
        }
        return false;
    }

    private static boolean isValidIpAddress(String url) {
        String ipAddressRegex = "^opc.tcp://\\d+\\.\\d+\\.\\d+\\.\\d+.*$";
        boolean matches = url.matches(ipAddressRegex);
        logger.info(" Match url  " + url + " result  ->> " + matches);
        return matches;
    }
}

