/*
 * Decompiled with CFR 0.152.
 */
package com.tas.wp500.opc_ua_apis;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.tas.wp500.opc_entity.NodeData;
import com.tas.wp500.opc_entity.NodeValue;
import com.tas.wp500.opc_entity.OpcNode;
import com.tas.wp500.opc_ua_apis.Browse;
import com.tas.wp500.opc_ua_client.OpcClientExecutorClass;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.json.JSONException;
import org.json.JSONObject;

public class OPCUARequester {
    private static Logger logger = Logger.getLogger(OPCUARequester.class);
    private static OPCUARequester instance = null;
    private Browse browse = Browse.getInstance();

    private OPCUARequester() {
    }

    public static OPCUARequester getInstance() {
        if (instance == null) {
            instance = new OPCUARequester();
        }
        return instance;
    }

    public JSONObject getOPCNodes(OpcNode opcNode, String user) throws JSONException {
        JSONObject resultObj = new JSONObject();
        try {
            List<NodeData> nodeDataList = this.browse.samplebrowseNode(opcNode.getOpcname(), opcNode.getNodeid(), 1);
            ObjectMapper objectMapper = new ObjectMapper();
            ArrayNode jsonArray = objectMapper.createArrayNode();
            for (NodeData nodeData : nodeDataList) {
                try {
                    ObjectNode jsonObject = objectMapper.convertValue((Object)nodeData, ObjectNode.class);
                    jsonArray.add(jsonObject);
                }
                catch (Exception e) {
                    logger.error("Error while getting opc nodes : " + e);
                    e.printStackTrace();
                }
            }
            resultObj.put("data", jsonArray);
            resultObj.put("status", "success");
            resultObj.put("msg", "Successfully fetched all OPC Nodes.");
            logger.debug("Successfully fetched all OPC Nodes.");
        }
        catch (Exception e) {
            resultObj.put("status", "fail");
            resultObj.put("msg", "Failed to fetch all OPC Nodes.");
            e.printStackTrace();
            logger.error("Error occurred while getOPCNodes : " + e);
        }
        return resultObj;
    }

    public JSONObject getOPCNodeValue(OpcNode opcNode, String user) throws JSONException {
        JSONObject resultObj = null;
        resultObj = new JSONObject();
        try {
            NodeValue nodeValue = this.browse.getValue(opcNode.getOpcname(), opcNode.getNodeid(), 1);
            ObjectMapper objectMapper = new ObjectMapper();
            ObjectNode jsonObject = objectMapper.convertValue((Object)nodeValue, ObjectNode.class);
            resultObj.put("data", jsonObject);
            resultObj.put("status", "success");
            resultObj.put("msg", "Successfully fetched  OPC Node value.");
            logger.info("Successfully fetched OPC node value.");
            return resultObj;
        }
        catch (Exception e) {
            resultObj.put("status", "fail");
            resultObj.put("msg", "Failed to fetch OPC Node values.");
            e.printStackTrace();
            logger.error("Error occurred while getOPCNodeValue : " + e);
            return resultObj;
        }
    }

    public JSONObject getOpcClientList(String user) throws JSONException {
        JSONObject resultObj = null;
        try {
            resultObj = new JSONObject();
            Set<String> OpcKeySet = OpcClientExecutorClass.connections.keySet();
            resultObj.put("data", OpcKeySet);
            resultObj.put("status", "success");
            resultObj.put("msg", "Successfully fetched all OPC Names.");
            logger.info("Fetched all OPC Names successfully.");
        }
        catch (Exception e) {
            e.printStackTrace();
            resultObj.put("data", new HashSet());
            resultObj.put("status", "fail");
            resultObj.put("msg", "Failed to fetch all OPC Names.");
            logger.error("Failed to fetch all OPC names : " + e);
        }
        return resultObj;
    }
}

