/*
 * Decompiled with CFR 0.152.
 */
package com.tas.wp500.opc_ua_apis;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.tas.wp500.opc_entity.NodeData;
import com.tas.wp500.opc_entity.NodeValue;
import com.tas.wp500.opc_ua_client.ClientClass;
import com.tas.wp500.opc_ua_client.OpcClientExecutorClass;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import org.apache.log4j.Logger;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.api.UaClient;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;
import org.eclipse.milo.opcua.stack.core.types.enumerated.BrowseDirection;
import org.eclipse.milo.opcua.stack.core.types.enumerated.BrowseResultMask;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.types.structured.BrowseDescription;
import org.eclipse.milo.opcua.stack.core.types.structured.BrowseResult;
import org.eclipse.milo.opcua.stack.core.types.structured.ReferenceDescription;
import org.eclipse.milo.opcua.stack.core.util.ConversionUtil;

public class Browse {
    private static Logger logger = Logger.getLogger(Browse.class);
    private DateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private HashMap<String, OpcUaClient> opchashmap = new HashMap();
    ObjectMapper mapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    private static Browse instance = null;

    private Browse() {
    }

    public static Browse getInstance() {
        if (instance == null) {
            instance = new Browse();
        }
        return instance;
    }

    public NodeId getNodeId(String nodeId) {
        String[] node_name = nodeId.split("\\$");
        NodeId node_id = null;
        try {
            node_id = new NodeId(Integer.parseInt(node_name[0]), Integer.parseInt(node_name[1]));
        }
        catch (Exception e) {
            node_id = new NodeId(Integer.parseInt(node_name[0]), node_name[1]);
        }
        return node_id;
    }

    public static boolean isConnected(ClientClass opc) {
        try {
            return opc.getClient().connect().get() != null;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public List<NodeData> samplebrowseNode(String opcname, String node_id_str, int no) {
        OpcUaClient opc;
        ArrayList<NodeData> list = new ArrayList<NodeData>();
        if (OpcClientExecutorClass.connections.containsKey(opcname) && (opc = OpcClientExecutorClass.connections.get(opcname).getClient()) != null) {
            BrowseDescription browse;
            CompletableFuture<UaClient> connect;
            try {
                UaClient uaClient = opc.connect().get();
            }
            catch (InterruptedException e1) {
                connect = opc.connect();
                logger.error("Error while connecting uaClient" + e1.getStackTrace());
                e1.printStackTrace();
            }
            catch (ExecutionException e1) {
                connect = opc.connect();
                logger.error("Error while connecting uaClient" + e1.getStackTrace());
                e1.printStackTrace();
            }
            if (node_id_str.equalsIgnoreCase("Objects")) {
                browse = new BrowseDescription(Identifiers.RootFolder, BrowseDirection.Forward, Identifiers.References, true, Unsigned.uint(NodeClass.Object.getValue() | NodeClass.Variable.getValue()), Unsigned.uint(BrowseResultMask.All.getValue()));
            } else {
                NodeId node_id = this.getNodeId(node_id_str);
                browse = new BrowseDescription(node_id, BrowseDirection.Forward, Identifiers.References, true, Unsigned.uint(NodeClass.Object.getValue() | NodeClass.Variable.getValue()), Unsigned.uint(BrowseResultMask.All.getValue()));
            }
            try {
                BrowseResult nextResult;
                BrowseResult browseResult = opc.browse(browse).get();
                CopyOnWriteArrayList<ReferenceDescription> references = new CopyOnWriteArrayList<ReferenceDescription>();
                references.addAll(ConversionUtil.toList(browseResult.getReferences()));
                ByteString continuationPoint = browseResult.getContinuationPoint();
                while (continuationPoint != null && continuationPoint.isNotNull()) {
                    nextResult = opc.browseNext(false, continuationPoint).get();
                    references.addAll(ConversionUtil.toList(nextResult.getReferences()));
                    continuationPoint = nextResult.getContinuationPoint();
                }
                logger.debug("getNodeId references " + references.size());
                String[] node_name = node_id_str.split("\\$");
                if (references.size() == 0) {
                    try {
                        NodeId node_id = new NodeId(Integer.parseInt(node_name[0]), node_name[1]);
                        browse = new BrowseDescription(node_id, BrowseDirection.Forward, Identifiers.References, true, Unsigned.uint(NodeClass.Object.getValue() | NodeClass.Variable.getValue()), Unsigned.uint(BrowseResultMask.All.getValue()));
                        browseResult = opc.browse(browse).get();
                        references = new CopyOnWriteArrayList();
                        references.addAll(ConversionUtil.toList(browseResult.getReferences()));
                        continuationPoint = browseResult.getContinuationPoint();
                        while (continuationPoint != null && continuationPoint.isNotNull()) {
                            nextResult = opc.browseNext(false, continuationPoint).get();
                            references.addAll(ConversionUtil.toList(nextResult.getReferences()));
                            continuationPoint = nextResult.getContinuationPoint();
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        this.opchashmap.remove(opcname);
                    }
                    logger.debug("node_name[] references " + references.size());
                    if (references.size() == 0) {
                        try {
                            browse = new BrowseDescription(NodeId.parse("ns=" + node_name[0] + ";g=" + node_name[1]), BrowseDirection.Forward, Identifiers.References, true, Unsigned.uint(NodeClass.Object.getValue() | NodeClass.Variable.getValue()), Unsigned.uint(BrowseResultMask.All.getValue()));
                            browseResult = opc.browse(browse).get();
                            references = new CopyOnWriteArrayList();
                            references.addAll(ConversionUtil.toList(browseResult.getReferences()));
                            continuationPoint = browseResult.getContinuationPoint();
                            while (continuationPoint != null && continuationPoint.isNotNull()) {
                                nextResult = opc.browseNext(false, continuationPoint).get();
                                references.addAll(ConversionUtil.toList(nextResult.getReferences()));
                                continuationPoint = nextResult.getContinuationPoint();
                            }
                            logger.debug("g === references " + references.size());
                        }
                        catch (Exception e) {
                            logger.error("Error while browsing node : " + e);
                            e.printStackTrace();
                            this.opchashmap.remove(opcname);
                        }
                    }
                }
                for (ReferenceDescription rd : references) {
                    if (rd.getDisplayName().getText() == null || rd.getBrowseName().getNamespaceIndex().equals("0")) continue;
                    NodeData node = new NodeData();
                    node.setOpcname(opcname);
                    node.setType(rd.getNodeClass().name());
                    node.setBrowsename(rd.getBrowseName().getName());
                    node.setNodeid(rd.getBrowseName().getNamespaceIndex() + "$" + rd.getNodeId().getIdentifier());
                    node.setDisplayName(rd.getDisplayName().getText());
                    list.add(node);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.opchashmap.remove(opcname);
            }
        }
        return list;
    }

    public NodeValue getValue(String opcname, String node_id_str, int no_of_retry) {
        NodeValue value;
        block10: {
            value = new NodeValue();
            OpcUaClient opc = OpcClientExecutorClass.connections.get(opcname).getClient();
            if (opc != null) {
                if (node_id_str != null && !node_id_str.isEmpty()) {
                    try {
                        NodeId node_id = this.getNodeId(node_id_str);
                        value.setNodeid(node_id_str);
                        DataValue dataValue = opc.getAddressSpace().getVariableNode(node_id).readValue();
                        value.setTimestamp(this.df.format(dataValue.getServerTime().getJavaDate()));
                        value.setStatus(dataValue.getStatusCode().isGood() ? "good" : "bad");
                        value.setValue(dataValue.getValue().getValue());
                        if (dataValue.getValue().getValue() instanceof Integer) {
                            value.setDataType("Integer");
                            break block10;
                        }
                        if (dataValue.getValue().getValue() instanceof Double) {
                            value.setDataType("Double");
                            break block10;
                        }
                        if (dataValue.getValue().getValue() instanceof String) {
                            value.setDataType("String");
                            break block10;
                        }
                        if (dataValue.getValue().getValue() instanceof Float) {
                            value.setDataType("Float");
                            break block10;
                        }
                        value.setDataType(opc.getAddressSpace().getVariableNode(node_id).getValue().getClass().getSimpleName());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        logger.error("read From Opc", e);
                        this.opchashmap.remove(opcname);
                    }
                }
            } else if (no_of_retry <= 1) {
                logger.error("Opc Client Not Connected.");
            }
        }
        return value;
    }

    public boolean isNumeric(String str) {
        return str.matches("-?\\d+(\\.\\d+)?");
    }
}

