/*
 * Decompiled with CFR 0.152.
 */
package com.tas.wp500.opc_Settings;

import com.tas.wp500.fileLogSetting.FileBasedLogger;
import com.tas.wp500.security.Security;
import com.tas.wp500.sql_lite_db.SQLiteConnector;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class OpcClientSettingsOperations
extends Security {
    private static Logger logger = Logger.getLogger(OpcClientSettingsOperations.class);
    private static OpcClientSettingsOperations instance;
    private static final int SQLITE_BUSY = 5;
    private static final int RETRY_COUNT = 5;
    private static final int RETRY_DELAY = 10000;

    public OpcClientSettingsOperations() {
        this.createOpcClientSettingsTable();
    }

    public static OpcClientSettingsOperations getInstance() {
        if (instance == null) {
            instance = new OpcClientSettingsOperations();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createOpcClientSettingsTable() {
        Connection connection = SQLiteConnector.getConnection();
        try {
            Statement statement = connection.createStatement();
            String sql = "CREATE TABLE IF NOT EXISTS opc_client_settings (id INTEGER PRIMARY KEY AUTOINCREMENT, endUrl TEXT UNIQUE, Username TEXT, Password TEXT, Security TEXT, ActionType TEXT, prefix TEXT)";
            statement.execute(sql);
            statement.close();
            logger.debug("OPC Client Settings table created successfully.");
        }
        catch (SQLException e) {
            logger.debug("Error while creating opc_client_settings table : " + e);
        }
        finally {
            SQLiteConnector.closeConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject insertOpcClientSetting(JSONObject opcClientSetting, String user) throws JSONException {
        JSONObject resultObj = new JSONObject();
        for (int attempt = 0; attempt < 5; ++attempt) {
            Connection connection = null;
            try {
                connection = SQLiteConnector.getConnection();
                String sql = "INSERT INTO opc_client_settings (endUrl, Username, Password, Security, ActionType, prefix) VALUES (?, ?, ?, ?, ?, ?)";
                JSONObject data = opcClientSetting.getJSONObject("data");
                PreparedStatement statement = connection.prepareStatement(sql);
                statement.setString(1, OpcClientSettingsOperations.encrypt(data.getString("endUrl")));
                statement.setString(2, OpcClientSettingsOperations.encrypt(data.getString("Username")));
                statement.setString(3, OpcClientSettingsOperations.encrypt(data.getString("Password")));
                statement.setString(4, OpcClientSettingsOperations.encrypt(data.getString("Security")));
                statement.setString(5, OpcClientSettingsOperations.encrypt(data.getString("ActionType")));
                statement.setString(6, OpcClientSettingsOperations.encrypt(data.getString("prefix")));
                statement.executeUpdate();
                statement.close();
                resultObj.put("msg", "OPC Client setting inserted successfully.");
                resultObj.put("status", "Success");
                logger.info("Inserted OPC client settings successfully.");
                FileBasedLogger.info("Audit", "Inserted OPC client settings successfully.", user);
                break;
            }
            catch (Exception e) {
                if (((SQLException)e).getErrorCode() != 5 || attempt == 4) {
                    logger.error("Error occurred while inserting OPC Client setting : " + e);
                    FileBasedLogger.error("Audit", "Error occurred while inserting OPC Client setting : " + e, user);
                    resultObj.put("status", "fail");
                    resultObj.put("msg", "Failed to insert OPC Client setting.");
                    break;
                }
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
                continue;
            }
            finally {
                SQLiteConnector.closeConnection(connection);
            }
        }
        return resultObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject updateOpcClientSettingByPrefix(JSONObject opcClientSetting, String user) throws JSONException {
        JSONObject resultObj = new JSONObject();
        for (int attempt = 0; attempt < 5; ++attempt) {
            Connection connection = null;
            try {
                connection = SQLiteConnector.getConnection();
                String sql = "UPDATE opc_client_settings SET endUrl = ?, Username = ?, Password = ?, Security = ?, ActionType = ? WHERE prefix = ?";
                JSONObject data = opcClientSetting.getJSONObject("data");
                PreparedStatement statement = connection.prepareStatement(sql);
                statement.setString(1, OpcClientSettingsOperations.encrypt(data.getString("endUrl")));
                statement.setString(2, OpcClientSettingsOperations.encrypt(data.getString("Username")));
                statement.setString(3, OpcClientSettingsOperations.encrypt(data.getString("Password")));
                statement.setString(4, OpcClientSettingsOperations.encrypt(data.getString("Security")));
                statement.setString(5, OpcClientSettingsOperations.encrypt(data.getString("ActionType")));
                statement.setString(6, OpcClientSettingsOperations.encrypt(data.getString("prefix")));
                int rowsAffected = statement.executeUpdate();
                statement.close();
                if (rowsAffected > 0) {
                    resultObj.put("msg", "OPC Client setting updated successfully.");
                    resultObj.put("status", "Success");
                    logger.info(user + "Updated OPC client setting successfully.");
                    FileBasedLogger.info("Audit", "Updated OPC client setting successfully.", user);
                    break;
                }
                resultObj.put("msg", "No OPC Client setting found for the given prefix.");
                resultObj.put("status", "Fail");
                logger.info("No OPC client setting found for the given prefix.");
                FileBasedLogger.info("Audit", "No OPC client setting found for the given prefix.", user);
                break;
            }
            catch (Exception e) {
                e.printStackTrace();
                if (((SQLException)e).getErrorCode() != 5 || attempt == 4) {
                    logger.error("Error occurred while updating OPC Client setting : " + e);
                    FileBasedLogger.error("Audit", "Error occurred while updating OPC Client setting : " + e, user);
                    resultObj.put("status", "fail");
                    resultObj.put("msg", "Failed to update OPC Client setting.");
                    break;
                }
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
                continue;
            }
            finally {
                SQLiteConnector.closeConnection(connection);
            }
        }
        return resultObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject deleteOpcClientSetting(String prefix, String user) throws JSONException {
        JSONObject resultObj = new JSONObject();
        Connection connection = null;
        try {
            connection = SQLiteConnector.getConnection();
            String sql = "DELETE FROM opc_client_settings WHERE prefix = ?";
            PreparedStatement statement = connection.prepareStatement(sql);
            statement.setString(1, OpcClientSettingsOperations.encrypt(prefix));
            int rowsAffected = statement.executeUpdate();
            statement.close();
            if (rowsAffected > 0) {
                resultObj.put("msg", "OPC Client setting deleted successfully.");
                resultObj.put("status", "Success");
                logger.info("Deleted OPC client setting successfully.");
                FileBasedLogger.info("Audit", "Deleted OPC client setting successfully.", user);
            } else {
                resultObj.put("msg", "No OPC Client setting found for the given prefix.");
                resultObj.put("status", "Fail");
                FileBasedLogger.info("Audit", "No OPC client setting found fot the goven prefix.", user);
                logger.info("No OPC client setting found fot the goven prefix.");
            }
        }
        catch (Exception e) {
            logger.error("Error occurred while deleting OPC Client setting : " + e);
            FileBasedLogger.error("Audit", "Error occurred while deleting OPC Client setting : " + e, user);
            resultObj.put("status", "fail");
            resultObj.put("msg", "Failed to delete OPC Client setting.");
        }
        finally {
            SQLiteConnector.closeConnection(connection);
        }
        return resultObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject getAllOpcClientSettings(String user) throws JSONException {
        JSONObject resultObj = new JSONObject();
        JSONArray opcClientSettingsArray = new JSONArray();
        Connection connection = null;
        try {
            connection = SQLiteConnector.getConnection();
            String sql = "SELECT * FROM opc_client_settings";
            PreparedStatement statement = connection.prepareStatement(sql);
            ResultSet resultSet = statement.executeQuery();
            while (resultSet.next()) {
                JSONObject opcClientSetting = new JSONObject();
                opcClientSetting.put("id", resultSet.getInt("id"));
                opcClientSetting.put("endUrl", OpcClientSettingsOperations.decrypt(resultSet.getString("endUrl")));
                opcClientSetting.put("Username", OpcClientSettingsOperations.decrypt(resultSet.getString("Username")));
                opcClientSetting.put("Password", OpcClientSettingsOperations.decrypt(resultSet.getString("Password")));
                opcClientSetting.put("Security", OpcClientSettingsOperations.decrypt(resultSet.getString("Security")));
                opcClientSetting.put("ActionType", OpcClientSettingsOperations.decrypt(resultSet.getString("ActionType")));
                opcClientSetting.put("prefix", OpcClientSettingsOperations.decrypt(resultSet.getString("prefix")));
                opcClientSettingsArray.put(opcClientSetting);
            }
            resultObj.put("data", opcClientSettingsArray);
            resultObj.put("status", "success");
            resultObj.put("msg", "Successfully fetched opc client settings.");
            logger.info("Fetched OPC client settings successfully.");
            FileBasedLogger.info("Audit", "Fetched OPC client settings successfully.", user);
            resultSet.close();
            statement.close();
        }
        catch (SQLException | JSONException e) {
            e.printStackTrace();
            resultObj.put("data", opcClientSettingsArray);
            resultObj.put("status", "Fail");
            resultObj.put("msg", "Failed to fetched OPC client settings.");
            logger.error("Error occurred while fetching OPC Client settings : " + e);
            FileBasedLogger.error("Audit", "Error occurred while fetching OPC Client settings : " + e, user);
        }
        finally {
            SQLiteConnector.closeConnection(connection);
        }
        return resultObj;
    }
}

