/*
 * Decompiled with CFR 0.152.
 */
package com.tas.wp500.mqttSettings;

import com.tas.wp500.fileLogSetting.FileBasedLogger;
import com.tas.wp500.mqttSettings.MQTT;
import com.tas.wp500.security.Security;
import com.tas.wp500.sql_lite_db.SQLiteConnector;
import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class MQTT_opertions
extends Security {
    private Logger logger = Logger.getLogger(MQTT_opertions.class);
    private static MQTT_opertions instance = null;
    private static final String FOLDERPATH = "/usr/bin/crt_files";
    private static final int SQLITE_BUSY = 5;
    private static final int RETRY_COUNT = 5;
    private static final int RETRY_DELAY = 10000;

    public MQTT_opertions() {
        this.createMqttTable();
    }

    public static MQTT_opertions getInstance() {
        if (instance == null) {
            instance = new MQTT_opertions();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createMqttTable() {
        Connection connection = SQLiteConnector.getConnection();
        try {
            Statement statement = connection.createStatement();
            String sql = "CREATE TABLE IF NOT EXISTS mqtt (id INTEGER PRIMARY KEY AUTOINCREMENT, broker_ip_address TEXT UNIQUE, port_number TEXT, username TEXT, password TEXT, subscribe_topic TEXT, publish_topic TEXT, prefix TEXT, file_type TEXT, file_name TEXT, enable TEXT, publishing_format TEXT, time_format TEXT, client_id TEXT)";
            statement.execute(sql);
            statement.close();
            this.logger.info("creating mqtt table : ");
        }
        catch (SQLException e) {
            this.logger.debug("Error while creating mqtt table : " + e);
            e.printStackTrace();
        }
        finally {
            SQLiteConnector.closeConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject insertMqttData(JSONObject json1, String user) throws JSONException {
        JSONObject resultObj = new JSONObject();
        for (int attempt = 0; attempt < 5; ++attempt) {
            Connection connection = null;
            try {
                connection = SQLiteConnector.getConnection();
                String prefixToInsert = json1.getString("prefix");
                String clientId = "";
                if (json1.has("client_id")) {
                    clientId = json1.getString("client_id");
                }
                String checkDuplicateSql = "SELECT COUNT(*) as count FROM mqtt WHERE prefix = ?";
                PreparedStatement checkDuplicateStmt = connection.prepareStatement(checkDuplicateSql);
                checkDuplicateStmt.setString(1, MQTT_opertions.encrypt(prefixToInsert));
                ResultSet resultSet = checkDuplicateStmt.executeQuery();
                int rowCount = resultSet.getInt("count");
                checkDuplicateStmt.close();
                if (rowCount > 0) {
                    resultObj.put("status", "fail");
                    resultObj.put("msg", "Prefix already exists in the database : " + prefixToInsert);
                } else {
                    String sql = "INSERT INTO mqtt (broker_ip_address, port_number, username, password, subscribe_topic, publish_topic, prefix, file_type, file_name, enable, publishing_format, time_format, client_id) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
                    PreparedStatement statement = connection.prepareStatement(sql);
                    statement.setString(1, MQTT_opertions.encrypt(json1.getString("broker_ip_address")));
                    statement.setString(2, MQTT_opertions.encrypt(String.valueOf(json1.getInt("port_number"))));
                    statement.setString(3, MQTT_opertions.encrypt(json1.getString("username")));
                    statement.setString(4, MQTT_opertions.encrypt(json1.getString("password")));
                    statement.setString(5, MQTT_opertions.encrypt(json1.getString("subscribe_topic")));
                    statement.setString(6, MQTT_opertions.encrypt(json1.getString("publish_topic")));
                    statement.setString(7, MQTT_opertions.encrypt(json1.getString("prefix")));
                    statement.setString(8, json1.has("file_type") ? MQTT_opertions.encrypt(json1.getString("file_type")) : MQTT_opertions.encrypt(""));
                    statement.setString(9, MQTT_opertions.encrypt(json1.getString("file_name")));
                    statement.setString(10, MQTT_opertions.encrypt(json1.getString("enable")));
                    statement.setString(11, MQTT_opertions.encrypt(json1.getString("publishing_format")));
                    statement.setString(12, MQTT_opertions.encrypt(json1.getString("time_format")));
                    statement.setString(13, MQTT_opertions.encrypt(clientId));
                    statement.executeUpdate();
                    statement.close();
                    this.logger.info("MQTT server setting has been saved successfully.");
                    FileBasedLogger.info("Audit", "MQTT server setting has been saved successfully.", user);
                    resultObj.put("msg", "MQTT server setting has been saved successfully.");
                    resultObj.put("status", "Success");
                }
                resultSet.close();
                break;
            }
            catch (SQLException e) {
                e.printStackTrace();
                if (e.getErrorCode() != 5 || attempt == 4) {
                    this.logger.error("Error while inserting mqtt details : " + e);
                    FileBasedLogger.error("Audit", "Error while inserting mqtt details : " + e, user);
                    resultObj.put("status", "fail");
                    resultObj.put("msg", "Failed to insert MQTT server settings. Please check your input and try again.");
                    break;
                }
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
                continue;
            }
            finally {
                SQLiteConnector.closeConnection(connection);
            }
        }
        return resultObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject updateMqttData(JSONObject json, String user) throws JSONException {
        JSONObject resultObj = new JSONObject();
        for (int attempt = 0; attempt < 5; ++attempt) {
            Connection connection = null;
            try {
                connection = SQLiteConnector.getConnection();
                String clientId = "";
                if (json.has("client_id")) {
                    clientId = json.getString("client_id");
                }
                String sql = "UPDATE mqtt SET broker_ip_address = ?, port_number = ?, username = ?, password = ?, subscribe_topic = ?, publish_topic = ?, file_type = ?, enable = ?, file_name = ?, publishing_format = ?, time_format = ?, client_id = ? , prefix = ?WHERE id = ?";
                PreparedStatement statement = connection.prepareStatement(sql);
                statement.setString(1, MQTT_opertions.encrypt(json.getString("broker_ip_address")));
                statement.setString(2, MQTT_opertions.encrypt(String.valueOf(json.getInt("port_number"))));
                statement.setString(3, MQTT_opertions.encrypt(json.getString("username")));
                statement.setString(4, MQTT_opertions.encrypt(json.getString("password")));
                statement.setString(5, MQTT_opertions.encrypt(json.getString("subscribe_topic")));
                statement.setString(6, MQTT_opertions.encrypt(json.getString("publish_topic")));
                statement.setString(7, MQTT_opertions.encrypt(json.getString("file_type")));
                statement.setString(8, MQTT_opertions.encrypt(json.getString("enable")));
                statement.setString(9, json.has("file_name") ? MQTT_opertions.encrypt(json.getString("file_name")) : MQTT_opertions.encrypt(""));
                statement.setString(10, MQTT_opertions.encrypt(json.getString("publishing_format")));
                statement.setString(11, MQTT_opertions.encrypt(json.getString("time_format")));
                statement.setString(12, MQTT_opertions.encrypt(clientId));
                statement.setString(13, MQTT_opertions.encrypt(json.getString("prefix")));
                statement.setInt(14, Integer.parseInt(json.getString("id")));
                int rowsAffected = statement.executeUpdate();
                statement.close();
                if (rowsAffected > 0) {
                    this.logger.info("Mqtt Data updated successfully.");
                    FileBasedLogger.info("Audit", "Mqtt Data updated successfully.", user);
                    resultObj.put("msg", "MQTT server settings have been successfully updated.");
                    resultObj.put("status", "Success");
                    break;
                }
                this.logger.info("No rows updated. Mqtt Data with the given prefix not found.");
                FileBasedLogger.info("Audit", "No rows updated. Mqtt Data with the given id not found.", user);
                resultObj.put("msg", "No Mqtt server settings found for the given prefix.");
                resultObj.put("status", "Fail");
                break;
            }
            catch (SQLException e) {
                e.printStackTrace();
                if (e.getErrorCode() != 5 || attempt == 4) {
                    this.logger.error("Error while updating mqtt details : " + e);
                    FileBasedLogger.error("Audit", "Error while updating mqtt details : " + e, user);
                    resultObj.put("status", "fail");
                    resultObj.put("msg", "Failed to update Mqtt server settings.");
                    break;
                }
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
                continue;
            }
            finally {
                SQLiteConnector.closeConnection(connection);
            }
        }
        return resultObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject deleteMqttData(JSONObject json, String user) throws JSONException {
        JSONObject resultObj = new JSONObject();
        for (int attempt = 0; attempt < 5; ++attempt) {
            Connection connection = null;
            Statement pstmt = null;
            try {
                connection = SQLiteConnector.getConnection();
                if (json.has("id")) {
                    int prefixToDelete = Integer.parseInt(json.getString("id"));
                    String sql = "DELETE FROM mqtt WHERE id = ?";
                    pstmt = connection.prepareStatement(sql);
                    pstmt.setInt(1, prefixToDelete);
                    int rowsAffected = pstmt.executeUpdate();
                    if (rowsAffected > 0) {
                        this.logger.info("Deleted MQTT server setting successfully.");
                        FileBasedLogger.info("Audit", "Deleted MQTT server setting successfully.", user);
                        resultObj.put("msg", "MQTT server setting deleted successfully.");
                        resultObj.put("status", "Success");
                        break;
                    }
                    this.logger.info("id not found: " + prefixToDelete);
                    FileBasedLogger.info("Audit", "id not found: " + prefixToDelete, user);
                    resultObj.put("msg", "id data not found.");
                    resultObj.put("status", "Fail");
                    break;
                }
                resultObj.put("status", "Fail");
                resultObj.put("msg", "Prefix data not found in the request.");
                break;
            }
            catch (SQLException e) {
                e.printStackTrace();
                if (e.getErrorCode() != 5 || attempt == 4) {
                    this.logger.error("Error while deleting MQTT details: " + e);
                    FileBasedLogger.error("Audit", "Error while deleting MQTT details: " + e, user);
                    resultObj.put("status", "Error");
                    resultObj.put("msg", "Failed to delete MQTT server settings.");
                    break;
                }
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
                continue;
            }
            finally {
                if (pstmt != null) {
                    try {
                        pstmt.close();
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                }
                SQLiteConnector.closeConnection(connection);
            }
        }
        return resultObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject getAllMqttData(JSONObject json) throws JSONException {
        JSONObject resultObj = new JSONObject();
        Connection connection = null;
        try {
            connection = SQLiteConnector.getConnection();
            String sql = "SELECT * FROM mqtt";
            Statement statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery(sql);
            JSONArray mqttDataArray = new JSONArray();
            while (resultSet.next()) {
                JSONObject jsonData = new JSONObject();
                String id = String.valueOf(resultSet.getInt("id"));
                jsonData.put("id", id);
                String broker_ip_address = resultSet.getString("broker_ip_address");
                jsonData.put("broker_ip_address", MQTT_opertions.decrypt(broker_ip_address));
                String port_number = resultSet.getString("port_number");
                jsonData.put("port_number", Integer.parseInt(MQTT_opertions.decrypt(port_number)));
                String username = resultSet.getString("username");
                jsonData.put("username", MQTT_opertions.decrypt(username));
                String password = resultSet.getString("password");
                jsonData.put("password", MQTT_opertions.decrypt(password));
                String subscribe_topic = resultSet.getString("subscribe_topic");
                jsonData.put("subscribe_topic", MQTT_opertions.decrypt(subscribe_topic));
                String publish_topic = resultSet.getString("publish_topic");
                jsonData.put("publish_topic", MQTT_opertions.decrypt(publish_topic));
                String prefix = resultSet.getString("prefix");
                jsonData.put("prefix", MQTT_opertions.decrypt(prefix));
                String file_type = resultSet.getString("file_type");
                jsonData.put("file_type", MQTT_opertions.decrypt(file_type));
                String enable = resultSet.getString("enable");
                jsonData.put("enable", MQTT_opertions.decrypt(enable));
                String file_name = resultSet.getString("file_name");
                jsonData.put("file_name", MQTT_opertions.decrypt(file_name));
                String publishing_format = resultSet.getString("publishing_format");
                jsonData.put("publishing_format", MQTT_opertions.decrypt(publishing_format));
                String time_format = resultSet.getString("time_format");
                jsonData.put("time_format", MQTT_opertions.decrypt(time_format));
                String client_id = resultSet.getString("client_id");
                jsonData.put("client_id", MQTT_opertions.decrypt(client_id));
                mqttDataArray.put(jsonData);
            }
            resultSet.close();
            statement.close();
            resultObj.put("status", "success");
            resultObj.put("msg", "Successfully fetched all MQTT server settings.");
            resultObj.put("result", mqttDataArray);
            FileBasedLogger.info("Audit", "Successfully fetched all MQTT server settings.", json.getString("user"));
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error("Error while fetching mqtt settings : " + e);
            FileBasedLogger.error("Audit", "Error while fetching mqtt settings : " + e, json.getString("user"));
            resultObj.put("status", "fail");
            resultObj.put("msg", " Error while executing command.");
            resultObj.put("result", "[]");
        }
        finally {
            SQLiteConnector.closeConnection(connection);
        }
        return resultObj;
    }

    public JSONObject getCrtCertificatesFromfolers(JSONObject json) throws JSONException {
        JSONObject resultObj = new JSONObject();
        try {
            File[] files;
            JSONArray fileListArray = new JSONArray();
            File folder = new File(FOLDERPATH);
            if (folder.isDirectory() && (files = folder.listFiles()) != null) {
                for (File file : files) {
                    if ((!file.isFile() || !file.getName().toLowerCase().endsWith(".crt")) && !file.getName().toLowerCase().endsWith(".pem")) continue;
                    fileListArray.put(file.getName());
                }
            }
            resultObj.put("msg", "Successfully fetched crt files.");
            resultObj.put("status", "success");
            resultObj.put("result", fileListArray);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error("Error while getting crt file from folder : " + e);
            resultObj.put("msg", "Failed to fetch crt files.");
            resultObj.put("status", "Fail");
            this.logger.error("Error while fetching list of crt files : " + e);
        }
        return resultObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<MQTT> getAllMqttData() {
        Connection connection = null;
        ArrayList<MQTT> mqttDataList = new ArrayList<MQTT>();
        for (int attempt = 0; attempt < 5; ++attempt) {
            try {
                connection = SQLiteConnector.getConnection();
                String sql = "SELECT * FROM mqtt";
                Statement statement = connection.createStatement();
                ResultSet resultSet = statement.executeQuery(sql);
                while (resultSet.next()) {
                    MQTT mq = new MQTT();
                    int id = resultSet.getInt("id");
                    String broker_ip_address = resultSet.getString("broker_ip_address");
                    mq.setBroker_ip_address(MQTT_opertions.decrypt(broker_ip_address));
                    String port_number = resultSet.getString("port_number");
                    mq.setPort_number(Integer.parseInt(MQTT_opertions.decrypt(port_number)));
                    String username = resultSet.getString("username");
                    mq.setUsername(MQTT_opertions.decrypt(username));
                    String password = resultSet.getString("password");
                    mq.setPassword(MQTT_opertions.decrypt(password));
                    String subscribe_topic = resultSet.getString("subscribe_topic");
                    mq.setSubscribe_topic(MQTT_opertions.decrypt(subscribe_topic));
                    String publish_topic = resultSet.getString("publish_topic");
                    mq.setPublish_topic(MQTT_opertions.decrypt(publish_topic));
                    String prefix = resultSet.getString("prefix");
                    mq.setPrefix(MQTT_opertions.decrypt(prefix));
                    String file_type = resultSet.getString("file_type");
                    mq.setFile_type(MQTT_opertions.decrypt(file_type));
                    String file_name = resultSet.getString("file_name");
                    mq.setFile_name(MQTT_opertions.decrypt(file_name));
                    String enable = resultSet.getString("enable");
                    mq.setEnable(MQTT_opertions.decrypt(enable));
                    String publishing_format = resultSet.getString("publishing_format");
                    mq.setPublishing_format(MQTT_opertions.decrypt(publishing_format));
                    String time_format = resultSet.getString("time_format");
                    mq.setTime_format(MQTT_opertions.decrypt(time_format));
                    String client_id = resultSet.getString("client_id");
                    mq.setClient_id(MQTT_opertions.decrypt(client_id));
                    mqttDataList.add(mq);
                }
                resultSet.close();
                statement.close();
                break;
            }
            catch (Exception e) {
                e.printStackTrace();
                if (((SQLException)e).getErrorCode() != 5 || attempt == 4) {
                    e.printStackTrace();
                    this.logger.error("Error while fetching mqtt details : " + e);
                    break;
                }
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
                continue;
            }
            finally {
                SQLiteConnector.closeConnection(connection);
            }
        }
        return mqttDataList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPublishTopicName(String targetBrokerIpAddress) {
        block10: {
            Connection connection = null;
            int attempt = 0;
            if (attempt < 5) {
                try {
                    connection = SQLiteConnector.getConnection();
                    String sql = "SELECT * FROM mqtt WHERE broker_ip_address = ?";
                    PreparedStatement statement = connection.prepareStatement(sql);
                    statement.setString(1, MQTT_opertions.encrypt(targetBrokerIpAddress));
                    ResultSet resultSet = statement.executeQuery();
                    String string = MQTT_opertions.decrypt(resultSet.getString("publish_topic"));
                    return string;
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    if (e.getErrorCode() != 5 || attempt == 4) {
                        e.printStackTrace();
                        this.logger.error("Error while querying mqtt table : " + e);
                        FileBasedLogger.error("Application", "Error while querying mqtt table : " + e, "system");
                        break block10;
                    }
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (InterruptedException ie) {
                        Thread.currentThread().interrupt();
                    }
                    String string = "";
                    return string;
                }
                finally {
                    SQLiteConnector.closeConnection(connection);
                }
            }
        }
        return "";
    }

    /*
     * Exception decompiling
     */
    public String getpublishingFormat(String targetBrokerIpAddress) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public String getTimeFormat(String targetBrokerIpAddress) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSubcribeTopicName(String targetBrokerIpAddress) {
        for (int attempt = 0; attempt < 5; ++attempt) {
            Connection connection = null;
            try {
                connection = SQLiteConnector.getConnection();
                String sql = "SELECT * FROM mqtt WHERE broker_ip_address = ?";
                PreparedStatement statement = connection.prepareStatement(sql);
                statement.setString(1, MQTT_opertions.encrypt(targetBrokerIpAddress));
                ResultSet resultSet = statement.executeQuery();
                String string = MQTT_opertions.decrypt(resultSet.getString("subscribe_topic"));
                return string;
            }
            catch (SQLException e) {
                if (e.getErrorCode() != 5 || attempt == 4) {
                    this.logger.error("Error while querying mqtt table: " + e);
                    FileBasedLogger.error("Application", "Error while querying mqtt table: " + e, "system");
                    e.printStackTrace();
                    break;
                }
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
                continue;
            }
            finally {
                SQLiteConnector.closeConnection(connection);
            }
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getmqttStatus(String targetBrokerIpAddress) {
        for (int attempt = 0; attempt < 5; ++attempt) {
            Connection connection = null;
            try {
                connection = SQLiteConnector.getConnection();
                String sql = "SELECT * FROM mqtt WHERE broker_ip_address = ?";
                PreparedStatement statement = connection.prepareStatement(sql);
                statement.setString(1, MQTT_opertions.encrypt(targetBrokerIpAddress));
                ResultSet resultSet = statement.executeQuery();
                String string = MQTT_opertions.decrypt(resultSet.getString("enable"));
                return string;
            }
            catch (SQLException e) {
                if (e.getErrorCode() != 5 || attempt == 4) {
                    this.logger.error("Error while querying mqtt table: " + e);
                    FileBasedLogger.error("Application", "Error while querying mqtt table: " + e, "system");
                    e.printStackTrace();
                    break;
                }
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
                continue;
            }
            finally {
                SQLiteConnector.closeConnection(connection);
            }
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getBrokerIpAddresses() {
        ArrayList<String> brokerIpAddresses = new ArrayList<String>();
        for (int attempt = 0; attempt < 5; ++attempt) {
            Connection connection = null;
            Statement fetchStatement = null;
            try {
                connection = SQLiteConnector.getConnection();
                String fetchSql = "SELECT broker_ip_address FROM mqtt";
                fetchStatement = connection.createStatement();
                ResultSet resultSet = fetchStatement.executeQuery(fetchSql);
                while (resultSet.next()) {
                    String brokerIpAddress = resultSet.getString("broker_ip_address");
                    brokerIpAddresses.add(MQTT_opertions.decrypt(brokerIpAddress));
                }
                ArrayList<String> arrayList = brokerIpAddresses;
                return arrayList;
            }
            catch (SQLException e) {
                if (e.getErrorCode() != 5 || attempt == 4) {
                    e.printStackTrace();
                    this.logger.error("Error while querying mqtt table: " + e);
                    FileBasedLogger.error("Application", "Error while querying mqtt table: " + e, "system");
                    break;
                }
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
                continue;
            }
            finally {
                if (fetchStatement != null) {
                    try {
                        fetchStatement.close();
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                }
                SQLiteConnector.closeConnection(connection);
            }
        }
        return brokerIpAddresses;
    }
}

