/*
 * Decompiled with CFR 0.152.
 */
package com.tas.wp500.modBusClientSettings;

import com.tas.wp500.protocol.modbusClient.ModbusQueries;
import com.tas.wp500.protocol.modbusClient.TcpModbusExecuter;
import com.tas.wp500.security.Security;
import com.tas.wp500.sql_lite_db.SQLiteConnector;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ModbusQueriessDbOperation
extends Security {
    private static Logger logger = Logger.getLogger(ModbusQueriessDbOperation.class);
    private static ModbusQueriessDbOperation instance = null;

    private ModbusQueriessDbOperation() {
        this.createModbusQueriessTable();
    }

    public static ModbusQueriessDbOperation getInstance() {
        if (instance == null) {
            instance = new ModbusQueriessDbOperation();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createModbusQueriessTable() {
        Connection connection = SQLiteConnector.getConnection();
        try {
            Statement statement = connection.createStatement();
            String sql = "CREATE TABLE `Modbus_Queriess` (`id`    INTEGER PRIMARY KEY AUTOINCREMENT,`device_name`    TEXT,`queries_name`    TEXT,`slave_id`    TEXT,`function_code`    TEXT,`data_type`    TEXT,`start_address`    TEXT,`no_of_register`    TEXT,`status`    TEXT);";
            statement.execute(sql);
            statement.close();
            System.out.println("Modbus queries table created successfully.");
        }
        catch (SQLException e) {
            e.printStackTrace();
            logger.error("Error while creating modbus queries table: " + e);
        }
        finally {
            SQLiteConnector.closeConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject insertModbusQuery(JSONObject json) {
        JSONObject resultObj = new JSONObject();
        Connection connection = SQLiteConnector.getConnection();
        PreparedStatement preparedStatement = null;
        try {
            String sql = "INSERT INTO Modbus_Queriess (device_name, queries_name, slave_id, function_code, data_type, start_address, no_of_register, status) VALUES (?, ?, ?, ?, ?, ?, ?, ?)";
            preparedStatement = connection.prepareStatement(sql);
            preparedStatement.setString(1, ModbusQueriessDbOperation.encrypt(json.getString("device_name")));
            preparedStatement.setString(2, ModbusQueriessDbOperation.encrypt(json.getString("queries_name")));
            preparedStatement.setString(3, ModbusQueriessDbOperation.encrypt(json.getString("slave_id")));
            preparedStatement.setString(4, ModbusQueriessDbOperation.encrypt(json.getString("function_code")));
            preparedStatement.setString(5, ModbusQueriessDbOperation.encrypt(json.getString("data_type")));
            preparedStatement.setString(6, ModbusQueriessDbOperation.encrypt(json.getString("start_address")));
            preparedStatement.setString(7, ModbusQueriessDbOperation.encrypt(json.getString("no_of_register")));
            preparedStatement.setString(8, ModbusQueriessDbOperation.encrypt(json.getString("status")));
            preparedStatement.executeUpdate();
            preparedStatement.close();
            resultObj.put("status", "success");
            resultObj.put("msg", "Modbus query inserted successfully.");
            System.out.println("Modbus query inserted successfully.");
        }
        catch (SQLException e) {
            e.printStackTrace();
            resultObj.put("status", "fail");
            resultObj.put("msg", "Failed to insert Modbus query. Please try again.");
            logger.error("Error while inserting modbus query: " + e);
        }
        finally {
            SQLiteConnector.closeConnection(connection);
        }
        return resultObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject deleteModbusQuery(JSONObject json) {
        JSONObject resultObj = new JSONObject();
        Connection connection = SQLiteConnector.getConnection();
        PreparedStatement preparedStatement = null;
        try {
            String sql = "DELETE FROM Modbus_Queriess WHERE id = ?";
            preparedStatement = connection.prepareStatement(sql);
            preparedStatement.setInt(1, json.getInt("id"));
            int rowsDeleted = preparedStatement.executeUpdate();
            if (rowsDeleted > 0) {
                resultObj.put("status", "success");
                resultObj.put("msg", "Modbus query deleted successfully.");
            } else {
                resultObj.put("status", "fail");
                resultObj.put("msg", "No Modbus query found with the given ID.");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            resultObj.put("status", "fail");
            resultObj.put("msg", "Failed to delete Modbus query. Please try again.");
            logger.error("Error while deleting modbus query: " + e);
        }
        finally {
            SQLiteConnector.closeConnection(connection);
        }
        return resultObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject updateModbusQuery(JSONObject json) {
        JSONObject resultObj = new JSONObject();
        Connection connection = SQLiteConnector.getConnection();
        PreparedStatement preparedStatement = null;
        try {
            String sql = "UPDATE Modbus_Queriess SET device_name = ?, queries_name = ?, slave_id = ?, function_code = ?, data_type = ?, start_address = ?, no_of_register = ?, status = ? WHERE id = ?";
            preparedStatement = connection.prepareStatement(sql);
            preparedStatement.setString(1, ModbusQueriessDbOperation.encrypt(json.getString("device_name")));
            preparedStatement.setString(2, ModbusQueriessDbOperation.encrypt(json.getString("queries_name")));
            preparedStatement.setString(3, ModbusQueriessDbOperation.encrypt(json.getString("slave_id")));
            preparedStatement.setString(4, ModbusQueriessDbOperation.encrypt(json.getString("function_code")));
            preparedStatement.setString(5, ModbusQueriessDbOperation.encrypt(json.getString("data_type")));
            preparedStatement.setString(6, ModbusQueriessDbOperation.encrypt(json.getString("start_address")));
            preparedStatement.setString(7, ModbusQueriessDbOperation.encrypt(json.getString("no_of_register")));
            preparedStatement.setString(8, ModbusQueriessDbOperation.encrypt(json.getString("status")));
            preparedStatement.setInt(9, json.getInt("id"));
            int rowsUpdated = preparedStatement.executeUpdate();
            if (rowsUpdated > 0) {
                resultObj.put("status", "success");
                resultObj.put("msg", "Modbus query updated successfully.");
            } else {
                resultObj.put("status", "fail");
                resultObj.put("msg", "No Modbus query found with the given ID.");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            resultObj.put("status", "fail");
            resultObj.put("msg", "Failed to update Modbus query. Please try again.");
            logger.error("Error while updating modbus query: " + e);
        }
        finally {
            SQLiteConnector.closeConnection(connection);
        }
        return resultObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<ModbusQueries> getAllModbusQueries() {
        ArrayList<ModbusQueries> queriesList = new ArrayList<ModbusQueries>();
        Connection connection = SQLiteConnector.getConnection();
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = connection.createStatement();
            String sql = "SELECT * FROM Modbus_Queriess";
            resultSet = statement.executeQuery(sql);
            while (resultSet.next()) {
                ModbusQueries query = new ModbusQueries();
                query.setId(resultSet.getInt("id"));
                query.setDevice_name(ModbusQueriessDbOperation.decrypt(resultSet.getString("device_name")));
                query.setQueries_name(ModbusQueriessDbOperation.decrypt(resultSet.getString("queries_name")));
                query.setSlave_id(Integer.parseInt(ModbusQueriessDbOperation.decrypt(resultSet.getString("slave_id"))));
                query.setFunction_code(ModbusQueriessDbOperation.decrypt(resultSet.getString("function_code")));
                query.setData_type(ModbusQueriessDbOperation.decrypt(resultSet.getString("data_type")));
                query.setStart_address(Long.parseLong(ModbusQueriessDbOperation.decrypt(resultSet.getString("start_address"))));
                query.setNo_of_register(Long.parseLong(ModbusQueriessDbOperation.decrypt(resultSet.getString("no_of_register"))));
                query.setStatus(ModbusQueriessDbOperation.decrypt(resultSet.getString("status")));
                queriesList.add(query);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            SQLiteConnector.closeConnection(connection);
        }
        return queriesList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONArray getAllModbusQueriesAsJsonArray() {
        JSONArray jsonArray = new JSONArray();
        Connection connection = SQLiteConnector.getConnection();
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = connection.createStatement();
            String sql = "SELECT * FROM Modbus_Queriess";
            resultSet = statement.executeQuery(sql);
            while (resultSet.next()) {
                JSONObject queryJson = new JSONObject();
                queryJson.put("id", resultSet.getInt("id"));
                queryJson.put("device_name", ModbusQueriessDbOperation.decrypt(resultSet.getString("device_name")));
                queryJson.put("queries_name", ModbusQueriessDbOperation.decrypt(resultSet.getString("queries_name")));
                queryJson.put("slave_id", ModbusQueriessDbOperation.decrypt(resultSet.getString("slave_id")));
                queryJson.put("function_code", ModbusQueriessDbOperation.decrypt(resultSet.getString("function_code")));
                queryJson.put("data_type", ModbusQueriessDbOperation.decrypt(resultSet.getString("data_type")));
                queryJson.put("start_address", ModbusQueriessDbOperation.decrypt(resultSet.getString("start_address")));
                queryJson.put("no_of_register", ModbusQueriessDbOperation.decrypt(resultSet.getString("no_of_register")));
                queryJson.put("status", ModbusQueriessDbOperation.decrypt(resultSet.getString("status")));
                jsonArray.put(queryJson);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            SQLiteConnector.closeConnection(connection);
        }
        return jsonArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject getAllModbusQueriesAsJsonObj() {
        JSONArray jsonArray = new JSONArray();
        JSONObject resultObj = new JSONObject();
        Connection connection = SQLiteConnector.getConnection();
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = connection.createStatement();
            String sql = "SELECT * FROM Modbus_Queriess";
            resultSet = statement.executeQuery(sql);
            while (resultSet.next()) {
                JSONObject queryJson = new JSONObject();
                queryJson.put("id", resultSet.getInt("id"));
                queryJson.put("device_name", ModbusQueriessDbOperation.decrypt(resultSet.getString("device_name")));
                queryJson.put("queries_name", ModbusQueriessDbOperation.decrypt(resultSet.getString("queries_name")));
                queryJson.put("slave_id", ModbusQueriessDbOperation.decrypt(resultSet.getString("slave_id")));
                queryJson.put("function_code", ModbusQueriessDbOperation.decrypt(resultSet.getString("function_code")));
                queryJson.put("data_type", ModbusQueriessDbOperation.decrypt(resultSet.getString("data_type")));
                queryJson.put("start_address", ModbusQueriessDbOperation.decrypt(resultSet.getString("start_address")));
                queryJson.put("no_of_register", ModbusQueriessDbOperation.decrypt(resultSet.getString("no_of_register")));
                queryJson.put("status", ModbusQueriessDbOperation.decrypt(resultSet.getString("status")));
                jsonArray.put(queryJson);
            }
            resultSet.close();
            statement.close();
            resultObj.put("resultArray", jsonArray);
            resultObj.put("status", "success");
            resultObj.put("msg", "Retrieved all Modbus queries successfully.");
        }
        catch (SQLException e) {
            e.printStackTrace();
            resultObj.put("status", "error");
            resultObj.put("msg", "Failed to retrieve Modbus queries: " + e.getMessage());
        }
        finally {
            SQLiteConnector.closeConnection(connection);
        }
        System.out.println("result : " + resultObj);
        return resultObj;
    }

    public JSONObject modbusDebugQuery(JSONObject json) {
        JSONObject resultObj = new JSONObject();
        try {
            String deviceName = json.getString("device_name");
            String queriesName = json.getString("queries_name");
            String startAddress = json.getString("start_address");
            String noOfRegister = json.getString("no_of_register");
            String dataType = json.getString("data_type");
            String key = deviceName + "_" + queriesName;
            JSONArray dataArray = new JSONArray();
            ArrayList<Long> regList = this.getRegList(Long.parseLong(startAddress), Long.parseLong(noOfRegister), dataType);
            for (Long reg : regList) {
                JSONObject registerValues = new JSONObject();
                double value = TcpModbusExecuter.tagHashmap.getOrDefault(key + "_" + reg, 0.0);
                registerValues.put("address", reg);
                registerValues.put("value", value);
                dataArray.put(registerValues);
            }
            resultObj.put("register_values", dataArray);
            resultObj.put("status", "success");
            resultObj.put("msg", "Successfully fetched address and value list.");
        }
        catch (Exception e) {
            resultObj.put("status", "fail");
            resultObj.put("msg", "Error while fetching modbus address list." + e.getMessage());
        }
        System.out.println("resultObj-->" + resultObj);
        return resultObj;
    }

    public ArrayList<Long> getRegList(long startReg, long noOfReg, String dataType) {
        ArrayList<Long> longList = new ArrayList<Long>();
        switch (dataType) {
            case "swap_float": {
                for (long i = 0L; i < noOfReg; ++i) {
                    longList.add(startReg + i);
                    ++i;
                }
                break;
            }
            case "non_swap_float": {
                for (long i = 0L; i < noOfReg; ++i) {
                    longList.add(startReg + i);
                    ++i;
                }
                break;
            }
            case "swap_long": {
                for (long i = 0L; i < noOfReg; ++i) {
                    longList.add(startReg + i);
                    ++i;
                }
                break;
            }
            case "non_swap_long": {
                for (long i = 0L; i < noOfReg; ++i) {
                    longList.add(startReg + i);
                    ++i;
                }
                break;
            }
            case "integer": {
                for (long i = 0L; i < noOfReg; ++i) {
                    longList.add(startReg + i);
                }
                break;
            }
            case "boolean": {
                for (long i = 0L; i < noOfReg; ++i) {
                    longList.add(startReg + i);
                }
                break;
            }
        }
        return longList;
    }

    public JSONObject sortQueryDbOperation(JSONObject json) throws JSONException {
        JSONObject ack_res = new JSONObject();
        if (json.has("operation_type")) {
            String operation_type;
            switch (operation_type = json.getString("operation_type")) {
                case "insert_modbusQuery_data": {
                    ack_res = this.insertModbusQuery(json);
                    ack_res.put("operation_type", "insert_modbusQuery_data");
                    break;
                }
                case "update_modbusQuery_data": {
                    ack_res = this.updateModbusQuery(json);
                    ack_res.put("operation_type", "update_modbusQuery_data");
                    break;
                }
                case "delete_modbusQuery_data": {
                    ack_res = this.deleteModbusQuery(json);
                    ack_res.put("operation_type", "delete_modbusQuery_data");
                    break;
                }
                case "get_modbusQuery_data": {
                    ack_res = this.getAllModbusQueriesAsJsonObj();
                    ack_res = ack_res.put("operation_type", "get_modbusQuery_data");
                    break;
                }
                case "get_modbusDebugQuery_data": {
                    ack_res = this.modbusDebugQuery(json);
                    ack_res = ack_res.put("operation_type", "get_modbusQuery_data");
                    break;
                }
            }
        }
        return ack_res;
    }
}

