/*
 * Decompiled with CFR 0.152.
 */
package com.tas.wp500.modBusClientSettings;

import com.tas.wp500.protocol.modbusClient.ModbusClient;
import com.tas.wp500.security.Security;
import com.tas.wp500.sql_lite_db.SQLiteConnector;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ModbusClientsDbOperation
extends Security {
    private static Logger logger = Logger.getLogger(ModbusClientsDbOperation.class);
    private static ModbusClientsDbOperation instance = null;

    private ModbusClientsDbOperation() {
        this.createModbusClientsTable();
    }

    public static ModbusClientsDbOperation getInstance() {
        if (instance == null) {
            instance = new ModbusClientsDbOperation();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createModbusClientsTable() {
        Connection connection = SQLiteConnector.getConnection();
        try {
            Statement statement = connection.createStatement();
            String sql = "CREATE TABLE IF NOT EXISTS modbus_clients (id INTEGER PRIMARY KEY AUTOINCREMENT, device_name TEXT, HostIp TEXT, portNo TEXT, status TEXT)";
            statement.execute(sql);
            statement.close();
            System.out.println("Modbus clients table created successfully.");
        }
        catch (SQLException e) {
            e.printStackTrace();
            logger.error("Error while creating modbus clients table: " + e);
        }
        finally {
            SQLiteConnector.closeConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject insertModbusClient(JSONObject json) {
        JSONObject resultObj = new JSONObject();
        Connection connection = SQLiteConnector.getConnection();
        PreparedStatement preparedStatement = null;
        try {
            String deviceName = json.getString("device_name");
            if (deviceName.length() > 20) {
                resultObj.put("status", "fail");
                resultObj.put("msg", "Device name exceeds maximum length (100 characters). Modbus client setting not saved.");
                JSONObject jSONObject = resultObj;
                return jSONObject;
            }
            String hostIp = json.getString("hostIp");
            if (!this.isValidIpAddress(hostIp)) {
                resultObj.put("status", "fail");
                resultObj.put("msg", "Invalid host IP address format. Modbus client setting not saved.");
                JSONObject jSONObject = resultObj;
                return jSONObject;
            }
            String portNo = json.getString("portNo");
            if (Integer.parseInt(portNo) < 1 || Integer.parseInt(portNo) > 65535) {
                resultObj.put("status", "fail");
                resultObj.put("msg", "Invalid port number. Port number must be in the range 1-65535. Modbus client setting not saved.");
                JSONObject jSONObject = resultObj;
                return jSONObject;
            }
            String checkSql = "SELECT COUNT(*) FROM modbus_clients WHERE device_name = ?";
            preparedStatement = connection.prepareStatement(checkSql);
            preparedStatement.setString(1, ModbusClientsDbOperation.encrypt(deviceName));
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next() && resultSet.getInt(1) > 0) {
                resultObj.put("status", "fail");
                resultObj.put("msg", "Device name already exists. Modbus client setting not saved.");
            } else {
                String insertSql = "INSERT INTO modbus_clients (device_name, HostIp, portNo, status) VALUES (?, ?, ?, ?)";
                preparedStatement = connection.prepareStatement(insertSql);
                preparedStatement.setString(1, ModbusClientsDbOperation.encrypt(deviceName));
                preparedStatement.setString(2, ModbusClientsDbOperation.encrypt(hostIp));
                preparedStatement.setString(3, ModbusClientsDbOperation.encrypt(portNo));
                preparedStatement.setString(4, ModbusClientsDbOperation.encrypt(json.getString("status")));
                preparedStatement.executeUpdate();
                resultObj.put("status", "success");
                resultObj.put("msg", "Modbus client setting saved successfully.");
                System.out.println("Modbus client inserted successfully.");
            }
            preparedStatement.close();
            resultSet.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            resultObj.put("status", "fail");
            resultObj.put("msg", "Failed to save Modbus client setting. Please try again.");
            logger.error("Error while inserting modbus client: " + e);
        }
        finally {
            SQLiteConnector.closeConnection(connection);
        }
        return resultObj;
    }

    private boolean isValidIpAddress(String ipAddress) {
        String ipPattern = "^([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])$";
        return Pattern.matches(ipPattern, ipAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject deleteModbusClient(JSONObject json) {
        JSONObject resultObj = new JSONObject();
        Connection connection = SQLiteConnector.getConnection();
        PreparedStatement preparedStatement = null;
        try {
            String sql = "DELETE FROM modbus_clients WHERE device_name = ?";
            preparedStatement = connection.prepareStatement(sql);
            preparedStatement.setString(1, ModbusClientsDbOperation.encrypt(json.getString("device_name")));
            int rowsDeleted = preparedStatement.executeUpdate();
            if (rowsDeleted > 0) {
                resultObj.put("status", "success");
                resultObj.put("msg", "Modbus client deleted successfully.");
            } else {
                resultObj.put("status", "fail");
                resultObj.put("msg", "No Modbus client found with the given device name.");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            resultObj.put("status", "fail");
            resultObj.put("msg", "Failed to delete Modbus client. Please try again.");
            logger.error("Error while deleting modbus client: " + e);
        }
        finally {
            SQLiteConnector.closeConnection(connection);
        }
        return resultObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject updateModbusClient(JSONObject json) {
        JSONObject resultObj = new JSONObject();
        Connection connection = SQLiteConnector.getConnection();
        PreparedStatement preparedStatement = null;
        try {
            String hostIp = json.getString("hostIp");
            if (!this.isValidIpAddress(hostIp)) {
                resultObj.put("status", "fail");
                resultObj.put("msg", "Invalid host IP address format. Modbus client not updated.");
                JSONObject jSONObject = resultObj;
                return jSONObject;
            }
            String portNo = json.getString("portNo");
            if (Integer.parseInt(portNo) < 1 || Integer.parseInt(portNo) > 65535) {
                resultObj.put("status", "fail");
                resultObj.put("msg", "Invalid port number. Port number must be in the range 1-65535. Modbus client not updated.");
                JSONObject jSONObject = resultObj;
                return jSONObject;
            }
            String status = json.getString("status");
            if (status.isEmpty()) {
                resultObj.put("status", "fail");
                resultObj.put("msg", "Status cannot be empty. Modbus client not updated.");
                JSONObject jSONObject = resultObj;
                return jSONObject;
            }
            String sql = "UPDATE modbus_clients SET HostIp = ?, portNo = ?, status = ? WHERE device_name = ?";
            preparedStatement = connection.prepareStatement(sql);
            preparedStatement.setString(1, ModbusClientsDbOperation.encrypt(hostIp));
            preparedStatement.setString(2, ModbusClientsDbOperation.encrypt(portNo));
            preparedStatement.setString(3, ModbusClientsDbOperation.encrypt(status));
            preparedStatement.setString(4, ModbusClientsDbOperation.encrypt(json.getString("device_name")));
            int rowsUpdated = preparedStatement.executeUpdate();
            if (rowsUpdated > 0) {
                resultObj.put("status", "success");
                resultObj.put("msg", "Modbus client updated successfully.");
            } else {
                resultObj.put("status", "fail");
                resultObj.put("msg", "No Modbus client found with the given device_name.");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            resultObj.put("status", "fail");
            resultObj.put("msg", "Failed to update Modbus client. Please try again.");
            logger.error("Error while updating modbus client: " + e);
        }
        finally {
            SQLiteConnector.closeConnection(connection);
        }
        return resultObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<ModbusClient> getAllModbusClients() {
        ArrayList<ModbusClient> clientsList = new ArrayList<ModbusClient>();
        Connection connection = SQLiteConnector.getConnection();
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = connection.createStatement();
            String sql = "SELECT * FROM modbus_clients";
            resultSet = statement.executeQuery(sql);
            while (resultSet.next()) {
                ModbusClient client = new ModbusClient();
                client.setDeviceName(ModbusClientsDbOperation.decrypt(resultSet.getString("device_name")));
                client.setHostIp(ModbusClientsDbOperation.decrypt(resultSet.getString("HostIp")));
                client.setPortNo(ModbusClientsDbOperation.decrypt(resultSet.getString("portNo")));
                client.setStatus(ModbusClientsDbOperation.decrypt(resultSet.getString("status")));
                clientsList.add(client);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (statement != null) {
                    statement.close();
                }
                SQLiteConnector.closeConnection(connection);
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return clientsList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject getAllModbusClients1() {
        JSONObject resultObj = new JSONObject();
        Connection connection = SQLiteConnector.getConnection();
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = connection.createStatement();
            String sql = "SELECT * FROM modbus_clients";
            resultSet = statement.executeQuery(sql);
            JSONArray resultArry = new JSONArray();
            while (resultSet.next()) {
                JSONObject clientObj = new JSONObject();
                clientObj.put("device_name", ModbusClientsDbOperation.decrypt(resultSet.getString("device_name")));
                clientObj.put("hostIp", ModbusClientsDbOperation.decrypt(resultSet.getString("HostIp")));
                clientObj.put("portNo", ModbusClientsDbOperation.decrypt(resultSet.getString("portNo")));
                clientObj.put("status", ModbusClientsDbOperation.decrypt(resultSet.getString("status")));
                resultArry.put(clientObj);
            }
            resultObj.put("status", "success");
            resultObj.put("msg", "Successfully retrieved all Modbus clients.");
            resultObj.put("dataArray", resultArry);
        }
        catch (SQLException e) {
            e.printStackTrace();
            resultObj.put("status", "fail");
            resultObj.put("msg", "Failed to retrieve Modbus clients. Please try again.");
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (statement != null) {
                    statement.close();
                }
                SQLiteConnector.closeConnection(connection);
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return resultObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject getDeviceNamesFromTable() {
        JSONArray deviceNamesArray = new JSONArray();
        JSONObject resultObj = new JSONObject();
        Connection connection = SQLiteConnector.getConnection();
        PreparedStatement preparedStatement = null;
        try {
            String sql = "SELECT device_name FROM modbus_clients";
            preparedStatement = connection.prepareStatement(sql);
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String deviceName = ModbusClientsDbOperation.decrypt(resultSet.getString("device_name"));
                deviceNamesArray.put(deviceName);
            }
            resultObj.put("resultArray", deviceNamesArray);
            resultObj.put("status", "success");
            resultObj.put("msg", "Device names retrieved successfully.");
        }
        catch (SQLException e) {
            e.printStackTrace();
            resultObj.put("status", "fail");
            resultObj.put("msg", "Failed to retrieve device names from the table: ");
        }
        finally {
            SQLiteConnector.closeConnection(connection);
        }
        return resultObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject getModbusClientsByDevice(JSONObject json) {
        JSONObject resultObj = new JSONObject();
        Connection connection = SQLiteConnector.getConnection();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            String sql = "SELECT * FROM modbus_clients WHERE device_name = ?";
            preparedStatement = connection.prepareStatement(sql);
            preparedStatement.setString(1, ModbusClientsDbOperation.encrypt(json.getString("device_name")));
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                resultObj.put("device_name", ModbusClientsDbOperation.decrypt(resultSet.getString("device_name")));
                resultObj.put("hostIp", ModbusClientsDbOperation.decrypt(resultSet.getString("HostIp")));
                resultObj.put("portNo", ModbusClientsDbOperation.decrypt(resultSet.getString("portNo")));
                resultObj.put("status", ModbusClientsDbOperation.decrypt(resultSet.getString("status")));
            }
            if (resultObj.length() > 0) {
                resultObj.put("Status", "success");
                resultObj.put("msg", "Successfully retrieved Modbus client(s) for device: ");
            } else {
                resultObj.put("Status", "fail");
                resultObj.put("msg", "No Modbus client found for device: ");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            resultObj.put("Status", "fail");
            resultObj.put("msg", "Failed to retrieve Modbus clients. Please try again.");
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                SQLiteConnector.closeConnection(connection);
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return resultObj;
    }

    public JSONObject sortQueryDbOperation(JSONObject json) throws JSONException {
        JSONObject ack_res = new JSONObject();
        if (json.has("operation_type")) {
            String operation_type;
            switch (operation_type = json.getString("operation_type")) {
                case "insert_modbusClient_data": {
                    ack_res = this.insertModbusClient(json);
                    ack_res.put("operation_type", "insert_modbusClient_data");
                    break;
                }
                case "update_modbusClient_data": {
                    ack_res = this.updateModbusClient(json);
                    ack_res.put("operation_type", "update_modbusClient_data");
                    break;
                }
                case "delete_modbusClient_data": {
                    ack_res = this.deleteModbusClient(json);
                    ack_res.put("operation_type", "delete_modbusClient_data");
                    break;
                }
                case "get_modbusClient_data": {
                    ack_res = this.getAllModbusClients1();
                    ack_res = ack_res.put("operation_type", "get_modbusClient_data");
                    break;
                }
                case "get_modbus_clients_data_by_device": {
                    ack_res = this.getModbusClientsByDevice(json);
                    ack_res = ack_res.put("operation_type", "get_modbus_clients_data_by_device");
                    break;
                }
                case "get_device_list": {
                    ack_res = this.getDeviceNamesFromTable();
                    ack_res = ack_res.put("operation_type", "get_modbus_clients_data_by_device");
                    break;
                }
            }
        }
        return ack_res;
    }
}

