/*
 * Decompiled with CFR 0.152.
 */
package com.tas.wp500.log4jSetting;

import java.io.File;
import java.util.Arrays;
import java.util.Comparator;
import org.apache.log4j.Logger;

public class LogCleaner {
    private static final String LOG_DIRECTORY_PATH = "/data/log/";
    private static final long MAX_LOG_FOLDER_SIZE = 0x1400000L;
    private static final Logger logger = Logger.getLogger(LogCleaner.class);

    public static void cleanLogFiles() {
        File logDirectory = new File(LOG_DIRECTORY_PATH);
        if (!logDirectory.exists() || !logDirectory.isDirectory()) {
            logger.warn("Log directory does not exist or is not a directory: /data/log/");
            return;
        }
        File[] logFiles = logDirectory.listFiles((dir, name) -> name.endsWith(".log"));
        if (logFiles == null || logFiles.length == 0) {
            logger.info("No log files found to clean.");
            return;
        }
        long totalSize = Arrays.stream(logFiles).mapToLong(File::length).sum();
        if (totalSize > 0x1400000L) {
            Arrays.sort(logFiles, Comparator.comparingLong(File::lastModified));
            for (File file : logFiles) {
                if (totalSize > 0x1400000L) {
                    long fileSize = file.length();
                    if (file.delete()) {
                        totalSize -= fileSize;
                        continue;
                    }
                    logger.warn("Failed to delete log file: " + file.getName());
                    continue;
                }
                break;
            }
        } else {
            logger.info("Log folder size is within the limit. No cleanup needed.");
        }
    }
}

