/*
 * Decompiled with CFR 0.152.
 */
package com.tas.wp500.liveValueTrigger;

import com.tas.wp500.linx_command.FileReaderUtil;
import com.tas.wp500.protocol.startan.Tag;
import com.tas.wp500.services.Service;
import com.tas.wp500.smtpSettings.SmtpDemo;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimerTask;
import javax.mail.MessagingException;
import org.apache.log4j.Logger;
import org.json.JSONObject;

public class TriggerCheckTimer
extends TimerTask {
    private static Logger logger = Logger.getLogger(TriggerCheckTimer.class);
    SmtpDemo smtp = SmtpDemo.getInstance();
    private JSONObject dataObj;
    private String currentTagName = "";
    private int previousValue = -1;
    private boolean emailSent = false;

    public void setDataObj(JSONObject dataObj) {
        this.dataObj = dataObj;
        String tagName = dataObj.optString("tag_name");
        if (!tagName.equalsIgnoreCase(this.currentTagName)) {
            this.currentTagName = tagName;
            this.emailSent = false;
        }
    }

    @Override
    public void run() {
        block9: {
            try {
                if (this.dataObj == null) break block9;
                String tagName = this.dataObj.optString("tag_name");
                String dataValue = this.dataObj.getString("compare_tag_value");
                int value = Integer.parseInt(dataValue);
                String mailStatus = this.dataObj.getString("mail");
                Tag tag = Service.variableTagMap.get(tagName);
                if (tag != null) {
                    String currentValueString = tag.getValue().toString();
                    try {
                        int currentValue = Integer.parseInt(currentValueString);
                        if (this.previousValue != currentValue) {
                            this.previousValue = currentValue;
                            this.emailSent = false;
                        }
                        if (currentValue != value || this.emailSent) break block9;
                        logger.info("Value of tag " + tagName + " has matched from " + currentValue + " to " + value);
                        if (mailStatus.equalsIgnoreCase("enable")) {
                            JSONObject resultObj = FileReaderUtil.getInstance().getOverviewInfo("wp500");
                            String tasSerialNo = resultObj.getString("TAS_SERIAL_NO");
                            String message = this.constructEmailMessage(this.dataObj.optString("tag_msg"), tasSerialNo);
                            try {
                                new Thread(() -> {
                                    try {
                                        this.smtp.sendEmailMessage(message, "Tampering-Alert TAS Serial No: " + tasSerialNo);
                                    }
                                    catch (MessagingException e) {
                                        e.printStackTrace();
                                    }
                                }).start();
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        this.emailSent = true;
                    }
                    catch (NumberFormatException e) {
                        logger.error("Error: The value of the tag " + tagName + " is not a valid number.");
                    }
                    break block9;
                }
                logger.info("Tag not found with name: " + tagName);
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error("Error while checking trigger value from tag: " + e.getMessage());
            }
        }
    }

    private String constructEmailMessage(String msg, String tasSerialNo) {
        Date currentTime = new Date();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String formattedTime = dateFormat.format(currentTime);
        StringBuilder emailContent = new StringBuilder();
        emailContent.append("<html><body>");
        emailContent.append("<h2>Tampering Details for TAS Serial No: ").append(tasSerialNo).append("</h2>");
        emailContent.append("<p><strong>Message: </strong>").append(msg).append("</p>");
        emailContent.append("<p><strong>Rtu Time: </strong>").append(formattedTime).append("</p>");
        emailContent.append("</body></html>");
        return emailContent.toString();
    }
}

