/*
 * Decompiled with CFR 0.152.
 */
package com.tas.wp500.liveValueTrigger;

import com.tas.wp500.fileLogSetting.FileBasedLogger;
import com.tas.wp500.liveValueTrigger.LiveValueTriggerOperation;
import com.tas.wp500.liveValueTrigger.TriggerCheckTimer;
import java.util.ArrayList;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.log4j.Logger;
import org.json.JSONObject;

public class TriggerCheckExecutor
implements Runnable {
    private static Logger logger = Logger.getLogger(TriggerCheckExecutor.class);
    private LiveValueTriggerOperation op = LiveValueTriggerOperation.getInstance();
    private ArrayList<Timer> triggerTimerList = new ArrayList();

    @Override
    public void run() {
        try {
            JSONObject retrieveLiveData = this.op.retrieveLiveData();
            String status = retrieveLiveData.getString("status");
            String tamperingStatus = retrieveLiveData.getString("tampering");
            String compareTagValue = retrieveLiveData.getString("compare_tag_value");
            if (status.equals("success") && tamperingStatus.equalsIgnoreCase("enable") && !compareTagValue.isEmpty()) {
                TriggerCheckTimer triggerCheckTimer = new TriggerCheckTimer();
                triggerCheckTimer.setDataObj(retrieveLiveData);
                Timer triggerTimer = new Timer();
                triggerTimer.scheduleAtFixedRate((TimerTask)triggerCheckTimer, 60000L, 60000L);
                this.triggerTimerList.add(triggerTimer);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(" Error while getting trigger value from db : " + e);
        }
    }

    public void cancelAlarmTimer(String user) {
        try {
            if (!this.triggerTimerList.isEmpty()) {
                ArrayList<Timer> timersCopy = new ArrayList<Timer>(this.triggerTimerList);
                for (Timer t : timersCopy) {
                    if (t == null) continue;
                    t.cancel();
                    logger.info("triggerTimerList timer canceled.");
                }
            }
            this.triggerTimerList.clear();
        }
        catch (Exception e) {
            e.printStackTrace();
            FileBasedLogger.error("Application", "Error while canceling trigger timer : " + e, user);
            logger.error("Error while canceling trigger timer : " + e);
        }
    }
}

