/*
 * Decompiled with CFR 0.152.
 */
package com.tas.wp500.liveValueTrigger;

import com.tas.wp500.fileLogSetting.FileBasedLogger;
import com.tas.wp500.security.Security;
import com.tas.wp500.sql_lite_db.SQLiteConnector;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;
import org.json.JSONException;
import org.json.JSONObject;

public class LiveValueTriggerOperation
extends Security {
    private static Logger logger = Logger.getLogger(LiveValueTriggerOperation.class);
    public static final int ID = 1;
    private static LiveValueTriggerOperation instance = null;
    public static final String CONFIG_PATH = "/etc/wp500cfg/config.ini";
    private static final int SQLITE_BUSY = 5;
    private static final int RETRY_COUNT = 5;
    private static final int RETRY_DELAY = 10000;

    private LiveValueTriggerOperation() {
        this.liveValueTriggerTable();
    }

    public static LiveValueTriggerOperation getInstance() {
        if (instance == null) {
            instance = new LiveValueTriggerOperation();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void liveValueTriggerTable() {
        Connection connection = null;
        try {
            connection = SQLiteConnector.getConnection();
            Statement statement = connection.createStatement();
            ResultSet resultSet = connection.getMetaData().getTables(null, null, "live_value_trigger", null);
            if (!resultSet.next()) {
                String createTableSql = "CREATE TABLE live_value_trigger (id INTEGER PRIMARY KEY CHECK (id = 1), tag_name TEXT, compare_tag_value TEXT, tag_msg TEXT, mail TEXT, tampering TEXT)";
                statement.execute(createTableSql);
                String insertQuery = "INSERT INTO live_value_trigger (id, tag_name, compare_tag_value, tag_msg, mail, tampering) VALUES (1, ?, ?, ?, ?, ?)";
                PreparedStatement preparedStatement = connection.prepareStatement(insertQuery);
                preparedStatement.setString(1, LiveValueTriggerOperation.encrypt(""));
                preparedStatement.setString(2, LiveValueTriggerOperation.encrypt(""));
                preparedStatement.setString(3, LiveValueTriggerOperation.encrypt(""));
                preparedStatement.setString(4, LiveValueTriggerOperation.encrypt("Disable"));
                preparedStatement.setString(5, LiveValueTriggerOperation.encrypt("Disable"));
                preparedStatement.executeUpdate();
                logger.debug("live_value_trigger table created successfully and default data inserted.");
            } else {
                logger.debug("live_value_trigger table already exists. Skipping creation and data insertion.");
            }
            statement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            logger.debug("Error while creating live_value_trigger table: " + e);
        }
        finally {
            SQLiteConnector.closeConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject insertOrUpdateLiveData(JSONObject jsonData) {
        JSONObject resultObj = new JSONObject();
        for (int attempt = 0; attempt < 5; ++attempt) {
            Connection connection = null;
            PreparedStatement preparedStatement = null;
            String tagName = "";
            try {
                int rowsAffected;
                boolean recordExists;
                String checkIfExistsQuery;
                if (jsonData.has("tag_name")) {
                    tagName = jsonData.getString("tag_name");
                }
                String compareTagValue = jsonData.getString("compare_tag_value");
                String tagMsg = jsonData.getString("tag_msg");
                String mail = jsonData.getString("mail");
                String tampering = jsonData.getString("tampering");
                connection = SQLiteConnector.getConnection();
                preparedStatement = connection.prepareStatement(checkIfExistsQuery = "SELECT COUNT(*) FROM live_value_trigger WHERE id = 1");
                ResultSet resultSet = preparedStatement.executeQuery();
                boolean bl = recordExists = resultSet.next() && resultSet.getInt(1) > 0;
                if (recordExists) {
                    String updateQuery = "UPDATE live_value_trigger SET tag_name = ?, compare_tag_value = ?, tag_msg = ?, mail = ?, tampering = ? WHERE id = 1";
                    preparedStatement = connection.prepareStatement(updateQuery);
                    preparedStatement.setString(1, LiveValueTriggerOperation.encrypt(tagName));
                    preparedStatement.setString(2, LiveValueTriggerOperation.encrypt(compareTagValue));
                    preparedStatement.setString(3, LiveValueTriggerOperation.encrypt(tagMsg));
                    preparedStatement.setString(4, LiveValueTriggerOperation.encrypt(mail));
                    preparedStatement.setString(5, LiveValueTriggerOperation.encrypt(tampering));
                    resultObj.put("msg", "Tampering setting has been updating successfully. Required load configuration updated.");
                }
                if ((rowsAffected = preparedStatement.executeUpdate()) > 0) {
                    resultObj.put("status", "success");
                } else {
                    resultObj.put("msg", "error while updating tampering setting.");
                }
                resultSet.close();
                preparedStatement.close();
                logger.info("Tampering setting save or update successfully.");
                FileBasedLogger.info("Audit", "Tampering setting save or update successfully.", jsonData.getString("user"));
            }
            catch (Exception e) {
                block13: {
                    e.printStackTrace();
                    if (((SQLException)e).getErrorCode() == 5 && attempt != 4) break block13;
                    logger.error("Error while saving or updating tampering setting : " + e.getMessage());
                    FileBasedLogger.error("Audit", "Error while saving or updating tampering setting : " + e.getMessage(), jsonData.getString("user"));
                    SQLiteConnector.closeConnection(connection);
                    break;
                }
                try {
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (InterruptedException ie) {
                        Thread.currentThread().interrupt();
                    }
                    continue;
                }
                finally {
                    SQLiteConnector.closeConnection(connection);
                }
            }
            SQLiteConnector.closeConnection(connection);
            break;
        }
        return resultObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject deleteLiveData() {
        JSONObject resultObj = new JSONObject();
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        try {
            connection = SQLiteConnector.getConnection();
            String deleteQuery = "DELETE FROM live_value_trigger WHERE id = 1";
            preparedStatement = connection.prepareStatement(deleteQuery);
            int rowsAffected = preparedStatement.executeUpdate();
            preparedStatement.close();
            if (rowsAffected > 0) {
                resultObj.put("status", "success");
                resultObj.put("msg", "Tampering settings deleted successfully.");
            } else {
                resultObj.put("status", "fail");
                resultObj.put("msg", "Tampering settings deleted successfully.");
            }
            logger.info("Tampering setting delete successfully.");
        }
        catch (SQLException e) {
            e.printStackTrace();
            logger.error("Error occurred while deleting data: " + e.getMessage());
        }
        finally {
            SQLiteConnector.closeConnection(connection);
        }
        return resultObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject retrieveLiveData() {
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        JSONObject resultObj = new JSONObject();
        try {
            connection = SQLiteConnector.getConnection();
            String selectQuery = "SELECT * FROM live_value_trigger WHERE id = 1";
            preparedStatement = connection.prepareStatement(selectQuery);
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                String tagName = resultSet.getString("tag_name");
                String compareTagValue = resultSet.getString("compare_tag_value");
                String tagMsg = resultSet.getString("tag_msg");
                resultObj.put("tag_name", LiveValueTriggerOperation.decrypt(tagName));
                resultObj.put("compare_tag_value", LiveValueTriggerOperation.decrypt(compareTagValue));
                resultObj.put("tag_msg", LiveValueTriggerOperation.decrypt(tagMsg));
                resultObj.put("mail", LiveValueTriggerOperation.decrypt(resultSet.getString("mail")));
                resultObj.put("tampering", LiveValueTriggerOperation.decrypt(resultSet.getString("tampering")));
                resultSet.close();
                preparedStatement.close();
                resultObj.put("status", "success");
                resultObj.put("msg", "Tampering settings fetched successfully.");
            } else {
                resultObj.put("status", "fail");
                resultObj.put("msg", "Error while retrieving tampering settings.");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            logger.error("Error occurred while retrieving data: " + e.getMessage());
        }
        finally {
            SQLiteConnector.closeConnection(connection);
        }
        return resultObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject retrieveLiveData1(String user) {
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        JSONObject resultObj = new JSONObject();
        try {
            connection = SQLiteConnector.getConnection();
            String selectQuery = "SELECT * FROM live_value_trigger WHERE id = 1";
            preparedStatement = connection.prepareStatement(selectQuery);
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                String tagName = resultSet.getString("tag_name");
                String compareTagValue = resultSet.getString("compare_tag_value");
                String tagMsg = resultSet.getString("tag_msg");
                resultObj.put("tag_name", LiveValueTriggerOperation.decrypt(tagName));
                resultObj.put("compare_tag_value", LiveValueTriggerOperation.decrypt(compareTagValue));
                resultObj.put("tag_msg", LiveValueTriggerOperation.decrypt(tagMsg));
                resultObj.put("mail", LiveValueTriggerOperation.decrypt(resultSet.getString("mail")));
                resultObj.put("tampering", LiveValueTriggerOperation.decrypt(resultSet.getString("tampering")));
                resultSet.close();
                preparedStatement.close();
                resultObj.put("status", "success");
                resultObj.put("msg", "Tampering settings fetched successfully.");
                FileBasedLogger.info("Audit", "Tampering settings fetched successfully.", user);
            } else {
                resultObj.put("status", "fail");
                resultObj.put("msg", "Error while retrieving tampering settings.");
                FileBasedLogger.error("Audit", "Error while retrieving tampering settings.", user);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            logger.error("Error occurred while retrieving data: " + e.getMessage());
            FileBasedLogger.error("Audit", "Error occurred while retrieving data: " + e.getMessage(), user);
        }
        finally {
            SQLiteConnector.closeConnection(connection);
        }
        return resultObj;
    }

    public JSONObject sortQueryUsingTriggerOperation(JSONObject json, String userRole) throws JSONException {
        JSONObject ack_res = new JSONObject();
        if (json.has("operation_type")) {
            String operation_type;
            switch (operation_type = json.getString("operation_type")) {
                case "insert_trigger_data": {
                    if (userRole.equalsIgnoreCase("admin") || userRole.equalsIgnoreCase("operator")) {
                        ack_res = this.insertOrUpdateLiveData(json);
                        ack_res.put("operation_type", "insert_trigger_data");
                        break;
                    }
                    ack_res.put("status", "fail");
                    ack_res.put("msg", " Access denied. Only Administrators and operator can perform operation.");
                    break;
                }
                case "update_trigger_data": {
                    if (userRole.equalsIgnoreCase("admin") || userRole.equalsIgnoreCase("operator")) {
                        ack_res = this.insertOrUpdateLiveData(json);
                        ack_res.put("operation_type", "update_trigger_data");
                        break;
                    }
                    ack_res.put("status", "fail");
                    ack_res.put("msg", " Access denied. Only Administrators and operator can perform operation.");
                    break;
                }
                case "delete_trigger_data": {
                    if (userRole.equalsIgnoreCase("admin") || userRole.equalsIgnoreCase("operator")) {
                        ack_res = this.deleteLiveData();
                        ack_res.put("operation_type", "delete_trigger_data");
                        break;
                    }
                    ack_res.put("status", "fail");
                    ack_res.put("msg", " Access denied. Only Administrators and operator can perform operation.");
                    break;
                }
                case "get_trigger_data": {
                    if (userRole.equalsIgnoreCase("admin") || userRole.equalsIgnoreCase("operator")) {
                        ack_res = this.retrieveLiveData1(json.getString("user"));
                        ack_res.put("operation_type", "get_trigger_data");
                        break;
                    }
                    ack_res.put("status", "fail");
                    ack_res.put("msg", " Access denied. Only Administrators and operator can perform operation.");
                    break;
                }
            }
        }
        return ack_res;
    }
}

