/*
 * Decompiled with CFR 0.152.
 */
package com.tas.wp500.linx_command;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.sun.management.OperatingSystemMXBean;
import com.tas.wp500.fileLogSetting.FileBasedLogger;
import com.tas.wp500.passwordSetting.PasswordAttemptsManger;
import com.tas.wp500.passwordSetting.PasswordPolicyChecker;
import com.tas.wp500.passwordSetting.PasswordPolicyDbOperation;
import com.tas.wp500.security.CaptchaSetting;
import com.tas.wp500.services.Service;
import com.tas.wp500.sql_lite_db.Db_opertions;
import com.tas.wp500.sql_lite_db.FileIntegrityAndSnortDBConnector;
import com.tas.wp500.sql_lite_db.SQLiteConnector;
import com.tas.wp500.user_token.TokenManager;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.management.ManagementFactory;
import java.security.SecureRandom;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class LinuxCommad {
    private static Logger logger = Logger.getLogger(LinuxCommad.class);
    private static final String ASCII_CHARACTERS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
    private static final String NUMBERS = "0123456789";
    private static final String SPECIAL_CHARACTERS = "@#$&*";
    private static LinuxCommad instance = null;
    private static Db_opertions db = Db_opertions.getInstance();
    private PasswordAttemptsManger passwordAttemptsManger = PasswordAttemptsManger.getInstance();
    private PasswordPolicyDbOperation passwordPolicyDbOperation = PasswordPolicyDbOperation.getInstance();

    private LinuxCommad() {
    }

    public static LinuxCommad getInstance() {
        if (instance == null) {
            instance = new LinuxCommad();
        }
        return instance;
    }

    public void changeIPAddressOfLAN(JSONObject json) {
        String configFilePath = "/etc/wp500cfg/config.ini";
        try {
            Properties properties = new Properties();
            FileInputStream inputStream = new FileInputStream(configFilePath);
            properties.load(inputStream);
            inputStream.close();
            properties.setProperty("eth0_dhcp ", "1");
            properties.setProperty("eth0_ipaddr ", "192.168.0.2");
            FileOutputStream outputStream = new FileOutputStream(configFilePath);
            properties.store(outputStream, "Updated IP addresses");
            outputStream.close();
            logger.info("IP address updated successfully.");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void executeCommand() {
        try {
            String line;
            String command = "ls -al /";
            Process process = Runtime.getRuntime().exec(command);
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((line = reader.readLine()) != null) {
            }
            process.waitFor();
            process.destroy();
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Error while executing command : " + e);
        }
    }

    public JSONObject addUser(JSONObject json, String user) {
        JSONObject resultObj;
        block20: {
            resultObj = new JSONObject();
            try {
                String username = json.getString("username");
                String password = null;
                String first_name = json.getString("first_name");
                String last_name = json.getString("last_name");
                String role = json.getString("user_role");
                String email = "";
                if (json.has("email") && !json.getString("email").isEmpty()) {
                    email = json.getString("email");
                }
                if (role.equalsIgnoreCase("superuser")) {
                    password = LinuxCommad.generateUniquePassword(SQLiteConnector.getConnection(), user);
                } else {
                    password = json.getString("password");
                    JSONObject passwordPolicyCheck = PasswordPolicyChecker.passwordPolicyCheck(password, user);
                    if (passwordPolicyCheck.has("status") && passwordPolicyCheck.getString("status").equals("fail")) {
                        return passwordPolicyCheck;
                    }
                }
                if (password != null) {
                    try {
                        boolean checkIfUsernameExists = db.checkIfUsernameExists(username);
                        if (!checkIfUsernameExists) {
                            if (!username.equals("wp500")) {
                                ProcessBuilder pb = null;
                                pb = role.equalsIgnoreCase("superuser") ? new ProcessBuilder("adduser", "-G", "sudo", "-s", "/bin/sh", username) : new ProcessBuilder("adduser", username);
                                pb.redirectInput(ProcessBuilder.Redirect.PIPE);
                                pb.redirectOutput(ProcessBuilder.Redirect.PIPE);
                                pb.redirectError(ProcessBuilder.Redirect.PIPE);
                                Process p = pb.start();
                                p.getOutputStream().write((password + "\n").getBytes());
                                p.getOutputStream().write((password + "\n").getBytes());
                                p.getOutputStream().write("\n".getBytes());
                                p.getOutputStream().write("\n".getBytes());
                                p.getOutputStream().write("\n".getBytes());
                                p.getOutputStream().flush();
                                int exitCode = p.waitFor();
                                if (exitCode == 0) {
                                    db.insertUserData(SQLiteConnector.getConnection(), username, password, first_name, last_name, role, email, user);
                                    logger.info(" - " + username + " - User created successfully. ");
                                    FileBasedLogger.info("Audit", username + " - User created successfully with role: " + role + ".", user);
                                    try {
                                        if ("admin".equalsIgnoreCase(role) || "operator".equalsIgnoreCase(role) || "viewer".equalsIgnoreCase(role) || "superuser".equalsIgnoreCase(role)) {
                                            this.addUserToGroup(username, role, user);
                                        }
                                        if (role.equalsIgnoreCase("SUPERUSER")) {
                                            resultObj.put("status", "success");
                                            resultObj.put("msg", "Account created successfully for superuser " + username + ". Your password is: " + password + " Please keep it safe.");
                                            return resultObj;
                                        }
                                        resultObj.put("status", "success");
                                        resultObj.put("msg", "Account created successfully for user : " + username);
                                    }
                                    catch (Exception e) {
                                        e.printStackTrace();
                                        FileBasedLogger.error("Audit", "Error while adding username into group : " + e, user);
                                        logger.error("Error while adding username into group : " + e);
                                    }
                                } else {
                                    logger.info(" Error while creating account for " + user + " - " + username + ".");
                                    resultObj.put("status", "fail");
                                    resultObj.put("msg", "Failed to create an account for user : " + username);
                                }
                                break block20;
                            }
                            logger.info(username + " has been successfully created Account.");
                            FileBasedLogger.info("Audit", username + " has been successfully created account with role: " + role + ".", user);
                            resultObj.put("status", "success");
                            resultObj.put("msg", "Account created successfully for user : " + username);
                            db.insertUserData(SQLiteConnector.getConnection(), username, password, first_name, last_name, role, email, user);
                            try {
                                if ("admin".equalsIgnoreCase(role) || "operator".equalsIgnoreCase(role) || "viewer".equalsIgnoreCase(role) || "superuser".equalsIgnoreCase(role)) {
                                    this.addUserToGroup(username, role, user);
                                }
                                break block20;
                            }
                            catch (Exception e) {
                                logger.error("Error while adding username into group : " + e);
                            }
                            break block20;
                        }
                        resultObj.put("status", "success");
                        resultObj.put("msg", "Sorry, the username '" + username + "' is already taken. Please choose a different username.");
                        FileBasedLogger.info("Audit", "Username already exists: " + username, user);
                        logger.info("Already exits with username " + username);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        FileBasedLogger.error("Audit", "Error while creating user in application : " + e, user);
                        logger.error("Error while creating user in application : " + e);
                    }
                    break block20;
                }
                resultObj.put("msg", "\"Error while creating user in application :");
                resultObj.put("status", "success");
                logger.info("Error while storing password in application :" + password);
            }
            catch (Exception e) {
                e.printStackTrace();
                FileBasedLogger.error("Audit", "Error while creating user in application: " + e.getMessage(), user);
                logger.error("Error while creating user in application : " + e);
            }
        }
        return resultObj;
    }

    private void addUserToGroup(String username, String role, String user) {
        try {
            String groupName = "admin".equalsIgnoreCase(role) ? "adm" : ("operator".equalsIgnoreCase(role) || "viewer".equalsIgnoreCase(role) ? "operator" : ("superuser".equalsIgnoreCase(role) ? "sudo" : null));
            if (groupName != null) {
                String[] command = new String[]{"usermod", "-aG", groupName, username};
                ProcessBuilder processBuilder = new ProcessBuilder(command);
                Process process = processBuilder.start();
                int exitCode = process.waitFor();
                if (exitCode == 0) {
                    logger.info(username + " User added to the group : " + groupName);
                    FileBasedLogger.info("Audit", "User added to the group : " + groupName, user);
                } else {
                    logger.info("Failed to add user to the group.");
                    FileBasedLogger.error("Audit", "Failed to add user to the group.", user);
                }
            }
        }
        catch (Exception e) {
            FileBasedLogger.error("Audit", "Error while add user to the group :", user);
        }
    }

    public static String generatePassword(int asciiCount, int mixedCount, int numberCount, int specialCount) {
        StringBuilder password = new StringBuilder();
        SecureRandom random = new SecureRandom();
        try {
            int randomIndex;
            int i;
            for (i = 0; i < asciiCount; ++i) {
                randomIndex = random.nextInt(ASCII_CHARACTERS.length());
                password.append(ASCII_CHARACTERS.charAt(randomIndex));
            }
            for (i = 0; i < mixedCount; ++i) {
                randomIndex = random.nextInt(ASCII_CHARACTERS.length());
                password.append(ASCII_CHARACTERS.charAt(randomIndex));
            }
            for (i = 0; i < numberCount; ++i) {
                randomIndex = random.nextInt(NUMBERS.length());
                password.append(NUMBERS.charAt(randomIndex));
            }
            for (i = 0; i < specialCount; ++i) {
                randomIndex = random.nextInt(SPECIAL_CHARACTERS.length());
                password.append(SPECIAL_CHARACTERS.charAt(randomIndex));
            }
            ArrayList<Character> charList = new ArrayList<Character>();
            for (char ch : password.toString().toCharArray()) {
                charList.add(Character.valueOf(ch));
            }
            Collections.shuffle(charList);
            StringBuilder shuffledPassword = new StringBuilder();
            Iterator iterator = charList.iterator();
            while (iterator.hasNext()) {
                char ch = ((Character)iterator.next()).charValue();
                shuffledPassword.append(ch);
            }
            System.out.println("password : " + shuffledPassword.toString());
            return shuffledPassword.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String generateUniquePassword(Connection connection, String user) {
        HashSet<String> existingPasswords = new HashSet<String>(db.getPasswordList(connection));
        String password = LinuxCommad.generatePassword(4, 2, 2, 2);
        try {
            while (existingPasswords.contains(password)) {
                password = LinuxCommad.generatePassword(4, 2, 2, 2);
            }
        }
        catch (Exception e) {
            FileBasedLogger.error("Audit", "Error while generating unique password.", user);
            logger.error("Error while generating unique password: " + e.getMessage());
        }
        return password;
    }

    public String getUserDetailsoFlinux() {
        try {
            try {
                String line;
                Process process = new ProcessBuilder("id").start();
                BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                while ((line = reader.readLine()) != null) {
                    logger.debug("Application detail response : " + line);
                }
                reader.close();
                return line;
            }
            catch (IOException e) {
                e.printStackTrace();
                logger.error("Error occurred while get user details from Application : " + e);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }

    public JSONObject deleteUserFromLinux(JSONObject json, String user) {
        JSONObject resultObj = new JSONObject();
        try {
            String username = json.getString("username");
            Process process = new ProcessBuilder("userdel", "-r", username).start();
            int exitCode = process.waitFor();
            if (exitCode == 0) {
                logger.info(username + " User has been deleted successfully.");
                FileBasedLogger.info("Audit", username + " - User has been deleted successfully.", user);
                resultObj = db.deleteUser(SQLiteConnector.getConnection(), username, json);
                String buildDeletePath1 = "/media/rfs/rw/upperdir/home/" + username + "/.bashrc";
                String buildDeletePath2 = "/media/rfs/rw/upperdir/home/" + username + "/.profile";
                this.deleteFileEntriesFromDB(buildDeletePath1);
                this.deleteFileEntriesFromDB(buildDeletePath2);
            } else {
                logger.error(" Failed to delete " + user + " of username " + username + ".");
                FileBasedLogger.error("Audit", "Failed to delete user: " + username + ".", user);
                resultObj.put("status", "fail");
                resultObj.put("msg", "Failed to delete user : " + username + ".");
            }
        }
        catch (IOException | InterruptedException e) {
            logger.error("Error while delete user from system : " + e);
            FileBasedLogger.error("Audit", "Error while deleting user from system: " + e.getMessage(), user);
            e.printStackTrace();
            try {
                json.put("status", "fail");
            }
            catch (JSONException e1) {
                e1.printStackTrace();
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
            try {
                resultObj.put("status", "fail");
            }
            catch (JSONException e1) {
                logger.error("Error while delete user from system : " + e);
                e1.printStackTrace();
            }
        }
        return resultObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteFileEntriesFromDB(String partialFilename) {
        Connection connection = null;
        try {
            connection = FileIntegrityAndSnortDBConnector.getConnection();
            String sql = "DELETE FROM file_integrity WHERE filename LIKE ?";
            try (PreparedStatement pstmt = connection.prepareStatement(sql);){
                pstmt.setString(1, "%" + partialFilename + "%");
                int n = pstmt.executeUpdate();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            logger.error("Error deleting file entries from database: " + e.getMessage());
        }
        finally {
            SQLiteConnector.closeConnection(connection);
        }
    }

    public void replaceUserHomeDirectoryInLinuxSystem(String username, String newHomeDir, String user) {
        try {
            Process process = new ProcessBuilder("usermod", "-d", newHomeDir, username).start();
            int exitCode = process.waitFor();
            if (exitCode == 0) {
                logger.info(user + " - " + username + "'s home directory has been changed to : " + newHomeDir);
            } else {
                logger.error("Failed to modify user " + username + "'s home directory. Exit code: " + exitCode);
            }
        }
        catch (IOException | InterruptedException e) {
            logger.error("Error while modifying user home directory : " + e);
            e.printStackTrace();
        }
    }

    public JSONObject updateUserPasswordOfLinux1(JSONObject json, String user) {
        try {
            if (json.has("username") && json.has("password")) {
                String username = json.getString("username");
                String newPassword = json.getString("password");
                JSONObject passwordPolicyCheck = PasswordPolicyChecker.passwordPolicyCheck(newPassword, user);
                if (passwordPolicyCheck.has("status") && passwordPolicyCheck.getString("status").equals("fail")) {
                    return passwordPolicyCheck;
                }
                try {
                    ProcessBuilder changePasswordProcessBuilder = new ProcessBuilder("passwd", username);
                    Process changePasswordProcess = changePasswordProcessBuilder.start();
                    changePasswordProcess.getOutputStream().write((newPassword + "\n").getBytes());
                    changePasswordProcess.getOutputStream().flush();
                    changePasswordProcess.getOutputStream().write((newPassword + "\n").getBytes());
                    changePasswordProcess.getOutputStream().flush();
                    int exitCode = changePasswordProcess.waitFor();
                    if (exitCode != 0) {
                        json.put("status", "fail");
                        json.put("msg", "Error while changing password for user : " + username);
                        logger.info("Error while changing password of application user : " + user);
                        FileBasedLogger.info("Audit", "Error while changing password of application user : " + user, user);
                        return json;
                    }
                    logger.info("User password changed successfully.");
                    FileBasedLogger.info("Audit", "Password changed successfully for user: " + username, user);
                    return db.updateUserPassword(json);
                }
                catch (IOException | InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            FileBasedLogger.error("Audit", "Error while updating password for system : " + e.getLocalizedMessage(), user);
            logger.error("Error while updating password for system : " + e);
        }
        return json;
    }

    public JSONObject getAllNonSystemUserFromLinux(JSONObject json) {
        HashSet<String> nonSystemUsers = new HashSet<String>();
        try {
            String line;
            ProcessBuilder processBuilder = new ProcessBuilder("awk", "-F:", "{print $1}", "/etc/passwd");
            Process process = processBuilder.start();
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((line = reader.readLine()) != null) {
                nonSystemUsers.add(line);
            }
            int exitCode = process.waitFor();
            if (exitCode != 0) {
                try {
                    json.put("status", "fail");
                    json.put("msg", "Error while executing command. ");
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    logger.error("Error while execution of command : " + e);
                }
            } else {
                try {
                    json.put("status", "success");
                    json.put("msg", "successfully fetched all users.");
                    logger.info("Successfully fetched all users.");
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
            for (String user : nonSystemUsers) {
                logger.info("Non system user : " + user);
            }
            json.put("result", nonSystemUsers);
        }
        catch (IOException | InterruptedException | JSONException e) {
            e.printStackTrace();
            try {
                json.put("status", "fail");
                json.put("msg", "Error while executing command. ");
                logger.info("Error while executing command.");
            }
            catch (JSONException e1) {
                e1.printStackTrace();
            }
        }
        return json;
    }

    public JSONObject checkUserExistsForLogin(JSONObject json) {
        try {
            if (json.has("username")) {
                boolean userExists = this.checkUserExists(json.getString("username"));
                if (userExists) {
                    json.put("status", "success");
                    json.put("msg", json.getString("username") + " User exists .");
                    logger.info(" User exists with username " + json.getString("username") + ".");
                } else {
                    json.put("status", "fail");
                    json.put("msg", json.getString("username") + " User does not exist.");
                    logger.info("User does not exist.");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return json;
    }

    public boolean checkUserExists(String username) {
        try {
            String line;
            Process process = new ProcessBuilder("id", "-u", username).start();
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            StringBuilder output = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                output.append(line);
            }
            int exitValue = process.waitFor();
            return exitValue == 0;
        }
        catch (IOException | InterruptedException e) {
            e.printStackTrace();
            return false;
        }
    }

    public JSONObject addFirewallSettings(JSONObject json, String user) throws JSONException {
        JSONObject resultObj = new JSONObject();
        try {
            if (json.has("port_num") && json.has("protocol") && json.has("ip_address")) {
                String command = "";
                int port_num = json.getInt("port_num");
                String protocol = json.getString("protocol");
                String ipAddress = json.getString("ip_address").trim();
                command = ipAddress.equals("") ? "iptables -A INPUT -p " + protocol + " --dport " + port_num + " -j ACCEPT" : "iptables -A INPUT -p " + protocol + " -s " + ipAddress + " --dport " + port_num + " -j ACCEPT";
                logger.info(user + " - added firewall command - " + command);
                Process process = Runtime.getRuntime().exec(command);
                int exitCode = process.waitFor();
                if (exitCode == 0) {
                    logger.info("Ip tables command executed successfully for user : " + user);
                    resultObj.put("status", "success");
                    resultObj.put("msg", "iptables command executed successfully.");
                } else {
                    logger.error("Ip tables command execution failed for user : " + user);
                    resultObj.put("status", "fail");
                    resultObj.put("msg", "iptables command execution failed. ");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(" Error occurred while adding firewall settings : " + e);
            resultObj.put("status", "fail");
            resultObj.put("msg", "iptables command failed. ");
        }
        return resultObj;
    }

    public JSONObject deleteOneFirewallSettings(JSONObject json, String user) throws JSONException {
        JSONObject resultObj = new JSONObject();
        try {
            if (json.has("chain_num")) {
                int num = json.getInt("chain_num");
                Process process = Runtime.getRuntime().exec("iptables -D INPUT " + num);
                int exitCode = process.waitFor();
                if (exitCode == 0) {
                    resultObj.put("status", "success");
                    resultObj.put("msg", "iptables command executed successfully.");
                    logger.info(" Ip tables command executed successfully for user : " + user);
                } else {
                    resultObj.put("status", "fail");
                    resultObj.put("msg", "iptables command failed.");
                    logger.error(" Ip tables command failed for user : " + user);
                }
            }
        }
        catch (Exception e) {
            logger.error(" Error occurred while deleting firewall settings : " + e);
            e.printStackTrace();
            resultObj.put("status", "fail");
            resultObj.put("msg", "iptables command failed. ");
        }
        return resultObj;
    }

    public JSONObject getListOfFirewallSettingsOfIPTables() throws JSONException {
        JSONObject resultObj = new JSONObject();
        try {
            String iptablesOutput = LinuxCommad.executeCommand("iptables", "-L");
            JsonObject jsonObject = LinuxCommad.parseIptablesOutput(iptablesOutput);
            Gson gson = new Gson();
            String json = gson.toJson(jsonObject);
            resultObj.put("status", "success");
            resultObj.put("msg", "successfully fetched list of ip Tables.");
            resultObj.put("result", json);
            logger.info(" List of ip-Tables fetched Successfully. ");
        }
        catch (IOException | InterruptedException e) {
            e.printStackTrace();
            logger.error(" Error occurred while fetching ip-Tables list : " + e);
            resultObj.put("status", "fail");
            resultObj.put("msg", "Failed to fetched list of ip Tables.");
        }
        return resultObj;
    }

    public static String executeCommand(String ... command) throws IOException, InterruptedException {
        String line;
        ProcessBuilder processBuilder = new ProcessBuilder(command);
        Process process = processBuilder.start();
        InputStream inputStream = process.getInputStream();
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
        StringBuilder output = new StringBuilder();
        while ((line = reader.readLine()) != null) {
            output.append(line).append("\n");
        }
        int exitCode = process.waitFor();
        if (exitCode != 0) {
            // empty if block
        }
        return output.toString();
    }

    public static JsonObject parseIptablesOutput(String output) {
        String[] lines;
        JsonObject jsonObject = new JsonObject();
        JsonArray rulesArray = new JsonArray();
        for (String line : lines = output.split("\n")) {
            JsonObject ruleObject = new JsonObject();
            String[] columns = line.split("\\s+");
            if (columns.length < 9) continue;
            ruleObject.addProperty("target", columns[0]);
            ruleObject.addProperty("protocol", columns[1]);
            ruleObject.addProperty("opt", columns[2]);
            ruleObject.addProperty("in", columns[3]);
            ruleObject.addProperty("out", columns[4]);
            ruleObject.addProperty("source", columns[5]);
            ruleObject.addProperty("destination", columns[6]);
            ruleObject.addProperty("state", columns[7]);
            ruleObject.addProperty("extra", columns[8]);
            rulesArray.add(ruleObject);
        }
        jsonObject.add("rules", rulesArray);
        return jsonObject;
    }

    public JSONObject getListOfFirewallSettigs(JSONObject json) {
        JSONObject resultObj = new JSONObject();
        try {
            String line;
            int i = 0;
            ProcessBuilder processBuilder = new ProcessBuilder("iptables", "-L", "INPUT", "-n", "--line-numbers");
            Process process = processBuilder.start();
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            StringBuilder output = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                if (i != 0) {
                    output.append(line).append("\n");
                }
                ++i;
            }
            String jsonOutput = LinuxCommad.convertOutputToJson(output.toString());
            resultObj.put("status", "success");
            resultObj.put("msg", "successfully fetched list of ip Tables.");
            resultObj.put("result", jsonOutput);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Error while fetching list of ip tables : " + e);
            try {
                resultObj.put("status", "fail");
                resultObj.put("msg", "failed to fetch list of ip Tables.");
            }
            catch (JSONException e1) {
                e1.printStackTrace();
            }
        }
        return resultObj;
    }

    private static String convertOutputToJson(String output) {
        String[] lines = output.split("\\r?\\n");
        StringBuilder jsonOutput = new StringBuilder("[");
        for (int i = 1; i < lines.length; ++i) {
            String[] parts = lines[i].split("\\s+");
            jsonOutput.append("{\"lineNumber\": \"").append(parts[0]).append("\", \"target\": \"").append(parts[1]).append("\", \"protocol\": \"").append(parts[2]).append("\", \"port\": \"").append(parts[6]).append("\", \"source\": \"").append(parts[4]).append("\", \"destination\": \"").append(parts[5]).append("\"},");
        }
        if (jsonOutput.length() > 1) {
            jsonOutput.setLength(jsonOutput.length() - 1);
        }
        jsonOutput.append("]");
        return jsonOutput.toString();
    }

    public JSONObject doLogin(JSONObject json) {
        JSONObject resultObj = new JSONObject();
        try {
            boolean resultCaptcha;
            if (json.has("captcha") && !(resultCaptcha = CaptchaSetting.getInstance().verifyCaptcha(json))) {
                resultObj.put("status", "fail");
                resultObj.put("msg", "Invalid captcha.");
                FileBasedLogger.warn("Audit", "Invalid captcha.", json.getString("username"));
                return resultObj;
            }
            if (json.has("username") && json.has("password")) {
                String username = json.getString("username");
                String password = json.getString("password");
                boolean statusFirstLogin = false;
                boolean checkIfUsernameExists = db.checkIfUsernameExists(username);
                boolean checkIfSuperUser = db.isSuperUserAvailable(username);
                if (checkIfSuperUser) {
                    if (checkIfUsernameExists) {
                        boolean isUserLocked;
                        long remainingTime = this.passwordAttemptsManger.unlockUserIfNeeded(SQLiteConnector.getConnection(), username);
                        boolean bl = isUserLocked = remainingTime > 0L;
                        if (!isUserLocked) {
                            boolean validateLogin = db.validateLogin(SQLiteConnector.getConnection(), username, password);
                            if (validateLogin) {
                                this.passwordAttemptsManger.resetFailedAttempts(SQLiteConnector.getConnection(), username);
                                boolean firstLoginDetails = db.getFirstLoginDetails(SQLiteConnector.getConnection(), username);
                                if (firstLoginDetails) {
                                    resultObj.put("first_login", "false");
                                    statusFirstLogin = true;
                                } else {
                                    resultObj.put("first_login", "true");
                                }
                                String totpAuthenticator = db.getTotpDetails(username);
                                resultObj.put("totp_authenticator", totpAuthenticator);
                                resultObj.put("status", "success");
                                resultObj.put("msg", "valid user");
                                String userRole = db.getUserRole(username, SQLiteConnector.getConnection());
                                if (!userRole.equals("")) {
                                    resultObj.put("role", userRole);
                                } else {
                                    resultObj.put("role", "Not found");
                                }
                                if ("disable".equalsIgnoreCase(totpAuthenticator) && statusFirstLogin) {
                                    try {
                                        resultObj.put("session_timeout", this.passwordPolicyDbOperation.getSessionTimeout(SQLiteConnector.getConnection(), username));
                                        String token = TokenManager.generateToken(username);
                                        Service.USER_WISE_TOKEN.put(username, token);
                                        resultObj.put("token", token);
                                        resultObj.put("token_status", "success");
                                        logger.info("User has logged in.");
                                        FileBasedLogger.info("Audit", username + " - User logged in successfully.", username);
                                    }
                                    catch (Exception e) {
                                        e.printStackTrace();
                                    }
                                } else {
                                    resultObj.put("token_status", "fail");
                                }
                            } else {
                                this.passwordAttemptsManger.incrementFailedAttempts(SQLiteConnector.getConnection(), username);
                                resultObj.put("status", "fail");
                                resultObj.put("msg", "Invalid user name or password : " + username);
                                FileBasedLogger.warn("Audit", "Failed login attempt. Invalid username or password for user: " + username, username);
                            }
                        } else if (remainingTime >= 0L) {
                            long minutes = remainingTime / 60000L;
                            long seconds = remainingTime / 1000L % 60L;
                            String remainingTimeFormat = minutes > 0L ? String.format("%d minute(s) and %d second(s)", minutes, seconds) : String.format("%d second(s)", seconds);
                            resultObj.put("status", "fail");
                            resultObj.put("msg", "Your account is currently locked. Please wait for " + remainingTimeFormat + " before trying again.");
                            FileBasedLogger.warn("Audit", username + " - Account locked, login attempt blocked.", username);
                        } else {
                            resultObj.put("status", "fail");
                            resultObj.put("msg", "Error while checking locked user.");
                        }
                    } else {
                        resultObj.put("status", "fail");
                        resultObj.put("msg", "User not available : " + username);
                        FileBasedLogger.warn("Audit", "Login attempt failed. User does not exist: " + username, username);
                    }
                } else {
                    resultObj.put("status", "fail");
                    resultObj.put("msg", "Access denied");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Error while validating user : " + e);
            FileBasedLogger.error("Audit", "Error while validating user : " + e.getLocalizedMessage(), json.getString("username"));
        }
        return resultObj;
    }

    public JSONObject doLogout(JSONObject json) {
        JSONObject resultObj = new JSONObject();
        try {
            String username = json.getString("user");
            String token = json.getString("token");
            if (Service.USER_WISE_TOKEN.containsKey(username) && Service.USER_WISE_TOKEN.get(username).equals(token)) {
                Service.USER_WISE_TOKEN.remove(username);
                resultObj.put("status", "success");
                resultObj.put("msg", " Logout successfully.");
                logger.info("User has logged out.");
                FileBasedLogger.info("Audit", "User has logged out.", username);
            } else {
                resultObj.put("status", "fail");
                resultObj.put("msg", username + " User not found.");
                FileBasedLogger.info("Audit", "User not found.", username);
            }
        }
        catch (Exception e) {
            resultObj.put("status", "fail");
            resultObj.put("msg", "An error occurred during logout.");
            logger.error("Error while logout : " + e);
            FileBasedLogger.error("Audit", "User not found.", "system");
        }
        return resultObj;
    }

    public JSONObject isValidUser(JSONObject json, String user) {
        try {
            if (json.has("username") && json.has("password")) {
                String line;
                String username = json.getString("username");
                String password = json.getString("password");
                ProcessBuilder processBuilder = new ProcessBuilder("passwd", "--stdin", username);
                Process process = processBuilder.start();
                BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                process.getOutputStream().write((password + "\n").getBytes());
                process.getOutputStream().flush();
                process.getOutputStream().close();
                while ((line = reader.readLine()) != null) {
                    if (!line.contains("Authentication token manipulation error") && !line.contains("passwd: Authentication failure")) continue;
                    json.put("status", "success");
                    json.put("msg", "Invalid user.");
                    logger.info(user + " - " + username + " Is invalid user. ");
                }
                json.put("status", "success");
                json.put("msg", "valid user. ");
                logger.info(user + " - " + username + "Is valid user.");
                reader.close();
                process.waitFor();
            }
        }
        catch (IOException | InterruptedException | JSONException e) {
            e.printStackTrace();
            logger.error("Error while validating user : " + e);
            try {
                json.put("status", "fail");
                json.put("msg", "Something wrong. Please check again." + e);
            }
            catch (JSONException e1) {
                e1.printStackTrace();
            }
        }
        return json;
    }

    public JSONObject getSystemInfo() throws JSONException {
        OperatingSystemMXBean osBean = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
        JSONObject resultObj = new JSONObject();
        try {
            JSONObject resultCpuInfo = this.addCpuInformation(osBean);
            resultObj.put("cpu_information", resultCpuInfo);
            JSONObject resultMemoryInfo = this.addMemoryInformation(osBean);
            resultObj.put("memory_information", resultMemoryInfo);
            JSONObject resultRamInfo = this.addRamInformation();
            resultObj.put("ram_information", resultRamInfo);
            JSONObject resultDiskInfo = this.addDiskInformation();
            resultObj.put("disk_information", resultDiskInfo);
            JSONObject resultTaskAndUserInfo = this.addTaskAndUserInformation();
            resultObj.put("task_user_information", resultTaskAndUserInfo);
            JSONObject resultCpuOperationsInfo = this.addCpuRunningOperations();
            resultObj.put("cpu_running_task_information", resultCpuOperationsInfo);
            resultObj.put("status", "success");
            resultObj.put("msg", "Successfully retrieved system information.");
        }
        catch (JSONException e) {
            e.printStackTrace();
            logger.error("Error while retrieving system information : " + e.getMessage());
            resultObj.put("status", "fail");
            resultObj.put("msg", "Failed to retrieve system information.");
        }
        return resultObj;
    }

    private JSONObject addCpuInformation(OperatingSystemMXBean osBean) throws JSONException {
        JSONObject cpuInfo = new JSONObject();
        try {
            String cpuUsage = LinuxCommad.getCpuUsage();
            if (cpuUsage.isEmpty()) {
                cpuInfo.put("SystemLoadAverage", osBean.getSystemLoadAverage() + "%");
            }
            cpuInfo.put("Architecture", osBean.getArch());
            cpuInfo.put("Name", osBean.getName());
            cpuInfo.put("Version", osBean.getVersion());
            cpuInfo.put("AvailableProcessors", osBean.getAvailableProcessors());
            cpuInfo.put("SystemLoadAverage", cpuUsage);
            cpuInfo.put("status", "success");
            cpuInfo.put("msg", " successfully get cpu information.");
        }
        catch (JSONException e) {
            e.printStackTrace();
            cpuInfo.put("status", "fail");
            cpuInfo.put("msg", " Error while getting cpu information.");
            logger.debug(" Error while execute CPU Information : " + e);
        }
        return cpuInfo;
    }

    private JSONObject addMemoryInformation(OperatingSystemMXBean osBean) throws JSONException {
        JSONObject memoryInfo = new JSONObject();
        try {
            memoryInfo.put("TotalPhysicalMemory", LinuxCommad.formatSize(osBean.getTotalPhysicalMemorySize()));
            memoryInfo.put("AvailablePhysicalMemory", LinuxCommad.formatSize(osBean.getFreePhysicalMemorySize()));
            memoryInfo.put("TotalSwapSpaceSize", LinuxCommad.formatSize(osBean.getTotalSwapSpaceSize()));
            memoryInfo.put("AvailableSwapSpaceSize", LinuxCommad.formatSize(osBean.getFreeSwapSpaceSize()));
            memoryInfo.put("CommittedVirtualMemorySize", LinuxCommad.formatSize(osBean.getCommittedVirtualMemorySize()));
            memoryInfo.put("status", "success");
            memoryInfo.put("msg", "successfully get memory information.");
        }
        catch (JSONException e) {
            memoryInfo.put("status", "fail");
            memoryInfo.put("msg", " Error while getting memory information.");
            e.printStackTrace();
            logger.debug(" Error while execute memory Information : " + e);
        }
        return memoryInfo;
    }

    private JSONObject addRamInformation() throws JSONException {
        JSONObject ramInfo = new JSONObject();
        try {
            String line;
            Process process = Runtime.getRuntime().exec("free -m");
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            long bufferedRAM = 0L;
            while ((line = reader.readLine()) != null) {
                StringTokenizer tokenizer = new StringTokenizer(line);
                String token = tokenizer.nextToken();
                if (token.equalsIgnoreCase("Mem:")) {
                    long totalMemory = Long.parseLong(tokenizer.nextToken());
                    long usedMemory = Long.parseLong(tokenizer.nextToken());
                    long freeMemory = Long.parseLong(tokenizer.nextToken());
                    long sharedMemory = Long.parseLong(tokenizer.nextToken());
                    long bufferCache = Long.parseLong(tokenizer.nextToken());
                    long availableMemory = Long.parseLong(tokenizer.nextToken());
                    ramInfo.put("TotalMemory", totalMemory);
                    ramInfo.put("UsedMemory", usedMemory);
                    ramInfo.put("FreeMemory", freeMemory);
                    ramInfo.put("SharedMemory", sharedMemory);
                    ramInfo.put("BufferCache", bufferCache);
                    ramInfo.put("AvailableMemory", availableMemory);
                    continue;
                }
                if (!token.equalsIgnoreCase("Buffer:")) continue;
                bufferedRAM = Long.parseLong(tokenizer.nextToken());
            }
            ramInfo.put("status", "success");
            ramInfo.put("msg", " Successfully get RAM information.");
        }
        catch (Exception e) {
            ramInfo.put("status", "fail");
            ramInfo.put("msg", " Error while getting RAM information.");
            e.printStackTrace();
            logger.debug(" Error while execute RAM Information : " + e);
        }
        return ramInfo;
    }

    private JSONObject addDiskInformation() throws JSONException {
        JSONObject diskResult = new JSONObject();
        try {
            String line;
            Process process = Runtime.getRuntime().exec("df -h");
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            StringBuilder diskInfoBuilder = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                diskInfoBuilder.append(line).append("\n");
            }
            reader.close();
            int exitCode = process.waitFor();
            JSONArray diskArray = this.parseDiskInfo(diskInfoBuilder.toString());
            diskResult.put("diskInfo", diskArray);
            diskResult.put("status", "success");
            diskResult.put("msg", " successfully get Disk information.");
        }
        catch (Exception e) {
            e.printStackTrace();
            diskResult.put("status", "fail");
            diskResult.put("msg", " Error while getting Disk information.");
            logger.debug(" Error while executing df -h command : " + e);
        }
        return diskResult;
    }

    private JSONObject addTaskAndUserInformation() throws JSONException {
        JSONObject taskAndUserInfo = new JSONObject();
        try {
            String line;
            Process process = Runtime.getRuntime().exec("top -b -n 1");
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            ArrayList<String> taskDetails = new ArrayList<String>();
            String usersInfo = "";
            while ((line = reader.readLine()) != null) {
                if (line.contains("Tasks:")) {
                    taskDetails.add(line);
                }
                if (line.contains("user,")) {
                    usersInfo = line;
                    continue;
                }
                if (!line.contains("users,")) continue;
                usersInfo = line;
            }
            String regex = "(\\d+)\\s+user(?:s)?";
            Pattern pattern = Pattern.compile(regex);
            Matcher matcher = pattern.matcher(usersInfo);
            int numberOfUsers = 0;
            if (matcher.find()) {
                numberOfUsers = Integer.parseInt(matcher.group(1));
            }
            JSONArray tasksArray = new JSONArray((Collection<?>)taskDetails);
            taskAndUserInfo.put("taskDetails", tasksArray);
            taskAndUserInfo.put("numberOfUsers", numberOfUsers);
            taskAndUserInfo.put("usersInfo", usersInfo);
            taskAndUserInfo.put("status", "success");
            taskAndUserInfo.put("msg", "Successfully retrieved task and user information.");
            reader.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            taskAndUserInfo.put("status", "fail");
            taskAndUserInfo.put("msg", "Error while retrieving task and user information.");
            logger.debug("Error while executing top command: " + e);
        }
        return taskAndUserInfo;
    }

    private JSONObject addCpuRunningOperations() throws JSONException {
        JSONObject cpuOperations = new JSONObject();
        try {
            String line;
            ProcessBuilder processBuilder = new ProcessBuilder("top", "-b", "-n", "1");
            Process process = processBuilder.start();
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            StringBuilder cpuInfoBuilder = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                cpuInfoBuilder.append(line).append("\n");
            }
            reader.close();
            int exitCode = process.waitFor();
            JSONArray cpuArray = this.parseCpuInfo(cpuInfoBuilder.toString());
            cpuOperations.put("cpuRunningOperations", cpuArray);
            cpuOperations.put("status", "success");
            cpuOperations.put("msg", "successfully get CPU's performance information.");
        }
        catch (IOException | InterruptedException | JSONException e) {
            e.printStackTrace();
            cpuOperations.put("status", "fail");
            cpuOperations.put("msg", "Error while getting CPU's performance information.");
            logger.debug(" Error while execute top command operation's : " + e);
        }
        return cpuOperations;
    }

    private JSONArray parseCpuInfo(String cpuInfo) {
        JSONArray cpuArray = new JSONArray();
        String[] lines = cpuInfo.split("\n");
        int count = 0;
        for (String line : lines) {
            if ((line = line.trim()).isEmpty()) continue;
            if (count >= 7 && count < 17) {
                String[] tokens = line.split("\\s+");
                if (tokens.length >= 12) {
                    JSONObject cpuObject = new JSONObject();
                    try {
                        cpuObject.put("PID", tokens[0]);
                        cpuObject.put("USER", tokens[1]);
                        cpuObject.put("PR", tokens[2]);
                        cpuObject.put("NI", tokens[3]);
                        cpuObject.put("VIRT", tokens[4]);
                        cpuObject.put("RES", tokens[5]);
                        cpuObject.put("SHR", tokens[6]);
                        cpuObject.put("S", tokens[7]);
                        cpuObject.put("%CPU", tokens[8]);
                        cpuObject.put("%MEM", tokens[9]);
                        cpuObject.put("TIME+", tokens[10]);
                        cpuObject.put("COMMAND", tokens[11]);
                        cpuArray.put(cpuObject);
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                        logger.debug("Error while parsing CPU information : " + e.getMessage());
                    }
                } else {
                    logger.debug("Not enough tokens in line: " + line);
                }
            }
            ++count;
        }
        return cpuArray;
    }

    private JSONArray parseDiskInfo(String diskInfo) {
        JSONArray diskArray = new JSONArray();
        String[] lines = diskInfo.split("\n");
        for (int i = 1; i < lines.length; ++i) {
            String[] tokens = lines[i].split("\\s+");
            JSONObject diskObject = new JSONObject();
            try {
                diskObject.put("Filesystem", tokens[0]);
                diskObject.put("Size", tokens[1]);
                diskObject.put("Used", tokens[2]);
                diskObject.put("Available", tokens[3]);
                diskObject.put("Use%", tokens[4]);
                diskObject.put("MountedOn", tokens[5]);
            }
            catch (JSONException e) {
                e.printStackTrace();
                logger.debug("Error while parse disk info :" + e.getLocalizedMessage());
            }
            diskArray.put(diskObject);
        }
        return diskArray;
    }

    private static String formatSize(long bytes) {
        double megabytes = (double)bytes / 1048576.0;
        return String.format("%.2f MB", megabytes);
    }

    public static String getCpuUsage() {
        String command = "top -b -n1 | grep \"Cpu(s)\" | awk '{print $2 + $4}'";
        StringBuilder output = new StringBuilder();
        StringBuilder errorOutput = new StringBuilder();
        ProcessBuilder processBuilder = new ProcessBuilder("/bin/bash", "-c", command);
        processBuilder.redirectErrorStream(true);
        try {
            Process process = processBuilder.start();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                String line;
                while ((line = reader.readLine()) != null) {
                    output.append(line).append("\n");
                }
            }
            try (BufferedReader errorReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));){
                String errorLine;
                while ((errorLine = errorReader.readLine()) != null) {
                    errorOutput.append(errorLine).append("\n");
                }
            }
            process.waitFor();
            if (process.exitValue() != 0) {
                return "";
            }
        }
        catch (IOException e) {
            logger.error("Error while getting cpu load :" + e.getLocalizedMessage());
            e.printStackTrace();
            return "";
        }
        catch (InterruptedException e) {
            logger.error("Error while getting cpu load :" + e.getLocalizedMessage());
            e.printStackTrace();
            Thread.currentThread().interrupt();
            return "";
        }
        return output.toString().trim();
    }
}

