/*
 * Decompiled with CFR 0.152.
 */
package com.tas.wp500.linx_command;

import com.tas.wp500.configFileDbSettings.ConfigFileDbOperation;
import com.tas.wp500.fileLogSetting.FileBasedLogger;
import com.tas.wp500.protocol.mqtt.MqttExecutor;
import com.tas.wp500.sql_lite_db.SQLiteConnector;
import com.tas.wp500.ssl_certificate_manager.ServerXmlModifier;
import com.tas.wp500.util.PatchVersionSetting;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class FileReaderUtil {
    private static Logger logger = Logger.getLogger(FileReaderUtil.class);
    public static final String CONFIG_PATH = "/etc/wp500cfg/config.ini";
    public static final String T5_STARTON_PATH = "/etc/wp500cfg/t5cod/";
    public static final String FIRMWARE_PATH = "/data/firmware-file/";
    public static final String CRTFILE_PATH = "/usr/bin/crt_files/";
    private static FileReaderUtil instance = null;
    private ConfigFileDbOperation configFileDbOperation = ConfigFileDbOperation.getInstance();

    private FileReaderUtil() {
    }

    public static FileReaderUtil getInstance() {
        if (instance == null) {
            instance = new FileReaderUtil();
        }
        return instance;
    }

    public JSONObject getLogFileData(JSONObject json) throws JSONException {
        JSONObject resultObj = new JSONObject();
        try {
            logger.info(" Log file data get from Application. ");
            if (json.has("log_type")) {
                String log_type = json.getString("log_type");
                if (log_type.equalsIgnoreCase("application")) {
                    if (json.has("search")) {
                        JSONArray logFileDataFromApplicationLog = this.getLogFileDataFromApplicationLog(json.getString("file_name"), json.getString("search"));
                        resultObj.put("result", logFileDataFromApplicationLog);
                        resultObj.put("status", "success");
                        resultObj.put("msg", "Successfully fetched application log file data.");
                    } else {
                        JSONArray logFileDataFromApplicationLog = this.getLogFileDataFromApplicationLog(json.getString("file_name"));
                        resultObj.put("result", logFileDataFromApplicationLog);
                        resultObj.put("status", "success");
                        resultObj.put("msg", "Successfully fetched application log file data.");
                    }
                } else if (log_type.equalsIgnoreCase("system")) {
                    if (json.has("search")) {
                        JSONArray logFileDataFromSystemLog = this.getLogFileDataFromSystem(json.getString("search"), json.getString("start_month"), json.getString("start_time"), json.getString("end_month"), json.getString("end_time"));
                        resultObj.put("result", logFileDataFromSystemLog);
                        resultObj.put("status", "success");
                        resultObj.put("msg", "Successfully fetched system log file data.");
                    } else {
                        JSONArray logFileDataFromSystemLog = this.getLogFileDataFromSystem(json.getString("start_month"), json.getString("start_time"), json.getString("end_month"), json.getString("end_time"));
                        resultObj.put("result", logFileDataFromSystemLog);
                        resultObj.put("status", "success");
                        resultObj.put("msg", "Successfully fetched system log file data.");
                    }
                } else if (log_type.equalsIgnoreCase("load_system_log")) {
                    JSONArray logFileDataFromSystemLog = this.getLogFileDataFromSystemLog();
                    resultObj.put("result", logFileDataFromSystemLog);
                    resultObj.put("status", "success");
                    resultObj.put("msg", "Successfully fetched system log file data.");
                }
            }
        }
        catch (Exception e) {
            logger.error("Error occurred while getting log file data : " + e);
            e.printStackTrace();
            resultObj.put("status", "fail");
            resultObj.put("msg", "Failed to fetched  log file data.");
        }
        return resultObj;
    }

    private JSONArray getLogFileDataFromSystemLog() {
        String logFilePath = "/var/log/messages";
        int numLines = 100;
        JSONArray reversedArray = new JSONArray();
        JSONArray jsonArray = new JSONArray();
        try (RandomAccessFile file = new RandomAccessFile(logFilePath, "r");){
            long fileLength = file.length();
            int linesRead = 0;
            for (long pos = fileLength - 1L; pos >= 0L && linesRead < numLines; --pos) {
                file.seek(pos);
                char c = (char)file.readByte();
                if (c != '\n') continue;
                String line = file.readLine();
                jsonArray.put(line);
                ++linesRead;
            }
            for (int i = jsonArray.length() - 1; i >= 0; --i) {
                reversedArray.put(jsonArray.get(i));
            }
        }
        catch (IOException | JSONException e) {
            logger.error("Error while parsing log file : " + e);
            e.printStackTrace();
        }
        return reversedArray;
    }

    private JSONArray getLogFileDataFromApplicationLog(String file_name, String search) {
        JSONArray jsonArray = new JSONArray();
        try {
            int linesRead = 0;
            try {
                String logFilePath = "/data/log/" + file_name;
                try (BufferedReader reader = new BufferedReader(new FileReader(logFilePath));){
                    String line;
                    while ((line = reader.readLine()) != null) {
                        if (!line.toLowerCase().contains(search.toLowerCase())) continue;
                        ++linesRead;
                        jsonArray.put(line);
                    }
                    reader.close();
                }
                catch (IOException e) {
                    logger.error("Error while getting application log data : " + e);
                    e.printStackTrace();
                }
            }
            catch (Exception e) {
                logger.error("Error while getting application log data : " + e);
                e.printStackTrace();
            }
        }
        catch (Exception e) {
            logger.error("Error while getting application log data : " + e);
            e.printStackTrace();
        }
        return jsonArray;
    }

    private JSONArray getLogFileDataFromApplicationLog(String file_name) {
        JSONArray jsonArray = new JSONArray();
        try {
            int linesRead = 0;
            try {
                String logFilePath = "/data/log/" + file_name;
                try (BufferedReader reader = new BufferedReader(new FileReader(logFilePath));){
                    String line;
                    while ((line = reader.readLine()) != null) {
                        ++linesRead;
                        jsonArray.put(line);
                    }
                    reader.close();
                }
                catch (IOException e) {
                    logger.error("Error while getting application log data : " + e);
                    e.printStackTrace();
                }
            }
            catch (Exception e) {
                logger.error("Error while getting application log data : " + e);
                e.printStackTrace();
            }
        }
        catch (Exception e) {
            logger.error("Error while getting application log data : " + e);
            e.printStackTrace();
        }
        return jsonArray;
    }

    private JSONArray getLogFileDataFromSystem(String search, String monthDayStart, String startTime, String monthDayEnd, String endTime) {
        JSONArray resultArray = new JSONArray();
        try {
            String line;
            String filepath = "/var/log/messages";
            String[] command = new String[]{"sh", "-c", "awk '/" + monthDayStart + " " + startTime + ":/, /" + monthDayEnd + " " + endTime + ":/' " + filepath + " | grep \"" + search + "\""};
            Process process = new ProcessBuilder(command).start();
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((line = reader.readLine()) != null) {
                resultArray.put(line);
            }
            int exitCode = process.waitFor();
            if (exitCode != 0) {
                logger.info("Error while reading system log data. Exit code: " + exitCode);
            }
            reader.close();
        }
        catch (IOException | InterruptedException e) {
            e.printStackTrace();
            logger.error("Error while reading system log data : " + e);
        }
        return resultArray;
    }

    private JSONArray getLogFileDataFromSystem(String startDate, String startTime, String endDate, String endTime) {
        JSONArray resultArray = new JSONArray();
        try {
            String line;
            String filepath = "/var/log/messages";
            String[] command = new String[]{"awk", "/" + startDate + " " + startTime + ":/, /" + endDate + " " + endTime + ":/", filepath};
            Process process = new ProcessBuilder(command).start();
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((line = reader.readLine()) != null) {
                resultArray.put(line);
            }
            int exitCode = process.waitFor();
            if (exitCode != 0) {
                logger.info("Error while reading log data :" + exitCode);
            }
            reader.close();
        }
        catch (IOException | InterruptedException e) {
            e.printStackTrace();
            logger.error("Error while reading log data : " + e);
        }
        return resultArray;
    }

    public JSONObject getLogFileList(JSONObject json) throws JSONException {
        JSONObject resultObj = new JSONObject();
        try {
            File folder = new File("/data/log/");
            File[] files = folder.listFiles((dir, name) -> name.startsWith("WP500"));
            if (files != null && files.length > 0) {
                Arrays.sort(files, Comparator.comparingLong(File::lastModified).reversed());
                String[] sortedFileNames = (String[])Arrays.stream(files).map(File::getName).toArray(String[]::new);
                resultObj.put("result", sortedFileNames);
                resultObj.put("status", "success");
                resultObj.put("msg", "Fetched log files successfully.");
                logger.debug("Log files successfully fetched.");
            } else {
                resultObj.put("result", new JSONArray());
                resultObj.put("status", "success");
                resultObj.put("msg", "Log files not found.");
                logger.debug("Log files not found.");
            }
        }
        catch (Exception e) {
            logger.error("Error occurred while fetching list of log: " + e);
            resultObj.put("status", "fail");
            resultObj.put("msg", "Failed to fetch log files.");
        }
        return resultObj;
    }

    private static boolean isWithinDateTimeRange(String logEntry, String startTime, String endTime) {
        String[] fields = logEntry.split(" ");
        String logTime = fields[1];
        return logTime.compareTo(startTime) >= 0 && logTime.compareTo(endTime) <= 0;
    }

    public JSONObject application_log_reder(JSONObject obj) {
        int linesRead = 0;
        String line = null;
        JSONArray jsonArray = new JSONArray();
        try {
            int batchSize = obj.getInt("required_line");
            String DateFile = obj.getString("date");
            String logFilePath = "/data/log/wp_500" + DateFile + ".log";
            String StartTime = obj.getString("start_time");
            String EndTime = obj.getString("end_time");
            try {
                BufferedReader reader = new BufferedReader(new FileReader(logFilePath));
                while ((line = reader.readLine()) != null) {
                    if (FileReaderUtil.isWithinDateTimeRange(line, StartTime, EndTime)) {
                        jsonArray.put(line);
                    }
                    if (++linesRead % batchSize != 0) continue;
                }
                reader.close();
                obj.put("result", jsonArray);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
            logger.error("Error while reding application log : " + e);
        }
        return obj;
    }

    public JSONObject systeam_log_reader(JSONObject obj) {
        String logFilePath = "/var/log/messages";
        int batchSize = 100;
        int linesRead = 0;
        JSONArray jsonArray = new JSONArray();
        try (BufferedReader reader = new BufferedReader(new FileReader(logFilePath));){
            String line;
            while ((line = reader.readLine()) != null) {
                jsonArray.put(line);
                if (++linesRead % batchSize != 0) continue;
            }
            reader.close();
            obj.put("result", jsonArray);
        }
        catch (IOException e) {
            logger.error("Error while reading system log file : " + e);
            e.printStackTrace();
        }
        catch (JSONException e) {
            logger.error("Error while reading system log file : " + e);
            e.printStackTrace();
        }
        return obj;
    }

    public JSONObject getDhcpSettingIp(JSONObject json, String user) {
        JSONObject resultObj = new JSONObject();
        try {
            boolean has = json.has("eth_type");
            if (has) {
                int eth_type = json.getInt("eth_type");
                JSONObject etDhcpSettingFromDevice = this.etDhcpSettingFromDevice(String.valueOf(eth_type));
                if (etDhcpSettingFromDevice != null) {
                    resultObj.put("eth" + eth_type + "_dhcp", eth_type);
                    resultObj.put("eth" + eth_type + "_ipaddr", etDhcpSettingFromDevice.getString("ip"));
                    resultObj.put("eth" + eth_type + "_subnet", etDhcpSettingFromDevice.getString("subnet"));
                    resultObj.put("status", "success");
                    resultObj.put("msg", " Successfully fetched DHCP setting.");
                    logger.info("DHCP setting fetched successfully.");
                    FileBasedLogger.info("Network", "DHCP setting fetched successfully.", user);
                } else {
                    resultObj.put("status", "fail");
                    resultObj.put("msg", " Failed to fetched DHCP Setting.");
                    FileBasedLogger.info("Network", "Failed to fetched DHCP Setting.", user);
                }
            }
        }
        catch (Exception e) {
            logger.error("Error occurred while fetching DHCP settings : " + e);
            FileBasedLogger.error("Network", "Error occurred while fetching DHCP settings : " + e, user);
            e.printStackTrace();
        }
        return resultObj;
    }

    public JSONObject getEthernetDetails1(JSONObject json, String user) {
        JSONObject resultObj = new JSONObject();
        try (FileInputStream fileInputStream = new FileInputStream(CONFIG_PATH);){
            Properties properties = new Properties();
            properties.load(fileInputStream);
            String serverIp = ServerXmlModifier.getInstance().getConnectorAddress().trim();
            JSONObject lan0 = new JSONObject();
            JSONObject lan1 = new JSONObject();
            JSONObject lan2 = new JSONObject();
            JSONObject ntpObj = new JSONObject();
            JSONObject commomObj = new JSONObject();
            JSONObject generalObj = new JSONObject();
            JSONObject snortObj = new JSONObject();
            String lan0_dhcp = properties.getProperty("lan0_dhcp");
            String lan0_ipaddr = properties.getProperty("lan0_ipaddr");
            String lan0_subnet = properties.getProperty("lan0_subnet");
            String lan0_gateway = properties.getProperty("lan0_gateway");
            String lan0_dns = properties.getProperty("lan0_dns");
            lan0.put("lan0_dhcp", lan0_dhcp.trim());
            lan0.put("lan0_ipaddr", lan0_ipaddr.trim());
            lan0.put("lan0_subnet", lan0_subnet.trim());
            lan0.put("lan0_gateway", lan0_gateway.trim());
            lan0.put("lan0_dns", lan0_dns.trim());
            if (serverIp.equals(lan0_ipaddr.trim())) {
                lan0.put("lan0_ip_bind", "1");
            } else {
                lan0.put("lan0_ip_bind", "0");
            }
            resultObj.put("lan0", lan0);
            String lan1Dhcp = properties.getProperty("lan1_dhcp");
            String lan1IpAddr = properties.getProperty("lan1_ipaddr");
            String lan1Subnet = properties.getProperty("lan1_subnet");
            String lan1_gateway = properties.getProperty("lan1_gateway");
            String lan1_dns = properties.getProperty("lan1_dns");
            String lan1_enable = properties.getProperty("lan1_enable");
            lan1.put("lan1_dhcp", lan1Dhcp.trim());
            lan1.put("lan1_ipaddr", lan1IpAddr.trim());
            lan1.put("lan1_subnet", lan1Subnet.trim());
            lan1.put("lan1_gateway", lan1_gateway.trim());
            lan1.put("lan1_dns", lan1_dns.trim());
            lan1.put("lan1_enable", lan1_enable.trim());
            if (serverIp.equals(lan1IpAddr.trim())) {
                lan1.put("lan1_ip_bind", "1");
            } else {
                lan1.put("lan1_ip_bind", "0");
            }
            resultObj.put("LAN1_setting", lan1);
            String lan2Dhcp = properties.getProperty("lan2_dhcp");
            String lan2IpAddr = properties.getProperty("lan2_ipaddr");
            String lan2Subnet = properties.getProperty("lan2_subnet");
            String lan2_gateway = properties.getProperty("lan2_gateway");
            String lan2_dns = properties.getProperty("lan2_dns");
            String lan2_enable = properties.getProperty("lan2_enable");
            lan2.put("lan2_dhcp", lan2Dhcp.trim());
            lan2.put("lan2_ipaddr", lan2IpAddr.trim());
            lan2.put("lan2_subnet", lan2Subnet.trim());
            lan2.put("lan2_gateway", lan2_gateway.trim());
            lan2.put("lan2_dns", lan2_dns.trim());
            lan2.put("lan2_enable", lan2_enable.trim());
            if (serverIp.equals(lan2IpAddr.trim())) {
                lan2.put("lan2_ip_bind", "1");
            } else {
                lan2.put("lan2_ip_bind", "0");
            }
            resultObj.put("LAN2_setting", lan2);
            String ntpInterval = properties.getProperty("ntp_interval");
            String ntp_server1 = properties.getProperty("ntp_server1");
            String ntp_server2 = properties.getProperty("ntp_server2");
            String ntp_server3 = properties.getProperty("ntp_server3");
            ntpObj.put("ntp_interval", ntpInterval.trim());
            ntpObj.put("ntp_server1", ntp_server1.trim());
            ntpObj.put("ntp_server2", ntp_server2.trim());
            ntpObj.put("ntp_server3", ntp_server3.trim());
            resultObj.put("ntp_setting", ntpObj);
            String redundancyEnable = properties.getProperty("Redundancy_enable");
            String redundancyRole = properties.getProperty("Redundancy_Role");
            resultObj.put("Redundancy_enable", redundancyEnable.split(";")[0].split(";")[0].trim());
            resultObj.put("Redundancy_Role", redundancyRole.split(";")[0].split(";")[0].trim());
            String partnerIp = properties.getProperty("partner_ip");
            resultObj.put("partner_ip", partnerIp.split(";")[0].trim());
            String commonIp0 = properties.getProperty("common_ip0");
            String commonSubnet0 = properties.getProperty("common_subnet0");
            String commonIp1 = properties.getProperty("common_ip1");
            String commonSubnet1 = properties.getProperty("common_subnet1");
            String commonIp2 = properties.getProperty("common_ip2");
            String commonSubnet2 = properties.getProperty("common_subnet2");
            commomObj.put("common_ip0", commonIp0.split(";")[0].trim());
            commomObj.put("common_subnet0", commonSubnet0.split(";")[0].trim());
            commomObj.put("common_ip1", commonIp1.split(";")[0].trim());
            commomObj.put("common_subnet1", commonSubnet1.split(";")[0].trim());
            commomObj.put("common_ip2", commonIp2.split(";")[0].trim());
            commomObj.put("common_subnet2", commonSubnet2.split(";")[0].trim());
            resultObj.put("common_setting", commomObj);
            String enable_ftp = properties.getProperty("enable_ftp");
            String enable_ssh = properties.getProperty("enable_ssh");
            String enable_usbtty = properties.getProperty("enable_usbtty");
            String enable_sdcard = properties.getProperty("enable_sdcard");
            generalObj.put("enable_ftp", enable_ftp.trim());
            generalObj.put("enable_ssh", enable_ssh.trim());
            generalObj.put("enable_usbtty", enable_usbtty.trim());
            generalObj.put("enable_sdcard", enable_sdcard.trim());
            resultObj.put("general_setting", generalObj);
            String snort_mode = properties.getProperty("snort_mode");
            snortObj.put("snort_mode", snort_mode.trim());
            resultObj.put("snort_setting", snortObj);
            resultObj.put("status", "success");
            resultObj.put("msg", "Successfully fetched Ethernet settings.");
            logger.info("Ethernet settings fetched successfully.");
            FileBasedLogger.info("Network", "Ethernet settings fetched successfully.", user);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Error occurred while getting ethernet details : " + e);
            FileBasedLogger.error("Network", "Error occurred while getting ethernet details : " + e, user);
            try {
                resultObj.put("status", "fail");
                resultObj.put("msg", "Failed to fetched  Ethernet settings.");
                logger.info(" Failed to fetch ethernet settings.");
            }
            catch (JSONException jsonException) {
                jsonException.printStackTrace();
            }
        }
        return resultObj;
    }

    private static String getSubnet(String ipAddress) {
        String[] octets = ipAddress.split("\\.");
        if (octets.length == 4) {
            int firstOctet = Integer.parseInt(octets[0]);
            if (firstOctet >= 0 && firstOctet <= 127) {
                return "255.0.0.0";
            }
            if (firstOctet >= 128 && firstOctet <= 191) {
                return "255.255.0.0";
            }
            if (firstOctet >= 192 && firstOctet <= 223) {
                return "255.255.255.0";
            }
            if (firstOctet >= 224 && firstOctet <= 239) {
                return "Class D - Multicast Address";
            }
            if (firstOctet >= 240 && firstOctet <= 255) {
                return "Class E - Experimental Address";
            }
        }
        return "Unknown subnet";
    }

    private JSONObject etDhcpSettingFromDevice(String type) {
        try {
            String line;
            Process process1 = Runtime.getRuntime().exec("ifconfig lan" + type);
            Process process2 = Runtime.getRuntime().exec("ifconfig lan" + type);
            BufferedReader reader1 = new BufferedReader(new InputStreamReader(process1.getInputStream()));
            BufferedReader reader2 = new BufferedReader(new InputStreamReader(process2.getInputStream()));
            String ipAddress = null;
            String subnetMask = null;
            Pattern ipPattern = Pattern.compile("inet\\s+(\\d+\\.\\d+\\.\\d+\\.\\d+)");
            Pattern subnetPattern = Pattern.compile("netmask\\s+(\\d+\\.\\d+\\.\\d+\\.\\d+)");
            while ((line = reader1.readLine()) != null) {
                Matcher ipMatcher = ipPattern.matcher(line);
                Matcher subnetMatcher = subnetPattern.matcher(line);
                if (ipMatcher.find()) {
                    ipAddress = ipMatcher.group(1);
                    continue;
                }
                if (!subnetMatcher.find()) continue;
                subnetMask = subnetMatcher.group(1);
            }
            while ((line = reader2.readLine()) != null) {
                Matcher subnetMatcher = subnetPattern.matcher(line);
                if (!subnetMatcher.find()) continue;
                subnetMask = subnetMatcher.group(1);
            }
            reader1.close();
            reader2.close();
            process1.waitFor();
            process2.waitFor();
            if (ipAddress != null && subnetMask != null) {
                return new JSONObject().put("ip", ipAddress).put("subnet", subnetMask);
            }
        }
        catch (IOException | InterruptedException | JSONException e) {
            e.printStackTrace();
        }
        return null;
    }

    private String getDHCPSettingsFromDevice(String type) {
        try {
            String command = "ifconfig eth" + type + " | grep 'inet addr' | awk '{print $2}' | cut -d: -f2";
            Process process = Runtime.getRuntime().exec(command);
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String ipAddress = reader.readLine().trim();
            reader.close();
            return ipAddress;
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
    }

    public JSONObject UpdateLanConfiguration(JSONObject json, String user) {
        JSONObject resultObj = new JSONObject();
        boolean rebootFlag = false;
        String ipaddr = "";
        String subnet = "";
        try {
            if (json.has("lan_type")) {
                String lan_type = json.getString("lan_type");
                if (lan_type.equalsIgnoreCase("lan0") || lan_type.equalsIgnoreCase("lan1") || lan_type.equalsIgnoreCase("lan2")) {
                    if (json.has(lan_type + "_ipaddr") && json.has(lan_type + "_subnet")) {
                        ipaddr = json.getString(lan_type + "_ipaddr");
                        subnet = json.getString(lan_type + "_subnet");
                    }
                    if (!ipaddr.isEmpty() || !subnet.isEmpty()) {
                        if (!this.isValidIpAddress(ipaddr) && !ipaddr.isEmpty()) {
                            resultObj.put("status", "success");
                            resultObj.put("msg", "Invalid IP address format for " + lan_type);
                            return resultObj;
                        }
                        if (!this.isValidSubnetMask(subnet) && !subnet.isEmpty()) {
                            resultObj.put("status", "success");
                            resultObj.put("msg", "Invalid subnet mask format for " + lan_type);
                            return resultObj;
                        }
                        if (json.has(lan_type + "_ip_bind") && json.getString(lan_type + "_ip_bind").equals("1") && !ipaddr.isEmpty()) {
                            String currentAddress = ServerXmlModifier.getInstance().getConnectorAddress();
                            if (ipaddr.equals(currentAddress)) {
                                logger.info("Connector address is already set to " + ipaddr + " for " + lan_type + ". No update needed.");
                            } else {
                                boolean resultBind = ServerXmlModifier.getInstance().updateConnectorAddress(ipaddr);
                                if (resultBind) {
                                    logger.info("Connector address updated successfully to " + ipaddr + " for " + lan_type);
                                    rebootFlag = true;
                                } else {
                                    logger.error("Failed to update connector address for " + lan_type);
                                }
                            }
                        }
                    }
                }
                if (lan_type.equalsIgnoreCase("lan0")) {
                    this.configFileDbOperation.writeOnDbLan0(json, user);
                    this.writeONFile(json, user);
                    resultObj.put("msg", "succsfully updated LAN settings.");
                    resultObj.put("status", "success");
                    logger.info("Successfully updated LAN settings.");
                } else if (lan_type.equalsIgnoreCase("lan1")) {
                    this.configFileDbOperation.writeOnDbLan1ORLan2(json, "lan1", user);
                    this.writeONFileLan1Setting(json, user);
                    resultObj.put("msg", "succsfully updated LAN settings.");
                    resultObj.put("status", "success");
                    logger.info("Successfully updated LAN settings for user : " + user);
                } else if (lan_type.equalsIgnoreCase("lan2")) {
                    this.configFileDbOperation.writeOnDbLan1ORLan2(json, "lan2", user);
                    this.writeONFileLan2Setting(json, user);
                    resultObj.put("msg", "succsfully updated LAN settings.");
                    resultObj.put("status", "success");
                    logger.info("Successfully updated LAN settings.");
                } else if (lan_type.equalsIgnoreCase("ntp")) {
                    this.configFileDbOperation.writeOnDbNtp(json, user);
                    this.writeONFileNtpSetting(json, user);
                    resultObj.put("msg", "succsfully updated NTP settings.");
                    resultObj.put("status", "success");
                    logger.info("Successfully updated NTP settings.");
                } else if (lan_type.equalsIgnoreCase("general")) {
                    this.configFileDbOperation.writeOnDbGeneral(json, user);
                    this.writeONFileGeneralSetting(json, user);
                    resultObj.put("msg", "Succsfully updated general settings.");
                    resultObj.put("status", "success");
                    logger.info("Successfully updated genral settings.");
                } else if (lan_type.equalsIgnoreCase("snort")) {
                    this.configFileDbOperation.writeOnDbSnort(json, user);
                    this.writeONFileSnortlSetting(json, user);
                    resultObj.put("msg", "Succsfully updated snort settings.");
                    resultObj.put("status", "success");
                    logger.info("Successfully updated snort settings.");
                } else if (lan_type.equalsIgnoreCase("redundancy_setting")) {
                    this.configFileDbOperation.writeOnDbRedundancy(json, user);
                    this.writeONFileRedundancySetting(json, user);
                    resultObj.put("msg", "Succsfully updated redundancy setting.");
                    resultObj.put("status", "success");
                    logger.info("Successfully updated redundancy settings.");
                }
            }
            if (rebootFlag) {
                return this.rebootSystem(ipaddr.trim(), " LAN settings updated Successfully.");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Error occurred while updating lan configuration : " + e);
            FileBasedLogger.error("Network", "Error occurred while updating lan configuration : " + e, user);
            try {
                resultObj.put("msg", "failed to update LAN settings.");
                resultObj.put("status", "success");
                logger.info("Error occurred while updating lan configuration.");
            }
            catch (JSONException e1) {
                e1.printStackTrace();
                logger.error("Error occurred while updating LAN Settings : " + e);
            }
        }
        return resultObj;
    }

    private void writeONFile(JSONObject json, String user) {
        try {
            String line;
            String lan0_dhcp = "";
            String lan0_ipaddr = "";
            String lan0_subnet = "";
            String lan0_gateway = "";
            String lan0_dns = "";
            if (json.has("lan0_dhcp")) {
                lan0_dhcp = json.getString("lan0_dhcp");
            }
            if (json.has("lan0_ipaddr")) {
                lan0_ipaddr = json.getString("lan0_ipaddr");
            }
            if (json.has("lan0_subnet")) {
                lan0_subnet = json.getString("lan0_subnet");
            }
            if (json.has("lan0_gateway")) {
                lan0_gateway = json.getString("lan0_gateway");
            }
            if (json.has("lan0_dns")) {
                lan0_dns = json.getString("lan0_dns");
            }
            File file = new File(CONFIG_PATH);
            BufferedReader reader = new BufferedReader(new FileReader(file));
            StringBuilder content = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("lan0_dhcp =") || line.contains("lan0_dhcp")) {
                    if (!lan0_dhcp.isEmpty()) {
                        line = "lan0_dhcp = " + lan0_dhcp;
                    }
                } else if (line.startsWith("lan0_ipaddr =") || line.contains("lan0_ipaddr")) {
                    if (!lan0_ipaddr.isEmpty() && lan0_dhcp.equals("0")) {
                        line = "lan0_ipaddr = " + lan0_ipaddr;
                    }
                } else if (line.startsWith("lan0_subnet =") || line.contains("lan0_subnet")) {
                    if (!lan0_subnet.isEmpty() && lan0_dhcp.equals("0")) {
                        line = "lan0_subnet = " + lan0_subnet;
                    }
                } else if (line.startsWith("lan0_gateway =") || line.contains("lan0_gateway")) {
                    if (!lan0_gateway.isEmpty() && lan0_dhcp.equals("0")) {
                        line = "lan0_gateway = " + lan0_gateway;
                    }
                } else if ((line.startsWith("lan0_dns =") || line.contains("lan0_dns")) && !lan0_dns.isEmpty() && lan0_dhcp.equals("0")) {
                    line = "lan0_dns = " + lan0_dns;
                }
                content.append(line).append(System.lineSeparator());
            }
            reader.close();
            BufferedWriter writer = new BufferedWriter(new FileWriter(file));
            writer.write(content.toString());
            writer.flush();
            writer.close();
            logger.info("lan0 IP address changed successfully");
            FileBasedLogger.info("Network", "lan0 IP address changed successfully", user);
        }
        catch (Exception e) {
            logger.error("Error while updating lan configuration : " + e);
            FileBasedLogger.error("Network", "Error while updating lan configuration : " + e, user);
            e.printStackTrace();
        }
    }

    private void writeONFileLan1Setting(JSONObject json, String user) {
        try {
            String line;
            String lan1_dhcp = "";
            String lan1_ipaddr = "";
            String lan1_subnet = "";
            String lan1_gateway = "";
            String lan1_dns = "";
            String lan1_enable = "";
            if (json.has("lan1_dhcp")) {
                lan1_dhcp = json.getString("lan1_dhcp");
            }
            if (json.has("lan1_ipaddr")) {
                lan1_ipaddr = json.getString("lan1_ipaddr");
            }
            if (json.has("lan1_subnet")) {
                lan1_subnet = json.getString("lan1_subnet");
            }
            if (json.has("lan1_gateway")) {
                lan1_gateway = json.getString("lan1_gateway");
            }
            if (json.has("lan1_dns")) {
                lan1_dns = json.getString("lan1_dns");
            }
            if (json.has("lan1_enable")) {
                lan1_enable = json.getString("lan1_enable");
            }
            File file = new File(CONFIG_PATH);
            BufferedReader reader = new BufferedReader(new FileReader(file));
            StringBuilder content = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("lan1_dhcp =") || line.contains("lan1_dhcp")) {
                    if (!lan1_dhcp.isEmpty()) {
                        line = "lan1_dhcp = " + lan1_dhcp;
                    }
                } else if (line.startsWith("lan1_ipaddr=") || line.contains("lan1_ipaddr")) {
                    if (!lan1_ipaddr.isEmpty() && lan1_dhcp.contains("0")) {
                        line = "lan1_ipaddr = " + lan1_ipaddr;
                    }
                } else if (line.startsWith("lan1_subnet =") || line.contains("lan1_subnet")) {
                    if (!lan1_subnet.isEmpty() && lan1_dhcp.contains("0")) {
                        line = "lan1_subnet = " + lan1_subnet;
                    }
                } else if (line.startsWith("lan1_gateway =") || line.contains("lan1_gateway")) {
                    if (!lan1_gateway.isEmpty() && lan1_dhcp.contains("0")) {
                        line = "lan1_gateway = " + lan1_gateway;
                    }
                } else if (line.startsWith("lan1_dns =") || line.contains("lan1_dns")) {
                    if (!lan1_dns.isEmpty() && lan1_dhcp.contains("0")) {
                        line = "lan1_dns = " + lan1_dns;
                    }
                } else if ((line.startsWith("lan1_enable =") || line.contains("lan1_enable")) && !lan1_enable.isEmpty() && !lan1_enable.isEmpty()) {
                    line = "lan1_enable = " + lan1_enable;
                }
                content.append(line).append(System.lineSeparator());
            }
            reader.close();
            BufferedWriter writer = new BufferedWriter(new FileWriter(file));
            writer.write(content.toString());
            writer.flush();
            writer.close();
            logger.info("LAN1 IP address changed successfully");
            FileBasedLogger.info("Network", "LAN1 IP address changed successfully", user);
        }
        catch (Exception e) {
            logger.error("Error while updating lan configuration : " + e);
            FileBasedLogger.error("Network", "Error while updating lan configuration : " + e, user);
            e.printStackTrace();
        }
    }

    private void writeONFileLan2Setting(JSONObject json, String user) {
        try {
            String line;
            String lan2_dhcp = "";
            String lan2_ipaddr = "";
            String lan2_subnet = "";
            String lan2_gateway = "";
            String lan2_dns = "";
            String lan2_enable = "";
            if (json.has("lan2_dhcp")) {
                lan2_dhcp = json.getString("lan2_dhcp");
            }
            if (json.has("lan2_ipaddr")) {
                lan2_ipaddr = json.getString("lan2_ipaddr");
            }
            if (json.has("lan2_subnet")) {
                lan2_subnet = json.getString("lan2_subnet");
            }
            if (json.has("lan2_gateway")) {
                lan2_gateway = json.getString("lan2_gateway");
            }
            if (json.has("lan2_dns")) {
                lan2_dns = json.getString("lan2_dns");
            }
            if (json.has("lan2_enable")) {
                lan2_enable = json.getString("lan2_enable");
            }
            File file = new File(CONFIG_PATH);
            BufferedReader reader = new BufferedReader(new FileReader(file));
            StringBuilder content = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("lan2_dhcp =") || line.contains("lan2_dhcp")) {
                    if (!lan2_dhcp.isEmpty()) {
                        line = "lan2_dhcp = " + lan2_dhcp;
                    }
                } else if (line.startsWith("lan2_ipaddr =") || line.contains("lan2_ipaddr")) {
                    if (!lan2_ipaddr.isEmpty() && lan2_dhcp.contains("0")) {
                        line = "lan2_ipaddr = " + lan2_ipaddr;
                    }
                } else if (line.startsWith("lan2_subnet =") || line.contains("lan2_subnet")) {
                    if (!lan2_subnet.isEmpty() && lan2_dhcp.contains("0")) {
                        line = "lan2_subnet = " + lan2_subnet;
                    }
                } else if (line.startsWith("lan2_gateway =") || line.contains("lan2_gateway")) {
                    if (!lan2_gateway.isEmpty() && lan2_dhcp.contains("0")) {
                        line = "lan2_gateway = " + lan2_gateway;
                    }
                } else if (line.startsWith("lan2_dns =") || line.contains("lan2_dns")) {
                    if (!lan2_dns.isEmpty() && lan2_dhcp.contains("0")) {
                        line = "lan2_dns = " + lan2_dns;
                    }
                } else if ((line.startsWith("lan2_enable =") || line.contains("lan2_enable")) && !lan2_enable.isEmpty() && !lan2_enable.isEmpty()) {
                    line = "lan2_enable = " + lan2_enable;
                }
                content.append(line).append(System.lineSeparator());
            }
            reader.close();
            BufferedWriter writer = new BufferedWriter(new FileWriter(file));
            writer.write(content.toString());
            writer.flush();
            writer.close();
            logger.info("LAN2 IP address changed successfully");
            FileBasedLogger.info("Network", "LAN2 IP address changed successfully", user);
        }
        catch (Exception e) {
            logger.error("Error while updating lan configuration : " + e);
            FileBasedLogger.error("Network", "Error while updating lan configuration : " + e, user);
            e.printStackTrace();
        }
    }

    private void writeONFileNtpSetting(JSONObject json, String user) {
        try {
            String line;
            String ntp_server1 = "";
            String ntp_server2 = "";
            String ntp_server3 = "";
            String ntp_interval = "";
            if (json.has("ntp_server1")) {
                ntp_server1 = json.getString("ntp_server1");
            }
            if (json.has("ntp_server2")) {
                ntp_server2 = json.getString("ntp_server2");
            }
            if (json.has("ntp_server3")) {
                ntp_server3 = json.getString("ntp_server3");
            }
            if (json.has("ntp_interval")) {
                ntp_interval = json.getString("ntp_interval");
            }
            File file = new File(CONFIG_PATH);
            BufferedReader reader = new BufferedReader(new FileReader(file));
            StringBuilder content = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("ntp_server1 =")) {
                    line = !ntp_server1.isEmpty() ? "ntp_server1 = " + ntp_server1 : "ntp_server1 = " + ntp_server1;
                } else if (line.startsWith("ntp_server2 =")) {
                    line = !ntp_server2.isEmpty() ? "ntp_server2 = " + ntp_server2 : "ntp_server2 = " + ntp_server2;
                } else if (line.startsWith("ntp_server3 =")) {
                    line = !ntp_server3.isEmpty() ? "ntp_server3 = " + ntp_server3 : "ntp_server3 = " + ntp_server3;
                } else if (line.startsWith("ntp_interval =")) {
                    line = !ntp_interval.isEmpty() ? "ntp_interval = " + ntp_interval : "ntp_interval = " + ntp_interval;
                }
                content.append(line).append(System.lineSeparator());
            }
            reader.close();
            BufferedWriter writer = new BufferedWriter(new FileWriter(file));
            writer.write(content.toString());
            writer.flush();
            writer.close();
            logger.info("NTP setting updated successfully");
            FileBasedLogger.info("Network", "NTP setting updated successfully", user);
        }
        catch (Exception e) {
            logger.error("Error while updating ntp configuration : " + e);
            FileBasedLogger.error("Network", "Error while updating ntp configuration : " + e, user);
            e.printStackTrace();
        }
    }

    private void writeONFileGeneralSetting(JSONObject json, String user) {
        try {
            String line;
            String enable_ftp = "";
            String enable_ssh = "";
            String enable_usbtty = "";
            String enable_sdcard = "";
            if (json.has("enable_ftp")) {
                enable_ftp = json.getString("enable_ftp");
            }
            if (json.has("enable_ssh")) {
                enable_ssh = json.getString("enable_ssh");
            }
            if (json.has("enable_usbtty")) {
                enable_usbtty = json.getString("enable_usbtty");
            }
            if (json.has("enable_sdcard")) {
                enable_sdcard = json.getString("enable_sdcard");
            }
            File file = new File(CONFIG_PATH);
            BufferedReader reader = new BufferedReader(new FileReader(file));
            StringBuilder content = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("enable_ftp =")) {
                    line = !enable_ftp.isEmpty() ? "enable_ftp = " + enable_ftp : "enable_ftp = " + enable_ftp;
                } else if (line.startsWith("enable_ssh =")) {
                    line = !enable_ssh.isEmpty() ? "enable_ssh = " + enable_ssh : "enable_ssh = " + enable_ssh;
                } else if (line.startsWith("enable_usbtty =")) {
                    line = !enable_usbtty.isEmpty() ? "enable_usbtty = " + enable_usbtty : "enable_usbtty = " + enable_usbtty;
                } else if (line.startsWith("enable_sdcard =")) {
                    line = !enable_sdcard.isEmpty() ? "enable_sdcard = " + enable_sdcard : "enable_sdcard = " + enable_sdcard;
                }
                content.append(line).append(System.lineSeparator());
            }
            reader.close();
            BufferedWriter writer = new BufferedWriter(new FileWriter(file));
            writer.write(content.toString());
            writer.flush();
            writer.close();
            logger.info("General setting updated successfully");
            FileBasedLogger.info("Network", "General setting updated successfully", user);
        }
        catch (Exception e) {
            logger.error("Error while updating General configuration : " + e);
            FileBasedLogger.error("Network", "Error while updating General configuration : " + e, user);
            e.printStackTrace();
        }
    }

    private void writeONFileRedundancySetting(JSONObject json, String user) {
        try {
            String line;
            String Redundancy_enable = "";
            String Redundancy_Role = "";
            String partner_ip = "";
            String common_ip0 = "";
            String common_subnet0 = "";
            String common_ip1 = "";
            String common_subnet1 = "";
            String common_ip2 = "";
            String common_subnet2 = "";
            if (json.has("Redundancy_enable")) {
                Redundancy_enable = json.getString("Redundancy_enable");
            }
            if (json.has("Redundancy_Role")) {
                Redundancy_Role = json.getString("Redundancy_Role");
            }
            if (json.has("partner_ip")) {
                partner_ip = json.getString("partner_ip");
            }
            if (json.has("common_ip0")) {
                common_ip0 = json.getString("common_ip0");
            }
            if (json.has("common_subnet0")) {
                common_subnet0 = json.getString("common_subnet0");
            }
            if (json.has("common_ip1")) {
                common_ip1 = json.getString("common_ip1");
            }
            if (json.has("common_subnet1")) {
                common_subnet1 = json.getString("common_subnet1");
            }
            if (json.has("common_ip2")) {
                common_ip2 = json.getString("common_ip2");
            }
            if (json.has("common_subnet2")) {
                common_subnet2 = json.getString("common_subnet2");
            }
            File file = new File(CONFIG_PATH);
            BufferedReader reader = new BufferedReader(new FileReader(file));
            StringBuilder content = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("Redundancy_enable =") || line.contains("Redundancy_enable")) {
                    if (!Redundancy_enable.isEmpty()) {
                        line = "Redundancy_enable = " + Redundancy_enable + "           ; integer 1: enable 0:disable";
                    }
                } else if (line.startsWith("Redundancy_Role =") || line.contains("Redundancy_Role")) {
                    if (!Redundancy_Role.isEmpty()) {
                        line = "Redundancy_Role = " + Redundancy_Role + "             ; integer 1:Primary 0:secondary";
                    }
                } else if (line.startsWith("partner_ip =") || line.contains("partner_ip")) {
                    if (!partner_ip.isEmpty()) {
                        line = "partner_ip = " + partner_ip + "           ; partner ip address";
                    }
                } else if (line.startsWith("common_ip0 =") || line.contains("common_ip0")) {
                    if (!common_ip0.isEmpty()) {
                        line = "common_ip0 = " + common_ip0 + "           ; lan0 common ip address";
                    }
                } else if (line.startsWith("common_subnet0 =") || line.contains("common_subnet0")) {
                    if (!common_subnet0.isEmpty()) {
                        line = "common_subnet0 = " + common_subnet0 + "           ; lan0 common ip subnet";
                    }
                } else if (line.startsWith("common_ip1 =") || line.contains("common_ip1")) {
                    if (!common_ip1.isEmpty()) {
                        line = "common_ip1 = " + common_ip1 + "           ; lan1 common ip address";
                    }
                } else if (line.startsWith("common_subnet1 =") || line.contains("common_subnet1")) {
                    if (common_subnet1.isEmpty()) {
                        line = "common_subnet1 = " + common_subnet1 + "           ; lan1 common ip subnet";
                    }
                } else if (line.startsWith("common_ip2 =") || line.contains("common_ip2")) {
                    if (!common_ip2.isEmpty()) {
                        line = "common_ip2 = " + common_ip2 + "           ; lan2 common ip address";
                    }
                } else if ((line.startsWith("common_subnet2 =") || line.contains("common_subnet2")) && !common_subnet2.isEmpty()) {
                    line = "common_subnet2 = " + common_subnet2 + "           ; lan2 common ip subnet";
                }
                content.append(line).append(System.lineSeparator());
            }
            reader.close();
            BufferedWriter writer = new BufferedWriter(new FileWriter(file));
            writer.write(content.toString());
            writer.flush();
            writer.close();
            logger.info("Redundancy configuration changed successfully");
            FileBasedLogger.info("Network", "Redundancy configuration changed successfully", user);
        }
        catch (Exception e) {
            logger.error("Error while updating Redundancy configuration : " + e);
            FileBasedLogger.error("Network", "Error while updating Redundancy configuration : " + e, user);
            e.printStackTrace();
        }
    }

    private void writeONFileSnortlSetting(JSONObject json, String user) {
        try {
            String line;
            String snort_mode = "";
            if (json.has("snort_mode")) {
                snort_mode = json.getString("snort_mode");
            }
            File file = new File(CONFIG_PATH);
            BufferedReader reader = new BufferedReader(new FileReader(file));
            StringBuilder content = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("snort_mode =")) {
                    line = !snort_mode.isEmpty() ? "snort_mode = " + snort_mode : "snort_mode = " + snort_mode;
                }
                content.append(line).append(System.lineSeparator());
            }
            reader.close();
            BufferedWriter writer = new BufferedWriter(new FileWriter(file));
            writer.write(content.toString());
            writer.flush();
            writer.close();
            logger.info("Snort setting updated successfully");
            FileBasedLogger.info("Network", "Snort setting updated successfully", user);
        }
        catch (Exception e) {
            logger.error("Error while updating Snort configuration : " + e);
            FileBasedLogger.error("Network", "Error while updating Snort configuration : " + e, user);
            e.printStackTrace();
        }
    }

    public JSONObject fetchFirewallSettings(JSONObject json) throws JSONException {
        JSONObject firewallSettings = new JSONObject();
        JSONObject resultObj = new JSONObject();
        try {
            String line;
            Process process = Runtime.getRuntime().exec("iptables -L -n -v");
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            JSONArray rulesArray = new JSONArray();
            while ((line = reader.readLine()) != null) {
                JSONObject rule = FileReaderUtil.parseFirewallRule(line);
                if (rule == null) continue;
                rulesArray.put(rule);
            }
            firewallSettings.put("rules", rulesArray);
            resultObj.put("status", "success");
            resultObj.put("msg", "Successfully fetched firewall settings.");
            resultObj.put("result", firewallSettings);
            logger.info("Firewall settings fetched successfully. ");
            reader.close();
        }
        catch (IOException e) {
            logger.error("Error occurred while fetching firewall settings : " + e);
            e.printStackTrace();
            resultObj.put("status", "fail");
            resultObj.put("msg", "failed to fetched firewall settings.");
        }
        return json;
    }

    private static JSONObject parseFirewallRule(String ruleString) throws JSONException {
        JSONObject rule = new JSONObject();
        rule.put("rule", ruleString);
        return rule;
    }

    public JSONObject update_ntp(JSONObject obj, String user) throws JSONException {
        JSONObject resultObj = new JSONObject();
        try {
            boolean setNtp = this.setNtp(obj);
            if (setNtp) {
                resultObj.put("status", "success");
                resultObj.put("msg", "Ntp settings successfully updated.");
                logger.info("Updated NTP settings.");
            } else {
                resultObj.put("status", "fail");
                resultObj.put("msg", "failed to update Ntp settings.");
                logger.info("Failed To Update NTP settings.");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(" Error occurred while updating ntp details : " + e);
        }
        return resultObj;
    }

    public JSONObject get_ntp(JSONObject obj) throws JSONException {
        JSONObject resultObj = new JSONObject();
        try {
            String line;
            String filePath = CONFIG_PATH;
            File file = new File(filePath);
            BufferedReader reader = new BufferedReader(new FileReader(file));
            StringBuilder content = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                if (line.contains("ntp_client")) {
                    String ip0 = line.split("=")[1].trim().split(";")[0];
                    resultObj.put("ntp_client", ip0.trim());
                } else if (line.contains("ntp_interval")) {
                    String ip1 = line.split("=")[1].trim().split(";")[0];
                    resultObj.put("ntp_interval", ip1.trim());
                } else if (line.contains("ntp_server")) {
                    String ip2 = line.split("=")[1].trim().split(";")[0];
                    resultObj.put("ntp_server", ip2.trim());
                }
                content.append(line).append("\n");
            }
            reader.close();
            resultObj.put("status", "success");
            resultObj.put("msg", "successfully fetched ntp details.");
            logger.info("NTP details fetched successfully.");
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(" Error occurred while fetching ntp details : " + e);
            resultObj.put("status", "fail");
            resultObj.put("msg", "failed to fetch ntp settings.");
        }
        return resultObj;
    }

    public boolean setNtp(JSONObject json) throws JSONException {
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
        String ntpValue = json.getString("ntp_client");
        if (ntpValue.equals("1")) {
            processBuilder.command("systemctl", "start", "systemd-timesyncd.service");
        } else if (ntpValue.equals("0")) {
            processBuilder.command("timedatectl", "set-ntp", "FALSE");
        }
        try {
            Process process = processBuilder.start();
            int exitCode = process.waitFor();
            return exitCode == 0;
        }
        catch (IOException | InterruptedException e) {
            e.printStackTrace();
            return false;
        }
    }

    public JSONObject setManulTime(JSONObject json, String user) throws JSONException {
        JSONObject resultObj = new JSONObject();
        try {
            ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
            if (json.has("time")) {
                String time = json.getString("time");
                processBuilder.command("timedatectl", "set-time", time);
                resultObj.put("status", "success");
                resultObj.put("msg", "Time set successfully.");
                logger.info("Set time successfully.");
            } else {
                resultObj.put("status", "success");
                resultObj.put("msg", "Time value not found in JSON format.");
            }
            Process process = processBuilder.start();
            int exitCode = process.waitFor();
            if (exitCode == 0) {
                resultObj.put("status", "success");
                resultObj.put("msg", "Time set successfully.");
                logger.info("Set time successfully.");
            } else {
                resultObj.put("status", "fail");
                resultObj.put("msg", "Failed to set time.");
                logger.info("Failed to set time.");
            }
        }
        catch (IOException | InterruptedException e) {
            e.printStackTrace();
            logger.error("Error occurred while set time : " + e);
        }
        return resultObj;
    }

    public JSONObject getMqttConnectionStatus(JSONObject json) {
        JSONObject resultObj = new JSONObject();
        logger.info("------------------------" + json);
        if (!MqttExecutor.serverlistMap.isEmpty()) {
            logger.info("Logging all entries in serverlistMap:");
            for (Map.Entry<String, MqttClient> entry : MqttExecutor.serverlistMap.entrySet()) {
                String ip_address = entry.getKey();
                boolean connected = entry.getValue().isConnected();
                logger.info("ip_address: " + ip_address + " - Connected: " + connected);
            }
        } else {
            logger.info("serverlistMap is empty.");
        }
        try {
            if (json.has("ip_address")) {
                String ip_address = json.getString("ip_address");
                if (MqttExecutor.serverlistMap.containsKey(ip_address.trim())) {
                    boolean connected = MqttExecutor.serverlistMap.get(ip_address.trim()).isConnected();
                    logger.info("Connection status for ip_address " + ip_address + ": " + connected);
                    if (connected) {
                        resultObj.put("status", "success");
                        resultObj.put("connection_status", "true");
                        resultObj.put("msg", "Successfully fetched connetion status of ip_address.");
                    } else {
                        resultObj.put("status", "success");
                        resultObj.put("connection_status", "false");
                        resultObj.put("msg", "Successfully fetched connetion status of ip_address.");
                    }
                } else {
                    resultObj.put("status", "success");
                    resultObj.put("connection_status", "false");
                    resultObj.put("msg", "Not Found provided ip_address.");
                }
            }
        }
        catch (Exception e) {
            resultObj.put("status", "Fail");
            resultObj.put("connection_status", "false");
            resultObj.put("msg", "failed to fetch ip_address status.");
            e.printStackTrace();
            logger.error("Failed to fetch ip_address status.");
        }
        return resultObj;
    }

    public JSONObject fileManger(JSONObject json, String user) {
        try {
            String operationType = json.getString("operation_type");
            if (operationType.equalsIgnoreCase("straton_file_list")) {
                JSONObject stratonResult = FileReaderUtil.listFilesFromDevice(T5_STARTON_PATH, ".cod");
                return stratonResult;
            }
            if (operationType.equalsIgnoreCase("firmware_file_list")) {
                JSONObject firmwareResult = FileReaderUtil.listFilesFromDevice(FIRMWARE_PATH, ".swu");
                return firmwareResult;
            }
            if (operationType.equalsIgnoreCase("ssl_certificate_file_list")) {
                JSONObject firmwareResult = FileReaderUtil.listFilesFromDevice(CRTFILE_PATH, ".crt");
                return firmwareResult;
            }
            if (operationType.equalsIgnoreCase("straton_file_delete")) {
                String stratonFileName = json.getString("straton_file_name");
                boolean deletionStatus = FileReaderUtil.deleteFile(T5_STARTON_PATH, stratonFileName);
                JSONObject deletionResult = new JSONObject();
                if (deletionStatus) {
                    this.deleteFileEntriesFromDB(stratonFileName);
                    deletionResult.put("status", "success");
                    deletionResult.put("message", "File '" + stratonFileName + "' deleted successfully.");
                    logger.info("Successfully deleted file : " + stratonFileName);
                    FileBasedLogger.info("Audit", "Successfully deleted file : " + stratonFileName, user);
                } else {
                    deletionResult.put("status", "fail");
                    deletionResult.put("error", "Error while deleting file '" + stratonFileName + "'.");
                    logger.info("Error occurred while Deleting file.");
                    FileBasedLogger.info("Audit", "Error occurred while Deleting file.", user);
                }
                return deletionResult;
            }
            if (operationType.equalsIgnoreCase("firmware_file_delete")) {
                String firmwareFileName = json.getString("firmware_file_name");
                boolean deletionStatus = FileReaderUtil.deleteFile(FIRMWARE_PATH, firmwareFileName);
                JSONObject deletionResult = new JSONObject();
                if (deletionStatus) {
                    this.deleteFileEntriesFromDB(firmwareFileName);
                    deletionResult.put("status", "success");
                    deletionResult.put("msg", "File '" + firmwareFileName + "' deleted successfully.");
                    logger.info("Successfully deleted file : " + firmwareFileName);
                    FileBasedLogger.info("Audit", "Successfully deleted file : " + firmwareFileName, user);
                } else {
                    deletionResult.put("status", "fail");
                    deletionResult.put("error", "Error while deleting file '" + firmwareFileName + "'.");
                    logger.info("Error occurred while Deleting file.");
                    FileBasedLogger.info("Audit", "Error occurred while Deleting file.", user);
                }
                return deletionResult;
            }
            if (operationType.equalsIgnoreCase("crt_file_delete")) {
                String crtFileName = json.getString("crt_file_name");
                boolean deletionStatus = FileReaderUtil.deleteFile(CRTFILE_PATH, crtFileName);
                JSONObject deletionResult = new JSONObject();
                if (deletionStatus) {
                    this.deleteFileEntriesFromDB(crtFileName);
                    deletionResult.put("status", "success");
                    deletionResult.put("message", "File '" + crtFileName + "' deleted successfully.");
                    logger.info("Successfully deleted file : " + crtFileName);
                    FileBasedLogger.info("Audit", "Successfully deleted file : " + crtFileName, user);
                } else {
                    deletionResult.put("status", "fail");
                    deletionResult.put("error", "Error while deleting file '" + crtFileName + "'.");
                    logger.info("Error occurred while Deleting file.");
                    FileBasedLogger.info("Audit", "Error occurred while Deleting file.", user);
                }
                return deletionResult;
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
            logger.error("Error occurred while processing JSON : " + e.getMessage());
            FileBasedLogger.info("Application", "Error occurred while fileManger.", user);
        }
        return null;
    }

    public static boolean deleteFile(String filePath, String fileName) {
        try {
            File file = new File(filePath, fileName);
            if (file.exists() && file.isFile()) {
                return file.delete();
            }
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            FileBasedLogger.info("Application", "Error occurred while Deleting file.", "system");
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteFileEntriesFromDB(String partialFilename) {
        Connection connection = null;
        try {
            connection = SQLiteConnector.getConnection();
            String sql = "DELETE FROM file_integrity WHERE filename LIKE ?";
            try (PreparedStatement pstmt = connection.prepareStatement(sql);){
                pstmt.setString(1, "%" + partialFilename + "%");
                int n = pstmt.executeUpdate();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            logger.error("Error deleting file entries from database: " + e.getMessage());
            FileBasedLogger.error("Application", "Error deleting file entries from database.", "system");
        }
        finally {
            SQLiteConnector.closeConnection(connection);
        }
    }

    private static JSONObject listFilesFromDevice(String directoryPath, String fileExtension) throws JSONException {
        JSONObject resultObj = new JSONObject();
        try {
            ArrayList<String> fileList = new ArrayList<String>();
            File directory = new File(directoryPath);
            File[] files = directory.listFiles();
            if (files != null) {
                for (File file : files) {
                    if (!file.isFile() || !file.getName().toLowerCase().endsWith(fileExtension.toLowerCase())) continue;
                    fileList.add(file.getName());
                }
            }
            JSONArray filesArray = new JSONArray((Collection<?>)fileList);
            resultObj.put("files", filesArray);
            resultObj.put("status", "success");
            resultObj.put("msg", "Files listed successfully.");
        }
        catch (JSONException e) {
            resultObj.put("status", "fail");
            resultObj.put("msg", "Failed to listing files.");
            logger.error("Error occurred while listing files: " + e.getMessage());
            FileBasedLogger.error("Application", "Error occurred while listing files.", "system");
        }
        return resultObj;
    }

    public JSONObject get_ntp_details(String user) throws JSONException {
        JSONObject resultObj = new JSONObject();
        try {
            Process process = Runtime.getRuntime().exec("timedatectl status");
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                String line;
                while ((line = reader.readLine()) != null) {
                    String[] parts;
                    if (line.contains("System clock synchronized:")) {
                        parts = line.split(":");
                        if (parts.length <= 1) continue;
                        resultObj.put("system_clock_synchronized", parts[1].trim());
                        continue;
                    }
                    if (!line.contains("NTP service:") || (parts = line.split(":")).length <= 1) continue;
                    resultObj.put("ntp_service", parts[1].trim());
                }
                resultObj.put("status", "success");
                resultObj.put("msg", "Successfully fetched ntp details.");
                logger.info("Fetched ntp details successfully.");
            }
            catch (JSONException e) {
                resultObj.put("status", "fail");
                resultObj.put("msg", "Failed to fetch ntp details.");
                e.printStackTrace();
                logger.error(" Error occurred while fetching ntp details : " + e.getMessage());
                FileBasedLogger.error("Application", "Error occurred while fetching ntp setting.", "system");
            }
        }
        catch (IOException e) {
            resultObj.put("status", "fail");
            resultObj.put("msg", "Failed to fetch ntp details.");
            e.printStackTrace();
            logger.error("Error occurred while fetching ntp details : " + e.getMessage());
            FileBasedLogger.error("Application", "Error occurred while fetching ntp setting.", "system");
        }
        return resultObj;
    }

    public JSONObject getOverviewInfo(String user) throws JSONException {
        JSONObject resultObj = new JSONObject();
        String filePath = "/etc/hwstatus/hwstatus.dat";
        try {
            String[] commands;
            for (String command : commands = new String[]{"fw_printenv FW_REV", "fw_printenv HW_REV", "fw_printenv TAS_SERIAL_NO"}) {
                Process process = new ProcessBuilder("bash", "-c", command).start();
                BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                String output = reader.readLine();
                reader.close();
                String[] keyValue = output.split("=");
                if (keyValue.length != 2) continue;
                String key = keyValue[0].trim();
                String value = keyValue[1].trim();
                resultObj.put(key, value);
            }
            try (BufferedReader br = new BufferedReader(new FileReader(filePath));){
                String line;
                while ((line = br.readLine()) != null) {
                    String[] parts = line.split("=");
                    if (parts.length != 2) continue;
                    String key = parts[0].trim();
                    String value = parts[1].trim();
                    if (!key.contains("NTP_SYNC_STATUS") && !key.contains("SEC_PATCH_LVL") && !key.contains("MAC_ID0") && !key.contains("MAC_ID1") && !key.contains("MAC_ID2")) continue;
                    resultObj.put(key, value);
                }
            }
            catch (IOException | JSONException e) {
                e.printStackTrace();
            }
            resultObj.put("patch_version", PatchVersionSetting.PatchVersion);
            resultObj.put("backend_version", PatchVersionSetting.backendVersion);
            resultObj.put("status", "success");
            resultObj.put("msg", "Successfully fetched overview information.");
            logger.info("Fetched overview information successfully.");
        }
        catch (IOException | JSONException e) {
            e.printStackTrace();
            resultObj.put("status", "fail");
            resultObj.put("msg", "Failed to fetch overview information.");
            logger.error("Error occurred while getting overview information : " + e);
            FileBasedLogger.error("Application", "Error occurred while getting overview information.", "system");
        }
        return resultObj;
    }

    public boolean isValidIpAddress(String ipAddress) {
        String ipPattern = "^([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])$";
        return Pattern.matches(ipPattern, ipAddress);
    }

    private boolean isValidSubnetMask(String subnetMask) {
        String subnetPattern = "^((128|192|224|240|248|252|254)\\.0\\.0\\.0)|(255\\.(0|128|192|224|240|248|252|254)\\.0\\.0)|(255\\.255\\.(0|128|192|224|240|248|252|254)\\.0)|(255\\.255\\.255\\.(0|128|192|224|240|248|252|254))$";
        return Pattern.matches(subnetPattern, subnetMask);
    }

    public JSONObject rebootSystem(String bindIpAddress, String customMessage) {
        JSONObject json = new JSONObject();
        try {
            String fullMessage = customMessage + " Note: Restarting service. This process may take a few moments. Once completed, you can log in with the IP address: " + bindIpAddress;
            json.put("status", "success");
            json.put("msg", fullMessage);
        }
        catch (JSONException e) {
            logger.error("Error occurred while creating JSON response: " + e.getMessage());
            json.put("status", "fail");
            json.put("msg", "Failed to prepare the restart response.");
            return json;
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    logger.info("Attempting to restart Apache Tomcat...");
                    Thread.sleep(15000L);
                    Process restartTomcat = Runtime.getRuntime().exec("systemctl restart apache-tomcat.service");
                    int tomcatExitStatus = restartTomcat.waitFor();
                    if (tomcatExitStatus == 0) {
                        logger.info("Apache Tomcat restarted successfully.");
                    } else {
                        logger.error("Failed to restart Apache Tomcat. Exit status: " + tomcatExitStatus);
                    }
                }
                catch (Exception e) {
                    logger.error("Error occurred while restarting Apache Tomcat: " + e.getMessage());
                }
            }
        }).start();
        return json;
    }
}

