/*
 * Decompiled with CFR 0.152.
 */
package com.tas.wp500.jsonBuilderSettings;

import com.tas.wp500.fileLogSetting.FileBasedLogger;
import com.tas.wp500.protocol.jsonbuillder.JSONBuilder;
import com.tas.wp500.security.Security;
import com.tas.wp500.services.Service;
import com.tas.wp500.sql_lite_db.SQLiteConnector;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public class JsonBuilder_operation
extends Security {
    private static Logger logger = Logger.getLogger(JsonBuilder_operation.class);
    private static JsonBuilder_operation instance = null;
    private static final int SQLITE_BUSY = 5;
    private static final int RETRY_COUNT = 5;
    private static final int RETRY_DELAY = 10000;

    public JsonBuilder_operation() {
        this.createJsonBuilderTable();
    }

    public static JsonBuilder_operation getInstance() {
        if (instance == null) {
            instance = new JsonBuilder_operation();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createJsonBuilderTable() {
        Connection connection = null;
        try {
            connection = SQLiteConnector.getConnection();
            Statement statement = connection.createStatement();
            String sql = "CREATE TABLE IF NOT EXISTS jsonbuilder (id INTEGER PRIMARY KEY AUTOINCREMENT ,json_string_name TEXT ,json_interval TEXT, broker_ip_address TEXT ,broker_type TEXT , publish_topic_name TEXT ,publishing_status text ,store_n_forward text ,json_string TEXT )";
            statement.execute(sql);
            statement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            logger.debug("Error while creating Jsonbuilder table : " + e);
            FileBasedLogger.error("Application", "Error while creating Jsonbuilder table : " + e, "system");
        }
        finally {
            SQLiteConnector.closeConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JSONObject insertJSONBuilderData(JSONObject json2, String user) throws JSONException {
        JSONObject resultObj = new JSONObject();
        logger.info("JsonString---->" + json2);
        int attempt = 0;
        while (attempt < 5) {
            Connection connection;
            block9: {
                connection = null;
                try {
                    if (!json2.has("Data")) break block9;
                    JSONObject json = json2.getJSONObject("Data");
                    Object json_string = json.get("json_string");
                    connection = SQLiteConnector.getConnection();
                    String jsonStringName = json.getString("json_string_name");
                    String selectSql = "SELECT * FROM jsonbuilder WHERE json_string_name = ?";
                    PreparedStatement selectStatement = connection.prepareStatement(selectSql);
                    selectStatement.setString(1, JsonBuilder_operation.encrypt(jsonStringName));
                    ResultSet resultSet = selectStatement.executeQuery();
                    if (resultSet.next()) {
                        resultObj.put("status", "Fail");
                        resultObj.put("msg", "JSON String setting with the same JSON string name already exists. Please choose a different name.");
                        break block9;
                    }
                    String sql = "INSERT INTO jsonbuilder (json_string_name ,json_interval ,broker_ip_address,broker_type, publish_topic_name , publishing_status , store_n_forward , json_string ) VALUES (?, ?, ?, ?, ?, ?, ?,?)";
                    PreparedStatement statement = connection.prepareStatement(sql);
                    statement.setString(1, JsonBuilder_operation.encrypt(json.getString("json_string_name")));
                    statement.setString(2, JsonBuilder_operation.encrypt(json.getString("json_interval")));
                    statement.setString(3, JsonBuilder_operation.encrypt(json.getString("broker_ip_address")));
                    statement.setString(4, JsonBuilder_operation.encrypt(json.getString("broker_type")));
                    statement.setString(5, JsonBuilder_operation.encrypt(json.getString("publish_topic_name")));
                    statement.setString(6, JsonBuilder_operation.encrypt(json.getString("publishing_status")));
                    statement.setString(7, JsonBuilder_operation.encrypt(json.getString("store_n_forward")));
                    statement.setString(8, JsonBuilder_operation.encrypt(json_string.toString()));
                    statement.executeUpdate();
                    statement.close();
                    resultObj.put("status", "success");
                    resultObj.put("msg", " JSON String setting has been saved successfully.");
                    logger.info("JSON string setting has been saved successfully.");
                    FileBasedLogger.info("Audit", "JSON string setting has been saved successfully.", user);
                }
                catch (SQLException e) {
                    block10: {
                        try {
                            e.printStackTrace();
                            if (e.getErrorCode() == 5 && attempt != 4) break block10;
                            logger.error("Error occurred while save Jsonbuilder data : " + e);
                            FileBasedLogger.error("Audit", "Error occurred while save Jsonbuilder data : " + e, user);
                            resultObj.put("status", "Fail");
                            resultObj.put("msg", "Failed to save JSON String setting.");
                        }
                        catch (Throwable throwable) {
                            SQLiteConnector.closeConnection(connection);
                            throw throwable;
                        }
                        SQLiteConnector.closeConnection(connection);
                        return resultObj;
                    }
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (InterruptedException ie) {
                        Thread.currentThread().interrupt();
                    }
                    SQLiteConnector.closeConnection(connection);
                }
                SQLiteConnector.closeConnection(connection);
                return resultObj;
            }
            SQLiteConnector.closeConnection(connection);
            ++attempt;
        }
        return resultObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject updateJsonBuilderData(JSONObject json2, String user) throws JSONException {
        JSONObject resultObj = new JSONObject();
        for (int attempt = 0; attempt < 5; ++attempt) {
            Connection connection = null;
            try {
                connection = SQLiteConnector.getConnection();
                JSONObject json = json2.getJSONObject("Data");
                String json_string_name = json.getString("json_string_name");
                String json_interval = json.getString("json_interval");
                String broker_ip_address = json.getString("broker_ip_address");
                String broker_type = json.getString("broker_type");
                String publish_topic_name = json.getString("publish_topic_name");
                String publishing_status = json.getString("publishing_status");
                String store_n_forward = json.getString("store_n_forward");
                Object json_string = json.get("json_string");
                String sql = "UPDATE jsonbuilder SET json_interval = ?, broker_ip_address = ?,broker_type = ?, publish_topic_name = ?, publishing_status = ?, store_n_forward = ?, json_string = ? WHERE json_string_name = ?";
                PreparedStatement statement = connection.prepareStatement(sql);
                statement.setString(1, JsonBuilder_operation.encrypt(json_interval));
                statement.setString(2, JsonBuilder_operation.encrypt(broker_ip_address));
                statement.setString(3, JsonBuilder_operation.encrypt(broker_type));
                statement.setString(4, JsonBuilder_operation.encrypt(publish_topic_name));
                statement.setString(5, JsonBuilder_operation.encrypt(publishing_status));
                statement.setString(6, JsonBuilder_operation.encrypt(store_n_forward));
                statement.setString(7, JsonBuilder_operation.encrypt(json_string.toString()));
                statement.setString(8, JsonBuilder_operation.encrypt(json_string_name));
                int rowsAffected = statement.executeUpdate();
                statement.close();
                if (rowsAffected > 0) {
                    resultObj.put("status", "Success");
                    resultObj.put("msg", "JSON String setting updated successfully.");
                    logger.info("JSON String setting updated successfully.");
                    FileBasedLogger.info("Audit", "JSON String setting updated successfully.", user);
                    break;
                }
                resultObj.put("status", "Fail");
                resultObj.put("msg", "Failed to update JSON String setting. Please Check.");
                FileBasedLogger.info("Audit", "Failed to update JSON String setting. Please Check.", user);
                break;
            }
            catch (SQLException e) {
                e.printStackTrace();
                if (e.getErrorCode() != 5 || attempt == 4) {
                    logger.error("Error occurred While Updating JsonBuilder Data : " + e);
                    FileBasedLogger.error("Audit", "Error occurred While Updating JsonBuilder Data : " + e, user);
                    resultObj.put("status", "failed");
                    resultObj.put("msg", "Failed to update JSON String setting data. Please check.");
                    break;
                }
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
                continue;
            }
            finally {
                SQLiteConnector.closeConnection(connection);
            }
        }
        return resultObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject deleteJsonBuilderData(JSONObject json2, String user) throws JSONException {
        JSONObject resultObj = new JSONObject();
        Connection connection = null;
        try {
            connection = SQLiteConnector.getConnection();
            String prefixToDelete = json2.getString("json_string_name");
            String sql = "DELETE FROM jsonbuilder WHERE json_string_name = ?";
            PreparedStatement pstmt = connection.prepareStatement(sql);
            pstmt.setString(1, JsonBuilder_operation.encrypt(prefixToDelete));
            int rowsAffected = pstmt.executeUpdate();
            if (rowsAffected > 0) {
                resultObj.put("status", "success");
                resultObj.put("msg", "JSON String setting deleted successfully.");
                logger.info("Deleted JSON string settings successfully.");
                FileBasedLogger.info("Audit", "Deleted JSON string settings successfully.", user);
            } else {
                resultObj.put("status", "failed");
                resultObj.put("msg", "Failed to delete JSON String setting.");
                logger.info("Failed to delete JSON string setting.");
                FileBasedLogger.info("Audit", "Failed to delete JSON string setting.", user);
            }
            pstmt.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            logger.error("Error occurred While deleting JSON builder data : " + e);
            FileBasedLogger.error("Audit", "Error occurred While deleting JSON builder data : " + e, user);
            resultObj.put("status", "failed");
            resultObj.put("msg", "Failed to delete  JSON String setting.");
        }
        finally {
            SQLiteConnector.closeConnection(connection);
        }
        return resultObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject getAllJsonBuilderData(JSONObject json, String user) {
        JSONObject resultObj = new JSONObject();
        Connection connection = null;
        try {
            connection = SQLiteConnector.getConnection();
            String sql = "SELECT * FROM jsonbuilder";
            Statement statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery(sql);
            JSONArray jsonBuilderDataArray = new JSONArray();
            while (resultSet.next()) {
                JSONObject jsonData = new JSONObject();
                String json_string_name = resultSet.getString("json_string_name");
                jsonData.put("json_string_name", JsonBuilder_operation.decrypt(json_string_name));
                String json_interval = resultSet.getString("json_interval");
                jsonData.put("json_interval", Integer.parseInt(JsonBuilder_operation.decrypt(json_interval)));
                String broker_ip_address = resultSet.getString("broker_ip_address");
                jsonData.put("broker_ip_address", JsonBuilder_operation.decrypt(broker_ip_address));
                String broker_type = resultSet.getString("broker_type");
                jsonData.put("broker_type", JsonBuilder_operation.decrypt(broker_type));
                String publish_topic_name = resultSet.getString("publish_topic_name");
                jsonData.put("publish_topic_name", JsonBuilder_operation.decrypt(publish_topic_name));
                String publishing_status = resultSet.getString("publishing_status");
                jsonData.put("publishing_status", JsonBuilder_operation.decrypt(publishing_status));
                String store_n_forward = resultSet.getString("store_n_forward");
                jsonData.put("store_n_forward", JsonBuilder_operation.decrypt(store_n_forward));
                String json_string = resultSet.getString("json_string");
                jsonData.put("json_string", JsonBuilder_operation.decrypt(json_string));
                jsonBuilderDataArray.put(jsonData);
            }
            resultSet.close();
            statement.close();
            try {
                resultObj.put("status", "success");
                resultObj.put("msg", "Successfully fetched all JSON String setting.");
                resultObj.put("result", jsonBuilderDataArray);
                logger.info("All JSON string setting fetched successfully.");
                FileBasedLogger.info("Audit", "All JSON string setting fetched successfully.", user);
            }
            catch (JSONException e) {
                e.printStackTrace();
                logger.error("Error occurred While Fetching JSON Builder Data : " + e);
                FileBasedLogger.error("Audit", "Error occurred While Fetching JSON Builder Data : " + e, user);
            }
        }
        catch (SQLException | JSONException e) {
            e.printStackTrace();
            try {
                resultObj.put("status", "Fail");
                resultObj.put("msg", "Failed to fetch JSON String setting. ");
            }
            catch (JSONException e1) {
                e1.printStackTrace();
                FileBasedLogger.error("Audit", "Error occurred While Fetching JSON Builder Data : " + e, user);
            }
        }
        finally {
            SQLiteConnector.closeConnection(connection);
        }
        return resultObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject getBrokerIpDetailsFromMqtt(JSONObject json) throws JSONException {
        JSONObject resultObj = new JSONObject();
        Connection connection = null;
        try {
            connection = SQLiteConnector.getConnection();
            String sql = "SELECT broker_ip_address FROM mqtt";
            Statement statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery(sql);
            JSONArray brokerIpAddresses = new JSONArray();
            while (resultSet.next()) {
                String brokerIpAddress = resultSet.getString("broker_ip_address");
                brokerIpAddresses.put(JsonBuilder_operation.decrypt(brokerIpAddress));
            }
            resultSet.close();
            statement.close();
            resultObj.put("result", brokerIpAddresses);
            resultObj.put("status", "success");
            resultObj.put("msg", "Successfully fetched all broker Ip's.");
            logger.debug("All broker Ip's fetched successfully.");
        }
        catch (SQLException e) {
            e.printStackTrace();
            FileBasedLogger.error("Application", "Error occurred while fetching all broker Ip's : " + e, "system");
            logger.error("Error occurred while fetching all broker Ip's : " + e);
            resultObj.put("status", "Fail");
            resultObj.put("msg", "Failed to fetched all broker Ip's.");
        }
        finally {
            SQLiteConnector.closeConnection(connection);
        }
        return resultObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<JSONBuilder> getAllJsonBuilderData() {
        ArrayList<JSONBuilder> jsonBuilderDataList = new ArrayList<JSONBuilder>();
        for (int attempt = 0; attempt < 5; ++attempt) {
            Connection connection = null;
            try {
                connection = SQLiteConnector.getConnection();
                String sql = "SELECT * FROM jsonbuilder";
                Statement statement = connection.createStatement();
                ResultSet resultSet = statement.executeQuery(sql);
                while (resultSet.next()) {
                    JSONBuilder json = new JSONBuilder();
                    String json_string_name = resultSet.getString("json_string_name");
                    json.setJson_string_name(JsonBuilder_operation.decrypt(json_string_name));
                    String json_interval = resultSet.getString("json_interval");
                    json.setJson_interval(JsonBuilder_operation.decrypt(json_interval));
                    String broker_ip_address = resultSet.getString("broker_ip_address");
                    json.setBroker_ip_address(JsonBuilder_operation.decrypt(broker_ip_address));
                    String broker_type = resultSet.getString("broker_type");
                    json.setBroker_type(JsonBuilder_operation.decrypt(broker_type));
                    String publish_topic_name = resultSet.getString("publish_topic_name");
                    json.setPublish_topic_name(JsonBuilder_operation.decrypt(publish_topic_name));
                    String publishing_status = resultSet.getString("publishing_status");
                    json.setPublishing_status(JsonBuilder_operation.decrypt(publishing_status));
                    String store_n_forward = resultSet.getString("store_n_forward");
                    json.setStore_n_forward(JsonBuilder_operation.decrypt(store_n_forward));
                    String json_string = resultSet.getString("json_string");
                    json.setJson_string(JsonBuilder_operation.decrypt(json_string));
                    jsonBuilderDataList.add(json);
                }
                resultSet.close();
                statement.close();
                break;
            }
            catch (Exception e) {
                e.printStackTrace();
                if (((SQLException)e).getErrorCode() != 5 || attempt == 4) {
                    e.printStackTrace();
                    logger.error("Error while fetching JsonBuilder data : " + e);
                    FileBasedLogger.error("Application", "Error while fetching JsonBuilder data : " + e, "system");
                    break;
                }
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
                continue;
            }
            finally {
                SQLiteConnector.closeConnection(connection);
            }
        }
        return jsonBuilderDataList;
    }

    public JSONObject validateJsonString(JSONObject json) {
        JSONObject resultObj = new JSONObject();
        try {
            resultObj.put("status", "success");
            resultObj.put("msg", "Validation successful");
            resultObj.put("result", true);
            StringBuilder missingTagsMessage = new StringBuilder();
            if (json.has("json_string")) {
                String jsonString = json.getString("json_string");
                if (this.isJsonValid(jsonString)) {
                    Object jsonContent = this.parseJsonWithDuplicates(jsonString);
                    this.validateJsonContent(jsonContent, missingTagsMessage);
                    if (missingTagsMessage.length() > 0) {
                        resultObj.put("status", "fail");
                        resultObj.put("msg", "In STRATON, the following tags are not present: " + missingTagsMessage.toString() + ". Please correct them.");
                        resultObj.put("result", false);
                    }
                } else {
                    resultObj.put("status", "fail");
                    resultObj.put("msg", "The provided 'json_string' is not a valid JSON object or array.");
                    resultObj.put("result", false);
                }
            } else {
                resultObj.put("status", "fail");
                resultObj.put("msg", "'json_string' field is missing in the input JSON.");
                resultObj.put("result", false);
            }
        }
        catch (Exception e) {
            resultObj.put("status", "fail");
            resultObj.put("msg", "An error occurred during validation: " + e.getMessage());
            resultObj.put("result", false);
            FileBasedLogger.error("Application", "Error while validating json string: " + e.getLocalizedMessage(), "system");
            logger.error("Error while validating json string: " + e.getLocalizedMessage());
        }
        return resultObj;
    }

    private boolean isJsonValid(String jsonString) {
        try {
            new JSONObject(jsonString);
        }
        catch (JSONException ex) {
            try {
                new JSONArray(jsonString);
            }
            catch (JSONException ex1) {
                return false;
            }
        }
        return true;
    }

    private Object parseJsonWithDuplicates(String jsonString) throws JSONException {
        JSONTokener tokener = new JSONTokener(new StringReader(jsonString));
        Object jsonContent = tokener.nextValue();
        return jsonContent;
    }

    private void validateJsonContent(Object content, StringBuilder missingTagsMessage) {
        if (content instanceof JSONObject) {
            this.validateObject((JSONObject)content, missingTagsMessage);
        } else if (content instanceof JSONArray) {
            JSONArray jsonArray = (JSONArray)content;
            for (int i = 0; i < jsonArray.length(); ++i) {
                this.validateJsonContent(jsonArray.get(i), missingTagsMessage);
            }
        }
    }

    private void validateObject(JSONObject jsonObject, StringBuilder missingTagsMessage) {
        Iterator<String> keys = jsonObject.keys();
        while (keys.hasNext()) {
            String key = keys.next();
            Object value = jsonObject.get(key);
            if ("unit_id".equalsIgnoreCase(key) || "asset_id".equalsIgnoreCase(key) || "EQUIPID".equalsIgnoreCase(key) || "MSGTYP".equalsIgnoreCase(key) || "CUSTID".equalsIgnoreCase(key)) continue;
            if (value instanceof JSONObject || value instanceof JSONArray) {
                this.validateJsonContent(value, missingTagsMessage);
                continue;
            }
            if (Service.variableTagMap.containsKey(value.toString())) continue;
            if (missingTagsMessage.length() > 0) {
                missingTagsMessage.append(", ");
            }
            missingTagsMessage.append("'").append(value.toString()).append("'");
        }
    }
}

