/*
 * Decompiled with CFR 0.152.
 */
package com.tas.wp500.firmware;

import com.tas.wp500.fileLogSetting.FileBasedLogger;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class FirmwareUpdate {
    private static Logger logger = Logger.getLogger(FirmwareUpdate.class);
    private static FirmwareUpdate instance = null;
    private static final List<String> commandOutput = new ArrayList<String>();
    private static final String filePath = "/data/FirmwareStatus/firmware-update-log.txt";

    public static FirmwareUpdate getInstance() {
        if (instance == null) {
            instance = new FirmwareUpdate();
        }
        return instance;
    }

    public JSONObject executeFirmwareUpdate(JSONObject json, final String user) throws JSONException {
        final JSONObject resultObj = new JSONObject();
        try {
            commandOutput.clear();
            this.clearFirmwareLogFile();
            if (json.has("file_name")) {
                String fileName = json.getString("file_name");
                final String command = "fwupdate.sh /data/firmware-file/" + fileName;
                logger.info("Firmware file path is : " + command);
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            String line;
                            Process process = Runtime.getRuntime().exec(command);
                            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                            BufferedReader stdErrorReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                            boolean success = false;
                            StringBuilder outputBuilder = new StringBuilder();
                            StringBuilder errorBuilder = new StringBuilder();
                            while ((line = reader.readLine()) != null) {
                                outputBuilder.append(line).append("\n");
                                logger.debug("firmware update status : " + line);
                                commandOutput.add(line);
                                FirmwareUpdate.this.writeLineToFile(line);
                                if (line.contains("verify")) {
                                    FileBasedLogger.info("Audit", line, user);
                                }
                                if (!line.contains("SWUpdate was successful")) continue;
                                success = true;
                            }
                            while ((line = stdErrorReader.readLine()) != null) {
                                errorBuilder.append(line).append("\n");
                                commandOutput.add(line);
                                FirmwareUpdate.this.writeLineToFile(line);
                                FileBasedLogger.error("Audit", line, user);
                            }
                            int exitCode = process.waitFor();
                            if (exitCode == 0) {
                                if (success) {
                                    resultObj.put("status", "success");
                                    resultObj.put("msg", "Firmware update completed successfully.");
                                    logger.info("Firmware update completed successfully.");
                                    FileBasedLogger.info("Audit", "Firmware update completed successfully.", user);
                                } else {
                                    resultObj.put("status", "success");
                                    resultObj.put("msg", "Firmware updating is in progress. please wait.");
                                    FileBasedLogger.info("Audit", "Firmware updating is in progress. please wait.", user);
                                }
                            } else {
                                resultObj.put("status", "fail");
                                resultObj.put("msg", "Firmware update was failed.");
                                logger.info("Firmware update failed or success message not found.");
                                FileBasedLogger.info("Audit", "Firmware update failed or success message not found.", user);
                            }
                            resultObj.put("result", outputBuilder);
                        }
                        catch (IOException | InterruptedException | JSONException e) {
                            e.printStackTrace();
                            logger.error(" Error occurred while firmware update : " + e.getMessage());
                            FileBasedLogger.error("Audit", "Error occurred while firmware update : " + e.getMessage(), user);
                        }
                    }
                }).start();
                resultObj.put("status", "success");
                resultObj.put("msg", "Firmware updating is in progress. please wait.");
                FileBasedLogger.info("Audit", "Firmware updating is in progress. please wait.", user);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
            resultObj.put("status", "fail");
            resultObj.put("msg", "Firmware update failed. Please check your network connection and try again.");
            logger.error(" Error occurred while firmware update : " + e.getMessage());
            FileBasedLogger.error("Audit", "Error occurred while firmware update : " + e.getMessage(), user);
        }
        return resultObj;
    }

    public JSONObject getFirmwareStatus(String user) throws JSONException {
        JSONObject resultObj;
        block15: {
            resultObj = new JSONObject();
            JSONArray outputArray = new JSONArray();
            try {
                if (commandOutput == null || commandOutput.isEmpty()) {
                    File file = new File(filePath);
                    if (file.exists() && file.canRead()) {
                        logger.info("Reading firmware status from log file: " + file.getAbsolutePath());
                        try (BufferedReader reader = new BufferedReader(new FileReader(file));){
                            String line;
                            while ((line = reader.readLine()) != null) {
                                outputArray.put(line);
                            }
                        }
                        catch (IOException e) {
                            logger.error("Error reading log file: " + e.getMessage());
                            resultObj.put("status", "fail");
                            resultObj.put("msg", "Error reading firmware status from log file.");
                            FileBasedLogger.error("Audit", "Error reading firmware status from log file.", user);
                            return resultObj;
                        }
                        if (outputArray.length() > 0) {
                            resultObj.put("firmware_status", outputArray);
                            resultObj.put("status", "success");
                            resultObj.put("msg", "Successfully read firmware status from log file.");
                            logger.info("Successfully read firmware status from log file.");
                            FileBasedLogger.info("Audit", "Successfully read firmware status from log file.", user);
                        } else {
                            resultObj.put("status", "success");
                            resultObj.put("msg", "No firmware status available in log file.");
                            logger.info("No firmware status available in log file.");
                            FileBasedLogger.info("Audit", "No firmware status available in log file.", user);
                        }
                        break block15;
                    }
                    resultObj.put("status", "success");
                    resultObj.put("msg", "No firmware status available. Please try again later.");
                    logger.info("No firmware status available.");
                    FileBasedLogger.info("Audit", "No firmware status available.", user);
                    break block15;
                }
                outputArray = new JSONArray((Collection<?>)commandOutput);
                resultObj.put("firmware_status", outputArray);
                resultObj.put("status", "success");
                resultObj.put("msg", "Successfully read firmware status.");
                logger.info("Successfully read firmware status.");
                FileBasedLogger.info("Audit", "Successfully read firmware status.", user);
            }
            catch (JSONException e) {
                logger.error("Error processing firmware status: " + e.getMessage());
                resultObj.put("status", "fail");
                resultObj.put("msg", "Error processing firmware status.");
                FileBasedLogger.error("Audit", "Error processing firmware status.", user);
            }
        }
        return resultObj;
    }

    private synchronized void writeLineToFile(String line) {
        try {
            File file = new File(filePath);
            File parentDir = file.getParentFile();
            if (parentDir != null && !parentDir.exists()) {
                if (parentDir.mkdirs()) {
                    logger.info("Directory created at: " + parentDir.getAbsolutePath());
                } else {
                    logger.warn("Failed to create directory at: " + parentDir.getAbsolutePath());
                }
            }
            if (!file.exists()) {
                if (file.createNewFile()) {
                    logger.info("Log file created at: " + file.getAbsolutePath());
                } else {
                    logger.warn("Failed to create log file: " + file.getAbsolutePath());
                }
            }
            try (BufferedWriter writer = new BufferedWriter(new FileWriter(file, true));){
                writer.write(line);
                writer.newLine();
                logger.info("Added line to log file: " + line);
            }
        }
        catch (IOException e) {
            logger.error("Error while writing to log file: " + e.getMessage());
        }
    }

    private synchronized void clearFirmwareLogFile() {
        File logFile = new File(filePath);
        if (logFile.exists()) {
            if (logFile.delete()) {
                logger.info("Firmware log file cleared: /data/FirmwareStatus/firmware-update-log.txt");
            } else {
                logger.warn("Failed to clear firmware log file: /data/FirmwareStatus/firmware-update-log.txt");
            }
        } else {
            logger.info("Firmware log file does not exist, no need to clear.");
        }
    }
}

