/*
 * Decompiled with CFR 0.152.
 */
package com.tas.wp500.fileLogSetting;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class LogFileReader {
    private static Logger logger = Logger.getLogger(LogFileReader.class);
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final int PAGE_SIZE = 100;
    private static LogFileReader instance = null;
    private static String fileBasedLogPath = "/data/logs/";

    public static LogFileReader getInstance() {
        if (instance == null) {
            instance = new LogFileReader();
        }
        return instance;
    }

    public JSONArray readLogFile(String filePath, int pageNumber) throws IOException, JSONException {
        JSONArray records = new JSONArray();
        int startRecord = (pageNumber - 1) * 100;
        int endRecord = pageNumber * 100;
        ArrayList<String> allLines = new ArrayList<String>();
        try (BufferedReader reader = new BufferedReader(new FileReader(filePath));){
            String line;
            while ((line = reader.readLine()) != null) {
                allLines.add(line);
            }
        }
        int totalRecords = allLines.size();
        int startRecordReversed = Math.max(totalRecords - endRecord, 0);
        int endRecordReversed = Math.max(totalRecords - startRecord, 0);
        StringBuilder multiLineJson = new StringBuilder();
        boolean inMultiLineJson = false;
        for (int i = endRecordReversed - 1; i >= startRecordReversed && i >= 0; --i) {
            JSONObject json;
            String line = ((String)allLines.get(i)).trim();
            if (line.startsWith("{")) {
                if (inMultiLineJson) {
                    multiLineJson.append(line);
                } else {
                    multiLineJson = new StringBuilder(line);
                    inMultiLineJson = true;
                }
                if (!line.endsWith("}")) continue;
                try {
                    json = new JSONObject(multiLineJson.toString());
                    records.put(json);
                    multiLineJson.setLength(0);
                    inMultiLineJson = false;
                }
                catch (JSONException e) {
                    logger.warn("Skipping invalid multi-line JSON object: " + multiLineJson.toString(), e);
                    multiLineJson.setLength(0);
                    inMultiLineJson = false;
                }
                continue;
            }
            if (inMultiLineJson) {
                multiLineJson.append(line);
                if (!line.endsWith("}")) continue;
                try {
                    json = new JSONObject(multiLineJson.toString());
                    records.put(json);
                    multiLineJson.setLength(0);
                    inMultiLineJson = false;
                }
                catch (JSONException e) {
                    logger.warn("Skipping invalid multi-line JSON object: " + multiLineJson.toString(), e);
                    multiLineJson.setLength(0);
                    inMultiLineJson = false;
                }
                continue;
            }
            logger.warn("Skipping invalid line (not a JSON object): " + line);
        }
        return records;
    }

    public JSONArray readLogFileWithSearchKey(String filePath, int pageNumber, String searchKey) throws IOException, JSONException {
        JSONArray records = new JSONArray();
        ArrayList<JSONObject> allLogs = new ArrayList<JSONObject>();
        String searchLower = searchKey.toLowerCase();
        try (BufferedReader reader = new BufferedReader(new FileReader(filePath));){
            String line;
            StringBuilder jsonBuffer = new StringBuilder();
            boolean readingJson = false;
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).startsWith("{")) {
                    jsonBuffer.setLength(0);
                    jsonBuffer.append(line);
                    readingJson = true;
                    if (!line.endsWith("}")) continue;
                    readingJson = false;
                    this.processLogEntry(jsonBuffer.toString(), allLogs, searchLower);
                    continue;
                }
                if (!readingJson) continue;
                jsonBuffer.append(line);
                if (!line.endsWith("}")) continue;
                readingJson = false;
                this.processLogEntry(jsonBuffer.toString(), allLogs, searchLower);
            }
            if (readingJson) {
                this.processLogEntry(jsonBuffer.toString(), allLogs, searchLower);
            }
        }
        Collections.reverse(allLogs);
        int start = (pageNumber - 1) * 100;
        int end = Math.min(start + 100, allLogs.size());
        for (int i = start; i < end; ++i) {
            if (i < 0 || i >= allLogs.size()) continue;
            records.put(allLogs.get(i));
        }
        return records;
    }

    private void processLogEntry(String jsonString, List<JSONObject> allLogs, String searchLower) {
        try {
            JSONObject json = new JSONObject(jsonString);
            if (this.containsSearchKey(json, searchLower)) {
                allLogs.add(json);
            }
        }
        catch (JSONException e) {
            logger.warn("Skipping invalid JSON entry: " + jsonString, e);
        }
    }

    public JSONArray readLogFileByDateRange(String filePath, int pageNumber, String startDate, String endDate) throws IOException, JSONException, ParseException {
        JSONArray records = new JSONArray();
        ArrayList<JSONObject> matchingLogs = new ArrayList<JSONObject>();
        Date start = DATE_FORMAT.parse(startDate);
        Date end = DATE_FORMAT.parse(endDate);
        try (BufferedReader reader = new BufferedReader(new FileReader(filePath));){
            String line;
            StringBuilder jsonBuffer = new StringBuilder();
            boolean readingJson = false;
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).startsWith("{")) {
                    jsonBuffer.setLength(0);
                    jsonBuffer.append(line);
                    readingJson = true;
                    if (!line.endsWith("}")) continue;
                    readingJson = false;
                    this.processJsonLine(jsonBuffer.toString(), matchingLogs, start, end);
                    continue;
                }
                if (!readingJson) continue;
                jsonBuffer.append(line);
                if (!line.endsWith("}")) continue;
                readingJson = false;
                this.processJsonLine(jsonBuffer.toString(), matchingLogs, start, end);
            }
            if (readingJson) {
                this.processJsonLine(jsonBuffer.toString(), matchingLogs, start, end);
            }
        }
        Collections.reverse(matchingLogs);
        int startIdx = (pageNumber - 1) * 100;
        int endIdx = Math.min(startIdx + 100, matchingLogs.size());
        for (int i = startIdx; i < endIdx; ++i) {
            if (i < 0 || i >= matchingLogs.size()) continue;
            records.put(matchingLogs.get(i));
        }
        return records;
    }

    private void processJsonLine(String jsonString, List<JSONObject> matchingLogs, Date start, Date end) {
        try {
            Date logDate;
            JSONObject json = new JSONObject(jsonString);
            String timestamp = json.optString("timestamp");
            if (!(timestamp.isEmpty() || (logDate = DATE_FORMAT.parse(timestamp)).before(start) || logDate.after(end))) {
                matchingLogs.add(json);
            }
        }
        catch (ParseException | JSONException e) {
            logger.warn("Skipping invalid JSON entry: " + jsonString, e);
        }
    }

    public JSONArray readLogFileByDateRangeSearchKey(String filePath, int pageNumber, String startDate, String endDate, String searchKey) throws IOException, JSONException, ParseException {
        JSONArray records = new JSONArray();
        ArrayList<JSONObject> matchingLogs = new ArrayList<JSONObject>();
        Date start = DATE_FORMAT.parse(startDate);
        Date end = DATE_FORMAT.parse(endDate);
        try (BufferedReader reader = new BufferedReader(new FileReader(filePath));){
            String line;
            StringBuilder jsonBuffer = new StringBuilder();
            boolean readingJson = false;
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).startsWith("{")) {
                    jsonBuffer.setLength(0);
                    jsonBuffer.append(line);
                    readingJson = true;
                    if (!line.endsWith("}")) continue;
                    readingJson = false;
                    this.processJsonLine(jsonBuffer.toString(), matchingLogs, start, end, searchKey);
                    continue;
                }
                if (!readingJson) continue;
                jsonBuffer.append(line);
                if (!line.endsWith("}")) continue;
                readingJson = false;
                this.processJsonLine(jsonBuffer.toString(), matchingLogs, start, end, searchKey);
            }
            if (readingJson) {
                this.processJsonLine(jsonBuffer.toString(), matchingLogs, start, end, searchKey);
            }
        }
        Collections.reverse(matchingLogs);
        int startIdx = (pageNumber - 1) * 100;
        int endIdx = Math.min(startIdx + 100, matchingLogs.size());
        for (int i = startIdx; i < endIdx; ++i) {
            if (i < 0 || i >= matchingLogs.size()) continue;
            records.put(matchingLogs.get(i));
        }
        return records;
    }

    private void processJsonLine(String jsonString, List<JSONObject> matchingLogs, Date start, Date end, String searchKey) {
        try {
            JSONObject json = new JSONObject(jsonString);
            String timestamp = json.optString("timestamp");
            Date logDate = DATE_FORMAT.parse(timestamp);
            if (!logDate.before(start) && !logDate.after(end) && this.containsSearchKey(json, searchKey.toLowerCase())) {
                matchingLogs.add(json);
            }
        }
        catch (ParseException | JSONException e) {
            logger.warn("Skipping invalid JSON entry: " + jsonString, e);
        }
    }

    private int countTotalRecords(String filePath) throws IOException {
        int recordCount = 0;
        try (BufferedReader reader = new BufferedReader(new FileReader(filePath));){
            String line;
            StringBuilder jsonBuffer = new StringBuilder();
            boolean readingJson = false;
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).startsWith("{")) {
                    jsonBuffer.setLength(0);
                    jsonBuffer.append(line);
                    readingJson = true;
                    if (!line.endsWith("}")) continue;
                    readingJson = false;
                    ++recordCount;
                    continue;
                }
                if (!readingJson) continue;
                jsonBuffer.append(line);
                if (!line.endsWith("}")) continue;
                readingJson = false;
                if (!this.isValidJson(jsonBuffer.toString())) continue;
                ++recordCount;
            }
            if (readingJson) {
                logger.warn("Incomplete JSON at end of file: " + jsonBuffer.toString());
            }
        }
        return recordCount;
    }

    private boolean isValidJson(String jsonString) {
        try {
            new JSONObject(jsonString);
            return true;
        }
        catch (JSONException e) {
            logger.warn("Invalid JSON detected: " + jsonString);
            return false;
        }
    }

    public int countTotalRecordsByDateRange(String filePath, String startDate, String endDate) throws IOException, ParseException {
        int recordCount = 0;
        Date start = DATE_FORMAT.parse(startDate);
        Date end = DATE_FORMAT.parse(endDate);
        try (BufferedReader reader = new BufferedReader(new FileReader(filePath));){
            String line;
            StringBuilder jsonBuffer = new StringBuilder();
            boolean readingJson = false;
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).startsWith("{")) {
                    jsonBuffer.setLength(0);
                    jsonBuffer.append(line);
                    readingJson = true;
                    if (!line.endsWith("}")) continue;
                    readingJson = false;
                    if (!this.isValidEntry(jsonBuffer.toString(), start, end)) continue;
                    ++recordCount;
                    continue;
                }
                if (!readingJson) continue;
                jsonBuffer.append(line);
                if (!line.endsWith("}")) continue;
                readingJson = false;
                if (!this.isValidEntry(jsonBuffer.toString(), start, end)) continue;
                ++recordCount;
            }
            if (readingJson && this.isValidEntry(jsonBuffer.toString(), start, end)) {
                ++recordCount;
            }
        }
        return recordCount;
    }

    private boolean isValidEntry(String jsonString, Date start, Date end) {
        try {
            JSONObject json = new JSONObject(jsonString);
            String timestamp = json.optString("timestamp");
            if (timestamp.isEmpty()) {
                return false;
            }
            Date logDate = DATE_FORMAT.parse(timestamp);
            return !logDate.before(start) && !logDate.after(end);
        }
        catch (ParseException | JSONException e) {
            logger.warn("Skipping invalid entry: " + jsonString, e);
            return false;
        }
    }

    public int countTotalRecordsByDateRangeWithSearchKey(String filePath, String startDate, String endDate, String searchKey) throws IOException, JSONException, ParseException {
        int recordCount = 0;
        Date start = DATE_FORMAT.parse(startDate);
        Date end = DATE_FORMAT.parse(endDate);
        String searchLower = searchKey.toLowerCase();
        try (BufferedReader reader = new BufferedReader(new FileReader(filePath));){
            String line;
            StringBuilder jsonBuffer = new StringBuilder();
            boolean readingJson = false;
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).startsWith("{")) {
                    jsonBuffer.setLength(0);
                    jsonBuffer.append(line);
                    readingJson = true;
                    if (!line.endsWith("}")) continue;
                    readingJson = false;
                    if (!this.processEntry(jsonBuffer.toString(), start, end, searchLower)) continue;
                    ++recordCount;
                    continue;
                }
                if (!readingJson) continue;
                jsonBuffer.append(line);
                if (!line.endsWith("}")) continue;
                readingJson = false;
                if (!this.processEntry(jsonBuffer.toString(), start, end, searchLower)) continue;
                ++recordCount;
            }
            if (readingJson && this.processEntry(jsonBuffer.toString(), start, end, searchLower)) {
                ++recordCount;
            }
        }
        return recordCount;
    }

    private boolean processEntry(String jsonString, Date start, Date end, String searchLower) {
        try {
            JSONObject json = new JSONObject(jsonString);
            String timestamp = json.optString("timestamp");
            if (timestamp.isEmpty()) {
                return false;
            }
            Date logDate = DATE_FORMAT.parse(timestamp);
            if (logDate.before(start) || logDate.after(end)) {
                return false;
            }
            return this.containsSearchKey(json, searchLower);
        }
        catch (ParseException | JSONException e) {
            logger.warn("Skipping invalid JSON entry: " + jsonString, e);
            return false;
        }
    }

    private int countTotalRecordsWithSearchKey(String filePath, String searchKey) throws IOException {
        int recordCount = 0;
        String searchLower = searchKey.toLowerCase();
        try (BufferedReader reader = new BufferedReader(new FileReader(filePath));){
            String line;
            StringBuilder jsonBuffer = new StringBuilder();
            boolean readingJson = false;
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).startsWith("{")) {
                    jsonBuffer.setLength(0);
                    jsonBuffer.append(line);
                    readingJson = true;
                    if (!line.endsWith("}")) continue;
                    readingJson = false;
                    if (!this.isValidEntry(jsonBuffer.toString(), searchLower)) continue;
                    ++recordCount;
                    continue;
                }
                if (!readingJson) continue;
                jsonBuffer.append(line);
                if (!line.endsWith("}")) continue;
                readingJson = false;
                if (!this.isValidEntry(jsonBuffer.toString(), searchLower)) continue;
                ++recordCount;
            }
            if (readingJson && this.isValidEntry(jsonBuffer.toString(), searchLower)) {
                ++recordCount;
            }
        }
        return recordCount;
    }

    private boolean isValidEntry(String jsonString, String searchLower) {
        try {
            JSONObject json = new JSONObject(jsonString);
            return this.containsSearchKey(json, searchLower);
        }
        catch (JSONException e) {
            logger.warn("Skipping invalid JSON entry: " + jsonString);
            return false;
        }
    }

    public int getTotalPages(String filePath) throws IOException {
        int totalRecords = this.countTotalRecords(filePath);
        return (int)Math.ceil((double)totalRecords / 100.0);
    }

    public int getTotalPagesByDateRange(String filePath, String startDate, String endDate) throws IOException, JSONException, ParseException {
        int totalRecords = this.countTotalRecordsByDateRange(filePath, startDate, endDate);
        return (int)Math.ceil((double)totalRecords / 100.0);
    }

    public int getTotalPagesByDateRangeWithSearchKey(String filePath, String startDate, String endDate, String searchKey) throws IOException, JSONException, ParseException {
        int totalRecords = this.countTotalRecordsByDateRangeWithSearchKey(filePath, startDate, endDate, searchKey);
        return (int)Math.ceil((double)totalRecords / 100.0);
    }

    public int getTotalPagesWithSearchKey(String filePath, String searchKey) throws IOException {
        int totalRecords = this.countTotalRecordsWithSearchKey(filePath, searchKey);
        return (int)Math.ceil((double)totalRecords / 100.0);
    }

    public synchronized JSONObject readLogFileManger(JSONObject json) {
        JSONObject resultObj = new JSONObject();
        try {
            int page;
            if (json == null || !json.has("log_type") || !json.has("page_no")) {
                resultObj.put("error", "Invalid input. 'log_type' and 'page_no' are required fields.");
                logger.error("Invalid JSON input: " + json);
                return resultObj;
            }
            String logType = json.getString("log_type");
            String pageNo = json.getString("page_no");
            try {
                page = Integer.parseInt(pageNo);
            }
            catch (NumberFormatException e) {
                resultObj.put("error", "'page_no' must be a valid integer.");
                logger.error("Invalid 'page_no': " + pageNo, e);
                return resultObj;
            }
            String logPath = fileBasedLogPath + logType + ".log";
            if (json.has("start_date") && json.has("end_date") && json.has("search_key")) {
                String startDate = json.getString("start_date");
                String endDate = json.getString("end_date");
                String searchKey = json.getString("search_key").trim();
                JSONArray resultArray = this.readLogFileByDateRangeSearchKey(logPath, page, startDate, endDate, searchKey);
                resultObj.put("dataArray", resultArray);
                resultObj.put("pageCount", this.getTotalPagesByDateRangeWithSearchKey(logPath, startDate, endDate, searchKey));
            } else if (json.has("start_date") && json.has("end_date")) {
                String startDate = json.getString("start_date");
                String endDate = json.getString("end_date");
                JSONArray resultArray = this.readLogFileByDateRange(logPath, page, startDate, endDate);
                resultObj.put("dataArray", resultArray);
                resultObj.put("pageCount", this.getTotalPagesByDateRange(logPath, startDate, endDate));
            } else if (json.has("search_key")) {
                String searchKey = json.getString("search_key").trim();
                JSONArray resultArray = this.readLogFileWithSearchKey(logPath, page, searchKey);
                resultObj.put("dataArray", resultArray);
                resultObj.put("pageCount", this.getTotalPagesWithSearchKey(logPath, searchKey));
            } else {
                JSONArray resultArray = this.readLogFile(logPath, page);
                resultObj.put("dataArray", resultArray);
                resultObj.put("pageCount", this.getTotalPages(logPath));
            }
        }
        catch (Exception e) {
            logger.error("Error while reading file-based log: " + e.getMessage(), e);
            resultObj.put("error", "Internal server error while processing request. Please check logs.");
        }
        return resultObj;
    }

    private boolean containsSearchKey1(JSONObject json, String searchKey) {
        String search = searchKey.toLowerCase();
        return json.optString("message", "").toLowerCase().contains(search) || json.optString("user", "").toLowerCase().contains(search) || json.optString("level", "").toLowerCase().contains(search);
    }

    private boolean containsSearchKey(JSONObject json, String searchKey) {
        if (searchKey == null || searchKey.isEmpty()) {
            return false;
        }
        String search = searchKey.toLowerCase(Locale.ROOT);
        return this.getJsonFieldValue(json, "message").contains(search) || this.getJsonFieldValue(json, "user").contains(search) || this.getJsonFieldValue(json, "level").contains(search);
    }

    private String getJsonFieldValue(JSONObject json, String key) {
        try {
            Object value = json.get(key);
            if (value == null) {
                return "";
            }
            return value.toString().toLowerCase(Locale.ROOT);
        }
        catch (JSONException e) {
            return "";
        }
    }
}

