/*
 * Decompiled with CFR 0.152.
 */
package com.tas.wp500.fileLogSetting;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import org.json.JSONException;
import org.json.JSONObject;

public class LogEntry {
    private String component;
    private String level;
    private String message;
    private String user;
    private String timestamp;
    private String packageName;
    private String className;
    private int lineNumber;

    public LogEntry(String component, String level, String message, String user, StackTraceElement callerInfo) {
        this.component = component;
        this.level = level;
        this.message = message;
        this.user = user;
        this.timestamp = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        if (callerInfo != null) {
            this.packageName = this.getPackageName(callerInfo.getClassName());
            this.className = this.getClassName(callerInfo.getClassName());
            this.lineNumber = callerInfo.getLineNumber();
        } else {
            this.packageName = "unknown";
            this.className = "unknown";
            this.lineNumber = -1;
        }
    }

    private String getPackageName(String fullClassName) {
        int lastDotIndex = fullClassName.lastIndexOf(46);
        return lastDotIndex != -1 ? fullClassName.substring(0, lastDotIndex) : "default";
    }

    private String getClassName(String fullClassName) {
        int lastDotIndex = fullClassName.lastIndexOf(46);
        return lastDotIndex != -1 ? fullClassName.substring(lastDotIndex + 1) : fullClassName;
    }

    public JSONObject toJson() {
        JSONObject json = new JSONObject();
        try {
            json.put("timestamp", this.timestamp);
            json.put("level", this.level);
            json.put("message", this.message);
            json.put("user", this.user);
            json.put("packageName", this.packageName);
            json.put("className", this.className);
            json.put("lineNumber", this.lineNumber);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return json;
    }

    public String getComponent() {
        return this.component;
    }

    public String getLevel() {
        return this.level.toLowerCase();
    }
}

