/*
 * Decompiled with CFR 0.152.
 */
package com.tas.wp500.fileLogSetting;

import com.tas.wp500.fileLogSetting.LogEntry;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class FileBasedLogger {
    private static final String LOG_DIR = "/data/logs";
    private static final int QUEUE_CAPACITY = 10000;
    private static final BlockingQueue<LogEntry> logQueue = new LinkedBlockingQueue<LogEntry>(10000);
    private static final ExecutorService logExecutor = Executors.newSingleThreadExecutor();
    private static final long MAX_FILE_SIZE_MB = 10L;
    private static final int LINES_TO_REMOVE = 50;
    private static Logger logger = Logger.getLogger(FileBasedLogger.class);

    private static void initializeLogDirectory() {
        boolean created;
        File logDir = new File(LOG_DIR);
        if (!logDir.exists() && !(created = logDir.mkdirs())) {
            logger.error("Failed to create log directory: /data/logs");
        }
    }

    public static void writeLogToFile(LogEntry logEntry) {
        String fileName = String.format("%s/%s.log", LOG_DIR, logEntry.getComponent());
        File logFile = new File(fileName);
        if (logFile.exists() && logFile.length() >= 0xA00000L) {
            logger.info("Log file '" + logFile.getName() + "' has reached the maximum size of " + 10L + " MB. Initiating trimming process...");
            FileBasedLogger.info("Application", "Log file '" + logFile.getName() + "' has reached the maximum size of " + 10L + " MB. Initiating trimming process...", "system");
            FileBasedLogger.trimLogFile(logFile, 50);
            logger.info("Trimming process completed for log file '" + logFile.getName() + "'. " + 50 + " old lines removed successfully.");
            FileBasedLogger.info("Application", "Trimming process completed for log file '" + logFile.getName() + "'. " + 50 + " old lines removed successfully.", "system");
        } else {
            logger.debug("Log file '" + logFile.getName() + "' is within the size limit (" + logFile.length() + " bytes). No trimming required.");
        }
        try (FileWriter fileWriter = new FileWriter(logFile, true);
             PrintWriter printWriter = new PrintWriter(fileWriter);){
            printWriter.println(logEntry.toJson().toString());
        }
        catch (IOException e) {
            System.err.println("Error writing log to file: " + e.getMessage());
            logger.error("Error writing log to file: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private static void log(String component, String level, String message, String user) {
        StackTraceElement callerInfo = Thread.currentThread().getStackTrace()[3];
        LogEntry logEntry = new LogEntry(component, level, message, user, callerInfo);
        boolean offered = logQueue.offer(logEntry);
        if (!offered) {
            System.err.println("Log queue is full. Dropping log entry: " + logEntry.toJson().toString());
        }
    }

    public static void info(String component, String message, String user) {
        FileBasedLogger.log(component, "INFO", message, user);
    }

    public static void warn(String component, String message, String user) {
        FileBasedLogger.log(component, "WARN", message, user);
    }

    public static void debug(String component, String message, String user) {
        FileBasedLogger.log(component, "DEBUG", message, user);
    }

    public static void error(String component, String message, String user) {
        FileBasedLogger.log(component, "ERROR", message, user);
    }

    public static void shutdown() {
        logExecutor.shutdown();
        try {
            if (!logExecutor.awaitTermination(5L, TimeUnit.SECONDS)) {
                logExecutor.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            logExecutor.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void trimLogFile(File logFile, int linesToRemove) {
        File tempFile = new File(logFile.getParent(), logFile.getName() + ".tmp");
        boolean renamingSuccessful = false;
        try (BufferedReader reader = new BufferedReader(new FileReader(logFile));
             BufferedWriter writer = new BufferedWriter(new FileWriter(tempFile));){
            String line;
            for (int linesSkipped = 0; (line = reader.readLine()) != null && linesSkipped < linesToRemove; ++linesSkipped) {
            }
            while ((line = reader.readLine()) != null) {
                writer.write(line);
                writer.newLine();
            }
            if (!logFile.delete()) {
                throw new IOException("Failed to delete original log file.");
            }
            if (!tempFile.renameTo(logFile)) {
                throw new IOException("Failed to rename temp file to original log file.");
            }
            renamingSuccessful = true;
        }
        catch (IOException e) {
            logger.error("Error occurred during log file trimming: " + e.getMessage());
            e.printStackTrace();
            if (tempFile.exists() && !tempFile.delete()) {
                logger.error("Failed to delete temporary file after error.");
            }
            if (!renamingSuccessful) {
                logger.error("Recovery attempt: Keeping the original file as-is.");
            }
        }
        finally {
            if (!tempFile.exists() && logFile.exists()) {
                logger.info("Log file size reduced successfully");
                FileBasedLogger.info("Application", "Log file size reduced successfully", "system");
            } else if (tempFile.exists() && !tempFile.delete()) {
                logger.error("Failed to delete temporary file during final cleanup.");
            }
        }
    }

    static {
        FileBasedLogger.initializeLogDirectory();
        logExecutor.execute(() -> {
            while (true) {
                try {
                    while (true) {
                        LogEntry logEntry = logQueue.take();
                        FileBasedLogger.writeLogToFile(logEntry);
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    logger.error("Failed to write log entry: " + e.getMessage());
                    continue;
                }
                break;
            }
        });
    }
}

