/*
 * Decompiled with CFR 0.152.
 */
package com.tas.wp500.fileHashSettings;

import com.tas.wp500.fileHashSettings.FileIntegrityTask;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class FileIntegrityScheduler {
    private static Logger logger = Logger.getLogger(FileIntegrityTask.class);
    private final ScheduledExecutorService serviceTask = Executors.newSingleThreadScheduledExecutor();

    public FileIntegrityScheduler() {
        logger.info("FileIntegrityScheduler initialized.");
    }

    public void startFileIntegrityTask() {
        FileIntegrityTask task = new FileIntegrityTask();
        this.serviceTask.scheduleAtFixedRate(task, 0L, 20L, TimeUnit.MINUTES);
    }

    public void shutdown() {
        logger.info("Shutting down FileIntegrityScheduler...");
        this.serviceTask.shutdown();
        try {
            if (!this.serviceTask.awaitTermination(5L, TimeUnit.SECONDS)) {
                logger.warn("FileIntegrityScheduler did not terminate within the specified time. Forcing shutdown...");
                this.serviceTask.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            logger.error("Shutdown interrupted: " + e.getMessage());
            Thread.currentThread().interrupt();
        }
        logger.info("FileIntegrityScheduler shut down successfully.");
    }
}

