/*
 * Decompiled with CFR 0.152.
 */
package com.tas.wp500.fileHashSettings;

import com.tas.wp500.fileLogSetting.FileBasedLogger;
import com.tas.wp500.sql_lite_db.FileIntegrityAndSnortDBConnector;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class FileIntegrityMonitorOperation {
    private static Logger logger = Logger.getLogger(FileIntegrityMonitorOperation.class);
    private static FileIntegrityMonitorOperation instance = null;
    private static final String DIRECTORYPATH = "/media/rfs/rw/upperdir/";
    private static final List<String> SKIP_PATHS = new ArrayList<String>();
    private static final int SQLITE_BUSY = 5;
    private static final int RETRY_COUNT = 10;
    private static final int RETRY_DELAY = 10000;
    private static JSONObject lastReport = null;

    private FileIntegrityMonitorOperation() {
        this.createTableIfNotExists();
        this.createTableFileAcknowledge();
        this.saveFileChecksumsToDB("system");
    }

    public static FileIntegrityMonitorOperation getInstance() {
        if (instance == null) {
            instance = new FileIntegrityMonitorOperation();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createTableIfNotExists() {
        Connection connection = FileIntegrityAndSnortDBConnector.getConnection();
        try (Statement statement = connection.createStatement();){
            String sql = "CREATE TABLE IF NOT EXISTS file_integrity (filename TEXT PRIMARY KEY, hash TEXT, permissions TEXT)";
            statement.execute(sql);
        }
        catch (SQLException e) {
            logger.debug("Error while creating file integrity table : " + e);
            FileBasedLogger.error("Security", "Error while creating file integrity table : " + e, "system");
        }
        finally {
            FileIntegrityAndSnortDBConnector.closeConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createTableFileAcknowledge() {
        Connection connection = FileIntegrityAndSnortDBConnector.getConnection();
        try (Statement statement = connection.createStatement();){
            String sql = "CREATE TABLE IF NOT EXISTS file_acknowledge (filename TEXT PRIMARY KEY, hash TEXT, permissions TEXT)";
            statement.execute(sql);
        }
        catch (SQLException e) {
            logger.debug("Error while creating file acknowledge table : " + e);
            FileBasedLogger.error("Security", "Error while creating file acknowledge table : " + e, "system");
        }
        finally {
            FileIntegrityAndSnortDBConnector.closeConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject saveFileChecksumsToDB(final String user) {
        JSONObject resultObj = new JSONObject();
        for (int attempt = 0; attempt < 10; ++attempt) {
            Connection connection = FileIntegrityAndSnortDBConnector.getConnection();
            try {
                connection.setAutoCommit(false);
                String sql = "INSERT OR REPLACE INTO file_integrity (filename, hash, permissions) VALUES (?, ?, ?)";
                try (final PreparedStatement pstmt = connection.prepareStatement(sql);){
                    final ExecutorService executor = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
                    try {
                        Files.walkFileTree(Paths.get(DIRECTORYPATH, new String[0]), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                            @Override
                            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                                executor.submit(() -> {
                                    try {
                                        String filename = file.toString();
                                        String checksum = FileIntegrityMonitorOperation.generateChecksum(filename);
                                        String permissionsStr = FileIntegrityMonitorOperation.getFilePermissions(filename);
                                        if (checksum != null && permissionsStr != null) {
                                            pstmt.setString(1, filename);
                                            pstmt.setString(2, checksum);
                                            pstmt.setString(3, permissionsStr);
                                            pstmt.executeUpdate();
                                        }
                                    }
                                    catch (IOException | SQLException e) {
                                        logger.error("Error processing file: " + file + " - " + e.getMessage());
                                        FileBasedLogger.error("Security", "Error while processing file Integrity : " + file + " - " + e.getMessage(), user);
                                    }
                                });
                                return FileVisitResult.CONTINUE;
                            }
                        });
                    }
                    finally {
                        executor.shutdown();
                        executor.awaitTermination(Long.MAX_VALUE, TimeUnit.NANOSECONDS);
                    }
                }
                connection.commit();
                logger.debug("File checksums saved to database successfully.");
                resultObj.put("status", "success");
                resultObj.put("msg", "File integrity save completed successfully.");
                break;
            }
            catch (IOException | InterruptedException | SQLException e) {
                if (((SQLException)e).getErrorCode() != 5 || attempt == 9) {
                    logger.error("Error occurred while saving hash into to db: " + e.getMessage());
                    FileBasedLogger.error("Security", "Error occurred while saving hash into to db: " + e.getMessage(), user);
                    resultObj.put("status", "fail");
                    resultObj.put("msg", "Error occurred while saving file integrity.");
                    break;
                }
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
                continue;
            }
            finally {
                FileIntegrityAndSnortDBConnector.closeConnection(connection);
            }
        }
        return resultObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject checkFileIntegrity(String user) {
        JSONObject resultObj = new JSONObject();
        final JSONArray newFileArray = new JSONArray();
        final JSONArray fileModifyArray = new JSONArray();
        final JSONArray filePermissionArray = new JSONArray();
        JSONArray fileDeleteArray = new JSONArray();
        for (int attempt = 0; attempt < 10; ++attempt) {
            final Connection connection = FileIntegrityAndSnortDBConnector.getConnection();
            try {
                final HashSet encounteredFiles = new HashSet();
                List<String> dbFiles = this.getFilesFromDB(connection);
                final List<String> acknowledgeFileList = this.getfileAcknowledgeFromDB(connection);
                final ExecutorService executor = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
                try {
                    Files.walkFileTree(Paths.get(DIRECTORYPATH, new String[0]), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                        @Override
                        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                            executor.submit(() -> {
                                try {
                                    String filename = file.toString();
                                    String checksum = FileIntegrityMonitorOperation.generateChecksum(filename);
                                    String storedChecksum = FileIntegrityMonitorOperation.this.getFileChecksumFromDB(filename, connection);
                                    String storedPermissions = FileIntegrityMonitorOperation.this.getFilePermissionsFromDB(filename, connection);
                                    if (storedChecksum == null) {
                                        if (acknowledgeFileList.contains(filename)) {
                                            FileIntegrityMonitorOperation.this.removeFileFromAcknowledgment(filename, connection);
                                        }
                                        newFileArray.put(filename);
                                    } else if (!checksum.contains(storedChecksum)) {
                                        if (acknowledgeFileList.contains(filename)) {
                                            FileIntegrityMonitorOperation.this.removeFileFromAcknowledgment(filename, connection);
                                        }
                                        fileModifyArray.put(filename);
                                    }
                                    String currentPermissions = FileIntegrityMonitorOperation.getFilePermissions(filename);
                                    if (storedPermissions != null && currentPermissions != null && !storedPermissions.equals(currentPermissions)) {
                                        if (acknowledgeFileList.contains(filename)) {
                                            FileIntegrityMonitorOperation.this.removeFileFromAcknowledgment(filename, connection);
                                        }
                                        filePermissionArray.put(filename);
                                    }
                                    encounteredFiles.add(filename);
                                }
                                catch (IOException | SQLException e) {
                                    e.printStackTrace();
                                }
                            });
                            return FileVisitResult.CONTINUE;
                        }
                    });
                }
                catch (IOException e) {
                    e.printStackTrace();
                    logger.debug("Error walking through files: " + e.getMessage());
                    FileBasedLogger.error("Security", "Error occurred while checking file integrity : " + e.getMessage(), user);
                    resultObj.put("status", "fail");
                    resultObj.put("msg", "Error occurred while checking file integrity.");
                }
                finally {
                    try {
                        executor.shutdown();
                        executor.awaitTermination(Long.MAX_VALUE, TimeUnit.NANOSECONDS);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                        FileBasedLogger.error("Security", "Error occurred while checking file integrity : " + e.getMessage(), user);
                        logger.debug("Interrupted while awaiting executor termination: " + e.getMessage());
                        resultObj.put("status", "fail");
                        resultObj.put("msg", "Error occurred while checking file integrity.");
                    }
                }
                for (String filename : dbFiles) {
                    boolean found = false;
                    for (String encounteredFileName : encounteredFiles) {
                        if (!filename.equals(encounteredFileName)) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    fileDeleteArray.put(filename);
                }
                resultObj.put("total_file_count", encounteredFiles.size());
                resultObj.put("new_file", newFileArray);
                resultObj.put("file_modified", fileModifyArray);
                resultObj.put("permission_modified", filePermissionArray);
                resultObj.put("file_deleted", fileDeleteArray);
                resultObj.put("count_deleted_file", fileDeleteArray.length());
                resultObj.put("count_modified_file", fileModifyArray.length());
                resultObj.put("count_new_file", newFileArray.length());
                resultObj.put("count_permission_file", filePermissionArray.length());
                resultObj.put("status", "success");
                resultObj.put("msg", "File integrity check completed successfully.");
                break;
            }
            catch (SQLException e1) {
                e1.printStackTrace();
                if (e1.getErrorCode() != 5 || attempt == 9) {
                    logger.debug("SQL Error: " + e1.getMessage());
                    FileBasedLogger.error("Security", "Error occurred while checking file integrity : " + e1.getMessage(), user);
                    resultObj.put("status", "fail");
                    resultObj.put("msg", "Error occurred while checking file integrity.");
                    break;
                }
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
                continue;
            }
            finally {
                FileIntegrityAndSnortDBConnector.closeConnection(connection);
            }
        }
        this.logFileIntegrityReport(resultObj, user);
        lastReport = new JSONObject(resultObj.toString());
        return resultObj;
    }

    public static String getFilePermissions(String filename) throws IOException {
        String command = "ls -l " + filename;
        Process process = Runtime.getRuntime().exec(command);
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
            String line;
            while ((line = reader.readLine()) != null) {
                String[] parts;
                if (line.startsWith("-")) {
                    parts = line.split("\\s+");
                    if (parts.length < 1) continue;
                    String string = parts[0].substring(1);
                    return string;
                }
                parts = line.split("\\s+");
                if (parts.length < 1) continue;
                String string = parts[0].substring(1);
                return string;
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getFilePermissionsFromDB(String filename, Connection connection) {
        String sql = "SELECT permissions FROM file_integrity WHERE filename = ?";
        try (PreparedStatement pstmt = connection.prepareStatement(sql);){
            pstmt.setString(1, filename);
            try (ResultSet rs = pstmt.executeQuery();){
                if (!rs.next()) return null;
                String string = rs.getString("permissions");
                return string;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            FileBasedLogger.error("Security", "Error while getting file permission from db :" + e.getMessage(), "system");
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getFileChecksumFromDB(String filename, Connection connection) {
        String sql = "SELECT hash FROM file_integrity WHERE filename = ?";
        try (PreparedStatement pstmt = connection.prepareStatement(sql);){
            pstmt.setString(1, filename);
            try (ResultSet rs = pstmt.executeQuery();){
                if (!rs.next()) return null;
                String string = rs.getString("hash");
                return string;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            FileBasedLogger.error("Security", "Error while getting file checksum from db :" + e.getMessage(), "system");
        }
        return null;
    }

    private List<String> getFilesFromDB(Connection connection) throws SQLException {
        ArrayList<String> filenames = new ArrayList<String>();
        String sql = "SELECT filename FROM file_integrity";
        try (Statement stmt = connection.createStatement();
             ResultSet rs = stmt.executeQuery(sql);){
            while (rs.next()) {
                filenames.add(rs.getString("filename"));
            }
        }
        return filenames;
    }

    private List<String> getfileAcknowledgeFromDB(Connection connection) throws SQLException {
        ArrayList<String> filenames = new ArrayList<String>();
        String sql = "SELECT filename FROM file_acknowledge";
        try (Statement stmt = connection.createStatement();
             ResultSet rs = stmt.executeQuery(sql);){
            while (rs.next()) {
                filenames.add(rs.getString("filename"));
            }
        }
        return filenames;
    }

    public static String generateChecksum(String filePath) {
        if (SKIP_PATHS.contains(filePath)) {
            return null;
        }
        try {
            String output;
            String[] parts;
            String line;
            ProcessBuilder pb = new ProcessBuilder("sha1sum", filePath);
            pb.redirectErrorStream(true);
            Process process = pb.start();
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            StringBuilder checksumStringBuilder = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                checksumStringBuilder.append(line);
            }
            int exitCode = process.waitFor();
            if (exitCode != 0) {
                logger.debug("Calculating checksum for file: " + filePath);
                logger.debug("Error calculating checksum. Exit code: " + exitCode);
            }
            if ((parts = (output = checksumStringBuilder.toString()).split("\\s+")).length >= 1) {
                String checksum = parts[0];
                return checksum;
            }
            logger.error("Invalid output format: " + output);
        }
        catch (IOException | InterruptedException e) {
            logger.error("Error calculating checksum: " + e.getMessage(), e);
            FileBasedLogger.error("Security", "Error while calculating file checksum: " + e.getMessage(), "system");
            return null;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject fileAcknowledge(JSONObject json, String user) {
        JSONObject resultObj = new JSONObject();
        for (int attempt = 0; attempt < 10; ++attempt) {
            Connection connection = FileIntegrityAndSnortDBConnector.getConnection();
            PreparedStatement pstmtFileAcknowledge = null;
            PreparedStatement pstmtFileIntegrity = null;
            try {
                String sqlFileAcknowledge = "INSERT OR REPLACE INTO file_acknowledge (filename, hash, permissions) VALUES (?, ?, ?)";
                String sqlFileIntegrity = "INSERT OR REPLACE INTO file_integrity (filename, hash, permissions) VALUES (?, ?, ?)";
                pstmtFileAcknowledge = connection.prepareStatement(sqlFileAcknowledge);
                pstmtFileIntegrity = connection.prepareStatement(sqlFileIntegrity);
                try {
                    String filename = json.getString("file_name");
                    String checksum = FileIntegrityMonitorOperation.generateChecksum(filename);
                    String permissionsStr = FileIntegrityMonitorOperation.getFilePermissions(filename.toString());
                    pstmtFileAcknowledge.setString(1, filename);
                    pstmtFileAcknowledge.setString(2, checksum);
                    pstmtFileAcknowledge.setString(3, permissionsStr);
                    pstmtFileAcknowledge.executeUpdate();
                    pstmtFileIntegrity.setString(1, filename);
                    pstmtFileIntegrity.setString(2, checksum);
                    pstmtFileIntegrity.setString(3, permissionsStr);
                    pstmtFileIntegrity.executeUpdate();
                    resultObj.put("status", "success");
                    resultObj.put("msg", "file acknowledgment done.");
                    logger.info("Acknowledgment completed for file: " + filename);
                    FileBasedLogger.info("Security", "Acknowledgment completed for file: " + filename, user);
                    break;
                }
                catch (IOException | JSONException e) {
                    try {
                        logger.error("Error occurred during file acknowledgment process." + e.getLocalizedMessage());
                        FileBasedLogger.error("Security", "Error occurred during file acknowledgment process : " + e.getMessage(), user);
                        resultObj.put("status", "success");
                        resultObj.put("msg", "Error occurred during file acknowledgment process.");
                    }
                    catch (SQLException e2) {
                        block12: {
                            if (e2.getErrorCode() == 5 && attempt != 9) break block12;
                            logger.error("Error occurred during file acknowledgment process." + e2.getMessage());
                            FileBasedLogger.error("Security", "Error occurred during file acknowledgment process : " + e2.getMessage(), user);
                            resultObj.put("status", "success");
                            resultObj.put("msg", "Error occurred during file acknowledgment process.");
                            break;
                        }
                        try {
                            Thread.sleep(10000L);
                        }
                        catch (InterruptedException ie) {
                            Thread.currentThread().interrupt();
                        }
                        continue;
                    }
                    FileIntegrityAndSnortDBConnector.closeConnection(connection);
                    continue;
                }
            }
            finally {
                FileIntegrityAndSnortDBConnector.closeConnection(connection);
            }
        }
        return resultObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject getFileAcknowledgeList(String user) {
        JSONObject resultObj = new JSONObject();
        try {
            Thread.sleep(30000L);
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
        }
        for (int attempt = 0; attempt < 10; ++attempt) {
            Connection connection = FileIntegrityAndSnortDBConnector.getConnection();
            try {
                JSONArray resultArray = new JSONArray();
                String sql = "SELECT filename FROM file_acknowledge";
                try (Statement stmt = connection.createStatement();
                     ResultSet rs = stmt.executeQuery(sql);){
                    while (rs.next()) {
                        resultArray.put(rs.getString("filename"));
                    }
                }
                if (resultArray.isEmpty()) {
                    resultObj.put("file_acknowledge_list", new JSONArray());
                    resultObj.put("status", "success");
                    resultObj.put("msg", "file acknowledge list is empty.");
                } else {
                    resultObj.put("file_acknowledge_list", resultArray);
                    resultObj.put("status", "success");
                    resultObj.put("msg", "file acknowledge list fetch successfully.");
                }
                logger.info("file acknowledge list fetch successfully.");
                FileBasedLogger.info("Security", "File acknowledge list fetch successfully.", user);
                break;
            }
            catch (SQLException e) {
                if (e.getErrorCode() != 5 || attempt == 9) {
                    logger.error("Error while fetching file acknowledge list. : " + e);
                    FileBasedLogger.error("Security", "Error while fetching file acknowledge list : " + e, user);
                    break;
                }
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
                continue;
            }
            finally {
                FileIntegrityAndSnortDBConnector.closeConnection(connection);
            }
        }
        return resultObj;
    }

    private void removeFileFromAcknowledgment(String filename, Connection connection) throws SQLException {
        if (filename == null || filename.trim().isEmpty()) {
            logger.warn("Filename is null or empty. Skipping acknowledgment removal.");
            return;
        }
        String sql = "DELETE FROM file_acknowledge WHERE filename = ?";
        try (PreparedStatement pstmt = connection.prepareStatement(sql);){
            pstmt.setString(1, filename);
            int rowsAffected = pstmt.executeUpdate();
            if (rowsAffected > 0) {
                logger.info("Acknowledgment file removed successfully: " + filename);
            } else {
                logger.warn("Acknowledgment file not found in database: " + filename);
            }
        }
        catch (SQLException e) {
            logger.error("Error removing acknowledgment for file: " + filename, e);
            throw e;
        }
    }

    private void logFileIntegrityReport(JSONObject currentReport, String user) {
        if (lastReport == null) {
            String message = "File Integrity Check Report: This is the first time the system has checked for changes. Summary of the current file status: New files: " + currentReport.getInt("count_new_file") + ", Modified files: " + currentReport.getInt("count_modified_file") + ", Files with changed permissions: " + currentReport.getInt("count_permission_file") + ", Deleted files: " + currentReport.getInt("count_deleted_file") + ", Total files processed: " + currentReport.getInt("total_file_count") + ".";
            logger.info(message);
            FileBasedLogger.info("Security", message, user);
        } else {
            StringBuilder message = new StringBuilder("File Integrity Check Report: Here's the latest update since the last check:\n");
            int newFilesDelta = currentReport.getInt("count_new_file") - lastReport.getInt("count_new_file");
            int modifiedFilesDelta = currentReport.getInt("count_modified_file") - lastReport.getInt("count_modified_file");
            int permissionModifiedDelta = currentReport.getInt("count_permission_file") - lastReport.getInt("count_permission_file");
            int deletedFilesDelta = currentReport.getInt("count_deleted_file") - lastReport.getInt("count_deleted_file");
            message.append("New files added: ").append(currentReport.getInt("count_new_file")).append(" (Change: ").append(newFilesDelta >= 0 ? "+" : "").append(newFilesDelta).append(").\n");
            message.append("Files that were modified: ").append(currentReport.getInt("count_modified_file")).append(" (Change: ").append(modifiedFilesDelta >= 0 ? "+" : "").append(modifiedFilesDelta).append(").\n");
            message.append("Files with permission changes: ").append(currentReport.getInt("count_permission_file")).append(" (Change: ").append(permissionModifiedDelta >= 0 ? "+" : "").append(permissionModifiedDelta).append(").\n");
            message.append("Files deleted: ").append(currentReport.getInt("count_deleted_file")).append(" (Change: ").append(deletedFilesDelta >= 0 ? "+" : "").append(deletedFilesDelta).append(").\n");
            message.append("Total files processed so far: ").append(currentReport.getInt("total_file_count")).append(".");
            logger.info(message.toString());
            FileBasedLogger.info("Security", message.toString(), user);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject saveFileChecksumsToFile() {
        JSONObject resultObj = new JSONObject();
        final Path logFilePath = Paths.get("fileNameList.txt", new String[0]);
        try {
            if (!Files.exists(logFilePath, new LinkOption[0])) {
                Files.createFile(logFilePath, new FileAttribute[0]);
            }
        }
        catch (IOException e) {
            logger.error("Error creating or accessing the log file: " + logFilePath + " - " + e.getMessage());
            resultObj.put("status", "fail");
            resultObj.put("msg", "Failed to create or access the log file.");
            return resultObj;
        }
        try {
            final ExecutorService executor = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
            try {
                Files.walkFileTree(Paths.get(DIRECTORYPATH, new String[0]), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        executor.submit(() -> {
                            try {
                                String filename = file.toString();
                                Path path = logFilePath;
                                synchronized (path) {
                                    Files.write(logFilePath, (filename + System.lineSeparator()).getBytes(), StandardOpenOption.APPEND);
                                }
                            }
                            catch (IOException e) {
                                logger.error("Error writing filename to log file: " + file + " - " + e.getMessage());
                            }
                        });
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            finally {
                executor.shutdown();
                executor.awaitTermination(Long.MAX_VALUE, TimeUnit.NANOSECONDS);
            }
            logger.debug("All filenames saved to the log file successfully.");
            resultObj.put("status", "success");
            resultObj.put("msg", "Filenames saved to the log file successfully.");
        }
        catch (Exception e) {
            logger.error("Error occurred while saving filenames to the log file: " + e.getMessage());
            resultObj.put("status", "fail");
            resultObj.put("msg", "Error occurred while saving filenames to the log file.");
        }
        return resultObj;
    }

    static {
        SKIP_PATHS.add("/media/rfs/rw/upperdir/etc/localtime");
        SKIP_PATHS.add("/media/rfs/rw/upperdir/etc/systemd/system/sysinit.target.wants/run-postinsts.service");
    }
}

