/*
 * Decompiled with CFR 0.152.
 */
package com.tas.wp500.factory_reset;

import com.tas.wp500.fileLogSetting.FileBasedLogger;
import org.apache.log4j.Logger;
import org.json.JSONObject;

public class FactoryReset {
    private static Logger logger = Logger.getLogger(FactoryReset.class);
    private static FactoryReset instanceFactoryReset = null;
    private static final String command1 = "fw_setenv root_reset yes";
    private static final String command2 = "fw_setenv data_reset yes";
    private static final String command3 = "reboot";

    private FactoryReset() {
    }

    public static FactoryReset getInstance() {
        if (instanceFactoryReset == null) {
            instanceFactoryReset = new FactoryReset();
        }
        return instanceFactoryReset;
    }

    public JSONObject doFactoryReset(final String user) {
        JSONObject resultObject = new JSONObject();
        try {
            if (this.executeCommand(command1, user) && this.executeCommand(command2, user)) {
                resultObject.put("status", "success");
                resultObject.put("msg", "Factory reset completed successfully. The system will now reboot. Please wait.");
                logger.info("Factory reset completed successfully.");
                FileBasedLogger.info("Audit", "Factory reset completed successfully.", user);
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            FactoryReset.this.executeCommand(FactoryReset.command3, user);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            logger.error("Error occurred while rebooting system : " + e);
                            FileBasedLogger.error("Audit", "Error occurred while rebooting system : " + e, user);
                        }
                    }
                }).start();
            } else {
                resultObject.put("status", "fail");
                resultObject.put("msg", "Factory reset failed. An error occurred during the process.");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Error occurred while doing factory reset :" + e);
            FileBasedLogger.error("Audit", "Error occurred while doing factory reset :" + e, user);
        }
        return resultObject;
    }

    private boolean executeCommand(String command, String user) {
        try {
            ProcessBuilder processBuilder = new ProcessBuilder("/bin/bash", "-c", command);
            processBuilder.redirectErrorStream(true);
            Process process = processBuilder.start();
            int exitCode = process.waitFor();
            return exitCode == 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Error occurred while executing factory reset command : " + e);
            FileBasedLogger.error("Audit", "Error occurred while executing factory reset command : " + e, user);
            return false;
        }
    }
}

