/*
 * Decompiled with CFR 0.152.
 */
package com.tas.wp500.events;

import com.tas.wp500.security.Security;
import com.tas.wp500.sql_lite_db.SQLiteConnector;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.LocalDate;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class EventsDbOperation
extends Security {
    private static Logger logger = Logger.getLogger(EventsDbOperation.class);
    private static EventsDbOperation instance = null;

    private EventsDbOperation() {
        this.createEventTable();
    }

    public static EventsDbOperation getInstance() {
        if (instance == null) {
            instance = new EventsDbOperation();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createEventTable() {
        Connection connection = SQLiteConnector.getConnection();
        try {
            Statement statement = connection.createStatement();
            String sql = "CREATE TABLE IF NOT EXISTS event (id INTEGER PRIMARY KEY AUTOINCREMENT, date_time TEXT, event_name TEXT, event_type TEXT, msg TEXT)";
            statement.execute(sql);
            statement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            logger.error(" Error occurred while creating event table : " + e);
        }
        finally {
            SQLiteConnector.closeConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertEvent(String dateTime, String eventName, String eventType, String message) {
        Connection connection = null;
        try {
            connection = SQLiteConnector.getConnection();
            String sql = "INSERT INTO event (date_time, event_name, event_type, msg) VALUES (?, ?, ?, ?)";
            PreparedStatement statement = connection.prepareStatement(sql);
            statement.setString(1, dateTime);
            statement.setString(2, EventsDbOperation.encrypt(eventName));
            statement.setString(3, EventsDbOperation.encrypt(eventType));
            statement.setString(4, EventsDbOperation.encrypt(message));
            statement.executeUpdate();
            statement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            logger.error(" Error occurred while inserting event : " + e);
        }
        finally {
            SQLiteConnector.closeConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject getAllEvents() throws JSONException {
        Connection connection = null;
        JSONObject result = new JSONObject();
        try {
            connection = SQLiteConnector.getConnection();
            String sql = "SELECT * FROM event";
            Statement statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery(sql);
            JSONArray eventArray = new JSONArray();
            while (resultSet.next()) {
                try {
                    JSONObject json = new JSONObject();
                    int id = resultSet.getInt("id");
                    String dateTime = resultSet.getString("date_time");
                    String eventName = resultSet.getString("event_name");
                    String eventType = resultSet.getString("event_type");
                    String message = resultSet.getString("msg");
                    json.put("date_time", dateTime);
                    json.put("event_name", EventsDbOperation.decrypt(eventName));
                    json.put("event_type", EventsDbOperation.decrypt(eventType));
                    json.put("msg", EventsDbOperation.decrypt(message));
                    eventArray.put(json);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
            result.put("data", eventArray);
            result.put("status", "success");
            statement.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Error while retrieving events : " + e);
            result.put("status", "fail");
        }
        finally {
            SQLiteConnector.closeConnection(connection);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject getMultipleEventData(JSONObject json) {
        Connection connection = null;
        try {
            String pageNo = json.getString("page_no");
            int itemsPerPage = 100;
            int requestedPage = Integer.parseInt(pageNo) + 1;
            connection = SQLiteConnector.getConnection();
            String countQuery = "SELECT COUNT(*) AS total FROM event";
            Statement countStatement = connection.createStatement();
            ResultSet countResult = countStatement.executeQuery(countQuery);
            countResult.next();
            int totalRecords = countResult.getInt("total");
            countStatement.close();
            int totalPages = (int)Math.ceil((double)totalRecords / (double)itemsPerPage);
            requestedPage = Math.max(1, Math.min(requestedPage, totalPages));
            int startRow = (requestedPage - 1) * itemsPerPage;
            int endRow = Math.min(startRow + itemsPerPage, totalRecords);
            String sql = "SELECT * FROM event LIMIT ?, ?";
            PreparedStatement statement = connection.prepareStatement(sql);
            statement.setInt(1, startRow);
            statement.setInt(2, endRow - startRow);
            ResultSet resultSet = statement.executeQuery();
            JSONArray dataArray = new JSONArray();
            while (resultSet.next()) {
                JSONObject json1 = new JSONObject();
                int id = resultSet.getInt("id");
                String dateTime = resultSet.getString("date_time");
                String eventName = resultSet.getString("event_name");
                String eventType = resultSet.getString("event_type");
                String message = resultSet.getString("msg");
                json1.put("date_time", dateTime);
                json1.put("event_name", EventsDbOperation.decrypt(eventName));
                json1.put("event_type", EventsDbOperation.decrypt(eventType));
                json1.put("msg", EventsDbOperation.decrypt(message));
                dataArray.put(json1);
            }
            statement.close();
            json.put("total_pages", totalPages);
            json.put("result", dataArray);
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                logger.error(" Error occurred while getting event data from db : " + e);
            }
            catch (Throwable throwable) {
                SQLiteConnector.closeConnection(connection);
                throw throwable;
            }
            SQLiteConnector.closeConnection(connection);
        }
        SQLiteConnector.closeConnection(connection);
        return json;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void maintainsOnly7DaysData() {
        Connection connection = null;
        try {
            connection = SQLiteConnector.getConnection();
            String sql = "DELETE FROM event WHERE date_time < ?";
            PreparedStatement statement = connection.prepareStatement(sql);
            LocalDate currentDate = LocalDate.now();
            LocalDate sevenDaysAgo = currentDate.minusDays(7L);
            Date sevenDaysAgoDate = Date.valueOf(sevenDaysAgo);
            statement.setDate(1, sevenDaysAgoDate);
            int rowsAffected = statement.executeUpdate();
            statement.close();
            System.out.println(rowsAffected + " old event(s) deleted.");
        }
        catch (SQLException e) {
            e.printStackTrace();
            logger.error("Error while deleting old events: " + e);
        }
        finally {
            SQLiteConnector.closeConnection(connection);
        }
    }
}

