/*
 * Decompiled with CFR 0.152.
 */
package com.tas.wp500.dispensorSettings;

import com.tas.wp500.dispensorSettings.Dispensor;
import com.tas.wp500.fileLogSetting.FileBasedLogger;
import com.tas.wp500.security.Security;
import com.tas.wp500.sql_lite_db.SQLiteConnector;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class DispensorTriggerDb_Operations
extends Security {
    private static Logger logger = Logger.getLogger(DispensorTriggerDb_Operations.class);
    private static DispensorTriggerDb_Operations instance = null;
    private static final int SQLITE_BUSY = 5;
    private static final int RETRY_COUNT = 5;
    private static final int RETRY_DELAY = 10000;

    private DispensorTriggerDb_Operations() {
        this.createDispenserTable();
    }

    public static DispensorTriggerDb_Operations getInstance() {
        if (instance == null) {
            instance = new DispensorTriggerDb_Operations();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createDispenserTable() {
        Connection connection = SQLiteConnector.getConnection();
        try {
            Statement statement = connection.createStatement();
            String sql = "CREATE TABLE IF NOT EXISTS dispenser (id INTEGER PRIMARY KEY AUTOINCREMENT, station_name TEXT, serial_number TEXT , side TEXT, trigger_tag TEXT, trigger_value TEXT, status TEXT, start_pressesure TEXT, end_pressure TEXT, tempreture TEXT, total TEXT, quantity TEXT, unit_price TEXT, broker_ip_address TEXT, unit_id TEXT)";
            statement.execute(sql);
            statement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            logger.debug("Error while creating dispensor table : " + e);
            FileBasedLogger.error("Application", "Error while creating dispensor table : " + e, "system");
        }
        finally {
            SQLiteConnector.closeConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject insertDispenserData(JSONObject json1, String user) throws JSONException {
        JSONObject resultObj = new JSONObject();
        for (int attempt = 0; attempt < 5; ++attempt) {
            Connection connection = null;
            try {
                connection = SQLiteConnector.getConnection();
                boolean serialNumberExists = this.checkSerialNumberExists(DispensorTriggerDb_Operations.encrypt(json1.getString("serial_number")), DispensorTriggerDb_Operations.encrypt(json1.getString("side")), connection);
                if (serialNumberExists) {
                    resultObj.put("status", "success");
                    resultObj.put("msg", "Serial number and side already exists in the database. Please use a different serial number and side.");
                    continue;
                }
                String sql = "INSERT INTO dispenser (station_name, serial_number, side, trigger_tag, trigger_value, status, start_pressesure, end_pressure, tempreture, total, quantity, unit_price, broker_ip_address, unit_id) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ? ,?)";
                PreparedStatement statement = connection.prepareStatement(sql);
                statement.setString(1, DispensorTriggerDb_Operations.encrypt(json1.getString("station_name")));
                statement.setString(2, DispensorTriggerDb_Operations.encrypt(json1.getString("serial_number")));
                statement.setString(3, DispensorTriggerDb_Operations.encrypt(json1.getString("side")));
                statement.setString(4, DispensorTriggerDb_Operations.encrypt(json1.getString("trigger_tag")));
                statement.setString(5, DispensorTriggerDb_Operations.encrypt(json1.getString("trigger_value")));
                statement.setString(6, DispensorTriggerDb_Operations.encrypt(json1.getString("status")));
                statement.setString(7, DispensorTriggerDb_Operations.encrypt(json1.getString("start_pressesure")));
                statement.setString(8, DispensorTriggerDb_Operations.encrypt(json1.getString("end_pressure")));
                statement.setString(9, DispensorTriggerDb_Operations.encrypt(json1.getString("tempreture")));
                statement.setString(10, DispensorTriggerDb_Operations.encrypt(json1.getString("total")));
                statement.setString(11, DispensorTriggerDb_Operations.encrypt(json1.getString("quantity")));
                statement.setString(12, DispensorTriggerDb_Operations.encrypt(json1.getString("unit_price")));
                statement.setString(13, DispensorTriggerDb_Operations.encrypt(json1.getString("broker_ip_address")));
                statement.setString(14, DispensorTriggerDb_Operations.encrypt(json1.getString("unit_id")));
                statement.executeUpdate();
                statement.close();
                resultObj.put("status", "success");
                resultObj.put("msg", "Dispenser trigger setting saved successfully.");
                logger.info("Saved dispenser trigger setting successfully.");
                FileBasedLogger.info("Audit", "Saved dispenser trigger setting successfully.", user);
                break;
            }
            catch (Exception e) {
                e.printStackTrace();
                if (((SQLException)e).getErrorCode() != 5 || attempt == 4) {
                    resultObj.put("status", "fail");
                    resultObj.put("msg", "Failed to save Dispenser Trigger setting. Please try again.");
                    logger.error("Error occurred while inserting Dispenser Trigger data : " + e);
                    FileBasedLogger.error("Audit", "Error occurred while inserting Dispenser Trigger data : " + e, user);
                    break;
                }
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
                continue;
            }
            finally {
                SQLiteConnector.closeConnection(connection);
            }
        }
        return resultObj;
    }

    private boolean checkSerialNumberExists(String station_name, String side, Connection connection) throws SQLException {
        String sql = "SELECT COUNT(*) AS count FROM dispenser WHERE serial_number = ? AND side = ?";
        PreparedStatement statement = connection.prepareStatement(sql);
        statement.setString(1, station_name);
        statement.setString(2, side);
        ResultSet resultSet = statement.executeQuery();
        int count = 0;
        if (resultSet.next()) {
            count = resultSet.getInt("count");
        }
        resultSet.close();
        statement.close();
        return count > 0;
    }

    private boolean checkSerialNumberExists1(String serial_number, String side, int currentId, Connection connection) throws SQLException {
        String sql = "SELECT COUNT(*) AS count FROM dispenser WHERE serial_number = ? AND side = ? AND id != ?";
        PreparedStatement statement = connection.prepareStatement(sql);
        statement.setString(1, serial_number);
        statement.setString(2, side);
        statement.setInt(3, currentId);
        ResultSet resultSet = statement.executeQuery();
        int count = 0;
        if (resultSet.next()) {
            count = resultSet.getInt("count");
        }
        resultSet.close();
        statement.close();
        return count > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject updateDispenserData(JSONObject json1, String user) throws JSONException {
        JSONObject resultObj = new JSONObject();
        for (int attempt = 0; attempt < 5; ++attempt) {
            Connection connection = null;
            try {
                connection = SQLiteConnector.getConnection();
                int id = Integer.parseInt(json1.getString("id"));
                String serial_number = DispensorTriggerDb_Operations.encrypt(json1.getString("serial_number"));
                String side = DispensorTriggerDb_Operations.encrypt(json1.getString("side"));
                boolean serialNumberExists = this.checkSerialNumberExists1(serial_number, side, id, connection);
                if (serialNumberExists) {
                    resultObj.put("status", "fail");
                    resultObj.put("msg", "Serial number and side already exist in the database. Please use a different serial number and side.");
                    JSONObject jSONObject = resultObj;
                    return jSONObject;
                }
                String station_name = DispensorTriggerDb_Operations.encrypt(json1.getString("station_name"));
                String trigger_tag = DispensorTriggerDb_Operations.encrypt(json1.getString("trigger_tag"));
                String parsedValue = DispensorTriggerDb_Operations.encrypt(json1.getString("trigger_value"));
                String status = DispensorTriggerDb_Operations.encrypt(json1.getString("status"));
                String start_pressure = DispensorTriggerDb_Operations.encrypt(json1.getString("start_pressesure"));
                String end_pressure = DispensorTriggerDb_Operations.encrypt(json1.getString("end_pressure"));
                String temperature = DispensorTriggerDb_Operations.encrypt(json1.getString("tempreture"));
                String total = DispensorTriggerDb_Operations.encrypt(json1.getString("total"));
                String quantity = DispensorTriggerDb_Operations.encrypt(json1.getString("quantity"));
                String unit_price = DispensorTriggerDb_Operations.encrypt(json1.getString("unit_price"));
                String broker_ip_address = DispensorTriggerDb_Operations.encrypt(json1.getString("broker_ip_address"));
                String unit_id = DispensorTriggerDb_Operations.encrypt(json1.getString("unit_id"));
                String sql = "UPDATE dispenser SET station_name = ?, trigger_tag = ?, trigger_value = ?, status = ?, start_pressesure = ?, end_pressure = ?, tempreture = ?, total = ?, quantity = ?, unit_price = ?, broker_ip_address = ?, unit_id = ?, serial_number = ?, side = ? WHERE id = ?";
                PreparedStatement statement = connection.prepareStatement(sql);
                statement.setString(1, station_name);
                statement.setString(2, trigger_tag);
                statement.setString(3, parsedValue);
                statement.setString(4, status);
                statement.setString(5, start_pressure);
                statement.setString(6, end_pressure);
                statement.setString(7, temperature);
                statement.setString(8, total);
                statement.setString(9, quantity);
                statement.setString(10, unit_price);
                statement.setString(11, broker_ip_address);
                statement.setString(12, unit_id);
                statement.setString(13, serial_number);
                statement.setString(14, side);
                statement.setInt(15, id);
                int rowsAffected = statement.executeUpdate();
                statement.close();
                resultObj.put("status", "success");
                resultObj.put("msg", "Dispenser Trigger setting has been updated successfully.");
                logger.info("Updated dispenser trigger setting successfully.");
                FileBasedLogger.info("Audit", "Updated dispenser trigger setting successfully.", user);
                break;
            }
            catch (Exception e) {
                e.printStackTrace();
                if (((SQLException)e).getErrorCode() != 5 || attempt == 4) {
                    logger.error("Error occurred while updating Dispenser Trigger data : " + e);
                    FileBasedLogger.error("Audit", "Error occurred while updating Dispenser Trigger data : " + e, user);
                    resultObj.put("status", "fail");
                    resultObj.put("msg", "Failed to update dispenser trigger setting.");
                    break;
                }
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
                continue;
            }
            finally {
                SQLiteConnector.closeConnection(connection);
            }
        }
        return resultObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject deleteDispenserData(JSONObject json, String user) throws JSONException {
        JSONObject resultObj = new JSONObject();
        Connection connection = null;
        try {
            connection = SQLiteConnector.getConnection();
            int id = Integer.parseInt(json.getString("id"));
            String sql = "DELETE FROM dispenser WHERE id = ?";
            PreparedStatement pstmt = connection.prepareStatement(sql);
            pstmt.setInt(1, id);
            int rowsAffected = pstmt.executeUpdate();
            if (rowsAffected > 0) {
                resultObj.put("msg", "Dispenser Trigger setting deleted successfully.");
                resultObj.put("status", "success");
                logger.info("Deleted dispenser trigger setting successfully.");
                FileBasedLogger.info("Audit", "Dispenser Trigger setting deleted successfully.", user);
            } else {
                resultObj.put("status", "fail");
                resultObj.put("msg", "Error occurred while deleting Dispenser Trigger setting or ID not found.");
                logger.info("Error while deleting dispenser trigger setting.");
                FileBasedLogger.info("Audit", "Error occurred while deleting Dispenser Trigger setting or ID not found.", user);
            }
            pstmt.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Error occurred while deleting Dispenser Trigger setting: " + e);
            FileBasedLogger.error("Audit", "Error occurred while deleting Dispenser Trigger setting: " + e, user);
            resultObj.put("status", "fail");
            resultObj.put("msg", "Failed to delete Dispenser Trigger setting.");
        }
        finally {
            SQLiteConnector.closeConnection(connection);
        }
        return resultObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject getAllDispenserData(JSONObject json, String user) {
        JSONObject resultObj = new JSONObject();
        Connection connection = SQLiteConnector.getConnection();
        try {
            String sql = "SELECT * FROM dispenser";
            Statement statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery(sql);
            JSONArray dispenserDataArray = new JSONArray();
            while (resultSet.next()) {
                JSONObject jsonData = new JSONObject();
                int id = resultSet.getInt("id");
                jsonData.put("id", String.valueOf(id));
                String station_name = resultSet.getString("station_name");
                jsonData.put("station_name", DispensorTriggerDb_Operations.decrypt(station_name));
                String serial_number = resultSet.getString("serial_number");
                jsonData.put("serial_number", DispensorTriggerDb_Operations.decrypt(serial_number));
                String side = resultSet.getString("side");
                jsonData.put("side", DispensorTriggerDb_Operations.decrypt(side));
                String trigger_tag = resultSet.getString("trigger_tag");
                jsonData.put("trigger_tag", DispensorTriggerDb_Operations.decrypt(trigger_tag));
                String stringValue = resultSet.getString("trigger_value");
                jsonData.put("trigger_value", DispensorTriggerDb_Operations.decrypt(stringValue));
                String status = resultSet.getString("status");
                jsonData.put("status", DispensorTriggerDb_Operations.decrypt(status));
                String start_pressesure = resultSet.getString("start_pressesure");
                jsonData.put("start_pressesure", DispensorTriggerDb_Operations.decrypt(start_pressesure));
                String end_pressure = resultSet.getString("end_pressure");
                jsonData.put("end_pressure", DispensorTriggerDb_Operations.decrypt(end_pressure));
                String tempreture = resultSet.getString("tempreture");
                jsonData.put("tempreture", DispensorTriggerDb_Operations.decrypt(tempreture));
                String total = resultSet.getString("total");
                jsonData.put("total", DispensorTriggerDb_Operations.decrypt(total));
                String quantity = resultSet.getString("quantity");
                jsonData.put("quantity", DispensorTriggerDb_Operations.decrypt(quantity));
                String unit_price = resultSet.getString("unit_price");
                jsonData.put("unit_price", DispensorTriggerDb_Operations.decrypt(unit_price));
                String broker_ip_address = resultSet.getString("broker_ip_address");
                jsonData.put("broker_ip_address", DispensorTriggerDb_Operations.decrypt(broker_ip_address));
                String unit_id = resultSet.getString("unit_id");
                jsonData.put("unit_id", DispensorTriggerDb_Operations.decrypt(unit_id));
                dispenserDataArray.put(jsonData);
            }
            resultSet.close();
            statement.close();
            try {
                resultObj.put("status", "success");
                resultObj.put("msg", "Successfully retrieved all Dispenser Trigger settings.");
                resultObj.put("result", dispenserDataArray);
                logger.info("All dispenser trigger setting fetched successfully.");
                FileBasedLogger.info("Audit", "All dispenser trigger setting fetched successfully.", user);
            }
            catch (Exception e) {
                logger.error("Error occurred while fetching Dispensor Trigger setting : " + e);
                FileBasedLogger.info("Audit", "Error occurred while fetching Dispensor Trigger setting : " + e, user);
                e.printStackTrace();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                resultObj.put("status", "fail");
                resultObj.put("msg", "Failed to retrieve Dispenser data.");
            }
            catch (JSONException e1) {
                e1.printStackTrace();
            }
        }
        finally {
            SQLiteConnector.closeConnection(connection);
        }
        return resultObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<Dispensor> getAllDispenserData() {
        ArrayList<Dispensor> dispList = new ArrayList<Dispensor>();
        for (int attempt = 0; attempt < 5; ++attempt) {
            Connection connection = SQLiteConnector.getConnection();
            try {
                String sql = "SELECT * FROM dispenser";
                Statement statement = connection.createStatement();
                ResultSet resultSet = statement.executeQuery(sql);
                while (resultSet.next()) {
                    Dispensor disp = new Dispensor();
                    String station_name = resultSet.getString("station_name");
                    disp.setStation_name(DispensorTriggerDb_Operations.decrypt(station_name));
                    String serial_number = resultSet.getString("serial_number");
                    disp.setSerial_number(DispensorTriggerDb_Operations.decrypt(serial_number));
                    String side = resultSet.getString("side");
                    disp.setSide(DispensorTriggerDb_Operations.decrypt(side));
                    String trigger_tag = resultSet.getString("trigger_tag");
                    disp.setTrigger_tag(DispensorTriggerDb_Operations.decrypt(trigger_tag));
                    String trigger_value = resultSet.getString("trigger_value");
                    disp.setTrigger_value(DispensorTriggerDb_Operations.decrypt(trigger_value));
                    String status = resultSet.getString("status");
                    disp.setStatus(DispensorTriggerDb_Operations.decrypt(status));
                    String start_pressesure = resultSet.getString("start_pressesure");
                    disp.setStart_pressesure(DispensorTriggerDb_Operations.decrypt(start_pressesure));
                    String end_pressure = resultSet.getString("end_pressure");
                    disp.setEnd_pressure(DispensorTriggerDb_Operations.decrypt(end_pressure));
                    String tempreture = resultSet.getString("tempreture");
                    disp.setTempreture(DispensorTriggerDb_Operations.decrypt(tempreture));
                    String total = resultSet.getString("total");
                    disp.setTotal(DispensorTriggerDb_Operations.decrypt(total));
                    String quantity = resultSet.getString("quantity");
                    disp.setQuantity(DispensorTriggerDb_Operations.decrypt(quantity));
                    String unit_price = resultSet.getString("unit_price");
                    disp.setUnit_price(DispensorTriggerDb_Operations.decrypt(unit_price));
                    String broker_ip_address = resultSet.getString("broker_ip_address");
                    disp.setBroker_ip_address(DispensorTriggerDb_Operations.decrypt(broker_ip_address));
                    String unit_id = resultSet.getString("unit_id");
                    disp.setUnit_id(DispensorTriggerDb_Operations.decrypt(unit_id));
                    dispList.add(disp);
                }
                resultSet.close();
                statement.close();
                break;
            }
            catch (Exception e) {
                e.printStackTrace();
                if (((SQLException)e).getErrorCode() != 5 || attempt == 4) {
                    e.printStackTrace();
                    logger.error("Error while get all dispenser data : " + e);
                    FileBasedLogger.error("Application", "Error while get all dispenser data : " + e, "system");
                    break;
                }
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
                continue;
            }
            finally {
                SQLiteConnector.closeConnection(connection);
            }
        }
        return dispList;
    }
}

