/*
 * Decompiled with CFR 0.152.
 */
package com.tas.wp500.configFileDbSettings;

import com.tas.wp500.fileLogSetting.FileBasedLogger;
import com.tas.wp500.security.Security;
import com.tas.wp500.sql_lite_db.SQLiteConnector;
import com.tas.wp500.sql_lite_db.SQLiteRestoreBackupConnector;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.json.JSONException;
import org.json.JSONObject;

public class ConfigFileDbOperation
extends Security {
    private static Logger logger = Logger.getLogger(ConfigFileDbOperation.class);
    public static final int ID = 1;
    private static ConfigFileDbOperation instance = null;
    public static final String CONFIG_PATH = "/etc/wp500cfg/config.ini";
    private static final int SQLITE_BUSY = 5;
    private static final int RETRY_COUNT = 5;
    private static final int RETRY_DELAY = 10000;

    private ConfigFileDbOperation() {
        this.createConfigFileTable();
        this.getEthernetDetailsAndInsert();
    }

    public static ConfigFileDbOperation getInstance() {
        if (instance == null) {
            instance = new ConfigFileDbOperation();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createConfigFileTable() {
        Connection connection = SQLiteConnector.getConnection();
        String createTableSQL = "CREATE TABLE IF NOT EXISTS config_setting (id INTEGER PRIMARY KEY CHECK (id = 1),lan0_dhcp TEXT, lan0_ipaddr TEXT, lan0_subnet TEXT, lan0_gateway TEXT, lan0_dns TEXT, lan1_enable TEXT, lan1_dhcp TEXT, lan1_ipaddr TEXT, lan1_subnet TEXT, lan1_gateway TEXT, lan1_dns TEXT, lan2_enable TEXT, lan2_dhcp TEXT, lan2_ipaddr TEXT, lan2_subnet TEXT, lan2_gateway TEXT, lan2_dns TEXT, enable_ftp TEXT, enable_ssh TEXT, enable_usbtty TEXT, enable_sdcard TEXT, rtu_number TEXT, rtu_name TEXT, ntp_server1 TEXT, ntp_server2 TEXT, ntp_server3 TEXT, ntp_interval TEXT, snort_mode TEXT, Redundancy_enable TEXT, Redundancy_Role TEXT, partner_ip TEXT, common_ip0 TEXT, common_subnet0 TEXT, common_ip1 TEXT, common_subnet1 TEXT, common_ip2 TEXT, common_subnet2 TEXT)";
        try {
            PreparedStatement preparedStatement = connection.prepareStatement(createTableSQL);
            preparedStatement.executeUpdate();
            preparedStatement.close();
            logger.debug("Config file table created or already exists.");
        }
        catch (SQLException e) {
            e.printStackTrace();
            logger.debug("Error while creating config file  table : " + e);
        }
        finally {
            SQLiteConnector.closeConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getEthernetDetailsAndInsert() {
        HashMap<String, Object> configMap = new HashMap<String, Object>();
        Connection connection = null;
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(CONFIG_PATH));){
            String line;
            while ((line = bufferedReader.readLine()) != null) {
                String[] parts = line.split("=", 2);
                if (parts.length < 2) continue;
                String key = parts[0].trim();
                String value = parts[1].trim().split(";")[0].trim();
                configMap.put(key, value);
            }
            for (int attempt = 0; attempt < 5; ++attempt) {
                try {
                    connection = SQLiteConnector.getConnection();
                    StringBuilder checkSQL = new StringBuilder("SELECT COUNT(*) FROM config_setting WHERE ");
                    for (String key : configMap.keySet()) {
                        checkSQL.append(key).append(" = ? AND ");
                    }
                    checkSQL.delete(checkSQL.length() - 5, checkSQL.length());
                    PreparedStatement checkStatement = connection.prepareStatement(checkSQL.toString());
                    int index = 1;
                    for (String value : configMap.values()) {
                        checkStatement.setString(index++, value);
                    }
                    ResultSet resultSet = checkStatement.executeQuery();
                    if (resultSet.next() && resultSet.getInt(1) > 0) {
                        logger.info("Data already exists in the database. Skipping insertion.");
                    } else {
                        resultSet.close();
                        checkStatement.close();
                        StringBuilder insertSQL = new StringBuilder("INSERT INTO config_setting (");
                        StringBuilder valuesSQL = new StringBuilder(" VALUES (");
                        for (String key : configMap.keySet()) {
                            insertSQL.append(key).append(", ");
                            valuesSQL.append("?, ");
                        }
                        insertSQL.delete(insertSQL.length() - 2, insertSQL.length());
                        valuesSQL.delete(valuesSQL.length() - 2, valuesSQL.length());
                        insertSQL.append(")").append((CharSequence)valuesSQL).append(")");
                        PreparedStatement preparedStatement = connection.prepareStatement(insertSQL.toString());
                        index = 1;
                        for (String value : configMap.values()) {
                            preparedStatement.setString(index++, value);
                        }
                        preparedStatement.executeUpdate();
                        preparedStatement.close();
                        logger.info("Successfully saved Ethernet settings into db.");
                    }
                    break;
                }
                catch (SQLException e) {
                    if (e.getErrorCode() != 5 || attempt == 4) {
                        e.printStackTrace();
                        logger.debug("Error while inserting data into config_setting table: " + e);
                        break;
                    }
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (InterruptedException ie) {
                        Thread.currentThread().interrupt();
                    }
                    continue;
                }
                finally {
                    SQLiteConnector.closeConnection(connection);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            logger.debug("Error while reading properties file: " + e);
        }
    }

    public HashMap<String, String> readConfigFile(String filePath) throws IOException, JSONException {
        HashMap<String, String> configMap = new HashMap<String, String>();
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(filePath));){
            String line;
            while ((line = bufferedReader.readLine()) != null) {
                String[] parts = line.split("=", 2);
                if (parts.length < 2) continue;
                String key = parts[0].trim();
                String value = parts[1].trim().split(";")[0].trim();
                configMap.put(key, value);
            }
        }
        return configMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void writeOnDbLan0(JSONObject json, String user) {
        for (int attempt = 0; attempt < 5; ++attempt) {
            Connection connection = SQLiteConnector.getConnection();
            try {
                StringBuilder sqlBuilder = new StringBuilder("UPDATE config_setting SET");
                ArrayList<String> fieldsToUpdate = new ArrayList<String>();
                if (json.has("lan0_dhcp") && !json.getString("lan0_dhcp").isEmpty()) {
                    sqlBuilder.append(" lan0_dhcp = ?,");
                    fieldsToUpdate.add(json.getString("lan0_dhcp"));
                }
                if (json.has("lan0_ipaddr") && !json.getString("lan0_ipaddr").isEmpty()) {
                    sqlBuilder.append(" lan0_ipaddr = ?,");
                    fieldsToUpdate.add(json.getString("lan0_ipaddr"));
                }
                if (json.has("lan0_subnet") && !json.getString("lan0_subnet").isEmpty()) {
                    sqlBuilder.append(" lan0_subnet = ?,");
                    fieldsToUpdate.add(json.getString("lan0_subnet"));
                }
                if (json.has("lan0_gateway") && !json.getString("lan0_gateway").isEmpty()) {
                    sqlBuilder.append(" lan0_gateway = ?,");
                    fieldsToUpdate.add(json.getString("lan0_gateway"));
                }
                if (json.has("lan0_dns") && !json.getString("lan0_dns").isEmpty()) {
                    sqlBuilder.append(" lan0_dns = ?,");
                    fieldsToUpdate.add(json.getString("lan0_dns"));
                }
                if (fieldsToUpdate.size() > 0) {
                    sqlBuilder.deleteCharAt(sqlBuilder.length() - 1);
                    sqlBuilder.append(" WHERE id = 1");
                    PreparedStatement pstmt = connection.prepareStatement(sqlBuilder.toString());
                    try {
                        for (int i = 0; i < fieldsToUpdate.size(); ++i) {
                            pstmt.setString(i + 1, (String)fieldsToUpdate.get(i));
                        }
                        pstmt.executeUpdate();
                        if (pstmt == null) break;
                    }
                    catch (Throwable throwable) {
                        if (pstmt != null) {
                            try {
                                pstmt.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    pstmt.close();
                    break;
                }
                SQLiteConnector.closeConnection(connection);
                continue;
                {
                    catch (SQLException | JSONException e) {
                        block22: {
                            e.printStackTrace();
                            if (((SQLException)e).getErrorCode() == 5 && attempt != 4) break block22;
                            logger.error("Error updating record in the database : ", e);
                            FileBasedLogger.error("Network", "Error updating record in the database : " + e, user);
                            break;
                        }
                        try {
                            Thread.sleep(10000L);
                        }
                        catch (InterruptedException ie) {
                            Thread.currentThread().interrupt();
                        }
                        continue;
                    }
                }
            }
            finally {
                SQLiteConnector.closeConnection(connection);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void writeOnDbLan1ORLan2(JSONObject json, String lanIdentifier, String user) {
        for (int attempt = 0; attempt < 5; ++attempt) {
            Connection connection = SQLiteConnector.getConnection();
            try {
                StringBuilder sqlBuilder = new StringBuilder("UPDATE config_setting SET");
                ArrayList<String> fieldsToUpdate = new ArrayList<String>();
                if (json.has(lanIdentifier + "_dhcp") && !json.getString(lanIdentifier + "_dhcp").isEmpty()) {
                    sqlBuilder.append(" " + lanIdentifier + "_dhcp = ?,");
                    fieldsToUpdate.add(json.getString(lanIdentifier + "_dhcp"));
                }
                if (json.has(lanIdentifier + "_ipaddr") && !json.getString(lanIdentifier + "_ipaddr").isEmpty()) {
                    sqlBuilder.append(" " + lanIdentifier + "_ipaddr = ?,");
                    fieldsToUpdate.add(json.getString(lanIdentifier + "_ipaddr"));
                }
                if (json.has(lanIdentifier + "_subnet") && !json.getString(lanIdentifier + "_subnet").isEmpty()) {
                    sqlBuilder.append(" " + lanIdentifier + "_subnet = ?,");
                    fieldsToUpdate.add(json.getString(lanIdentifier + "_subnet"));
                }
                if (json.has(lanIdentifier + "_gateway") && !json.getString(lanIdentifier + "_gateway").isEmpty()) {
                    sqlBuilder.append(" " + lanIdentifier + "_gateway = ?,");
                    fieldsToUpdate.add(json.getString(lanIdentifier + "_gateway"));
                }
                if (json.has(lanIdentifier + "_dns") && !json.getString(lanIdentifier + "_dns").isEmpty()) {
                    sqlBuilder.append(" " + lanIdentifier + "_dns = ?,");
                    fieldsToUpdate.add(json.getString(lanIdentifier + "_dns"));
                }
                if (json.has(lanIdentifier + "_enable") && !json.getString(lanIdentifier + "_enable").isEmpty()) {
                    sqlBuilder.append(" " + lanIdentifier + "_enable = ?,");
                    fieldsToUpdate.add(json.getString(lanIdentifier + "_enable"));
                }
                if (fieldsToUpdate.size() > 0) {
                    sqlBuilder.deleteCharAt(sqlBuilder.length() - 1);
                    sqlBuilder.append(" WHERE id = 1");
                    PreparedStatement pstmt = connection.prepareStatement(sqlBuilder.toString());
                    try {
                        for (int i = 0; i < fieldsToUpdate.size(); ++i) {
                            pstmt.setString(i + 1, (String)fieldsToUpdate.get(i));
                        }
                        pstmt.executeUpdate();
                        if (pstmt == null) break;
                    }
                    catch (Throwable throwable) {
                        if (pstmt != null) {
                            try {
                                pstmt.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    pstmt.close();
                    break;
                }
                SQLiteConnector.closeConnection(connection);
                continue;
                {
                    catch (SQLException | JSONException e) {
                        block23: {
                            e.printStackTrace();
                            if (((SQLException)e).getErrorCode() == 5 && attempt != 4) break block23;
                            logger.error("Error updating record in the database : " + e);
                            FileBasedLogger.error("Network", "Error updating record in the database : " + e, user);
                            break;
                        }
                        try {
                            Thread.sleep(10000L);
                        }
                        catch (InterruptedException ie) {
                            Thread.currentThread().interrupt();
                        }
                        continue;
                    }
                }
            }
            finally {
                SQLiteConnector.closeConnection(connection);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void writeOnDbNtp(JSONObject json, String user) {
        for (int attempt = 0; attempt < 5; ++attempt) {
            Connection connection = SQLiteConnector.getConnection();
            try {
                StringBuilder sqlBuilder = new StringBuilder("UPDATE config_setting SET");
                ArrayList<String> fieldsToUpdate = new ArrayList<String>();
                if (json.has("ntp_server1") && !json.getString("ntp_server1").isEmpty()) {
                    sqlBuilder.append(" ntp_server1 = ?,");
                    fieldsToUpdate.add(json.getString("ntp_server1"));
                }
                if (json.has("ntp_server2") && !json.getString("ntp_server2").isEmpty()) {
                    sqlBuilder.append(" ntp_server2 = ?,");
                    fieldsToUpdate.add(json.getString("ntp_server2"));
                }
                if (json.has("ntp_server3") && !json.getString("ntp_server3").isEmpty()) {
                    sqlBuilder.append(" ntp_server3 = ?,");
                    fieldsToUpdate.add(json.getString("ntp_server3"));
                }
                if (json.has("ntp_interval") && !json.getString("ntp_interval").isEmpty()) {
                    sqlBuilder.append(" ntp_interval = ?,");
                    fieldsToUpdate.add(json.getString("ntp_interval"));
                }
                if (fieldsToUpdate.size() > 0) {
                    sqlBuilder.deleteCharAt(sqlBuilder.length() - 1);
                    sqlBuilder.append(" WHERE id = 1");
                    PreparedStatement pstmt = connection.prepareStatement(sqlBuilder.toString());
                    try {
                        for (int i = 0; i < fieldsToUpdate.size(); ++i) {
                            pstmt.setString(i + 1, (String)fieldsToUpdate.get(i));
                        }
                        pstmt.executeUpdate();
                        if (pstmt == null) break;
                    }
                    catch (Throwable throwable) {
                        if (pstmt != null) {
                            try {
                                pstmt.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    pstmt.close();
                    break;
                }
                SQLiteConnector.closeConnection(connection);
                continue;
                {
                    catch (SQLException | JSONException e) {
                        block21: {
                            e.printStackTrace();
                            if (((SQLException)e).getErrorCode() == 5 && attempt != 4) break block21;
                            logger.error("Error updating NTP settings in the database:" + e);
                            FileBasedLogger.error("Network", "Error updating NTP settings in the database:" + e, user);
                            break;
                        }
                        try {
                            Thread.sleep(10000L);
                        }
                        catch (InterruptedException ie) {
                            Thread.currentThread().interrupt();
                        }
                        continue;
                    }
                }
            }
            finally {
                SQLiteConnector.closeConnection(connection);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void writeOnDbGeneral(JSONObject json, String user) {
        for (int attempt = 0; attempt < 5; ++attempt) {
            Connection connection = SQLiteConnector.getConnection();
            try {
                StringBuilder sqlBuilder = new StringBuilder("UPDATE config_setting SET");
                ArrayList<String> fieldsToUpdate = new ArrayList<String>();
                if (json.has("enable_ftp") && !json.getString("enable_ftp").isEmpty()) {
                    sqlBuilder.append(" enable_ftp = ?,");
                    fieldsToUpdate.add(json.getString("enable_ftp"));
                }
                if (json.has("enable_ssh") && !json.getString("enable_ssh").isEmpty()) {
                    sqlBuilder.append(" enable_ssh = ?,");
                    fieldsToUpdate.add(json.getString("enable_ssh"));
                }
                if (json.has("enable_usbtty") && !json.getString("enable_usbtty").isEmpty()) {
                    sqlBuilder.append(" enable_usbtty = ?,");
                    fieldsToUpdate.add(json.getString("enable_usbtty"));
                }
                if (json.has("enable_sdcard") && !json.getString("enable_sdcard").isEmpty()) {
                    sqlBuilder.append(" enable_sdcard = ?,");
                    fieldsToUpdate.add(json.getString("enable_sdcard"));
                }
                if (fieldsToUpdate.size() > 0) {
                    sqlBuilder.deleteCharAt(sqlBuilder.length() - 1);
                    sqlBuilder.append(" WHERE id = 1");
                    PreparedStatement pstmt = connection.prepareStatement(sqlBuilder.toString());
                    try {
                        for (int i = 0; i < fieldsToUpdate.size(); ++i) {
                            pstmt.setString(i + 1, (String)fieldsToUpdate.get(i));
                        }
                        pstmt.executeUpdate();
                        if (pstmt == null) break;
                    }
                    catch (Throwable throwable) {
                        if (pstmt != null) {
                            try {
                                pstmt.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    pstmt.close();
                    break;
                }
                SQLiteConnector.closeConnection(connection);
                continue;
                {
                    catch (SQLException | JSONException e) {
                        block21: {
                            e.printStackTrace();
                            if (((SQLException)e).getErrorCode() == 5 && attempt != 4) break block21;
                            logger.error("Error updating General settings in the database:" + e);
                            FileBasedLogger.error("Network", "Error updating General settings in the database:" + e, user);
                            break;
                        }
                        try {
                            Thread.sleep(10000L);
                        }
                        catch (InterruptedException ie) {
                            Thread.currentThread().interrupt();
                        }
                        continue;
                    }
                }
            }
            finally {
                SQLiteConnector.closeConnection(connection);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void writeOnDbSnort(JSONObject json, String user) {
        for (int attempt = 0; attempt < 5; ++attempt) {
            PreparedStatement pstmt;
            Connection connection;
            block17: {
                connection = SQLiteConnector.getConnection();
                String snort_mode = "";
                if (json.has("snort_mode")) {
                    snort_mode = json.getString("snort_mode");
                }
                String sql = "UPDATE config_setting SET snort_mode = ? WHERE id = 1";
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, snort_mode);
                pstmt.executeUpdate();
                if (pstmt == null) break block17;
                pstmt.close();
            }
            SQLiteConnector.closeConnection(connection);
            break;
            {
                catch (Throwable throwable) {
                    try {
                        if (pstmt != null) {
                            try {
                                pstmt.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (SQLException | JSONException e) {
                        e.printStackTrace();
                        if (((SQLException)e).getErrorCode() != 5 || attempt == 4) {
                            logger.error("Error updating Snort settings in the database:" + e);
                            FileBasedLogger.error("Network", "Error updating Snort settings in the database:" + e, user);
                            SQLiteConnector.closeConnection(connection);
                            break;
                        }
                        try {
                            try {
                                Thread.sleep(10000L);
                            }
                            catch (InterruptedException ie) {
                                Thread.currentThread().interrupt();
                            }
                            continue;
                        }
                        catch (Throwable throwable3) {
                            throw throwable3;
                        }
                        finally {
                            SQLiteConnector.closeConnection(connection);
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void writeOnDbRedundancy(JSONObject json, String user) {
        for (int attempt = 0; attempt < 5; ++attempt) {
            Connection connection = SQLiteConnector.getConnection();
            try {
                String[] fieldNames;
                StringBuilder sqlBuilder = new StringBuilder("UPDATE config_setting SET");
                ArrayList<String> fieldsToUpdate = new ArrayList<String>();
                for (String fieldName : fieldNames = new String[]{"Redundancy_enable", "Redundancy_Role", "partner_ip", "common_ip0", "common_subnet0", "common_ip1", "common_subnet1", "common_ip2", "common_subnet2"}) {
                    if (!json.has(fieldName) || json.getString(fieldName).isEmpty()) continue;
                    sqlBuilder.append(" " + fieldName + " = ?,");
                    fieldsToUpdate.add(json.getString(fieldName));
                }
                if (fieldsToUpdate.size() > 0) {
                    sqlBuilder.deleteCharAt(sqlBuilder.length() - 1);
                    sqlBuilder.append(" WHERE id = 1");
                    PreparedStatement pstmt = connection.prepareStatement(sqlBuilder.toString());
                    try {
                        for (int i = 0; i < fieldsToUpdate.size(); ++i) {
                            pstmt.setString(i + 1, (String)fieldsToUpdate.get(i));
                        }
                        pstmt.executeUpdate();
                        if (pstmt == null) break;
                    }
                    catch (Throwable throwable) {
                        if (pstmt != null) {
                            try {
                                pstmt.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    pstmt.close();
                    break;
                }
                SQLiteConnector.closeConnection(connection);
                continue;
                {
                    catch (SQLException | JSONException e) {
                        block18: {
                            e.printStackTrace();
                            if (((SQLException)e).getErrorCode() == 5 && attempt != 4) break block18;
                            logger.error("Error updating Redundancy settings in the database:" + e);
                            FileBasedLogger.error("Network", "Error updating Redundancy settings in the database:" + e, user);
                            break;
                        }
                        try {
                            Thread.sleep(10000L);
                        }
                        catch (InterruptedException ie) {
                            Thread.currentThread().interrupt();
                        }
                        continue;
                    }
                }
            }
            finally {
                SQLiteConnector.closeConnection(connection);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLan0IpAddr1() {
        Connection connection = null;
        String lan0IpAddr = null;
        try {
            connection = SQLiteRestoreBackupConnector.getConnection();
            String sql = "SELECT lan0_ipaddr FROM config_setting";
            PreparedStatement statement = connection.prepareStatement(sql);
            ResultSet resultSet = statement.executeQuery();
            if (resultSet.next()) {
                lan0IpAddr = resultSet.getString("lan0_ipaddr");
            }
            resultSet.close();
            statement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            logger.error("Error while fetching lan0_ipaddr from config settings in DB: " + e);
        }
        finally {
            SQLiteRestoreBackupConnector.closeConnection(connection);
        }
        return lan0IpAddr;
    }
}

