/*
 * Decompiled with CFR 0.152.
 */
package com.tas.wp500.commandSettings;

import com.tas.wp500.commandSettings.Command;
import com.tas.wp500.fileLogSetting.FileBasedLogger;
import com.tas.wp500.security.Security;
import com.tas.wp500.sql_lite_db.SQLiteConnector;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class CommandDbOperations
extends Security {
    private static Logger logger = Logger.getLogger(CommandDbOperations.class);
    private static CommandDbOperations instance = null;
    private static final int SQLITE_BUSY = 5;
    private static final int RETRY_COUNT = 5;
    private static final int RETRY_DELAY = 10000;

    private CommandDbOperations() {
        this.createCommandTable();
    }

    public static CommandDbOperations getInstance() {
        if (instance == null) {
            instance = new CommandDbOperations();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createCommandTable() {
        Connection connection = SQLiteConnector.getConnection();
        try {
            Statement statement = connection.createStatement();
            String sql = "CREATE TABLE IF NOT EXISTS command (id INTEGER PRIMARY KEY CHECK (id = 1) , unit_id TEXT, asset_id TEXT, broker_type TEXT, broker_ip TEXT, intrval TEXT, command_tag TEXT, command_status TEXT)";
            statement.execute(sql);
            statement.close();
            logger.debug("command configuration table created successfully.");
        }
        catch (SQLException e) {
            e.printStackTrace();
            FileBasedLogger.error("Application", "Error while creating command configuration table : " + e, "system");
            logger.debug("Error while creating command configuration table : " + e);
        }
        finally {
            SQLiteConnector.closeConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject insertCommandData(JSONObject json1, String user) throws JSONException {
        JSONObject resultObj = new JSONObject();
        for (int attempt = 0; attempt < 5; ++attempt) {
            Connection connection = SQLiteConnector.getConnection();
            try {
                String id = json1.getString("id");
                String unit_id = json1.getString("unit_id");
                String asset_id = json1.getString("asset_id");
                String broker_type = json1.getString("broker_type");
                String broker_ip = json1.getString("broker_ip");
                String parsedValue = json1.getString("intrval");
                JSONArray command_tag = json1.getJSONArray("command_tag");
                String command_status = json1.getString("command_status");
                String Sql = "INSERT INTO command (id, unit_id, asset_id, broker_type, broker_ip, intrval, command_tag, command_status)VALUES (?, ?, ?, ?, ?, ?, ?, ?)";
                PreparedStatement statement = connection.prepareStatement(Sql);
                statement.setString(1, id);
                statement.setString(2, CommandDbOperations.encrypt(unit_id));
                statement.setString(3, CommandDbOperations.encrypt(asset_id));
                statement.setString(4, CommandDbOperations.encrypt(broker_type));
                statement.setString(5, CommandDbOperations.encrypt(broker_ip));
                statement.setString(6, CommandDbOperations.encrypt(parsedValue));
                statement.setString(7, CommandDbOperations.encrypt(command_tag.toString()));
                statement.setString(8, CommandDbOperations.encrypt(command_status));
                statement.executeUpdate();
                statement.close();
                resultObj.put("status", "success");
                resultObj.put("msg", "Command configuration settings has been saved successfully.");
                logger.info("Saved command configuration settings successfully.");
                FileBasedLogger.info("Audit", "Saved command configuration settings successfully.", user);
                break;
            }
            catch (SQLException e) {
                e.printStackTrace();
                if (e.getErrorCode() != 5 || attempt == 4) {
                    resultObj.put("status", "fail");
                    resultObj.put("msg", "Failed to save command configuration settings.");
                    logger.error("Error occurred while inserting command configuration data : " + e);
                    FileBasedLogger.error("Audit", "Error occurred while inserting command configuration data : " + e, user);
                    break;
                }
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
                continue;
            }
            finally {
                SQLiteConnector.closeConnection(connection);
            }
        }
        return resultObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject updateCommandData(JSONObject json1, String user) throws JSONException {
        JSONObject resultObj = new JSONObject();
        for (int attempt = 0; attempt < 5; ++attempt) {
            Connection connection = SQLiteConnector.getConnection();
            try {
                String id = json1.getString("id");
                String unit_id = json1.getString("unit_id");
                String asset_id = json1.getString("asset_id");
                String broker_type = json1.getString("broker_type");
                String broker_ip = json1.getString("broker_ip");
                String parsedValue = json1.getString("intrval");
                JSONArray command_tag = json1.getJSONArray("command_tag");
                String command_status = json1.getString("command_status");
                String sql = "UPDATE command SET unit_id = ?, asset_id = ?, broker_type = ?, broker_ip = ?, intrval = ?, command_tag = ?, command_status = ? WHERE id = ?";
                PreparedStatement statement = connection.prepareStatement(sql);
                statement.setString(1, CommandDbOperations.encrypt(unit_id));
                statement.setString(2, CommandDbOperations.encrypt(asset_id));
                statement.setString(3, CommandDbOperations.encrypt(broker_type));
                statement.setString(4, CommandDbOperations.encrypt(broker_ip));
                statement.setString(5, CommandDbOperations.encrypt(parsedValue));
                statement.setString(6, CommandDbOperations.encrypt(command_tag.toString()));
                statement.setString(7, CommandDbOperations.encrypt(command_status));
                statement.setString(8, id);
                statement.executeUpdate();
                statement.close();
                resultObj.put("status", "success");
                resultObj.put("msg", "Command configuration settings have been updated successfully.");
                logger.info("Updated Command configuration settings successfully.");
                FileBasedLogger.info("Audit", "Updated Command configuration settings successfully.", user);
                break;
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
                continue;
            }
            catch (SQLException e) {
                e.printStackTrace();
                if (e.getErrorCode() != 5 || attempt == 4) {
                    resultObj.put("status", "failed");
                    resultObj.put("msg", "Failed to update command configuration settings. ");
                    logger.error("Error occurred while updating command configuration data : " + e);
                    FileBasedLogger.error("Audit", "Error occurred while updating command configuration data : " + e, user);
                    break;
                }
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
                continue;
            }
            finally {
                SQLiteConnector.closeConnection(connection);
            }
        }
        return resultObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject deleteCommandData(JSONObject json1, String user) throws JSONException {
        JSONObject resultObj = new JSONObject();
        Connection connection = SQLiteConnector.getConnection();
        try {
            String id = json1.getString("id");
            String sql = "DELETE FROM command WHERE id = ?";
            PreparedStatement statement = connection.prepareStatement(sql);
            statement.setString(1, id);
            int rowsAffected = statement.executeUpdate();
            statement.close();
            if (rowsAffected > 0) {
                resultObj.put("msg", "Command configuration settings deleted successfully.");
                resultObj.put("status", "success");
                logger.info("Deleted command configuration settings data successfully.");
                FileBasedLogger.info("Audit", "Deleted command configuration settings data successfully.", user);
            } else {
                resultObj.put("status", "fail");
                resultObj.put("msg", "Command configuration  settings not found.");
                logger.info("Not found command configuration setting data.");
                FileBasedLogger.info("Audit", "Not found command configuration setting data.", user);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            logger.error("Error occurred while deleting command configuration settings id : " + e);
            FileBasedLogger.error("Audit", "Error occurred while deleting command configuration settings id : " + e, user);
        }
        finally {
            SQLiteConnector.closeConnection(connection);
        }
        return resultObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject getAllCommandData(JSONObject json, String user) throws JSONException {
        JSONObject resultObj = new JSONObject();
        Connection connection = SQLiteConnector.getConnection();
        try {
            String sql = "SELECT * FROM command";
            PreparedStatement statement = connection.prepareStatement(sql);
            ResultSet resultSet = statement.executeQuery();
            JSONObject commandData = new JSONObject();
            while (resultSet.next()) {
                commandData.put("id", resultSet.getString("id"));
                commandData.put("unit_id", CommandDbOperations.decrypt(resultSet.getString("unit_id")));
                commandData.put("asset_id", CommandDbOperations.decrypt(resultSet.getString("asset_id")));
                commandData.put("broker_type", CommandDbOperations.decrypt(resultSet.getString("broker_type")));
                commandData.put("broker_ip", CommandDbOperations.decrypt(resultSet.getString("broker_ip")));
                commandData.put("intrval", Integer.parseInt(CommandDbOperations.decrypt(resultSet.getString("intrval"))));
                commandData.put("command_tag", CommandDbOperations.decrypt(resultSet.getString("command_tag")));
                commandData.put("command_status", CommandDbOperations.decrypt(resultSet.getString("command_status")));
            }
            resultObj.put("result", commandData);
            resultObj.put("status", "success");
            resultObj.put("msg", "Command configuration settings fetched sucessfully.");
            logger.info("Command configuration data fetched Successfully");
            FileBasedLogger.info("Audit", "Command configuration data fetched Successfully.", user);
            resultSet.close();
            statement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            resultObj.put("status", "fail");
            resultObj.put("msg", "Error while executing command configuration.");
            logger.error("Error occurred while fetching command configuration settings : " + e);
            FileBasedLogger.error("Audit", "Error occurred while fetching command configuration settings : " + e, user);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        finally {
            SQLiteConnector.closeConnection(connection);
        }
        return resultObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<Command> getAllCommandData() throws JSONException {
        Connection connection = null;
        ArrayList<Command> commandDataList = new ArrayList<Command>();
        for (int attempt = 0; attempt < 5; ++attempt) {
            try {
                connection = SQLiteConnector.getConnection();
                String sql = "SELECT * FROM command";
                PreparedStatement statement = connection.prepareStatement(sql);
                ResultSet resultSet = statement.executeQuery();
                while (resultSet.next()) {
                    Command comand = new Command();
                    comand.setUnit_id(CommandDbOperations.decrypt(resultSet.getString("unit_id")));
                    comand.setAsset_id(CommandDbOperations.decrypt(resultSet.getString("asset_id")));
                    comand.setBroker_type(CommandDbOperations.decrypt(resultSet.getString("broker_type")));
                    comand.setBroker_ip(CommandDbOperations.decrypt(resultSet.getString("broker_ip")));
                    comand.setInterval(Integer.parseInt(CommandDbOperations.decrypt(resultSet.getString("intrval"))));
                    comand.setCommand_tag(new JSONArray(CommandDbOperations.decrypt(resultSet.getString("command_tag"))));
                    comand.setCommand_status(CommandDbOperations.decrypt(resultSet.getString("command_status")));
                    commandDataList.add(comand);
                }
                resultSet.close();
                statement.close();
                break;
            }
            catch (Exception e) {
                e.printStackTrace();
                if (((SQLException)e).getErrorCode() != 5 || attempt == 4) {
                    e.printStackTrace();
                    logger.error("Error while fetching command configuration data : " + e);
                    FileBasedLogger.error("Application", "Error while fetching command configuration data : " + e, "system");
                    break;
                }
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
                continue;
            }
            finally {
                SQLiteConnector.closeConnection(connection);
            }
        }
        return commandDataList;
    }
}

