/*
 * Decompiled with CFR 0.152.
 */
package com.tas.wp500.cgi_command;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.tas.wp500.events.EventsDbOperation;
import com.tas.wp500.fileLogSetting.FileBasedLogger;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.log4j.Logger;
import org.json.JSONException;
import org.json.JSONObject;

public class CGI_Command {
    private static Logger logger = Logger.getLogger(CGI_Command.class);
    private static CGI_Command instance = null;
    private EventsDbOperation event = EventsDbOperation.getInstance();

    private CGI_Command() {
    }

    public static CGI_Command getInstance() {
        if (instance == null) {
            instance = new CGI_Command();
        }
        return instance;
    }

    public JSONObject executeCGIgetListCommand(JSONObject json) throws JSONException {
        JSONObject resultObj = new JSONObject();
        String commandString = "QUERY_STRING=\"t5wcmd=list\" t5cgi";
        try {
            String line;
            ProcessBuilder pb = new ProcessBuilder("bash", "-c", commandString);
            pb.redirectErrorStream(true);
            Process process = pb.start();
            InputStream inputStream = process.getInputStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
            boolean foundArray = false;
            StringBuilder jsonArrayBuilder = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                if (!foundArray) {
                    if (!line.startsWith("[")) continue;
                    foundArray = true;
                    jsonArrayBuilder.append(line);
                    continue;
                }
                jsonArrayBuilder.append(line);
            }
            int exitValue = process.waitFor();
            if (exitValue == 0) {
                resultObj.put("status", "Success");
                resultObj.put("result", jsonArrayBuilder);
            } else {
                resultObj.put("status", "Fail");
                resultObj.put("result", jsonArrayBuilder);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(" Error occurred while fetching tag list from cgi command : " + e);
            FileBasedLogger.error("Application", "Error occurred while fetching tag list from cgi command : " + e, "system");
            resultObj.put("status", "Fail");
        }
        return resultObj;
    }

    public JSONObject readMultiplevariableUsingCGICommand(JSONObject json) throws JSONException {
        JSONObject resultObj = new JSONObject();
        String commandString = json.getString("commandString");
        try {
            String line;
            ProcessBuilder pb = new ProcessBuilder("bash", "-c", commandString);
            pb.redirectErrorStream(true);
            Process process = pb.start();
            InputStream inputStream = process.getInputStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
            boolean foundArray = false;
            StringBuilder jsonArrayBuilder = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                if (!foundArray) {
                    if (!line.startsWith("[")) continue;
                    foundArray = true;
                    jsonArrayBuilder.append(line);
                    continue;
                }
                jsonArrayBuilder.append(line);
            }
            int exitValue = process.waitFor();
            if (exitValue == 0) {
                resultObj.put("status", "Success");
                resultObj.put("result", jsonArrayBuilder);
            } else {
                resultObj.put("status", "Fail");
                resultObj.put("result", jsonArrayBuilder);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.debug(" Error occurred while fetching tag list read data from cgi command : " + e);
            json.put("status", "Fail");
        }
        return resultObj;
    }

    public boolean writeOnVariableUsingCommand(String commandString) {
        JSONObject json = null;
        try {
            String line;
            json = new JSONObject();
            ProcessBuilder pb = new ProcessBuilder("bash", "-c", commandString);
            pb.redirectErrorStream(true);
            Process process = pb.start();
            InputStream inputStream = process.getInputStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
            StringBuilder jsonLines = new StringBuilder();
            boolean jsonStarted = false;
            while ((line = reader.readLine()) != null) {
                logger.debug("Command output: " + line);
                if (line.trim().startsWith("{")) {
                    jsonStarted = true;
                }
                if (!jsonStarted) continue;
                jsonLines.append(line);
            }
            if (jsonLines.length() == 0) {
                logger.error("Empty output from command execution.");
                return false;
            }
            String jsonString = jsonLines.toString();
            logger.debug("Complete command output: " + jsonString);
            ObjectMapper objectMapper = new ObjectMapper();
            JsonNode jsonNode = objectMapper.readTree(jsonString);
            if (jsonNode.has("cmd") && jsonNode.has("data") && jsonNode.has("error") && jsonNode.has("errorTxt")) {
                String cmd = jsonNode.get("cmd").asText();
                JsonNode data = jsonNode.get("data");
                int error = jsonNode.get("error").asInt();
                String errorTxt = jsonNode.get("errorTxt").asText();
                json.put("cmd", cmd);
                json.put("data", data);
                json.put("error", error);
                json.put("errorTxt", errorTxt);
                logger.debug("Parsed JSON: " + json.toString());
                this.event.insertEvent(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()), "Command Write", "Success", json.toString());
                return error == 200;
            }
            logger.error("Invalid JSON structure: " + jsonString);
        }
        catch (Exception e) {
            logger.error("Error while writing Command request: ", e);
        }
        return false;
    }
}

