/*
 * Decompiled with CFR 0.152.
 */
package com.tas.wp500.banner;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class BannerService {
    private static Logger logger = Logger.getLogger(BannerService.class);
    private static BannerService instanceBannerService;
    private static final String BANNER_FILE_LOCATION = "/etc/ssh/Banner.txt";

    private BannerService() {
    }

    public static BannerService getInstance() {
        if (instanceBannerService == null) {
            instanceBannerService = new BannerService();
        }
        return instanceBannerService;
    }

    public JSONObject readBannerFile(String user) throws JSONException {
        JSONObject resultObject = new JSONObject();
        JSONArray linesBetweenHashes = null;
        try {
            linesBetweenHashes = new JSONArray();
            boolean insideHashBlock = false;
            try (BufferedReader reader = new BufferedReader(new FileReader(BANNER_FILE_LOCATION));){
                String line;
                while ((line = reader.readLine()) != null) {
                    if (line.trim().equals("#")) {
                        insideHashBlock = !insideHashBlock;
                        linesBetweenHashes.put(line);
                        continue;
                    }
                    if (insideHashBlock) {
                        linesBetweenHashes.put(line);
                        continue;
                    }
                    linesBetweenHashes.put(line);
                }
                resultObject.put("data", linesBetweenHashes);
                resultObject.put("status", "success");
                resultObject.put("msg", "Text content from the Banner file has been successfully read. ");
            }
        }
        catch (Exception e) {
            resultObject.put("status", "fail");
            resultObject.put("msg", "Failed to read text from the Banner file.");
            e.printStackTrace();
            logger.error(" Error occurred while reading banner file : " + e.getMessage());
        }
        return resultObject;
    }

    public JSONObject writeBackUpdatedLines(JSONObject json, String user) throws JSONException {
        JSONObject resultObject = new JSONObject();
        ArrayList<String> modifiedLines = new ArrayList<String>();
        try {
            if (json.has("data")) {
                JSONArray dataArray = json.getJSONArray("data");
                for (int i = 0; i < dataArray.length(); ++i) {
                    String value = dataArray.getString(i);
                    modifiedLines.add(value);
                }
                this.writeLinesToFile(modifiedLines);
                resultObject.put("status", "success");
                resultObject.put("msg", "Text in the Banner file has been successfully updated.");
                logger.info("Successfully update text in banner file.");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            resultObject.put("status", "fail");
            resultObject.put("msg", "Failed to update text in banner file. ");
            logger.error(" Error occurred while updating banner file : " + e);
        }
        return resultObject;
    }

    public List<String> modifyLinesBetweenHashes(JSONArray dataArray) {
        ArrayList<String> modifiedLines = new ArrayList<String>();
        try {
            boolean insideHashBlock = false;
            try (BufferedReader reader = new BufferedReader(new FileReader(BANNER_FILE_LOCATION));){
                String line;
                int flag = 0;
                while ((line = reader.readLine()) != null) {
                    if (line.trim().equals("#")) {
                        insideHashBlock = !insideHashBlock;
                        modifiedLines.add(line);
                        continue;
                    }
                    if (insideHashBlock) {
                        String valString = dataArray.getString(flag);
                        modifiedLines.add(valString);
                        ++flag;
                        continue;
                    }
                    modifiedLines.add(line);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return modifiedLines;
    }

    private void writeLinesToFile(List<String> modifiedLines) throws IOException {
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(BANNER_FILE_LOCATION));){
            for (String line : modifiedLines) {
                writer.write(line);
                writer.newLine();
            }
        }
    }
}

