/*
 * Decompiled with CFR 0.152.
 */
package com.tas.wp500.backup_restore;

import com.tas.wp500.security.Security;
import com.tas.wp500.sql_lite_db.SQLiteConnector;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class RestoreUser
extends Security {
    private static RestoreUser instance = null;
    private static Logger logger = Logger.getLogger(RestoreUser.class);

    public static RestoreUser getInstance() {
        if (instance == null) {
            instance = new RestoreUser();
        }
        return instance;
    }

    public void createUserIfNotExistsInLinux() {
        Map<String, String> usersFromDB = this.getAllUsersCredentials();
        for (Map.Entry<String, String> entry : usersFromDB.entrySet()) {
            String username = entry.getKey();
            String password = entry.getValue();
            if (!this.userExistsInLinux(username)) {
                String userRole = this.getUserRoleByUsername(username);
                logger.info("userRole - " + userRole);
                if (!userRole.equalsIgnoreCase("superuser")) {
                    this.createLinuxUser(username, password, userRole);
                    continue;
                }
                if (!userRole.equalsIgnoreCase("superuser")) continue;
                this.deleteUserByUsername(username);
                continue;
            }
            logger.info("User " + username + "  already exists in Linux.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getAllUsersCredentials() {
        HashMap<String, String> userCredentials = new HashMap<String, String>();
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            connection = SQLiteConnector.getConnection();
            if (connection != null) {
                String sql = "SELECT username, password FROM user";
                statement = connection.createStatement();
                resultSet = statement.executeQuery(sql);
                while (resultSet.next()) {
                    String username = resultSet.getString("username");
                    String password = resultSet.getString("password");
                    userCredentials.put(RestoreUser.decrypt(username), RestoreUser.decrypt(password));
                }
            }
            resultSet.close();
            statement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            logger.error("Error occurred while retrieving user credentials : " + e.getMessage());
        }
        finally {
            SQLiteConnector.closeConnection(connection);
        }
        return userCredentials;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean userExistsInLinux(String username) {
        Process process = null;
        BufferedReader reader = null;
        try {
            ProcessBuilder pb = new ProcessBuilder("id", "-u", username);
            pb.redirectInput(ProcessBuilder.Redirect.PIPE);
            pb.redirectOutput(ProcessBuilder.Redirect.PIPE);
            pb.redirectError(ProcessBuilder.Redirect.PIPE);
            process = pb.start();
            reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String line = reader.readLine();
            boolean bl = line != null && !line.isEmpty();
            return bl;
        }
        catch (IOException e) {
            e.printStackTrace();
            logger.error("Error occurred while checking user existence in Linux: " + e.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (process != null) {
                process.destroy();
            }
        }
    }

    private void createLinuxUser(String username, String password, String userRole) {
        try {
            ProcessBuilder pb = new ProcessBuilder("adduser", username);
            pb.redirectInput(ProcessBuilder.Redirect.PIPE);
            pb.redirectOutput(ProcessBuilder.Redirect.PIPE);
            pb.redirectError(ProcessBuilder.Redirect.PIPE);
            Process p = pb.start();
            p.getOutputStream().write((password + "\n").getBytes());
            p.getOutputStream().write((password + "\n").getBytes());
            p.getOutputStream().write("\n".getBytes());
            p.getOutputStream().write("\n".getBytes());
            p.getOutputStream().write("\n".getBytes());
            p.getOutputStream().flush();
            int exitCode = p.waitFor();
            if (exitCode == 0) {
                this.addUserToGroup(username, userRole);
                this.disableTotpForUser(username);
            } else {
                logger.error("Failed to create user '" + username + "' in Linux.");
            }
        }
        catch (IOException | InterruptedException e) {
            e.printStackTrace();
            logger.error("Error occurred while creating user '" + username + "' in Linux : " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disableTotpForUser(String username) {
        Connection connection = SQLiteConnector.getConnection();
        try {
            if (connection != null) {
                String sql = "UPDATE user SET totp_authenticator = ?, first_login = ? WHERE username = ?";
                PreparedStatement statement = connection.prepareStatement(sql);
                statement.setString(1, RestoreUser.encrypt("disable"));
                statement.setString(2, RestoreUser.encrypt("true"));
                statement.setString(3, RestoreUser.encrypt(username));
                int rowsUpdated = statement.executeUpdate();
                statement.close();
                if (rowsUpdated > 0) {
                    logger.info("Totp_authenticator disabled and first_login modified for user : " + username);
                } else {
                    logger.info("User '" + username + "' not found or totp_authenticator is already disabled.");
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            logger.error("Error occurred while disabling Totp_authenticator and modifying first_login for user : " + username);
        }
        finally {
            SQLiteConnector.closeConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getUserRoleByUsername(String username) {
        String userRole = null;
        Connection connection = null;
        Statement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            connection = SQLiteConnector.getConnection();
            if (connection != null) {
                String sql = "SELECT role FROM user WHERE username = ?";
                preparedStatement = connection.prepareStatement(sql);
                preparedStatement.setString(1, RestoreUser.encrypt(username));
                resultSet = preparedStatement.executeQuery();
                if (resultSet.next()) {
                    userRole = resultSet.getString("role");
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            logger.error("Error occurred while retrieving user role : " + e.getMessage());
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            SQLiteConnector.closeConnection(connection);
        }
        return RestoreUser.decrypt(userRole);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addUserToGroup(String username, String role) throws IOException, InterruptedException {
        String groupName = "admin".equalsIgnoreCase(role) ? "adm" : ("operator".equalsIgnoreCase(role) || "viewer".equalsIgnoreCase(role) ? "operator" : null);
        if (groupName != null) {
            String[] command = new String[]{"usermod", "-aG", groupName, username};
            ProcessBuilder processBuilder = new ProcessBuilder(command);
            Process process = null;
            try {
                process = processBuilder.start();
                int exitCode = process.waitFor();
                if (exitCode == 0) {
                }
                logger.error("Failed to add user to the group : " + groupName + " " + username);
            }
            catch (IOException e) {
                logger.error("Error while executing command to add user to group : " + e.getMessage());
            }
            finally {
                if (process != null) {
                    process.destroy();
                }
            }
        } else {
            logger.error("Invalid role provided : " + role);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAllRecordsFromTables() {
        Connection connection = SQLiteConnector.getConnection();
        try {
            connection.setAutoCommit(false);
            this.executeUpdate(connection, "DELETE FROM file_integrity");
            this.executeUpdate(connection, "DELETE FROM file_acknowledge");
            connection.commit();
            logger.info("All records deleted from file_integrity and file_acknowledge tables successfully.");
        }
        catch (SQLException e) {
            try {
                connection.rollback();
                logger.debug("Transaction rolled back due to error: " + e);
            }
            catch (SQLException rollbackEx) {
                logger.debug("Error while rolling back transaction: " + rollbackEx);
            }
            logger.debug("Error while deleting records from tables: " + e);
        }
        finally {
            SQLiteConnector.closeConnection(connection);
        }
    }

    private void executeUpdate(Connection connection, String sql) throws SQLException {
        try (Statement statement = connection.createStatement();){
            statement.executeUpdate(sql);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteUserByUsername(String username) {
        boolean isDeleted = false;
        Connection connection = null;
        Statement preparedStatement = null;
        try {
            connection = SQLiteConnector.getConnection();
            if (connection != null) {
                String sql = "DELETE FROM user WHERE username = ?";
                preparedStatement = connection.prepareStatement(sql);
                preparedStatement.setString(1, RestoreUser.encrypt(username));
                int rowsAffected = preparedStatement.executeUpdate();
                if (rowsAffected > 0) {
                    isDeleted = true;
                    logger.info("User with username: " + username + " was successfully deleted.");
                } else {
                    logger.warn("No user found with username: " + username);
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            logger.error("Error occurred while deleting user : " + e.getMessage());
        }
        finally {
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            SQLiteConnector.closeConnection(connection);
        }
        return isDeleted;
    }
}

