/*
 * Decompiled with CFR 0.152.
 */
package com.tas.wp500.backup_restore;

import com.tas.wp500.backup_restore.RestoreUser;
import com.tas.wp500.fileLogSetting.FileBasedLogger;
import com.tas.wp500.linx_command.FileReaderUtil;
import com.tas.wp500.sql_lite_db.SQLiteRestoreBackupConnector;
import com.tas.wp500.ssl_certificate_manager.ServerXmlModifier;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.security.Key;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.crypto.Cipher;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.log4j.Logger;
import org.json.JSONException;
import org.json.JSONObject;

public class Restore {
    private static Restore instance = null;
    private RestoreUser restoreUser = RestoreUser.getInstance();
    private static Logger logger = Logger.getLogger(Restore.class);
    private static String[] fileNames = new String[]{"t5.cod", "keystore.jks", "certificate.crt", "wp_500DbFile.db"};
    private static String sourceDirectory = "/data/wp500_backup/backup/crt_files";
    private static String destinationDirectory = "/usr/bin/crt_files/";
    private static String destinationFolderPath = "/data/wp500_backup/backup";
    private static String zipFilePath = "/data/wp500_backup/backup.zip";
    private static final String DELIMITER = "FILE_SEPARATOR";
    private static final String NAME_SEPARATOR = "NAME_SEPARATOR";
    private static final int GCM_NONCE_LENGTH = 12;
    private static final int GCM_TAG_LENGTH = 16;
    public static final String CONFIG_PATH = "/etc/wp500cfg/config.ini";

    public static Restore getInstance() {
        if (instance == null) {
            instance = new Restore();
        }
        return instance;
    }

    public JSONObject restoreBackupFile(String user, JSONObject json) throws JSONException {
        JSONObject resultObject;
        block11: {
            resultObject = new JSONObject();
            Path zipPath = Paths.get(zipFilePath, new String[0]);
            Path destinationPath = Paths.get(destinationFolderPath, new String[0]);
            try {
                String key = null;
                if (!json.has("backup_key")) {
                    resultObject.put("status", "success");
                    resultObject.put("msg", "Backup key is not found.");
                    return resultObject;
                }
                key = json.getString("backup_key");
                logger.info("backup_key--> " + key);
                String inputFile = "/data/wp500_backup/encryptedfile.enc";
                String outputDir = "/data/wp500_backup/backup";
                if (Restore.isKeyValid(key, inputFile)) {
                    logger.info("Backup Key is valid for decrypting file : " + inputFile);
                    FileBasedLogger.info("Audit", "Backup Key is valid", user);
                    try {
                        Restore.decryptFiles(key, inputFile, outputDir);
                        logger.debug("Files successfully decrypted to directory " + outputDir);
                        if (Files.exists(zipPath, new LinkOption[0])) {
                            Restore.unZipBackupFolder(zipFilePath, destinationFolderPath);
                            logger.debug("Backup unzipped successfully.");
                            Thread.sleep(500L);
                            String[] filesToCheck = new String[]{"keystore.jks", "certificate.crt", "wp_500DbFile.db"};
                            if (Files.exists(destinationPath, new LinkOption[0])) {
                                boolean allFilesExist = Restore.checkAllFilesExist(destinationFolderPath, filesToCheck);
                                if (allFilesExist) {
                                    resultObject.put("status", "success");
                                    resultObject.put("msg", "All required backup files are present.");
                                    logger.info("All required backup files are present in the directory.");
                                    FileBasedLogger.info("Audit", "All required backup files are present in the directory.", user);
                                    Restore.copyAllFileToDestination();
                                    logger.info("Files copied successfully.");
                                    FileBasedLogger.info("Audit", "Files copied successfully.", user);
                                    Thread.sleep(2000L);
                                    this.restoreUser.createUserIfNotExistsInLinux();
                                    logger.info("User restored successfully.");
                                    FileBasedLogger.info("Audit", "User restored successfully.", user);
                                    boolean resultIpBind = this.setLan0IpToIpBind();
                                    if (resultIpBind) {
                                        Restore.writeConfigFileDataUsingDB();
                                        logger.info("Config File restored successfully.");
                                        FileBasedLogger.info("Audit", "Config File restored successfully.", user);
                                        resultObject.put("status", "success");
                                        resultObject.put("msg", "Backup has been successfully restored.");
                                        logger.info("Backup has been successfully restored.");
                                        FileBasedLogger.info("Audit", "Backup has been successfully restored.", user);
                                        return this.rebootSystem(this.getLan0IpAddr(), "Backup has been successfully restored. System is rebooting. Please wait...", user);
                                    }
                                    FileBasedLogger.error("Audit", "Error while restoring lan configuration.", user);
                                    logger.info("Error while restoring lan configuration.");
                                    resultObject.put("status", "success");
                                    resultObject.put("msg", "Backup has been successfully restored.");
                                    FileBasedLogger.info("Audit", "Backup has been successfully restored.", user);
                                    logger.info("Backup has been successfully restored.");
                                } else {
                                    resultObject.put("status", "success");
                                    resultObject.put("msg", "Not all required backup files are present.");
                                    FileBasedLogger.info("Audit", "Some required backup files are missing in the directory.", user);
                                    logger.info("Some required backup files are missing in the directory.");
                                }
                                return resultObject;
                            }
                            resultObject.put("status", "success");
                            resultObject.put("msg", "Backup ZIP file could not be located.");
                            logger.info("Backup ZIP file could not be located.");
                            FileBasedLogger.info("Audit", "Backup ZIP file could not be located.", user);
                            break block11;
                        }
                        resultObject.put("status", "fail");
                        resultObject.put("msg", "Backup ZIP file could not be located.");
                        logger.info("Backup ZIP file not found at : " + zipFilePath);
                        FileBasedLogger.info("Audit", "Backup ZIP file not found at : " + zipFilePath, user);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        logger.error("Error occurred while decrypting backup file: " + e.getMessage());
                        FileBasedLogger.error("Audit", "Error occurred while decrypting backup file: " + e.getMessage(), user);
                    }
                    break block11;
                }
                resultObject.put("status", "success");
                resultObject.put("msg", "Backup key is not valid.");
                logger.info("Invalid decryption key for file: " + inputFile);
                FileBasedLogger.info("Audit", "Invalid decryption key for file: " + inputFile, user);
            }
            catch (Exception e) {
                resultObject.put("status", "fail");
                resultObject.put("msg", "Error occurred while restoring the backup process.");
                logger.error("Error occurred during backup restoration process: " + e.getMessage());
                FileBasedLogger.error("Audit", "Error occurred during backup restoration process: " + e.getMessage(), user);
            }
        }
        return resultObject;
    }

    public JSONObject restoreBackupFile1(String user, String key) throws JSONException {
        JSONObject resultObject;
        block9: {
            resultObject = new JSONObject();
            Path zipPath = Paths.get(zipFilePath, new String[0]);
            Path destinationPath = Paths.get(destinationFolderPath, new String[0]);
            try {
                if (!Restore.isValidAESKey(key)) {
                    logger.info("Invalid AES key format.");
                }
                String inputFile = "/data/wp500_backup/encryptedfile.enc";
                String outputDir = "/data/wp500_backup/backup";
                if (Restore.isKeyValid(key, inputFile)) {
                    logger.info("Key is valid for decrypting " + inputFile);
                    try {
                        Restore.decryptFiles(key, inputFile, outputDir);
                        logger.info("Files successfully decrypted to directory " + outputDir);
                        if (Files.exists(zipPath, new LinkOption[0])) {
                            Restore.unZipBackupFolder(zipFilePath, destinationFolderPath);
                            logger.info("Backup unzipped successfully.");
                            Thread.sleep(500L);
                            String[] filesToCheck = new String[]{"keystore.jks", "certificate.crt", "wp_500DbFile.db"};
                            if (Files.exists(destinationPath, new LinkOption[0])) {
                                boolean allFilesExist = Restore.checkAllFilesExist(destinationFolderPath, filesToCheck);
                                if (allFilesExist) {
                                    resultObject.put("status", "success");
                                    resultObject.put("msg", "Backup File is valid.");
                                    logger.info("All files exist in directory: " + allFilesExist);
                                    return resultObject;
                                }
                                resultObject.put("status", "success");
                                resultObject.put("msg", "Backup File is not exist.");
                                return resultObject;
                            }
                            resultObject.put("status", "success");
                            resultObject.put("msg", "Backup ZIP file could not be located.");
                            return resultObject;
                        }
                        resultObject.put("status", "fail");
                        resultObject.put("msg", "Backup ZIP file could not be located.");
                        logger.info(user + " - Backup ZIP file not found at : " + zipFilePath);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        logger.error("Error while decrypt backup file : " + e.getLocalizedMessage());
                    }
                    break block9;
                }
                resultObject.put("status", "success");
                resultObject.put("msg", " provided Key is not valid for decrypting File : " + inputFile);
                logger.info("Key is not valid for decrypting " + inputFile);
                return resultObject;
            }
            catch (Exception e) {
                resultObject.put("status", "fail");
                resultObject.put("msg", "Unexpected error occurred during the restoration of the backup. ");
                logger.error(user + " - Error during backup restoration", e);
            }
        }
        logger.info("resultObj----->" + resultObject);
        return resultObject;
    }

    private static boolean checkAllFilesExist(String directoryPath, String[] filesToCheck) {
        for (String fileName : filesToCheck) {
            String filePath = directoryPath + "/" + fileName;
            if (!(fileName.equals("crt_files") ? !Restore.directoryExists(filePath) : !Restore.fileExists(filePath))) continue;
            return false;
        }
        return true;
    }

    private static boolean directoryExists(String directoryPath) {
        Path path = Paths.get(directoryPath, new String[0]);
        return Files.exists(path, new LinkOption[0]) && Files.isDirectory(path, new LinkOption[0]);
    }

    private static boolean fileExists(String filePath) {
        Path path = Paths.get(filePath, new String[0]);
        return Files.exists(path, new LinkOption[0]) && Files.isRegularFile(path, new LinkOption[0]);
    }

    public static void copyAllFileToDestination() {
        HashMap<String, String> fileToDirectoryMap = new HashMap<String, String>();
        fileToDirectoryMap.put("t5.cod", "/etc/wp500cfg/t5cod/");
        fileToDirectoryMap.put("keystore.jks", "/opt/apache-tomcat-9.0.85/conf/");
        fileToDirectoryMap.put("certificate.crt", "/opt/apache-tomcat-9.0.85/conf/");
        fileToDirectoryMap.put("wp_500DbFile.db", "/usr/bin/");
        try {
            Restore.copyFolder(sourceDirectory, destinationDirectory);
            Restore.copyFiles(fileNames, fileToDirectoryMap);
        }
        catch (IOException e) {
            e.printStackTrace();
            FileBasedLogger.error("Audit", "Error while copying files : " + e.getMessage(), "system");
            logger.debug("Error while copying files : " + e.getMessage());
        }
    }

    public static void copyFiles(String[] fileNames, Map<String, String> fileToDirectoryMap) {
        for (String fileName : fileNames) {
            String targetDirectory = fileToDirectoryMap.get(fileName);
            if (targetDirectory != null) {
                Path sourcePath = Paths.get("/data/wp500_backup/backup/" + fileName, new String[0]);
                Path destinationPath = Paths.get(targetDirectory, fileName);
                File sourceFile = sourcePath.toFile();
                File destinationFile = destinationPath.toFile();
                File backupDir = new File(targetDirectory);
                if (!backupDir.exists() && backupDir.mkdirs()) {
                    logger.info("Created directory: " + backupDir.getAbsolutePath());
                }
                Restore.copyFileToDestination(sourceFile, destinationFile);
                continue;
            }
            logger.warn("No destination found for file :" + fileName);
        }
    }

    private static void copyFolder(String sourceDirectory, String destinationDirectory) throws IOException {
        final Path sourcePath = Paths.get(sourceDirectory, new String[0]);
        final Path destinationPath = Paths.get(destinationDirectory, new String[0]);
        if (!Files.exists(destinationPath, new LinkOption[0])) {
            Files.createDirectories(destinationPath, new FileAttribute[0]);
        }
        Files.walkFileTree(sourcePath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                Path targetDir = destinationPath.resolve(sourcePath.relativize(dir));
                Files.createDirectories(targetDir, new FileAttribute[0]);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.copy(file, destinationPath.resolve(sourcePath.relativize(file)), StandardCopyOption.REPLACE_EXISTING);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public static void unZipBackupFolder(String zipFilePath, String destinationFolderPath) {
        File destDir = new File(destinationFolderPath);
        if (!destDir.exists()) {
            destDir.mkdirs();
        }
        try (ZipInputStream zipInputStream = new ZipInputStream(new FileInputStream(zipFilePath));){
            ZipEntry entry;
            while ((entry = zipInputStream.getNextEntry()) != null) {
                String entryName = entry.getName();
                File file = new File(destDir, entryName);
                if (entry.isDirectory()) {
                    file.mkdirs();
                    continue;
                }
                File parent = file.getParentFile();
                if (parent != null && !parent.exists()) {
                    parent.mkdirs();
                }
                try (BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(file));){
                    int read;
                    byte[] buffer = new byte[1024];
                    while ((read = zipInputStream.read(buffer)) != -1) {
                        bos.write(buffer, 0, read);
                    }
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            FileBasedLogger.error("Audit", "Error occurred while unzipping files : " + e.getMessage(), "system");
            logger.debug("Error occurred while unzipping files : " + e.getMessage());
        }
    }

    public static void decryptFiles(String key, String inputFile, String outputDir) {
        try {
            SecretKeySpec secretKey = new SecretKeySpec(Base64.getDecoder().decode(key), "AES");
            byte[] fileContent = Files.readAllBytes(Paths.get(inputFile, new String[0]));
            byte[] nonce = Arrays.copyOfRange(fileContent, 0, 12);
            byte[] encryptedBytes = Arrays.copyOfRange(fileContent, 12, fileContent.length);
            Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
            GCMParameterSpec gcmParameterSpec = new GCMParameterSpec(128, nonce);
            cipher.init(2, (Key)secretKey, gcmParameterSpec);
            byte[] decryptedBytes = cipher.doFinal(encryptedBytes);
            List<FileData> filesData = Restore.splitCombinedBytes(decryptedBytes);
            Path outputDirectoryPath = Paths.get(outputDir, new String[0]);
            if (!Files.exists(outputDirectoryPath, new LinkOption[0])) {
                Files.createDirectories(outputDirectoryPath, new FileAttribute[0]);
            }
            for (FileData fileData : filesData) {
                Path outputPath = outputDirectoryPath.resolve(fileData.fileName);
                Files.createDirectories(outputPath.getParent(), new FileAttribute[0]);
                try (FileOutputStream outputStream = new FileOutputStream(outputPath.toFile());){
                    outputStream.write(fileData.fileBytes);
                }
            }
        }
        catch (Exception e) {
            FileBasedLogger.error("Audit", "Error while decrypting file: " + e.getMessage(), "system");
            logger.debug("Error while decrypting file: " + e.getMessage());
        }
    }

    private static List<FileData> splitCombinedBytes(byte[] combinedBytes) {
        try {
            ArrayList<FileData> filesData = new ArrayList<FileData>();
            byte[] delimiterBytes = DELIMITER.getBytes();
            byte[] nameSeparatorBytes = NAME_SEPARATOR.getBytes();
            int start = 0;
            if (start < combinedBytes.length) {
                int nameEndIndex = Restore.indexOf(combinedBytes, nameSeparatorBytes, start);
                String fileName = new String(Arrays.copyOfRange(combinedBytes, start, nameEndIndex));
                start = nameEndIndex + nameSeparatorBytes.length;
                int fileEndIndex = Restore.indexOf(combinedBytes, delimiterBytes, start);
                byte[] fileBytes = Arrays.copyOfRange(combinedBytes, start, fileEndIndex);
                start = fileEndIndex + delimiterBytes.length;
                filesData.add(new FileData(fileName, fileBytes));
                return filesData;
            }
        }
        catch (Exception e) {
            FileBasedLogger.error("Application", "Error while use split combined for decrypt file :" + e.getLocalizedMessage(), "system");
            logger.debug("Error while use split combined for decrypt file :" + e.getLocalizedMessage());
        }
        return null;
    }

    private static int indexOf(byte[] array, byte[] target, int start) {
        block0: for (int i = start; i <= array.length - target.length; ++i) {
            for (int j = 0; j < target.length; ++j) {
                if (array[i + j] != target[j]) continue block0;
            }
            return i;
        }
        return -1;
    }

    private static boolean isValidAESKey(String key) {
        try {
            byte[] keyBytes = Base64.getDecoder().decode(key);
            return keyBytes.length == 16 || keyBytes.length == 24 || keyBytes.length == 32;
        }
        catch (IllegalArgumentException e) {
            logger.debug("Error while check key is valid or not : " + e.getLocalizedMessage());
            return false;
        }
    }

    public static boolean isKeyValid(String key, String inputFile) {
        String tempOutputDir = "/data/wp500_backup/temp_output";
        try {
            Restore.decryptFiles(key, inputFile, tempOutputDir);
            Files.walk(Paths.get(tempOutputDir, new String[0]), new FileVisitOption[0]).sorted((a, b) -> b.compareTo((Path)a)).forEach(path -> path.toFile().delete());
            return true;
        }
        catch (Exception e) {
            logger.debug("Error while test key : " + e.getLocalizedMessage());
            return false;
        }
    }

    public JSONObject rebootSystem(String bindIpAddress, String customMessage, final String user) throws JSONException {
        final JSONObject json = new JSONObject();
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(150L);
                    Process process = Runtime.getRuntime().exec("reboot");
                    int exitStatus = process.waitFor();
                    if (exitStatus == 0) {
                        logger.info("Rebooting the system.");
                        FileBasedLogger.info("Application", "Rebooting the system.", user);
                    } else {
                        logger.error("Failed to reboot the system.");
                        FileBasedLogger.error("Application", "Failed to reboot the system.", user);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    logger.error("Error occurred while rebooting the system. " + e.getMessage());
                    FileBasedLogger.error("Application", "Error occurred while rebooting the system. " + e.getMessage(), user);
                    try {
                        json.put("status", "error");
                        json.put("msg", "Error occurred while rebooting the system.");
                    }
                    catch (JSONException e1) {
                        e1.printStackTrace();
                    }
                }
            }
        }).start();
        try {
            String fullMessage = customMessage + " You can log in with the IP address: " + bindIpAddress;
            json.put("status", "success");
            json.put("msg", fullMessage);
        }
        catch (JSONException e) {
            FileBasedLogger.error("Application", "Error occurred while creating JSON response. " + e.getMessage(), user);
            logger.error("Error occurred while creating JSON response. " + e.getMessage());
            json.put("status", "fail");
            json.put("msg", "Failed to reboot the system.");
        }
        return json;
    }

    private static void copyFileToDestination(File sourceFile, File destinationFile) {
        if (!sourceFile.exists()) {
            logger.error("Source file does not exist: " + sourceFile.getAbsolutePath());
            return;
        }
        long fileSize = sourceFile.length();
        int bufferSize = fileSize > 0xA00000L ? 8192 : 1024;
        try (FileInputStream inStream = new FileInputStream(sourceFile);
             FileOutputStream outStream = new FileOutputStream(destinationFile);){
            int bytesRead;
            logger.info("Starting to copy file from " + sourceFile.getAbsolutePath() + " to " + destinationFile.getAbsolutePath());
            byte[] buffer = new byte[bufferSize];
            while ((bytesRead = ((InputStream)inStream).read(buffer)) > 0) {
                ((OutputStream)outStream).write(buffer, 0, bytesRead);
            }
            logger.info("Successfully copied file from " + sourceFile.getAbsolutePath() + " to " + destinationFile.getAbsolutePath());
        }
        catch (FileNotFoundException e) {
            logger.error("File not found during copy: " + e.getMessage());
        }
        catch (IOException e) {
            logger.error("IOException while copying file from " + sourceFile.getAbsolutePath() + " to " + destinationFile.getAbsolutePath() + " to " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> getConfigSettings() {
        Connection connection = null;
        HashMap<String, String> configSettings = new HashMap<String, String>();
        try {
            connection = SQLiteRestoreBackupConnector.getConnection();
            String sql = "SELECT * FROM config_setting";
            PreparedStatement statement = connection.prepareStatement(sql);
            ResultSet resultSet = statement.executeQuery();
            if (resultSet.next()) {
                ResultSetMetaData metaData = resultSet.getMetaData();
                int columnCount = metaData.getColumnCount();
                for (int i = 1; i <= columnCount; ++i) {
                    String columnName = metaData.getColumnName(i);
                    String columnValue = resultSet.getString(i);
                    if (columnName.equalsIgnoreCase("id")) continue;
                    configSettings.put(columnName.trim(), columnValue.trim());
                }
            }
            resultSet.close();
            statement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            logger.error("Error while fetching config settings in DB: " + e);
        }
        finally {
            SQLiteRestoreBackupConnector.closeConnection(connection);
        }
        return configSettings;
    }

    public static void writeConfigFileDataUsingDB() throws IOException, JSONException {
        Map<String, String> existingConfigValues = Restore.getConfigSettings();
        File file = new File(CONFIG_PATH);
        try (BufferedReader reader = new BufferedReader(new FileReader(file));){
            String line;
            StringBuilder content = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                boolean lineUpdated = false;
                for (Map.Entry<String, String> entry : existingConfigValues.entrySet()) {
                    String key = entry.getKey();
                    String newValue = entry.getValue();
                    if (!line.startsWith(key + " =") || !line.contains(key)) continue;
                    line = key.equalsIgnoreCase("Redundancy_enable") && !newValue.isEmpty() ? "Redundancy_enable = " + newValue + "           ; integer 1: enable 0:disable" : (key.equalsIgnoreCase("Redundancy_Role") && !newValue.isEmpty() ? "Redundancy_Role = " + newValue + "             ; integer 1:Primary 0:secondary" : (key.equalsIgnoreCase("partner_ip") && !newValue.isEmpty() ? "partner_ip = " + newValue + "           ; partner ip address" : (key.equalsIgnoreCase("common_ip0") && !newValue.isEmpty() ? "common_ip0 = " + newValue + "           ; lan0 common ip address" : (key.equalsIgnoreCase("common_subnet0") && !newValue.isEmpty() ? "common_subnet0 = " + newValue + "           ; lan0 common ip subnet" : (key.equalsIgnoreCase("common_ip1") && !newValue.isEmpty() ? "common_ip1 = " + newValue + "           ; lan1 common ip address" : (key.equalsIgnoreCase("common_subnet1") && !newValue.isEmpty() ? "common_subnet1 = " + newValue + "           ; lan1 common ip subnet" : (key.equalsIgnoreCase("common_ip2") && !newValue.isEmpty() ? "common_ip2 = " + newValue + "           ; lan2 common ip address" : (key.equalsIgnoreCase("common_subnet2") && !newValue.isEmpty() ? "common_subnet2 = " + newValue + "           ; lan2 common ip subnet" : key + " = " + newValue))))))));
                    content.append(line).append(System.lineSeparator());
                    lineUpdated = true;
                    break;
                }
                if (lineUpdated) continue;
                content.append(line).append(System.lineSeparator());
            }
            try (BufferedWriter writer = new BufferedWriter(new FileWriter(file));){
                writer.write(content.toString());
                logger.info("Configuration data successfully written to the file.");
            }
            catch (IOException e) {
                logger.error("Error occurred while writing to the file :", e);
                e.printStackTrace();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            logger.error("Error occurred while reading the file :", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLan0IpAddr() {
        Connection connection = null;
        String lan0IpAddr = null;
        try {
            connection = SQLiteRestoreBackupConnector.getConnection();
            String sql = "SELECT lan0_ipaddr FROM config_setting";
            PreparedStatement statement = connection.prepareStatement(sql);
            ResultSet resultSet = statement.executeQuery();
            if (resultSet.next()) {
                lan0IpAddr = resultSet.getString("lan0_ipaddr");
            }
            resultSet.close();
            statement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            logger.error("Error while fetching lan0_ipaddr from config settings in DB: " + e);
        }
        finally {
            SQLiteRestoreBackupConnector.closeConnection(connection);
        }
        return lan0IpAddr;
    }

    public boolean setLan0IpToIpBind() {
        try {
            String lan0Ip = "0.0.0.0";
            logger.info("LAN0 IP from DB: " + lan0Ip);
            boolean resultOfIp = FileReaderUtil.getInstance().isValidIpAddress(lan0Ip);
            if (!resultOfIp) {
                logger.error("Invalid LAN0 IP address retrieved from the database: " + lan0Ip);
                return false;
            }
            boolean resultBind = ServerXmlModifier.getInstance().updateConnectorAddress(lan0Ip);
            if (resultBind) {
                logger.info("IP successfully bound during the restore process. IP: " + lan0Ip);
            } else {
                logger.error("Failed to bind IP during the restore process.");
            }
            return resultBind;
        }
        catch (Exception e) {
            logger.error("Error occurred while setting IP to bind: " + e.getMessage());
            return false;
        }
    }

    static class FileData {
        String fileName;
        byte[] fileBytes;

        FileData(String fileName, byte[] fileBytes) {
            this.fileName = fileName;
            this.fileBytes = fileBytes;
        }
    }
}

