/*
 * Decompiled with CFR 0.152.
 */
package com.tas.wp500.backup_restore;

import com.tas.wp500.sql_lite_db.SQLiteConnector;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Base64;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import org.apache.log4j.Logger;
import org.json.JSONException;
import org.json.JSONObject;

public class BackupKeyDbOperation {
    private static Logger logger = Logger.getLogger(BackupKeyDbOperation.class);
    private static BackupKeyDbOperation instance = null;

    private BackupKeyDbOperation() {
        this.createBackupKeyTable();
        this.storeKeyToDb();
    }

    public static BackupKeyDbOperation getInstance() {
        if (instance == null) {
            instance = new BackupKeyDbOperation();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createBackupKeyTable() {
        Connection connection = SQLiteConnector.getConnection();
        try {
            String sql = "CREATE TABLE IF NOT EXISTS backup_keys (id INTEGER PRIMARY KEY CHECK (id = 1),key TEXT NOT NULL);";
            PreparedStatement preparedStatement = connection.prepareStatement(sql);
            preparedStatement.executeUpdate();
            preparedStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            logger.error("Error while creating backup key table : " + e);
        }
        finally {
            SQLiteConnector.closeConnection(connection);
        }
    }

    public static String generateKey() {
        try {
            KeyGenerator keyGen = KeyGenerator.getInstance("AES");
            keyGen.init(256);
            SecretKey secretKey = keyGen.generateKey();
            return Base64.getEncoder().encodeToString(secretKey.getEncoded());
        }
        catch (Exception e) {
            logger.error("Error generating key: " + e.getMessage());
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean storeKey(String key) {
        Connection connection = SQLiteConnector.getConnection();
        try {
            String sql = "INSERT OR REPLACE INTO backup_keys (id, key) VALUES (1, ?)";
            PreparedStatement preparedStatement = connection.prepareStatement(sql);
            preparedStatement.setString(1, key);
            preparedStatement.executeUpdate();
            preparedStatement.close();
            boolean bl = true;
            return bl;
        }
        catch (SQLException e) {
            e.printStackTrace();
            logger.error("Error while storing the key: " + e);
        }
        finally {
            SQLiteConnector.closeConnection(connection);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getKey() {
        Connection connection = SQLiteConnector.getConnection();
        String key = null;
        try {
            String sql = "SELECT key FROM backup_keys WHERE id = 1";
            PreparedStatement preparedStatement = connection.prepareStatement(sql);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                key = resultSet.getString("key");
            }
            resultSet.close();
            preparedStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            logger.error("Error while retrieving the key: " + e);
        }
        finally {
            SQLiteConnector.closeConnection(connection);
        }
        return key;
    }

    public JSONObject updateKey() {
        JSONObject resultObject = new JSONObject();
        String key = BackupKeyDbOperation.generateKey();
        boolean resultKey = this.storeKey(key);
        if (resultKey) {
            logger.info("Backup key is stored into db.");
            resultObject.put("status", "success");
            resultObject.put("msg", "Backup key stored successfully.");
        } else {
            logger.info("Error while storing backup key.");
            resultObject.put("status", "fail");
            resultObject.put("msg", "Error while storing backup key.");
        }
        return resultObject;
    }

    public JSONObject retrieveKey() {
        JSONObject resultObject = new JSONObject();
        String key = this.getKey();
        if (key != null) {
            logger.info("Backup key retrieved from db.");
            resultObject.put("status", "success");
            resultObject.put("msg", "Backup key retrieved successfully.");
            resultObject.put("key", key);
        } else {
            logger.info("Error while retrieving backup key.");
            resultObject.put("status", "fail");
            resultObject.put("msg", "Error while retrieving backup key.");
        }
        return resultObject;
    }

    public void storeKeyToDb() {
        String key = BackupKeyDbOperation.generateKey();
        boolean resultKey = this.storeKey(key);
        if (resultKey) {
            logger.info("Backup key is stored into db.");
        } else {
            logger.info("Error while storing backup key.");
        }
    }

    public JSONObject sortQueryDbOperation(JSONObject json) throws JSONException {
        JSONObject ack_res = new JSONObject();
        if (json.has("operation_type")) {
            String operation_type;
            switch (operation_type = json.getString("operation_type")) {
                case "update_backup_key": {
                    ack_res = this.updateKey();
                    ack_res.put("operation", "update_backup_key");
                    break;
                }
                case "get_backup_key": {
                    ack_res = this.retrieveKey();
                    ack_res.put("operation", "get_backup_key");
                    break;
                }
            }
        }
        return ack_res;
    }
}

