/*
 * Decompiled with CFR 0.152.
 */
package com.tas.wp500.backup_restore;

import com.tas.wp500.backup_restore.BackupKeyDbOperation;
import com.tas.wp500.fileLogSetting.FileBasedLogger;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.Key;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Base64;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.log4j.Logger;
import org.json.JSONException;
import org.json.JSONObject;

public class Backup {
    private static Logger logger = Logger.getLogger(Backup.class);
    private static Backup instance = null;
    private static String[] sourcePaths = new String[]{"/etc/wp500cfg/t5cod/t5.cod", "/opt/apache-tomcat-9.0.85/conf/keystore.jks", "/opt/apache-tomcat-9.0.85/conf/certificate.crt", "/usr/bin/wp_500DbFile.db"};
    private static String[] sourceFolders = new String[]{"/usr/bin/crt_files"};
    private static String zipFilePath = "/data/wp500_backup/backup.zip";
    private static final String DELIMITER = "FILE_SEPARATOR";
    private static final String NAME_SEPARATOR = "NAME_SEPARATOR";
    private static final int GCM_NONCE_LENGTH = 12;
    private static final int GCM_TAG_LENGTH = 16;

    public static Backup getInstance() {
        if (instance == null) {
            instance = new Backup();
        }
        return instance;
    }

    public JSONObject getBackupFile(String user) throws JSONException {
        JSONObject resultObject = new JSONObject();
        try {
            Backup.createBackupZip(zipFilePath, sourcePaths, sourceFolders);
            String encodedKey = BackupKeyDbOperation.getInstance().getKey();
            String[] inputFiles = new String[]{zipFilePath};
            String outputFile = "/data/wp500_backup/encryptedfile.enc";
            Backup.encryptFiles(encodedKey, inputFiles, outputFile);
            logger.debug("Files successfully encrypted to " + outputFile);
            logger.debug("Encryption key (Base64): " + encodedKey);
            resultObject.put("status", "success");
            resultObject.put("msg", "Backup retrieval  successfully.");
            resultObject.put("backup_key", encodedKey);
            logger.info("Successfully get backup from system.");
            FileBasedLogger.info("Audit", "Successfully get backup from system.", user);
        }
        catch (Exception e) {
            resultObject.put("status", "fail");
            resultObject.put("msg", "Error occurred while retrieval  backup from system.");
            logger.error(" Error occurred while taking backup : " + e);
            FileBasedLogger.error("Audit", "Error occurred while taking backup : " + e, user);
        }
        return resultObject;
    }

    public static String generateKey() {
        try {
            KeyGenerator keyGen = KeyGenerator.getInstance("AES");
            keyGen.init(256);
            SecretKey secretKey = keyGen.generateKey();
            return Base64.getEncoder().encodeToString(secretKey.getEncoded());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static void createBackupZip(String zipFilePath, String[] sourcePaths, String[] sourceFolders) {
        Path destinationPath = Paths.get(zipFilePath, new String[0]);
        try {
            Files.deleteIfExists(destinationPath);
            Files.createDirectories(destinationPath.getParent(), new FileAttribute[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
            logger.error("Error while setting up backup directory : " + e.getMessage());
            FileBasedLogger.error("Application", "Error while setting up backup directory : " + e.getMessage(), "system");
        }
        try (FileOutputStream fileOutputStream = new FileOutputStream(zipFilePath);
             BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
             ZipOutputStream zipOutputStream = new ZipOutputStream(bufferedOutputStream);){
            for (String sourcePath : sourcePaths) {
                Path source = Paths.get(sourcePath, new String[0]);
                if (Files.exists(source, new LinkOption[0])) {
                    if (Files.isRegularFile(source, new LinkOption[0])) {
                        Backup.addToZip(zipOutputStream, source, source.getFileName().toString());
                        continue;
                    }
                    System.out.println("Not a file: " + sourcePath);
                    continue;
                }
                System.out.println("Source path not found: " + sourcePath);
            }
            for (String sourceFolder : sourceFolders) {
                Path folderPath = Paths.get(sourceFolder, new String[0]);
                if (!Files.isDirectory(folderPath, new LinkOption[0])) continue;
                Backup.zipDirectory(folderPath.toFile(), folderPath.getFileName().toString(), zipOutputStream);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            logger.error("Error while creating backup : " + e.getMessage());
            FileBasedLogger.error("Application", "Error while creating backup : " + e.getMessage(), "system");
        }
    }

    private static void zipDirectory(File folder, String parentFolder, ZipOutputStream zos) throws FileNotFoundException, IOException {
        for (File file : folder.listFiles()) {
            if (file.isDirectory()) {
                Backup.zipDirectory(file, parentFolder + "/" + file.getName(), zos);
                continue;
            }
            zos.putNextEntry(new ZipEntry(parentFolder + "/" + file.getName()));
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file));
            long bytesRead = 0L;
            byte[] bytesIn = new byte[4096];
            int read = 0;
            while ((read = bis.read(bytesIn)) != -1) {
                zos.write(bytesIn, 0, read);
                bytesRead += (long)read;
            }
            zos.closeEntry();
        }
    }

    public static void addToZip(ZipOutputStream zipOutputStream, Path sourcePath, String entryName) {
        try {
            zipOutputStream.putNextEntry(new ZipEntry(entryName));
            Files.copy(sourcePath, zipOutputStream);
            zipOutputStream.closeEntry();
        }
        catch (IOException e) {
            e.printStackTrace();
            logger.error("Error adding file to backup : " + e.getMessage());
            FileBasedLogger.error("Application", "Error adding file to backup : " + e.getMessage(), "system");
        }
    }

    public static void encryptFiles(String key, String[] inputFiles, String outputFile) {
        try {
            byte[] decodedKey = Base64.getDecoder().decode(key);
            SecretKeySpec secretKey = new SecretKeySpec(decodedKey, 0, decodedKey.length, "AES");
            Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
            byte[] nonce = new byte[12];
            SecureRandom random = new SecureRandom();
            random.nextBytes(nonce);
            GCMParameterSpec gcmParameterSpec = new GCMParameterSpec(128, nonce);
            cipher.init(1, (Key)secretKey, gcmParameterSpec);
            byte[] combinedBytes = Backup.combineFiles(inputFiles);
            byte[] encryptedBytes = cipher.doFinal(combinedBytes);
            try (FileOutputStream outputStream = new FileOutputStream(outputFile);){
                outputStream.write(nonce);
                outputStream.write(encryptedBytes);
            }
        }
        catch (Exception e) {
            FileBasedLogger.error("Application", "Error while encrypt file : " + e.getMessage(), "system");
            logger.error("Error while encrypt file : " + e.getMessage());
        }
    }

    private static byte[] combineFiles(String[] inputFiles) {
        try {
            ArrayList<Byte> combinedList = new ArrayList<Byte>();
            for (String file : inputFiles) {
                byte[] fileNameBytes;
                byte[] fileBytes = Files.readAllBytes(Paths.get(file, new String[0]));
                for (byte b : fileNameBytes = (file + NAME_SEPARATOR).getBytes()) {
                    combinedList.add(b);
                }
                for (byte b : fileBytes) {
                    combinedList.add(b);
                }
                for (byte b : DELIMITER.getBytes()) {
                    combinedList.add(b);
                }
            }
            byte[] combinedBytes = new byte[combinedList.size()];
            for (int i = 0; i < combinedList.size(); ++i) {
                combinedBytes[i] = (Byte)combinedList.get(i);
            }
            return combinedBytes;
        }
        catch (Exception e) {
            logger.info("Error while combine files :" + e.getMessage());
            FileBasedLogger.error("Application", "Error while combine files :" + e.getMessage(), "system");
            return null;
        }
    }
}

