/*
 * Decompiled with CFR 0.152.
 */
package com.tas.wp500.alarmSettings;

import com.tas.wp500.alarmSettings.Alaram;
import com.tas.wp500.fileLogSetting.FileBasedLogger;
import com.tas.wp500.security.Security;
import com.tas.wp500.sql_lite_db.SQLiteConnector;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AlarmDbOperation
extends Security {
    private static Logger logger = Logger.getLogger(AlarmDbOperation.class);
    private static AlarmDbOperation instance = null;
    private static final int SQLITE_BUSY = 5;
    private static final int RETRY_COUNT = 5;
    private static final int RETRY_DELAY = 10000;

    public AlarmDbOperation() {
        this.createAlarmTable();
    }

    public static AlarmDbOperation getInstance() {
        if (instance == null) {
            instance = new AlarmDbOperation();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createAlarmTable() {
        Connection connection = null;
        try {
            connection = SQLiteConnector.getConnection();
            Statement statement = connection.createStatement();
            String sql = "CREATE TABLE IF NOT EXISTS alarm (id INTEGER PRIMARY KEY CHECK (id = 1), unit_id TEXT, asset_id TEXT, broker_type TEXT, broker_ip TEXT, intrval TEXT, alarm_tag TEXT, alarm_status TEXT)";
            statement.execute(sql);
            statement.close();
            logger.debug("Alarm table created successfully.");
        }
        catch (SQLException e) {
            e.printStackTrace();
            FileBasedLogger.error("Application", "Error while creating alarm table : " + e, "system");
            logger.debug("Error while creating alarm table : " + e);
        }
        finally {
            SQLiteConnector.closeConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject insertAlarmData(JSONObject json1, String user) throws JSONException {
        JSONObject resultObj = new JSONObject();
        for (int attempt = 0; attempt < 5; ++attempt) {
            Connection connection = null;
            try {
                connection = SQLiteConnector.getConnection();
                String id = json1.getString("id");
                String unit_id = json1.getString("unit_id");
                String asset_id = json1.getString("asset_id");
                String broker_type = json1.getString("broker_type");
                String broker_ip = json1.getString("broker_ip");
                String parsedValue = json1.getString("intrval");
                JSONArray alarm_tag = json1.getJSONArray("alarm_tag");
                String alarm_status = json1.getString("alarm_status");
                String Sql = "INSERT INTO alarm (id, unit_id, asset_id, broker_type, broker_ip, intrval, alarm_tag, alarm_status)VALUES (?, ?, ?, ?, ?, ?, ?, ?)";
                PreparedStatement statement = connection.prepareStatement(Sql);
                statement.setString(1, id);
                statement.setString(2, AlarmDbOperation.encrypt(unit_id));
                statement.setString(3, AlarmDbOperation.encrypt(asset_id));
                statement.setString(4, AlarmDbOperation.encrypt(broker_type));
                statement.setString(5, AlarmDbOperation.encrypt(broker_ip));
                statement.setString(6, AlarmDbOperation.encrypt(parsedValue));
                statement.setString(7, AlarmDbOperation.encrypt(alarm_tag.toString()));
                statement.setString(8, AlarmDbOperation.encrypt(alarm_status));
                statement.executeUpdate();
                statement.close();
                resultObj.put("status", "success");
                resultObj.put("msg", "Alarm configuration settings have been saved successfully.");
                logger.info("Saved alarm configuration setting successfully.");
                FileBasedLogger.info("Audit", "Saved alarm configuration setting successfully.", user);
                break;
            }
            catch (SQLException e) {
                if (e.getErrorCode() != 5 || attempt == 4) {
                    e.printStackTrace();
                    resultObj.put("status", "fail");
                    resultObj.put("msg", "Failed to save alarm configuration settings.");
                    logger.error("Failed to insert alarm configuration data: " + e);
                    FileBasedLogger.error("Audit", "Failed to insert alarm configuration data: " + e, user);
                    break;
                }
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
                continue;
            }
            finally {
                SQLiteConnector.closeConnection(connection);
            }
        }
        return resultObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject updateAlarmData(JSONObject json1, String user) throws JSONException {
        JSONObject resultObj = new JSONObject();
        for (int attempt = 0; attempt < 5; ++attempt) {
            Connection connection = null;
            try {
                connection = SQLiteConnector.getConnection();
                String id = json1.getString("id");
                String unit_id = json1.getString("unit_id");
                String asset_id = json1.getString("asset_id");
                String broker_type = json1.getString("broker_type");
                String broker_ip = json1.getString("broker_ip");
                String parsedValue = json1.getString("intrval");
                JSONArray alarm_tag = json1.getJSONArray("alarm_tag");
                String alarm_status = json1.getString("alarm_status");
                String sql = "UPDATE alarm SET unit_id = ?, asset_id = ?, broker_type = ?, broker_ip = ?, intrval = ?, alarm_tag = ?, alarm_status = ? WHERE id = ?";
                PreparedStatement statement = connection.prepareStatement(sql);
                statement.setString(1, AlarmDbOperation.encrypt(unit_id));
                statement.setString(2, AlarmDbOperation.encrypt(asset_id));
                statement.setString(3, AlarmDbOperation.encrypt(broker_type));
                statement.setString(4, AlarmDbOperation.encrypt(broker_ip));
                statement.setString(5, AlarmDbOperation.encrypt(parsedValue));
                statement.setString(6, AlarmDbOperation.encrypt(alarm_tag.toString()));
                statement.setString(7, AlarmDbOperation.encrypt(alarm_status));
                statement.setString(8, id);
                statement.executeUpdate();
                statement.close();
                resultObj.put("status", "success");
                resultObj.put("msg", "Alarm configuration settings updated successfully.");
                logger.info("Update alarm configuration settings successfully.");
                FileBasedLogger.info("Audit", "Update alarm configuration settings successfully.", user);
                break;
            }
            catch (Exception e) {
                if (((SQLException)e).getErrorCode() != 5 || attempt == 4) {
                    e.printStackTrace();
                    resultObj.put("status", "fail");
                    resultObj.put("msg", "Failed to update alarm configuration settings.");
                    logger.error("Error occurred while updating alarm configuration data : " + e);
                    FileBasedLogger.error("Audit", "Error occurred while updating alarm configuration data : " + e, user);
                    break;
                }
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
                continue;
            }
            finally {
                SQLiteConnector.closeConnection(connection);
            }
        }
        return resultObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject deleteAlarmData(JSONObject json1, String user) throws JSONException {
        JSONObject resultObj = new JSONObject();
        Connection connection = null;
        try {
            connection = SQLiteConnector.getConnection();
            String id = json1.getString("id");
            String sql = "DELETE FROM alarm WHERE id = ?";
            PreparedStatement statement = connection.prepareStatement(sql);
            statement.setString(1, id);
            int rowsAffected = statement.executeUpdate();
            statement.close();
            if (rowsAffected > 0) {
                resultObj.put("msg", "Alarm configuration settings deleted successfully.");
                resultObj.put("status", "success");
                logger.info("Delete alarm configuration settings successfully. ");
                FileBasedLogger.info("Audit", "Alarm configuration settings deleted successfully.", user);
            } else {
                resultObj.put("status", "fail");
                resultObj.put("msg", "Failed to find alarm configuration settings.");
                logger.info("Not found alarm configuration settings.");
                FileBasedLogger.info("Audit", "Failed to find alarm configuration settings.", user);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            logger.error("Error occurred while deleting alarm configuration settings id : " + e);
            FileBasedLogger.error("Audit", "Error occurred while deleting alarm configuration settings id : " + e, user);
        }
        finally {
            SQLiteConnector.closeConnection(connection);
        }
        return resultObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject getAllAlarmData(JSONObject json, String user) throws JSONException {
        JSONObject resultObj = new JSONObject();
        Connection connection = SQLiteConnector.getConnection();
        try {
            String sql = "SELECT * FROM alarm";
            PreparedStatement statement = connection.prepareStatement(sql);
            ResultSet resultSet = statement.executeQuery();
            JSONObject alarmData = new JSONObject();
            while (resultSet.next()) {
                alarmData.put("id", resultSet.getString("id"));
                alarmData.put("unit_id", AlarmDbOperation.decrypt(resultSet.getString("unit_id")));
                alarmData.put("asset_id", AlarmDbOperation.decrypt(resultSet.getString("asset_id")));
                alarmData.put("broker_type", AlarmDbOperation.decrypt(resultSet.getString("broker_type")));
                alarmData.put("broker_ip", AlarmDbOperation.decrypt(resultSet.getString("broker_ip")));
                alarmData.put("intrval", Integer.parseInt(AlarmDbOperation.decrypt(resultSet.getString("intrval"))));
                alarmData.put("alarm_tag", AlarmDbOperation.decrypt(resultSet.getString("alarm_tag")));
                alarmData.put("alarm_status", AlarmDbOperation.decrypt(resultSet.getString("alarm_status")));
            }
            resultObj.put("result", alarmData);
            resultObj.put("status", "success");
            resultObj.put("msg", "Successfully retrieved all alarm configuration settings.");
            logger.info("Successfully fetched all alarm configuration settings.");
            FileBasedLogger.info("Audit", "Successfully fetched all alarm configuration settings.", user);
            resultSet.close();
            statement.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            resultObj.put("status", "fail");
            resultObj.put("msg", "Error occurred while retrieving alarm configuration settings.");
            logger.error("Error occurred while fetching alarm configuration settings : " + e);
            FileBasedLogger.info("Audit", "Error occurred while fetching alarm configuration settings : " + e, user);
        }
        finally {
            SQLiteConnector.closeConnection(connection);
        }
        return resultObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<Alaram> getAllAlarmData() throws JSONException {
        Connection connection = null;
        ArrayList<Alaram> alaramData = new ArrayList<Alaram>();
        for (int attempt = 0; attempt < 5; ++attempt) {
            try {
                connection = SQLiteConnector.getConnection();
                String sql = "SELECT * FROM alarm";
                PreparedStatement statement = connection.prepareStatement(sql);
                ResultSet resultSet = statement.executeQuery();
                while (resultSet.next()) {
                    Alaram alm = new Alaram();
                    alm.setUnit_id(AlarmDbOperation.decrypt(resultSet.getString("unit_id")));
                    alm.setAsset_id(AlarmDbOperation.decrypt(resultSet.getString("asset_id")));
                    alm.setBroker_type(AlarmDbOperation.decrypt(resultSet.getString("broker_type")));
                    alm.setBroker_ip(AlarmDbOperation.decrypt(resultSet.getString("broker_ip")));
                    alm.setInterval(Integer.parseInt(AlarmDbOperation.decrypt(resultSet.getString("intrval"))));
                    alm.setAlarmTag(new JSONArray(AlarmDbOperation.decrypt(resultSet.getString("alarm_tag"))));
                    alm.setAlarm_status(AlarmDbOperation.decrypt(resultSet.getString("alarm_status")));
                    alaramData.add(alm);
                }
                resultSet.close();
                statement.close();
                break;
            }
            catch (Exception e) {
                e.printStackTrace();
                if (((SQLException)e).getErrorCode() != 5 || attempt == 4) {
                    e.printStackTrace();
                    logger.error("Error while fetching alarm configuration settings : " + e);
                    FileBasedLogger.error("Application", "Error while fetching alarm configuration settings : " + e, "system");
                    break;
                }
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
                continue;
            }
            finally {
                SQLiteConnector.closeConnection(connection);
            }
        }
        return alaramData;
    }
}

