/*
 * Decompiled with CFR 0.152.
 */
package com.tas.wp500;

import com.tas.wp500.ClientHandler;
import com.tas.wp500.services.Service;
import java.io.FileInputStream;
import java.net.BindException;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.KeyStore;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocketFactory;
import org.apache.log4j.Logger;

public class TCPServer
implements Runnable {
    private static Logger logger = Logger.getLogger(TCPServer.class);
    private Service service;

    public TCPServer(Service service) {
        this.service = service;
    }

    @Override
    public void run() {
        this.startSSLServer();
    }

    private void startSSLServer() {
        try {
            int portNumber = 6801;
            String keystorePath = "/opt/apache-tomcat-9.0.85/conf/keystore.jks";
            String keystorePassword = "Wp500@https2023";
            KeyStore keyStore = KeyStore.getInstance("JKS");
            keyStore.load(new FileInputStream(keystorePath), keystorePassword.toCharArray());
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("SunX509");
            keyManagerFactory.init(keyStore, keystorePassword.toCharArray());
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(keyManagerFactory.getKeyManagers(), null, null);
            SSLServerSocketFactory sslServerSocketFactory = sslContext.getServerSocketFactory();
            ServerSocket serverSocket = sslServerSocketFactory.createServerSocket(portNumber);
            logger.info("SSL Server started successfully. Listening on port : " + portNumber);
            while (true) {
                Socket clientSocket = serverSocket.accept();
                Thread clientThread = new Thread(new ClientHandler(clientSocket, this.service));
                clientThread.start();
            }
        }
        catch (BindException e) {
            this.service.stopService("system");
            logger.debug("Application is already running on machine. Please check !!!");
            logger.debug("Error SSL Server : " + e);
            e.printStackTrace();
            System.exit(0);
        }
        catch (Exception e) {
            logger.error("Error occurred while starting SSL server: " + e.getMessage());
        }
    }

    private void startTCPServer() {
        try {
            int portNumber = 6801;
            ServerSocket serverSocket = new ServerSocket(portNumber);
            logger.info("Server started on port " + portNumber);
            while (true) {
                Socket clientSocket = serverSocket.accept();
                Thread clientThread = new Thread(new ClientHandler(clientSocket, this.service));
                clientThread.start();
            }
        }
        catch (BindException e) {
            this.service.stopService("system");
            logger.error("Error while executing Tcp Server : " + e);
            e.printStackTrace();
            System.exit(0);
        }
        catch (Exception e) {
            logger.error("Error while connecting Tcp server : " + e);
        }
    }
}

