/*
 * Decompiled with CFR 0.152.
 */
package com.tas.wp500;

import com.tas.wp500.ClientHandler;
import com.tas.wp500.protocol.mqtt.MqttExecutor;
import com.tas.wp500.util.Config;
import com.tas.wp500.util.ConfigClass;
import java.io.FileInputStream;
import java.security.KeyStore;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Timer;
import java.util.TimerTask;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.apache.log4j.Logger;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.IMqttToken;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.MqttPersistenceException;
import org.eclipse.paho.client.mqttv3.persist.MemoryPersistence;
import org.eclipse.paho.client.mqttv3.persist.MqttDefaultFilePersistence;
import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONTokener;

public class MQTTServer
implements Config,
Runnable,
MqttCallback {
    private static String mqtt_ip_address;
    private static String mqtt_username;
    private static String mqtt_password;
    private static String mqtt_port_number;
    private static String mqtt_publish_topic;
    private static String mqtt_subscribe_topic;
    private static String mqtt_type;
    private MqttClient mqttClient;
    private String clientId = "" + System.currentTimeMillis();
    private ConfigClass configInstance = ConfigClass.getInstance();
    private static Logger logger;

    @Override
    public void run() {
        this.readConfigProperties();
        try {
            Timer mqttTimer = new Timer("Mqtt server");
            mqttTimer.scheduleAtFixedRate(new TimerTask(){

                @Override
                public void run() {
                    if (MQTTServer.this.mqttClient == null) {
                        MQTTServer.this.doMqttConnection();
                    }
                }
            }, 5000L, 300000L);
        }
        catch (Exception e) {
            logger.error("Error while Connecting mqtt Client : " + e);
        }
    }

    private void doMqttConnection() {
        block17: {
            if (mqtt_ip_address != null && mqtt_username != null && mqtt_password != null && mqtt_port_number != null && mqtt_publish_topic != null && mqtt_subscribe_topic != null && mqtt_type != null) {
                if (mqtt_type.equalsIgnoreCase("TCP")) {
                    MemoryPersistence persistence = new MemoryPersistence();
                    try {
                        this.mqttClient = new MqttClient("tcp://" + mqtt_ip_address + ":" + Integer.parseInt(mqtt_port_number), this.clientId, persistence);
                        MqttConnectOptions connectOptions = new MqttConnectOptions();
                        connectOptions.setCleanSession(true);
                        connectOptions.setMaxInflight(3000);
                        connectOptions.setAutomaticReconnect(true);
                        if (!mqtt_username.isEmpty() && !mqtt_password.isEmpty()) {
                            connectOptions.setUserName(mqtt_username);
                            connectOptions.setPassword(mqtt_password.toCharArray());
                        }
                        this.mqttClient.setCallback(this);
                        try {
                            IMqttToken mqttConnectionToken = this.mqttClient.connectWithResult(connectOptions);
                            logger.info(" Connection status of mqtt Ip address: " + mqtt_ip_address + "  status: " + mqttConnectionToken.isComplete());
                            boolean status = this.mqttClient.isConnected();
                            if (status) {
                                this.mqttClient.subscribe(mqtt_subscribe_topic);
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    catch (MqttException e1) {
                        logger.error("Error while connecting mqtt client : " + e1);
                        e1.printStackTrace();
                    }
                } else if (mqtt_type.equalsIgnoreCase("SSl")) {
                    try {
                        String filePath = null;
                        filePath = "/usr/bin/crt_files/ca.crt";
                        if (filePath == null) break block17;
                        String tmpDir = System.getProperty("java.io.tmpdir");
                        MqttConnectOptions options = new MqttConnectOptions();
                        options.setCleanSession(true);
                        if (!mqtt_username.equalsIgnoreCase("")) {
                            options.setUserName(mqtt_username);
                        }
                        if (!mqtt_password.equalsIgnoreCase("")) {
                            options.setPassword(mqtt_password.toCharArray());
                        }
                        this.mqttClient = new MqttClient("ssl://" + mqtt_ip_address + ":" + mqtt_port_number, MqttClient.generateClientId(), new MqttDefaultFilePersistence(tmpDir));
                        SSLContext sslContext = SSLContext.getInstance("SSL");
                        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                        KeyStore keyStore = this.readKeyStore(filePath);
                        trustManagerFactory.init(keyStore);
                        sslContext.init(null, trustManagerFactory.getTrustManagers(), null);
                        options.setSocketFactory(sslContext.getSocketFactory());
                        this.mqttClient.connect(options);
                        System.out.println(this.mqttClient.getClientId() + " mqtt client starting connect the server...");
                        if (!this.mqttClient.isConnected()) break block17;
                        try {
                            MqttExecutor.serverlistMap.put(mqtt_ip_address, this.mqttClient);
                            this.mqttClient.setCallback(this);
                            logger.info(" mqtt_subscribe Module topic subscribe " + mqtt_subscribe_topic + " - Topic subscribed by server " + mqtt_ip_address);
                            this.mqttClient.subscribe(mqtt_subscribe_topic, 2);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            logger.error("Error occurred during MQTT client setup: " + e.getMessage());
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        logger.error("Failed to establish SSL connection: " + e.getMessage());
                    }
                }
            } else {
                logger.info("Error while reading Mqtt details please check ServerConfig file");
                this.readConfigProperties();
            }
        }
    }

    private void readConfigProperties() {
        try {
            mqtt_ip_address = this.configInstance.readConfigName("mqtt_ip_address");
            mqtt_username = this.configInstance.readConfigName("mqtt_username");
            mqtt_password = this.configInstance.readConfigName("mqtt_password");
            mqtt_port_number = this.configInstance.readConfigName("mqtt_port_number");
            mqtt_publish_topic = this.configInstance.readConfigName("mqtt_publish_topic");
            mqtt_subscribe_topic = this.configInstance.readConfigName("mqtt_subscribe_topic");
            mqtt_type = this.configInstance.readConfigName("mqtt_type");
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Error while reading MQTT configuration properties : ", e);
        }
    }

    public void publish(String content) {
        MqttMessage message = new MqttMessage();
        message.setPayload(content.getBytes());
        message.setQos(2);
        try {
            String topic = mqtt_publish_topic;
            if (this.mqttClient.isConnected()) {
                this.mqttClient.publish(topic, message);
                logger.debug("Successfully published msg on topic " + topic + " msg : " + message);
            } else {
                this.mqttClient = null;
            }
        }
        catch (MqttPersistenceException e) {
            e.printStackTrace();
        }
        catch (MqttException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void connectionLost(Throwable cause) {
        logger.error("Connection lost of mqtt ip address " + mqtt_ip_address);
        this.mqttClient = null;
    }

    @Override
    public void messageArrived(String topic, MqttMessage message) throws Exception {
        String payload = new String(message.getPayload());
        Object json = new JSONTokener(payload).nextValue();
        if (json instanceof JSONObject) {
            final JSONObject obj = new JSONObject(message.toString());
            System.out.println("Obj : " + obj);
            new Thread(new Runnable(){

                @Override
                public void run() {
                    String result = new ClientHandler().operation(obj, "mqtt");
                    if (result != null) {
                        MQTTServer.this.publish(result);
                    }
                }
            }).start();
        } else if (json instanceof JSONArray) {
            // empty if block
        }
    }

    @Override
    public void deliveryComplete(IMqttDeliveryToken token) {
    }

    public KeyStore readKeyStore(String filepath) {
        try {
            FileInputStream is = new FileInputStream(filepath);
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            X509Certificate caCert = (X509Certificate)cf.generateCertificate(is);
            KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
            ks.load(null);
            ks.setCertificateEntry("caCert", caCert);
            return ks;
        }
        catch (Exception e) {
            logger.debug(" MQTTClient " + mqtt_ip_address + " - readKeyStore. ");
            logger.error("Error while loading KeyStore from file : " + filepath + " :" + e.getMessage());
            return null;
        }
    }

    static {
        logger = Logger.getLogger(MQTTServer.class);
    }
}

