/*
 * Decompiled with CFR 0.152.
 */
package com.tas.wp500.IptablesSetting;

import com.tas.wp500.IptablesSetting.GenralSettingsOperation;
import com.tas.wp500.IptablesSetting.IptableSettingsOperations;
import com.tas.wp500.IptablesSetting.Rule;
import com.tas.wp500.fileLogSetting.FileBasedLogger;
import com.tas.wp500.security.Security;
import com.tas.wp500.sql_lite_db.SQLiteConnector;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class IptablesManager
extends Security {
    private Logger logger = Logger.getLogger(IptablesManager.class);
    private static IptablesManager instance = null;
    private GenralSettingsOperation gen = GenralSettingsOperation.getInstance();
    private static final String REJECT = "reject";
    private static final String DROP = "DROP";
    private static final String BASIC_TABLE_NAME = "firewall";
    private static final String BASIC_CHAIN_NAME = "inbound_lan0";
    private static final String IPV4_PATTERN = "^(25[0-5]|2[0-4][0-9]|1[0-9]{2}|[1-9]?[0-9])\\.(25[0-5]|2[0-4][0-9]|1[0-9]{2}|[1-9]?[0-9])\\.(25[0-5]|2[0-4][0-9]|1[0-9]{2}|[1-9]?[0-9])\\.(25[0-5]|2[0-4][0-9]|1[0-9]{2}|[1-9]?[0-9])$";
    private static final String IPV6_PATTERN = "^(([0-9a-fA-F]{1,4}:){7}([0-9a-fA-F]{1,4}|:)|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}(:[0-9a-fA-F]{1,4}){1,6}|:((:[0-9a-fA-F]{1,4}){1,7}|:)|fe80:(:[0-9a-fA-F]{0,4}){0,4}%[0-9a-zA-Z]+|::(ffff(:0{1,4}){0,1}:)?((25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)|([0-9a-fA-F]{1,4}:){1,4}:((25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?))$";
    private static final String MAC_PATTERN = "^([0-9A-Fa-f]{2}([-:]?)){5}[0-9A-Fa-f]{2}$";

    private IptablesManager() {
        this.createTable();
    }

    public static IptablesManager getInstance() {
        if (instance == null) {
            instance = new IptablesManager();
        }
        return instance;
    }

    public void createTable() {
        Connection connection = null;
        try {
            connection = SQLiteConnector.getConnection();
            PreparedStatement statement = connection.prepareStatement("CREATE TABLE IF NOT EXISTS iptables_rules (id INTEGER PRIMARY KEY AUTOINCREMENT, protocol TEXT, interface TEXT, from_port TEXT, from_ip TEXT, to_port TEXT, to_ip TEXT, name TEXT, action TEXT)");
            statement.executeUpdate();
            this.logger.debug("created table for iptables_rules.");
        }
        catch (SQLException e) {
            e.printStackTrace();
            this.logger.error("Error while creating iptable table: " + e);
            FileBasedLogger.error("Network", "Error while creating iptable table: " + e, "system");
        }
        finally {
            SQLiteConnector.closeConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertRule(String name, String iface, String protocol, String fromIp, String toIp, String fromPort, String toPort, String action) {
        Connection connection = null;
        JSONObject result = new JSONObject();
        try {
            connection = SQLiteConnector.getConnection();
            PreparedStatement statement = connection.prepareStatement("INSERT INTO iptables_rules (name, interface, protocol, from_ip, to_ip, from_port, to_port, action) VALUES (?, ?, ?, ?, ?, ?, ?, ?)");
            statement.setString(1, IptablesManager.encrypt(name));
            statement.setString(2, IptablesManager.encrypt(iface));
            statement.setString(3, IptablesManager.encrypt(protocol));
            statement.setString(4, IptablesManager.encrypt(fromIp));
            statement.setString(5, IptablesManager.encrypt(toIp));
            statement.setString(6, IptablesManager.encrypt(fromPort));
            statement.setString(7, IptablesManager.encrypt(toPort));
            statement.setString(8, IptablesManager.encrypt(action));
            statement.executeUpdate();
            result.put("status", "success");
            result.put("msg", "IP tables data inserted!!");
            statement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            result.put("status", "fail");
            result.put("msg", "Failed to insert IP table data!!");
            this.logger.error("Error while inserting record into IP table: " + e);
            FileBasedLogger.error("Network", "Error while inserting record into IP table: " + e, "system");
        }
        finally {
            SQLiteConnector.closeConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<Rule> fetchRules(String user) {
        Connection connection = null;
        ArrayList<Rule> roleList = new ArrayList<Rule>();
        try {
            connection = SQLiteConnector.getConnection();
            PreparedStatement statement = connection.prepareStatement("SELECT * FROM iptables_rules");
            ResultSet resultSet = statement.executeQuery();
            while (resultSet.next()) {
                int id = resultSet.getInt("id");
                String name = resultSet.getString("name");
                String iface = resultSet.getString("interface");
                String protocol = resultSet.getString("protocol");
                String fromIp = resultSet.getString("from_ip");
                String toIp = resultSet.getString("to_ip");
                String fromPort = resultSet.getString("from_port");
                String toPort = resultSet.getString("to_port");
                String action = resultSet.getString("action");
                Rule r = new Rule(IptablesManager.decrypt(name), IptablesManager.decrypt(iface), IptablesManager.decrypt(protocol).toLowerCase(), IptablesManager.decrypt(fromIp), IptablesManager.decrypt(toIp), IptablesManager.decrypt(fromPort), IptablesManager.decrypt(toPort), IptablesManager.decrypt(action).toLowerCase());
                roleList.add(r);
            }
            statement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            this.logger.error("Error while fetching ip tables data : " + e);
            FileBasedLogger.error("Network", "Error while fetching ip tables data : " + e, user);
        }
        finally {
            SQLiteConnector.closeConnection(connection);
        }
        return roleList;
    }

    public JSONObject insertRuleFromJson(JSONObject jsonObject, String user) throws JSONException {
        JSONObject result = new JSONObject();
        try {
            this.logger.debug("insert json--->" + jsonObject);
            String name = jsonObject.optString("name", "");
            String iface = jsonObject.optString("iface", "");
            String protocol = jsonObject.optString("protocol", "");
            String fromIp = jsonObject.optString("fromIp", "");
            String toIp = jsonObject.optString("toIp", "");
            String fromPort = jsonObject.optString("fromPort", "");
            String toPort = jsonObject.optString("toPort", "");
            String action = jsonObject.optString("action", "");
            this.insertRule(name, iface, protocol, fromIp, toIp, fromPort, toPort, action);
            result.put("status", "success");
            result.put("msg", "ip tables rule save successfully !!");
            this.logger.info("Save ip tables rule successfully.");
            FileBasedLogger.info("Network", "Save ip tables rule successfully.", user);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error("Error occurred while inserting rule from json : " + e);
            FileBasedLogger.error("Network", "Error occurred while inserting rule from json : " + e, user);
            result.put("status", "fail");
            result.put("msg", "failed to save ip table rule !!");
        }
        return result;
    }

    public JSONObject upsertRuleFromJson(JSONObject json, String user) throws JSONException {
        JSONObject result = new JSONObject();
        try {
            String name = json.getString("name");
            if (this.ruleExists(name)) {
                this.updateRuleFromJson(name, json);
                this.logger.info("Updating ip tables successfully.");
            }
            result.put("status", "success");
            result.put("msg", "ip tables rule updated successfully !!");
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error("Error occurred while updating rule from json : " + e);
            FileBasedLogger.error("Network", "Error occurred while updating rule from json : " + e, user);
            result.put("status", "fail");
            result.put("msg", "failed to update ip table rule !!");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean ruleExists(String name) {
        Connection connection = null;
        try {
            connection = SQLiteConnector.getConnection();
            PreparedStatement statement = connection.prepareStatement("SELECT COUNT(*) FROM iptables_rules WHERE name = ?");
            statement.setString(1, IptablesManager.encrypt(name));
            ResultSet resultSet = statement.executeQuery();
            if (resultSet.next()) {
                int count = resultSet.getInt(1);
                boolean bl = count > 0;
                return bl;
            }
            resultSet.close();
            statement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            SQLiteConnector.closeConnection(connection);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRuleFromJson(String name, JSONObject jsonObject) {
        Connection connection = null;
        try {
            connection = SQLiteConnector.getConnection();
            String iface = jsonObject.optString("iface", "");
            String protocol = jsonObject.optString("protocol", "");
            String fromIp = jsonObject.optString("fromIp", "");
            String toIp = jsonObject.optString("toIp", "");
            String fromPort = jsonObject.optString("fromPort", "");
            String toPort = jsonObject.optString("toPort", "");
            String action = jsonObject.optString("action", "");
            PreparedStatement statement = connection.prepareStatement("UPDATE iptables_rules SET interface = ?, protocol = ?, from_ip = ?, to_ip = ?, from_port = ?, to_port = ?, action = ? WHERE name = ?");
            statement.setString(1, IptablesManager.encrypt(iface));
            statement.setString(2, IptablesManager.encrypt(protocol));
            statement.setString(3, IptablesManager.encrypt(fromIp));
            statement.setString(4, IptablesManager.encrypt(toIp));
            statement.setString(5, IptablesManager.encrypt(fromPort));
            statement.setString(6, IptablesManager.encrypt(toPort));
            statement.setString(7, IptablesManager.encrypt(action));
            statement.setString(8, IptablesManager.encrypt(name));
            statement.executeUpdate();
            statement.close();
            this.logger.info("Updated ip tables rule.");
            FileBasedLogger.info("Network", "Updated ip tables rule.", "system");
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error("Error while updating ip tables : " + e);
            FileBasedLogger.error("Network", "Error while updating ip tables : " + e, "system");
        }
        finally {
            SQLiteConnector.closeConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject deleteRuleByName(String name, String user) throws JSONException {
        JSONObject result = new JSONObject();
        Connection connection = null;
        try {
            connection = SQLiteConnector.getConnection();
            PreparedStatement statement = connection.prepareStatement("DELETE FROM iptables_rules WHERE name = ?");
            statement.setString(1, IptablesManager.encrypt(name));
            statement.executeUpdate();
            statement.close();
            result.put("status", "success");
            result.put("msg", "ip tables rule deleted successfully !!");
            this.logger.info("Deleted ip tables rule successfully.");
            FileBasedLogger.info("Network", "Deleted ip tables rule successfully.", user);
        }
        catch (SQLException e) {
            e.printStackTrace();
            result.put("status", "fail");
            result.put("msg", "failed to delete ip table rule !!");
            this.logger.error("Failed TO delete ip table rule.");
            FileBasedLogger.error("Network", "Failed TO delete ip table rule.", user);
        }
        finally {
            SQLiteConnector.closeConnection(connection);
        }
        return result;
    }

    public JSONObject applyButtonAction(String user) throws JSONException {
        JSONObject result = new JSONObject();
        try {
            this.executeNftableRestartCommand(user);
            this.createUserChain(user);
            this.getAndApplyDefaultChainRule();
            ArrayList<Rule> ruleList = this.fetchRules(user);
            if (!ruleList.isEmpty()) {
                ruleList.forEach(eachList -> {
                    block33: {
                        String name = eachList.getName();
                        String iface = eachList.getIface();
                        String fromIp = eachList.getFromIp() != null ? eachList.getFromIp() : "";
                        String toIp = eachList.getToIp() != null ? eachList.getToIp() : "";
                        String fromPort = eachList.getFromPort() != null ? eachList.getFromPort() : "";
                        String toPort = eachList.getToPort() != null ? eachList.getToPort() : "";
                        String protocol = eachList.getProtocol();
                        String action = eachList.getAction();
                        String fromIpPart = "";
                        String toIpPart = "";
                        String userChainName = IptablesManager.formatIpCainName(iface);
                        if (!fromIp.equalsIgnoreCase("ALLMACDROP")) {
                            String nftCommand;
                            if (!fromIp.isEmpty()) {
                                String firstFromIp = fromIp.split(",")[0].trim();
                                this.logger.debug("from ip:-->" + fromIp);
                                if (IptablesManager.checkAddressType(firstFromIp).equals("IP")) {
                                    fromIpPart = IptablesManager.formatIpList("ip saddr", fromIp);
                                    this.logger.debug("Ip fromIpPart:-->" + fromIpPart);
                                } else if (IptablesManager.checkAddressType(firstFromIp).equals("MAC")) {
                                    fromIpPart = IptablesManager.formatIpList("ether saddr", fromIp);
                                    this.logger.debug("Mac fromIpPart:-->" + fromIpPart);
                                }
                            } else if (!toIp.isEmpty()) {
                                String firstToIp = toIp.split(",")[0].trim();
                                if (IptablesManager.checkAddressType(firstToIp).equals("IP")) {
                                    toIpPart = IptablesManager.formatIpList("ip daddr", toIp);
                                } else if (IptablesManager.checkAddressType(firstToIp).equals("MAC")) {
                                    toIpPart = IptablesManager.formatIpList("ether daddr", toIp);
                                }
                            }
                            if (!fromPort.isEmpty() && !toPort.isEmpty() && fromIp.isEmpty() && toIp.isEmpty()) {
                                nftCommand = "nft add rule inet firewall " + userChainName + " iifname \"" + iface + "\" " + protocol + " sport " + fromPort + " " + protocol + " dport " + toPort + " " + action + " comment \"" + name + "\"";
                                this.logger.debug("Generated nftable command : " + nftCommand);
                                try {
                                    ProcessBuilder processBuilder = new ProcessBuilder("/bin/bash", "-c", nftCommand);
                                    Process process = processBuilder.start();
                                    int exitCode = process.waitFor();
                                    if (exitCode == 0) {
                                        this.logger.debug("Executed Iptables command successfully.");
                                        break block33;
                                    }
                                    this.logger.error("Iptables command execution failed with exit code : " + exitCode);
                                    FileBasedLogger.error("Network", "Iptables command execution failed with exit code : " + exitCode, user);
                                }
                                catch (Exception e) {
                                    this.logger.error("Error executing iptables command : " + e.getMessage());
                                    FileBasedLogger.error("Network", "Error executing iptables command : " + e.getMessage(), user);
                                }
                            } else if (!(fromPort.isEmpty() || toPort.isEmpty() || fromIp.isEmpty() || toIp.isEmpty())) {
                                nftCommand = "nft add rule inet firewall " + userChainName + " iifname \"" + iface + "\"" + fromIpPart + " " + protocol + " sport " + fromPort + " " + protocol + " dport " + toPort + toIpPart + " " + action + " comment \"" + name + "\"";
                                this.logger.debug("Generated nftable command : " + nftCommand);
                                try {
                                    ProcessBuilder processBuilder = new ProcessBuilder("/bin/bash", "-c", nftCommand);
                                    Process process = processBuilder.start();
                                    int exitCode = process.waitFor();
                                    if (exitCode == 0) {
                                        this.logger.debug("Executed Iptables command successfully.");
                                        break block33;
                                    }
                                    this.logger.error("Iptables command execution failed with exit code : " + exitCode);
                                }
                                catch (Exception e) {
                                    this.logger.error("Error occurred at executing iptables command : " + e.getMessage());
                                    FileBasedLogger.error("Network", "Error executing iptables command : " + e.getMessage(), user);
                                }
                            } else if (!fromIp.isEmpty() && !fromPort.isEmpty() && !toPort.isEmpty() && toIp.isEmpty()) {
                                nftCommand = "nft add rule inet firewall " + userChainName + " iifname \"" + iface + "\"" + fromIpPart + " " + protocol + " sport " + fromPort + " " + protocol + " dport " + toPort + " " + action + " comment \"" + name + "\"";
                                this.logger.debug("Generated nftable command : " + nftCommand);
                                try {
                                    ProcessBuilder processBuilder = new ProcessBuilder("/bin/bash", "-c", nftCommand);
                                    Process process = processBuilder.start();
                                    int exitCode = process.waitFor();
                                    if (exitCode == 0) {
                                        this.logger.debug("Executed Iptables command successfully.");
                                        break block33;
                                    }
                                    this.logger.error(" Iptables command execution failed with exit code : " + exitCode);
                                }
                                catch (Exception e) {
                                    this.logger.error("Error occurred at executing iptables command : " + e.getMessage());
                                    FileBasedLogger.error("Network", "Error executing iptables command : " + e.getMessage(), user);
                                }
                            } else if (!toPort.isEmpty() && fromPort.isEmpty() && fromIp.isEmpty() && toIp.isEmpty()) {
                                nftCommand = this.generateBasicNftCommand1("iif", iface, protocol, toPort, action.toLowerCase(), name, userChainName);
                                this.executeCommand(nftCommand);
                            } else if (!fromIp.isEmpty() && !toPort.isEmpty() && fromPort.isEmpty() && toIp.isEmpty()) {
                                if (fromIp.equals("0.0.0.0")) {
                                    fromIpPart = "ip saddr 0.0.0.0/0";
                                }
                                nftCommand = "nft add rule inet firewall " + userChainName + " iifname \"" + iface + "\"" + fromIpPart + " " + protocol + " dport " + toPort + " " + action;
                                this.executeCommand(nftCommand);
                            } else if (!fromIp.isEmpty() && toPort.isEmpty() && fromPort.isEmpty() && toIp.isEmpty()) {
                                if (fromIp.equals("0.0.0.0")) {
                                    fromIpPart = "ip saddr 0.0.0.0/0";
                                }
                                nftCommand = "nft add rule inet firewall " + userChainName + " iifname \"" + iface + "\"" + fromIpPart + " " + action;
                                this.executeCommand(nftCommand);
                            } else {
                                this.logger.debug("nftable rule not match with exisiting command-->" + eachList);
                            }
                        }
                    }
                });
            } else {
                this.logger.debug("Config rule is empty.");
            }
            if (!ruleList.isEmpty()) {
                int ruleListSize = ruleList.size();
                AtomicInteger counter = new AtomicInteger(0);
                ruleList.forEach(eachList -> {
                    String name = eachList.getName();
                    String iface = eachList.getIface();
                    String fromIp = eachList.getFromIp() != null ? eachList.getFromIp() : "";
                    String toIp = eachList.getToIp() != null ? eachList.getToIp() : "";
                    String fromPort = eachList.getFromPort() != null ? eachList.getFromPort() : "";
                    String toPort = eachList.getToPort() != null ? eachList.getToPort() : "";
                    String protocol = eachList.getProtocol();
                    String action = eachList.getAction();
                    String fromIpPart = "";
                    String toIpPart = "";
                    String userChainName = IptablesManager.formatIpCainName(iface);
                    if (fromIp.equalsIgnoreCase("ALLMACDROP")) {
                        String dropAllMacIpCommand = "nft add rule inet firewall " + userChainName + " iifname \"" + iface + "\" " + action;
                        String dropCommand = "nft add rule inet firewall " + userChainName + " " + action;
                        this.executeCommand(dropCommand);
                    }
                });
            }
            this.getAllBasicIpConfigurationAndApplay();
            this.getAndApplyDefaultChainRuleDropRule();
            this.applyForwardRule();
            result.put("status", "success");
            result.put("msg", "Trafic rule changes applied successfully !!");
            this.logger.info("Successfully applied Trafic rule changes.");
            FileBasedLogger.info("Network", "Successfully applied Trafic rule changes.", user);
        }
        catch (Exception e) {
            e.printStackTrace();
            result.put("status", "fail");
            result.put("msg", "Failed to applied Trafic rule changes  !! " + e);
            this.logger.error("Failed to applied Trafic rule changes :" + e);
            FileBasedLogger.error("Network", "Failed to applied Trafic rule changes : " + e, user);
        }
        return result;
    }

    private static String formatIpList(String condition, String ipList) {
        if (ipList.contains(",")) {
            CharSequence[] ips = ipList.split(",");
            return " " + condition + " { " + String.join((CharSequence)", ", ips) + " }";
        }
        return " " + condition + " " + ipList;
    }

    private static String formatIpCainName(String iface) {
        if (iface.equals("lan0")) {
            return BASIC_CHAIN_NAME;
        }
        if (iface.equals("lan1")) {
            return "inbound_lan1";
        }
        if (iface.equals("lan2")) {
            return "inbound_lan2";
        }
        return iface;
    }

    private static String formatInboundCainName(String iface) {
        if (iface.contains("lan0")) {
            return BASIC_CHAIN_NAME;
        }
        if (iface.contains("lan1")) {
            return "inbound_lan1";
        }
        if (iface.contains("lan2")) {
            return "inbound_lan2";
        }
        return iface;
    }

    private void createChain(String tableName, String chainName) {
        try {
            String createChainCommand = "nft add chain inet " + tableName + " " + chainName + " { }";
            this.executeCommand(createChainCommand);
            Thread.sleep(500L);
            String jumpCommand = "nft add rule inet firewall inbound jump inbound_lan0;";
            this.executeCommand(jumpCommand);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error("Error while creating nftables basic chain:" + e);
        }
    }

    private void createUserChain(String user) {
        try {
            for (int i = 0; i < 3; ++i) {
                String chainName = "inbound_lan" + String.valueOf(i);
                String createChainCommand = "";
                createChainCommand = i == 0 ? "nft add chain inet firewall " + chainName + " { type filter hook input priority 0 ; }" : "nft add chain inet firewall " + chainName + " { type filter hook input priority filter ; policy accept ; }";
                String userChainCommand = "nft add chain inet firewall " + chainName + " { }";
                this.executeCommand(userChainCommand);
                String pingCommand = "nft add rule inet firewall " + chainName + " icmp type { echo-reply, echo-request } accept";
                this.executeCommand(pingCommand);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            FileBasedLogger.error("Network", "Error while creating nftables user chain:" + e, user);
            this.logger.error("Error while creating nftables user chain:" + e);
        }
    }

    public void applyForwardRule() {
        try {
            String forwardRuleLan0 = "nft add rule inet firewall forward iifname \"lan0\" drop";
            String forwardRuleLan1 = "nft add rule inet firewall forward iifname \"lan1\" drop";
            String forwardRuleLan2 = "nft add rule inet firewall forward iifname \"lan2\" drop";
            this.executeCommand(forwardRuleLan0);
            this.executeCommand(forwardRuleLan1);
            this.executeCommand(forwardRuleLan2);
        }
        catch (Exception e) {
            FileBasedLogger.error("Network", "Error applying forward rules:" + e.getMessage(), "system");
            this.logger.error("Error applying forward rules:" + e.getMessage());
        }
    }

    public void executeOnlyOneIptableCommand(int id, boolean flag) {
        try {
            JSONObject eachSetting = IptableSettingsOperations.getInstnce().getIptableSettingById(id);
            if (eachSetting != null) {
                String direction = eachSetting.getString("direction");
                String lan_type = eachSetting.getString("lan_type");
                String protocol = eachSetting.getString("protocol");
                String to_port = eachSetting.getString("to_port");
                String action = eachSetting.getString("action");
                if (flag) {
                    String dynamicString = String.format("iptables --replace %s -p %s -i %s --dport %s -j %s", direction, protocol, lan_type, to_port, action);
                    this.executeCommand(dynamicString, id, action);
                } else {
                    String dynamicString = "iptables -A " + direction + " -i " + lan_type + " -p " + protocol + " --dport " + to_port + " -j " + action;
                    this.executeCommand(dynamicString, id, action);
                }
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
            FileBasedLogger.info("Network", "Error occurred while executing ip table command :" + e.getMessage(), "system");
            this.logger.error("Error occurred while executing ip table command :" + e.getMessage());
        }
    }

    public void getAllBasicIpConfigurationAndApplay() {
        try {
            JSONObject allSettings = IptableSettingsOperations.getInstnce().getAllIptableSettings("wp500");
            if (allSettings.has("data")) {
                JSONArray dataArray = allSettings.getJSONArray("data");
                Thread.sleep(500L);
                for (int i = 0; i < dataArray.length(); ++i) {
                    JSONObject eachSetting = dataArray.getJSONObject(i);
                    String direction = eachSetting.getString("direction");
                    String lan_type = eachSetting.getString("lan_type");
                    String protocol = eachSetting.getString("protocol");
                    String to_port = eachSetting.getString("to_port");
                    String action = eachSetting.getString("action");
                    String comment = eachSetting.getString("comment");
                    String nftCommand = this.generateBasicNftCommand(direction, lan_type, protocol, to_port, action.toLowerCase(), comment);
                    this.executeCommand(nftCommand);
                    Thread.sleep(500L);
                }
                this.logger.info("Successfully applied trafic rule on this system.");
                FileBasedLogger.info("Network", "Successfully applied trafic rule on this system.", "system");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            FileBasedLogger.error("Network", "Error while executing Ip tables basic command:" + e, "system");
            this.logger.error("Error while executing Ip tables basic command:" + e);
        }
    }

    private void setDefaultPolicy(String chain, String networkInterface, String status) {
        try {
            String command = chain.equalsIgnoreCase("OUTPUT") ? "iptables -A " + chain + " -o " + networkInterface + " -j " + status : "iptables -A " + chain + " -i " + networkInterface + " -j " + status;
            ProcessBuilder processBuilder = new ProcessBuilder("/bin/bash", "-c", command);
            processBuilder.redirectErrorStream(true);
            Process process = processBuilder.start();
            int exitValue = process.waitFor();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                String line;
                while ((line = reader.readLine()) != null) {
                }
            }
            if (exitValue == 0) {
                this.logger.info("Default policy set to " + status + " for " + chain + " chain on " + networkInterface);
            } else {
                this.logger.error("Error setting default policy for " + chain + " chain on " + networkInterface + ". Exit code: " + exitValue);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error("Error while applying default policy for chain : " + e.getMessage());
        }
    }

    private void setInterfacePolicy(String interfaceName, String chain, String policy) {
        this.executeCommand(String.format("iptables -P %s -i %s %s", chain, interfaceName, policy));
    }

    public void getAndApplyDefaultChainRule() {
        try {
            JSONObject generalSetting = this.gen.getAllGeneralSettings();
            if (generalSetting.has("data") && generalSetting.getJSONArray("data").length() > 0) {
                JSONArray dataArray = generalSetting.getJSONArray("data");
                for (int i = 0; i < dataArray.length(); ++i) {
                    JSONObject resultSet = dataArray.getJSONObject(i);
                    String input = resultSet.getString("input");
                    String rule_drop = resultSet.getString("rule_drop");
                    String interfaces = resultSet.getString("interface");
                    Thread.sleep(100L);
                    if (rule_drop.equalsIgnoreCase("ON")) {
                        rule_drop = "accept";
                    } else if (rule_drop.equalsIgnoreCase("OFF")) {
                        rule_drop = "drop";
                    }
                    String userChainName = IptablesManager.formatInboundCainName(interfaces);
                    String chainName = IptablesManager.formatIpCainName(interfaces);
                    String generalSettingCommand = "nft add chain inet firewall " + userChainName + " { type filter hook input priority filter ; policy " + input.toLowerCase() + " ; }";
                    Thread.sleep(500L);
                    String connectionCommand = "nft add rule inet firewall " + userChainName + " ct state vmap { invalid : " + rule_drop + ", established : accept, related : accept }";
                    this.executeCommand(connectionCommand);
                    String jumpCommand = "nft add rule inet firewall " + userChainName + " jump " + chainName + ";";
                    String string = "nft add rule inet firewall " + userChainName + input.toLowerCase();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            FileBasedLogger.error("Network", "Error occurred while executing genral setting:" + e.getMessage(), "system");
            this.logger.error("Error occurred while executing genral setting:" + e.getMessage());
        }
    }

    public void getAndApplyDefaultChainRuleDropRule() {
        try {
            JSONObject generalSetting = this.gen.getAllGeneralSettings();
            if (generalSetting.has("data") && generalSetting.getJSONArray("data").length() > 0) {
                JSONArray dataArray = generalSetting.getJSONArray("data");
                for (int i = 0; i < dataArray.length(); ++i) {
                    JSONObject resultSet = dataArray.getJSONObject(i);
                    String input = resultSet.getString("input");
                    String rule_drop = resultSet.getString("rule_drop");
                    String interfaces = resultSet.getString("interface");
                    Thread.sleep(50L);
                    if (rule_drop.equalsIgnoreCase("ON")) {
                        rule_drop = "accept";
                    } else if (rule_drop.equalsIgnoreCase("OFF")) {
                        rule_drop = "drop";
                    }
                    String userChainName = IptablesManager.formatInboundCainName(interfaces);
                    String dropCommand = "nft add rule inet firewall " + userChainName + " " + input.toLowerCase();
                    this.executeCommand(dropCommand);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            FileBasedLogger.error("Network", "Error occurred while executing genral setting:" + e.getMessage(), "system");
            this.logger.error("Error occurred while executing genral setting:" + e.getMessage());
        }
    }

    public void executeDefualtChainRule() {
        try {
            String[] interfaces;
            for (String iface : interfaces = new String[]{"lan0", "lan1", "lan2"}) {
                this.setDefaultPolicy("INPUT", iface, DROP);
                Thread.sleep(100L);
                this.setDefaultPolicy("OUTPUT", iface, "ACCEPT");
                Thread.sleep(100L);
                this.setDefaultPolicy("FORWARD", iface, DROP);
            }
            String command = "iptables -A INPUT -m conntrack --ctstate INVALID -j ACCEPT";
            Thread.sleep(100L);
            this.executeCommand(command);
        }
        catch (Exception e) {
            e.printStackTrace();
            FileBasedLogger.error("Network", "Error while executing default chain rule : " + e.getMessage(), "system");
            this.logger.error("Error while executing default chain rule : " + e.getMessage());
        }
    }

    private void executeNftableRestartCommand(String user) {
        String command = "systemctl restart nftables";
        this.logger.info("Executing flush command: ");
        FileBasedLogger.info("Network", "Executing flush command: ", user);
        this.executeCommand(command);
    }

    private boolean executeCommand(String command, int id, String action) {
        try {
            ProcessBuilder processBuilder = new ProcessBuilder(command);
            Process process = processBuilder.start();
            int exitCode = process.waitFor();
            if (exitCode == 0) {
                this.logger.debug("Command executed successfully: " + command);
                return true;
            }
            this.logger.error("Command execution failed with exit code " + exitCode + ": " + command);
            FileBasedLogger.error("Network", "Error while executing command : " + command, "system");
            return false;
        }
        catch (IOException | InterruptedException e) {
            e.printStackTrace();
            FileBasedLogger.error("Network", "Error while executing command : " + e.getMessage(), "system");
            return false;
        }
    }

    public void executeCommand(String command) {
        try {
            String line;
            ProcessBuilder processBuilder = new ProcessBuilder(command.split("\\s+"));
            Process process = processBuilder.start();
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((line = reader.readLine()) != null) {
            }
            int exitCode = process.waitFor();
            if (exitCode != 0) {
                this.logger.error("Command execution failed with exit code: " + exitCode + " Command : " + command);
                FileBasedLogger.error("Network", "Error while executing command : " + command, "system");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            FileBasedLogger.error("Network", "Error while executing command : " + e.getMessage(), "system");
            this.logger.error("Error while executing command with :");
        }
    }

    public JSONObject executeGenralSettingCommand(String user) throws JSONException {
        JSONObject result = new JSONObject();
        try {
            JSONObject generalSetting = this.gen.getGeneralSetting();
            this.logger.debug("Executing genral settings command :" + generalSetting);
            String input = generalSetting.getString("input");
            String output = generalSetting.getString("output");
            String forward = generalSetting.getString("forword");
            String drop = generalSetting.getString("rule_drop");
            input = input.equalsIgnoreCase("accept") ? "ACCEPT" : DROP;
            output = output.equalsIgnoreCase("accept") ? "ACCEPT" : DROP;
            forward = forward.equalsIgnoreCase("accept") ? "ACCEPT" : DROP;
            String commandInput = "iptables -P INPUT " + input.toUpperCase();
            String commandOutput = "iptables -P OUTPUT " + output.toUpperCase();
            String commandForward = "iptables -P FORWARD " + forward.toUpperCase();
            this.logger.debug("Input query : " + commandInput);
            this.logger.debug("Output query : " + commandOutput);
            this.logger.debug("Forword query : " + commandForward);
            String command = new String();
            if (drop.equalsIgnoreCase("ON")) {
                command = "iptables -A INPUT -m conntrack --ctstate INVALID -j ACCEPT";
            } else if (drop.equalsIgnoreCase("OFF")) {
                command = "iptables -A INPUT -m conntrack --ctstate INVALID -j DROP";
            }
            this.logger.debug(" conntrack command : " + command);
            this.executeCommand(commandInput);
            Thread.sleep(500L);
            this.executeCommand(commandOutput);
            Thread.sleep(500L);
            this.executeCommand(commandForward);
            Thread.sleep(500L);
            this.executeCommand(command);
            result.put("status", "success");
            result.put("msg", "Trafic rule changes applied successfully !!");
            this.logger.info("Successfully applied changes for trafic rule.");
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error(" Error occurred while genral setting  :: " + e);
            result.put("status", "fail");
            result.put("msg", "Failed to applied Trafic rule changes  !! " + e);
        }
        return result;
    }

    public JSONObject saveIptablesRules(String user) throws JSONException {
        JSONObject resultObj = new JSONObject();
        try {
            Properties properties = new Properties();
            properties.load(new FileInputStream("/etc/wp500cfg/config.ini"));
            String filePath = properties.getProperty("iptables_file_path");
            if (filePath == null || filePath.isEmpty()) {
                resultObj.put("status", "error");
                resultObj.put("msg", "iptablesFilePath is not specified in/etc/wp500cfg/config.ini");
                return resultObj;
            }
            String fullFilePath = filePath + File.separator + "iptables_rules";
            File outputFile = new File(fullFilePath);
            File parentDirectory = outputFile.getParentFile();
            if (!parentDirectory.exists() && !parentDirectory.mkdirs()) {
                resultObj.put("status", "error");
                resultObj.put("msg", "Failed to create parent directories for iptables rules file.");
                this.logger.info("Failed to create parent directories for ip tables rule file. ");
                return resultObj;
            }
            outputFile.createNewFile();
            ProcessBuilder processBuilder = new ProcessBuilder("iptables-save");
            processBuilder.redirectOutput(outputFile);
            Process process = processBuilder.start();
            int exitCode = process.waitFor();
            if (exitCode == 0) {
                resultObj.put("status", "success");
                resultObj.put("msg", "Iptables rules saved successfully.");
                this.logger.info("Saved iptables rules successfully.");
            } else {
                resultObj.put("status", "error");
                resultObj.put("msg", "Error occurred while saving iptables rules. Exit code: " + exitCode);
                this.logger.info("Error occurred while saving iptables rules. ");
            }
        }
        catch (Exception e) {
            resultObj.put("status", "error");
            resultObj.put("msg", "Error occurred while saving iptables rules: " + e.getMessage());
        }
        return resultObj;
    }

    public void addIptablesRuleForRelatedAndEstablished() {
        String command = "iptables -A INPUT -m conntrack --ctstate RELATED,ESTABLISHED -j ACCEPT";
        this.executeCommand(command);
    }

    private String generateBasicNftCommand(String direction, String lan_type, String protocol, String to_port, String action, String comment) {
        StringBuilder nftCommand = new StringBuilder("nft add rule inet firewall inbound_lan0 ");
        nftCommand.append(direction.equals("iif") ? "iif" : "oif").append(" ").append(lan_type).append(" ");
        nftCommand.append(protocol);
        nftCommand.append(" dport ").append(to_port).append(" ");
        nftCommand.append(action);
        nftCommand.append(" comment \"").append(comment).append("\"");
        return nftCommand.toString();
    }

    private String generateBasicNftCommand1(String direction, String lan_type, String protocol, String to_port, String action, String comment, String userChainName) {
        StringBuilder nftCommand = new StringBuilder("nft add rule inet firewall " + userChainName + " ");
        nftCommand.append(direction.equals("iif") ? "iif" : "oif").append(" ").append(lan_type).append(" ");
        nftCommand.append(protocol);
        nftCommand.append(" dport ").append(to_port).append(" ");
        nftCommand.append(action);
        nftCommand.append(" comment \"").append(comment).append("\"");
        return nftCommand.toString();
    }

    public JSONObject applyTrafficRule(final String user) {
        JSONObject resultObj = new JSONObject();
        try {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    IptablesManager.this.applyButtonAction(user);
                }
            }).start();
            resultObj.put("status", "success");
            resultObj.put("msg", "Applying traffic rules. This may take a moment, please wait.");
            FileBasedLogger.info("Network", "Applying traffic rules successfully.", user);
        }
        catch (Exception e) {
            this.logger.error("Error while applying Trafic rule.");
            FileBasedLogger.error("Network", "Error while applying Trafic rule.", user);
            resultObj.put("status", "fail");
            resultObj.put("msg", "Error while applying Trafic rule changes  !! ");
        }
        return resultObj;
    }

    public static String checkAddressType(String address) {
        if (Pattern.matches(MAC_PATTERN, address)) {
            return "MAC";
        }
        return "IP";
    }
}

