/*
 * Decompiled with CFR 0.152.
 */
package com.tas.wp500.IptablesSetting;

import com.tas.wp500.IptablesSetting.IptablesManager;
import com.tas.wp500.fileLogSetting.FileBasedLogger;
import com.tas.wp500.security.Security;
import com.tas.wp500.sql_lite_db.SQLiteConnector;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class IptableSettingsOperations
extends Security {
    private static Logger logger = Logger.getLogger(IptableSettingsOperations.class);
    private static IptableSettingsOperations instance;
    private IptablesManager iptablesManager = IptablesManager.getInstance();
    private static final int SQLITE_BUSY = 5;
    private static final int RETRY_COUNT = 5;
    private static final int RETRY_DELAY = 10000;

    public IptableSettingsOperations() {
        this.createIptableSettingsTable();
    }

    public static IptableSettingsOperations getInstnce() {
        try {
            if (instance == null) {
                instance = new IptableSettingsOperations();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createIptableSettingsTable() {
        Connection connection = SQLiteConnector.getConnection();
        try {
            Statement statement = connection.createStatement();
            String sql = "CREATE TABLE IF NOT EXISTS iptable_settings (id INTEGER PRIMARY KEY AUTOINCREMENT, direction TEXT, lan_type TEXT, protocol TEXT, to_port TEXT, action TEXT, comment TEXT)";
            statement.execute(sql);
            statement.close();
        }
        catch (SQLException e) {
            logger.error("Error while creating iptable_settings table : " + e);
            FileBasedLogger.error("Network", "Error while creating iptable_settings table : " + e, "system");
        }
        finally {
            SQLiteConnector.closeConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject insertIptableSetting(JSONObject iptableSetting) throws JSONException {
        JSONObject resultObj = new JSONObject();
        for (int attempt = 0; attempt < 5; ++attempt) {
            Connection connection = null;
            try {
                connection = SQLiteConnector.getConnection();
                String sql = "INSERT INTO iptable_settings (direction, lan_type, protocol, to_port, action, comment) VALUES (?, ?, ?, ?, ?, ?)";
                PreparedStatement statement = connection.prepareStatement(sql);
                statement.setString(1, IptableSettingsOperations.encrypt(iptableSetting.getString("direction")));
                statement.setString(2, IptableSettingsOperations.encrypt(iptableSetting.getString("lan_type")));
                statement.setString(3, IptableSettingsOperations.encrypt(iptableSetting.getString("protocol")));
                statement.setString(4, IptableSettingsOperations.encrypt(iptableSetting.getString("to_port")));
                statement.setString(5, IptableSettingsOperations.encrypt(iptableSetting.getString("action")));
                statement.setString(6, IptableSettingsOperations.encrypt(iptableSetting.getString("comment")));
                statement.executeUpdate();
                statement.close();
                logger.info("Iptable setting inserted successfully : ");
                resultObj.put("msg", "Iptable setting inserted successfully.");
                resultObj.put("status", "Success");
                break;
            }
            catch (Exception e) {
                e.printStackTrace();
                if (((SQLException)e).getErrorCode() != 5 || attempt == 4) {
                    logger.error("Error while inserting iptable setting : " + e);
                    FileBasedLogger.error("Network", "Error while inserting iptable setting : " + e, "system");
                    resultObj.put("status", "fail");
                    resultObj.put("msg", "Failed to insert iptable setting.");
                    break;
                }
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
                continue;
            }
            finally {
                SQLiteConnector.closeConnection(connection);
            }
        }
        return resultObj;
    }

    public JSONObject insertOrUpdateIptableSetting(JSONObject iptableSetting, String user) throws JSONException {
        JSONObject resultObj = new JSONObject();
        for (int attempt = 0; attempt < 5; ++attempt) {
            try (Connection connection = SQLiteConnector.getConnection();){
                block37: {
                    String checkSql = "SELECT * FROM iptable_settings WHERE to_port = ?";
                    try (PreparedStatement checkStatement = connection.prepareStatement(checkSql);){
                        checkStatement.setString(1, IptableSettingsOperations.encrypt(iptableSetting.getString("to_port")));
                        try (ResultSet resultSet = checkStatement.executeQuery();){
                            if (resultSet.next()) {
                                String updateSql = "UPDATE iptable_settings SET direction = ?, lan_type = ?, protocol = ?, action = ?, comment = ? WHERE to_port = ?";
                                try (PreparedStatement updateStatement = connection.prepareStatement(updateSql);){
                                    updateStatement.setString(1, IptableSettingsOperations.encrypt(iptableSetting.getString("direction")));
                                    updateStatement.setString(2, IptableSettingsOperations.encrypt(iptableSetting.getString("lan_type")));
                                    updateStatement.setString(3, IptableSettingsOperations.encrypt(iptableSetting.getString("protocol")));
                                    updateStatement.setString(4, IptableSettingsOperations.encrypt(iptableSetting.getString("action")));
                                    updateStatement.setString(5, IptableSettingsOperations.encrypt(iptableSetting.getString("comment")));
                                    updateStatement.setString(6, IptableSettingsOperations.encrypt(iptableSetting.getString("to_port")));
                                    updateStatement.executeUpdate();
                                    resultObj.put("msg", "Iptable setting updated successfully.");
                                    logger.debug("Updated iptable settings successfully.");
                                    break block37;
                                }
                            }
                            String insertSql = "INSERT INTO iptable_settings (direction, lan_type, protocol, to_port, action, comment) VALUES (?, ?, ?, ?, ?, ?)";
                            try (PreparedStatement insertStatement = connection.prepareStatement(insertSql);){
                                insertStatement.setString(1, IptableSettingsOperations.encrypt(iptableSetting.getString("direction")));
                                insertStatement.setString(2, IptableSettingsOperations.encrypt(iptableSetting.getString("lan_type")));
                                insertStatement.setString(3, IptableSettingsOperations.encrypt(iptableSetting.getString("protocol")));
                                insertStatement.setString(4, IptableSettingsOperations.encrypt(iptableSetting.getString("to_port")));
                                insertStatement.setString(5, IptableSettingsOperations.encrypt(iptableSetting.getString("action")));
                                insertStatement.setString(6, IptableSettingsOperations.encrypt(iptableSetting.getString("comment")));
                                insertStatement.executeUpdate();
                                resultObj.put("msg", "Iptable setting inserted successfully.");
                                logger.debug("Inserted iptable settings successfully.");
                            }
                        }
                    }
                }
                resultObj.put("status", "Success");
                break;
            }
            catch (Exception e) {
                if (((SQLException)e).getErrorCode() != 5 || attempt == 4) {
                    logger.error("Error occurred while inserting/updating iptable setting : " + e);
                    FileBasedLogger.error("Network", "Error occurred while inserting/updating iptable setting : " + e, user);
                    resultObj.put("status", "Fail");
                    resultObj.put("msg", "Failed to insert/update iptable settings.");
                    break;
                }
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
                continue;
            }
        }
        return resultObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject updateIptableSettingAction(int id, String action) throws JSONException {
        JSONObject resultObj = new JSONObject();
        for (int attempt = 0; attempt < 5; ++attempt) {
            Connection connection = null;
            try {
                connection = SQLiteConnector.getConnection();
                String sql = "UPDATE iptable_settings SET action = ? WHERE id = ?";
                PreparedStatement statement = connection.prepareStatement(sql);
                statement.setString(1, IptableSettingsOperations.encrypt(action));
                statement.setInt(2, id);
                int rowsAffected = statement.executeUpdate();
                statement.close();
                if (rowsAffected > 0) {
                    resultObj.put("msg", "Iptable setting action updated successfully.");
                    resultObj.put("status", "Success");
                    break;
                }
                resultObj.put("msg", "No Iptable setting found for the given ID.");
                resultObj.put("status", "Fail");
                break;
            }
            catch (Exception e) {
                if (((SQLException)e).getErrorCode() != 5 || attempt == 4) {
                    logger.error("Error while updating iptable setting action : " + e);
                    FileBasedLogger.error("Network", "Error while updating iptable setting action : " + e, "system");
                    resultObj.put("status", "fail");
                    resultObj.put("msg", "Failed to update iptable setting action.");
                    e.printStackTrace();
                    break;
                }
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
                continue;
            }
            finally {
                SQLiteConnector.closeConnection(connection);
            }
        }
        return resultObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject updateIptableSetting(JSONObject iptableSetting) throws JSONException {
        JSONObject resultObj = new JSONObject();
        Connection connection = null;
        for (int attempt = 0; attempt < 5; ++attempt) {
            try {
                connection = SQLiteConnector.getConnection();
                String sql = "UPDATE iptable_settings SET direction = ?, lan_type = ?, protocol = ?, to_port = ?, action = ?, comment = ? WHERE id = ?";
                PreparedStatement statement = connection.prepareStatement(sql);
                statement.setString(1, IptableSettingsOperations.encrypt(iptableSetting.getString("direction")));
                statement.setString(2, IptableSettingsOperations.encrypt(iptableSetting.getString("lan_type")));
                statement.setString(3, IptableSettingsOperations.encrypt(iptableSetting.getString("protocol")));
                statement.setString(4, IptableSettingsOperations.encrypt(iptableSetting.getString("to_port")));
                statement.setString(5, IptableSettingsOperations.encrypt(iptableSetting.getString("action")));
                statement.setString(6, IptableSettingsOperations.encrypt(iptableSetting.getString("comment")));
                statement.setInt(7, iptableSetting.getInt("id"));
                int rowsAffected = statement.executeUpdate();
                statement.close();
                if (rowsAffected > 0) {
                    resultObj.put("msg", "Iptable settings updated successfully.");
                    resultObj.put("status", "Success");
                    break;
                }
                resultObj.put("msg", "No Iptable setting found for the given ID.");
                resultObj.put("status", "Fail");
                break;
            }
            catch (Exception e) {
                e.printStackTrace();
                if (((SQLException)e).getErrorCode() != 5 || attempt == 4) {
                    logger.error("Error while updating iptable setting: " + e);
                    FileBasedLogger.error("Network", "Error while updating iptable setting: " + e, "system");
                    resultObj.put("status", "fail");
                    resultObj.put("msg", "Failed to update iptable setting.");
                    break;
                }
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
                continue;
            }
            finally {
                SQLiteConnector.closeConnection(connection);
            }
        }
        return resultObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject deleteIptableSetting(int id) throws JSONException {
        JSONObject resultObj = new JSONObject();
        Connection connection = null;
        try {
            connection = SQLiteConnector.getConnection();
            String sql = "DELETE FROM iptable_settings WHERE id = ?";
            PreparedStatement statement = connection.prepareStatement(sql);
            statement.setInt(1, id);
            int rowsAffected = statement.executeUpdate();
            statement.close();
            if (rowsAffected > 0) {
                resultObj.put("msg", "Iptable setting deleted successfully.");
                resultObj.put("status", "Success");
            } else {
                resultObj.put("msg", "No Iptable setting found for the given ID.");
                resultObj.put("status", "Fail");
            }
        }
        catch (Exception e) {
            logger.error("Error while deleting iptable setting: " + e);
            FileBasedLogger.error("Network", "Error while deleting iptable setting: " + e, "system");
            resultObj.put("status", "fail");
            resultObj.put("msg", "Failed to delete iptable setting.");
        }
        finally {
            SQLiteConnector.closeConnection(connection);
        }
        return resultObj;
    }

    public JSONObject updateIptableCommands(JSONObject inputObject, String user) throws JSONException {
        JSONObject resultObj;
        block7: {
            resultObj = new JSONObject();
            try {
                if (!inputObject.has("data")) break block7;
                JSONArray dataArray = inputObject.getJSONArray("data");
                for (int i = 0; i < dataArray.length(); ++i) {
                    try {
                        JSONObject eachObj = dataArray.getJSONObject(i);
                        int id = eachObj.getInt("id");
                        String action = eachObj.getString("action");
                        this.updateIptableSettingAction(id, action);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        logger.error("Error while update ip table : " + e);
                    }
                    Thread.sleep(100L);
                }
                try {
                    resultObj.put("status", "success");
                    resultObj.put("msg", "Successfully updated Ip table settings for given Id's. ");
                    logger.info("Successfully updated ip table settings for given id's.");
                    FileBasedLogger.info("Network", "Successfully updated ip table settings for given id's.", user);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    logger.error("Error occurred while applying basic ip table command : " + e);
                    FileBasedLogger.error("Network", "Error occurred while applying basic ip table command : " + e, user);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error("Error occurred while updating ip table settings  for given id'd : " + e.getMessage());
                FileBasedLogger.error("Network", "Error occurred while updating ip table settings  for given id'd : " + e.getMessage(), user);
                resultObj.put("status", "Fail");
                resultObj.put("msg", "Failed Ip table settings for given Id's. ");
            }
        }
        return resultObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject getAllIptableSettings(String user) throws JSONException {
        JSONObject resultObj = new JSONObject();
        for (int attempt = 0; attempt < 5; ++attempt) {
            JSONArray iptableSettingsArray = new JSONArray();
            Connection connection = null;
            try {
                connection = SQLiteConnector.getConnection();
                String sql = "SELECT * FROM iptable_settings";
                PreparedStatement statement = connection.prepareStatement(sql);
                ResultSet resultSet = statement.executeQuery();
                while (resultSet.next()) {
                    JSONObject iptableSetting = new JSONObject();
                    iptableSetting.put("id", resultSet.getInt("id"));
                    iptableSetting.put("direction", IptableSettingsOperations.decrypt(resultSet.getString("direction")));
                    iptableSetting.put("lan_type", IptableSettingsOperations.decrypt(resultSet.getString("lan_type")));
                    iptableSetting.put("protocol", IptableSettingsOperations.decrypt(resultSet.getString("protocol")));
                    iptableSetting.put("to_port", IptableSettingsOperations.decrypt(resultSet.getString("to_port")));
                    iptableSetting.put("action", IptableSettingsOperations.decrypt(resultSet.getString("action")));
                    iptableSetting.put("comment", IptableSettingsOperations.decrypt(resultSet.getString("comment")));
                    iptableSettingsArray.put(iptableSetting);
                }
                resultObj.put("data", iptableSettingsArray);
                resultObj.put("status", "success");
                resultObj.put("msg", "IP table basic settings fetched successfully.");
                logger.info("Fetched ip table basic settings successfully.");
                FileBasedLogger.info("Network", "Fetched ip table basic settings successfully.", user);
                resultSet.close();
                statement.close();
                break;
            }
            catch (SQLException | JSONException e) {
                e.printStackTrace();
                if (((SQLException)e).getErrorCode() != 5 || attempt == 4) {
                    e.printStackTrace();
                    resultObj.put("data", iptableSettingsArray);
                    resultObj.put("status", "fail");
                    resultObj.put("msg", "Failed to fetch ip table settings.");
                    break;
                }
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
                logger.error("Error while fetching iptable settings : " + e);
                FileBasedLogger.error("Network", "Error while fetching iptable settings : " + e, user);
                continue;
            }
            finally {
                SQLiteConnector.closeConnection(connection);
            }
        }
        return resultObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public JSONObject getIptableSettingById(int id) throws JSONException {
        JSONObject jSONObject;
        JSONObject iptableSetting = null;
        Connection connection = null;
        try {
            iptableSetting = new JSONObject();
            connection = SQLiteConnector.getConnection();
            String sql = "SELECT * FROM iptable_settings WHERE id = ?";
            PreparedStatement statement = connection.prepareStatement(sql);
            statement.setInt(1, id);
            ResultSet resultSet = statement.executeQuery();
            while (resultSet.next()) {
                iptableSetting.put("id", resultSet.getInt("id"));
                iptableSetting.put("direction", IptableSettingsOperations.decrypt(resultSet.getString("direction")));
                iptableSetting.put("lan_type", IptableSettingsOperations.decrypt(resultSet.getString("lan_type")));
                iptableSetting.put("protocol", IptableSettingsOperations.decrypt(resultSet.getString("protocol")));
                iptableSetting.put("to_port", IptableSettingsOperations.decrypt(resultSet.getString("to_port")));
                iptableSetting.put("action", IptableSettingsOperations.decrypt(resultSet.getString("action")));
                iptableSetting.put("comment", IptableSettingsOperations.decrypt(resultSet.getString("comment")));
            }
            resultSet.close();
            statement.close();
            jSONObject = iptableSetting;
        }
        catch (SQLException | JSONException e) {
            try {
                e.printStackTrace();
                logger.error("Error while fetching iptable setting: " + e);
                FileBasedLogger.error("Network", "Error while fetching iptable setting: " + e, "system");
            }
            catch (Throwable throwable) {
                SQLiteConnector.closeConnection(connection);
                throw throwable;
            }
            SQLiteConnector.closeConnection(connection);
            return iptableSetting;
        }
        SQLiteConnector.closeConnection(connection);
        return jSONObject;
    }
}

