/*
 * Decompiled with CFR 0.152.
 */
package com.tas.wp500.IptablesSetting;

import com.tas.wp500.fileLogSetting.FileBasedLogger;
import com.tas.wp500.security.Security;
import com.tas.wp500.sql_lite_db.SQLiteConnector;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class GenralSettingsOperation
extends Security {
    private static Logger logger = Logger.getLogger(GenralSettingsOperation.class);
    private static GenralSettingsOperation instance = null;
    private static final int SQLITE_BUSY = 5;
    private static final int RETRY_COUNT = 5;
    private static final int RETRY_DELAY = 10000;

    private GenralSettingsOperation() {
        this.createGeneralSettingTable();
    }

    public static GenralSettingsOperation getInstance() {
        if (instance == null) {
            instance = new GenralSettingsOperation();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createGeneralSettingTable() {
        Connection connection = SQLiteConnector.getConnection();
        try {
            String createTableSQL = "CREATE TABLE IF NOT EXISTS general_setting (id INTEGER PRIMARY KEY,input TEXT,rule_drop TEXT,interface TEXT)";
            PreparedStatement preparedStatement = connection.prepareStatement(createTableSQL);
            preparedStatement.executeUpdate();
            preparedStatement.close();
            logger.debug("General_setting table created or already exists.");
        }
        catch (SQLException e) {
            e.printStackTrace();
            logger.error("Error creating general_setting table: " + e);
            FileBasedLogger.error("Network", "Error creating general_setting table: " + e, "system");
        }
        finally {
            SQLiteConnector.closeConnection(connection);
        }
    }

    private boolean isRecordExists(Connection connection, String tableName, int id) throws SQLException {
        try (PreparedStatement statement = connection.prepareStatement("SELECT * FROM " + tableName + " WHERE id = ?");){
            boolean bl;
            block12: {
                statement.setInt(1, id);
                ResultSet resultSet = statement.executeQuery();
                try {
                    bl = resultSet.next();
                    if (resultSet == null) break block12;
                }
                catch (Throwable throwable) {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                resultSet.close();
            }
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject insertGeneralSetting(JSONObject json, int id, String user) throws JSONException {
        JSONObject resultObj = new JSONObject();
        for (int attempt = 0; attempt < 5; ++attempt) {
            Connection connection = SQLiteConnector.getConnection();
            try {
                if (this.isRecordExists(connection, "general_setting", id)) {
                    this.updateGeneralSetting(json, id, user);
                    break;
                }
                String input = json.getString("input");
                String rule_drop = json.getString("rule_drop");
                String interfaces = json.getString("interface");
                String sql = "INSERT INTO general_setting (input,rule_drop,interface) VALUES (?, ?, ?)";
                PreparedStatement statement = connection.prepareStatement(sql);
                statement.setString(1, GenralSettingsOperation.encrypt(input));
                statement.setString(2, GenralSettingsOperation.encrypt(rule_drop));
                statement.setString(3, GenralSettingsOperation.encrypt(interfaces));
                statement.executeUpdate();
                statement.close();
                resultObj.put("status", "success");
                resultObj.put("msg", "General setting has been saved successfully.");
                logger.debug("Inserted General setting successfully.");
                break;
            }
            catch (SQLException e) {
                e.printStackTrace();
                if (e.getErrorCode() != 5 || attempt == 4) {
                    resultObj.put("status", "fail");
                    resultObj.put("msg", "Failed to save general setting data. An error occurred during the process.");
                    logger.error("Error occurred while inserting general setting data : " + e);
                    FileBasedLogger.error("Network", "Error occurred while inserting general setting data : " + e, user);
                    break;
                }
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
                continue;
            }
            finally {
                SQLiteConnector.closeConnection(connection);
            }
        }
        return resultObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject getGeneralSetting() throws JSONException {
        JSONObject resultObj = new JSONObject();
        for (int attempt = 0; attempt < 5; ++attempt) {
            Connection connection = SQLiteConnector.getConnection();
            try {
                String sql = "SELECT * FROM general_setting";
                PreparedStatement statement = connection.prepareStatement(sql);
                ResultSet resultSet = statement.executeQuery();
                if (resultSet.next()) {
                    String input = resultSet.getString("input");
                    String rule_drop = resultSet.getString("rule_drop");
                    String interfaces = resultSet.getString("interface");
                    resultObj.put("status", "success");
                    resultObj.put("input", GenralSettingsOperation.decrypt(input));
                    resultObj.put("rule_drop", GenralSettingsOperation.decrypt(rule_drop));
                    resultObj.put("interface", GenralSettingsOperation.decrypt(interfaces));
                } else {
                    resultObj.put("status", "fail");
                    resultObj.put("msg", "No general setting data found.");
                }
                statement.close();
                break;
            }
            catch (SQLException e) {
                e.printStackTrace();
                if (e.getErrorCode() != 5 || attempt == 4) {
                    e.printStackTrace();
                    resultObj.put("status", "fail");
                    resultObj.put("msg", "Error while retrieving general setting data.");
                    logger.error("Error occurred while retrieving general setting data: " + e);
                    FileBasedLogger.error("Network", "Error occurred while retrieving general setting data: " + e, "system");
                    break;
                }
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
                continue;
            }
            finally {
                SQLiteConnector.closeConnection(connection);
            }
        }
        return resultObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject getAllGeneralSettings() throws JSONException {
        JSONObject resultObj = new JSONObject();
        for (int attempt = 0; attempt < 5; ++attempt) {
            Connection connection = SQLiteConnector.getConnection();
            JSONArray settingsArray = new JSONArray();
            try {
                String sql = "SELECT * FROM general_setting";
                PreparedStatement statement = connection.prepareStatement(sql);
                ResultSet resultSet = statement.executeQuery();
                while (resultSet.next()) {
                    JSONObject settingObj = new JSONObject();
                    String input = resultSet.getString("input");
                    String rule_drop = resultSet.getString("rule_drop");
                    String interfaces = resultSet.getString("interface");
                    settingObj.put("input", GenralSettingsOperation.decrypt(input));
                    settingObj.put("rule_drop", GenralSettingsOperation.decrypt(rule_drop));
                    settingObj.put("interface", GenralSettingsOperation.decrypt(interfaces));
                    settingsArray.put(settingObj);
                }
                resultObj.put("status", "success");
                resultObj.put("msg", "No general setting data found.");
                resultObj.put("data", settingsArray);
                statement.close();
                break;
            }
            catch (SQLException e) {
                e.printStackTrace();
                if (e.getErrorCode() != 5 || attempt == 4) {
                    e.printStackTrace();
                    resultObj.put("data", settingsArray);
                    resultObj.put("status", "fail");
                    resultObj.put("msg", "Error while retrieving general setting data.");
                    logger.error("Error while retrieving general setting data: " + e);
                    FileBasedLogger.error("Network", "Error while retrieving general setting data: " + e, "system");
                    break;
                }
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
                continue;
            }
            finally {
                SQLiteConnector.closeConnection(connection);
            }
        }
        return resultObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject updateGeneralSetting(JSONObject json, int id, String user) throws JSONException {
        JSONObject resultObj = new JSONObject();
        for (int attempt = 0; attempt < 5; ++attempt) {
            Connection connection = SQLiteConnector.getConnection();
            try {
                if (this.isRecordExists(connection, "general_setting", id)) {
                    String input = json.getString("input");
                    String rule_drop = json.getString("rule_drop");
                    String interfaces = json.getString("interface");
                    String sql = "UPDATE general_setting SET input=?, rule_drop=?, interface=? WHERE id=?";
                    PreparedStatement statement = connection.prepareStatement(sql);
                    statement.setString(1, GenralSettingsOperation.encrypt(input));
                    statement.setString(2, GenralSettingsOperation.encrypt(rule_drop));
                    statement.setString(3, GenralSettingsOperation.encrypt(interfaces));
                    statement.setInt(4, id);
                    int updatedRows = statement.executeUpdate();
                    statement.close();
                    if (updatedRows > 0) {
                        resultObj.put("status", "success");
                        resultObj.put("msg", "General setting updated successfully.");
                        logger.debug("General setting updated successfully.");
                        break;
                    }
                    resultObj.put("status", "fail");
                    resultObj.put("msg", "General setting are not found or not updated.");
                    logger.debug("Genral settings not found or updated.");
                    break;
                }
                String input = json.getString("input");
                String rule_drop = json.getString("rule_drop");
                String interfaces = json.getString("interface");
                String sql = "INSERT INTO general_setting (input, rule_drop,interface) VALUES (?, ?, ?, ?,?)";
                PreparedStatement statement = connection.prepareStatement(sql);
                statement.setString(1, GenralSettingsOperation.encrypt(input));
                statement.setString(2, GenralSettingsOperation.encrypt(rule_drop));
                statement.setString(3, GenralSettingsOperation.encrypt(interfaces));
                statement.executeUpdate();
                statement.close();
                resultObj.put("status", "success");
                resultObj.put("msg", "General setting has been saved successfully.");
                logger.info("Genral settings has been saved successfully.");
                break;
            }
            catch (SQLException e) {
                e.printStackTrace();
                if (e.getErrorCode() != 5 || attempt == 4) {
                    e.printStackTrace();
                    resultObj.put("status", "fail");
                    resultObj.put("msg", "Error while updating general setting data");
                    logger.error("Error occurred while updating general setting data : " + e);
                    FileBasedLogger.error("Network", "Error occurred while updating general setting data : " + e, user);
                    break;
                }
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
                continue;
            }
            finally {
                SQLiteConnector.closeConnection(connection);
            }
        }
        return resultObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject deleteGeneralSetting(String user) throws JSONException {
        JSONObject resultObj = new JSONObject();
        Connection connection = null;
        try {
            connection = SQLiteConnector.getConnection();
            String sql = "DELETE FROM general_setting";
            PreparedStatement statement = connection.prepareStatement(sql);
            int deletedRows = statement.executeUpdate();
            statement.close();
            if (deletedRows > 0) {
                resultObj.put("status", "success");
                resultObj.put("msg", "All general settings deleted successfully.");
                logger.info("Deleted All general settings.");
                FileBasedLogger.info("Network", "Deleted All general settings.", user);
            } else {
                logger.info("Failed to delete all general settings.");
                FileBasedLogger.info("Network", "Failed to delete all general settings.", user);
                resultObj.put("status", "fail");
                resultObj.put("msg", "Failed to delete general settings.");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            resultObj.put("status", "fail");
            resultObj.put("msg", "Error while deleting general settings.");
            logger.error("Error occurred while deleting general settings : " + e);
            FileBasedLogger.error("Network", "Error occurred while deleting general settings : " + e, user);
        }
        finally {
            SQLiteConnector.closeConnection(connection);
        }
        return resultObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject getGeneralSettingByInterface(String targetInterface) throws JSONException {
        JSONObject resultObj = new JSONObject();
        for (int attempt = 0; attempt < 5; ++attempt) {
            Connection connection = SQLiteConnector.getConnection();
            ResultSet resultSet = null;
            try {
                String sql = "SELECT * FROM general_setting WHERE interface = ?";
                PreparedStatement statement = connection.prepareStatement(sql);
                statement.setString(1, GenralSettingsOperation.encrypt(targetInterface));
                resultSet = statement.executeQuery();
                if (resultSet.next()) {
                    String input = resultSet.getString("input");
                    String rule_drop = resultSet.getString("rule_drop");
                    String interfaces = resultSet.getString("interface");
                    resultObj.put("input", GenralSettingsOperation.decrypt(input));
                    resultObj.put("rule_drop", GenralSettingsOperation.decrypt(rule_drop));
                    resultObj.put("interface", GenralSettingsOperation.decrypt(interfaces));
                    resultObj.put("status", "success");
                    resultObj.put("msg", "Successfully fetched data for interface. ");
                } else {
                    resultObj.put("status", "fail");
                    resultObj.put("msg", "No general setting data found for interface. ");
                }
                statement.close();
                break;
            }
            catch (SQLException e) {
                e.printStackTrace();
                if (e.getErrorCode() != 5 || attempt == 4) {
                    e.printStackTrace();
                    resultObj.put("status", "fail");
                    resultObj.put("msg", "Error while retrieving general setting data.");
                    logger.error("Error while retrieving general setting data: " + e);
                    FileBasedLogger.error("Network", "Error while retrieving general setting data: " + e, "system");
                    break;
                }
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
                continue;
            }
            finally {
                SQLiteConnector.closeConnection(connection);
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return resultObj;
    }
}

