/*
 * Decompiled with CFR 0.152.
 */
package com.tas.wp500.IdentityStore;

import com.tas.wp500.fileLogSetting.FileBasedLogger;
import com.tas.wp500.sql_lite_db.SQLiteConnector;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class StoreDbSetting {
    private Logger logger = Logger.getLogger(StoreDbSetting.class);
    private static StoreDbSetting instance = null;
    private static final int SQLITE_BUSY = 5;
    private static final int RETRY_COUNT = 5;
    private static final int RETRY_DELAY = 10000;

    public StoreDbSetting() {
        this.createStoreTable();
        this.insertStoreIdentity();
    }

    public static StoreDbSetting getInstance() {
        if (instance == null) {
            instance = new StoreDbSetting();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createStoreTable() {
        for (int attempt = 0; attempt < 5; ++attempt) {
            Connection connection = SQLiteConnector.getConnection();
            String sql = "CREATE TABLE IF NOT EXISTS store_identity (store_name TEXT NOT NULL PRIMARY KEY, private_key_file_path TEXT NOT NULL, cer_file_path TEXT NOT NULL);";
            try {
                PreparedStatement statement = connection.prepareStatement(sql);
                statement.execute();
                statement.close();
                this.logger.debug("Table store_identity created successfully.");
                break;
            }
            catch (SQLException e) {
                this.logger.error("Error while creating store_identity table: " + e);
                e.printStackTrace();
                if (e.getErrorCode() != 5 || attempt == 4) {
                    e.printStackTrace();
                    this.logger.error("Error while creating store_identity table: " + e);
                    FileBasedLogger.error("Audit", "Error while creating store_identity table: " + e, "system");
                    break;
                }
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
                continue;
            }
            finally {
                SQLiteConnector.closeConnection(connection);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertStoreIdentity() {
        String storeName = "WP500CertificateStore";
        String privateKeyFilePath = "WP500Private.pem";
        String cerFilePath = "WP500Certificate.pem";
        for (int attempt = 0; attempt < 5; ++attempt) {
            Connection connection = SQLiteConnector.getConnection();
            String checkQuery = "SELECT COUNT(*) FROM store_identity WHERE store_name = ?";
            String insertQuery = "INSERT INTO store_identity (store_name, private_key_file_path, cer_file_path) VALUES (?, ?, ?)";
            try {
                PreparedStatement checkStatement = connection.prepareStatement(checkQuery);
                checkStatement.setString(1, storeName);
                ResultSet resultSet = checkStatement.executeQuery();
                resultSet.next();
                int count = resultSet.getInt(1);
                resultSet.close();
                checkStatement.close();
                if (count == 0) {
                    PreparedStatement insertStatement = connection.prepareStatement(insertQuery);
                    insertStatement.setString(1, storeName);
                    insertStatement.setString(2, privateKeyFilePath);
                    insertStatement.setString(3, cerFilePath);
                    insertStatement.executeUpdate();
                    insertStatement.close();
                    this.logger.info("Record inserted successfully into store_identity table.");
                    break;
                }
                this.logger.info("Record already exists in store_identity table. No action taken.");
                break;
            }
            catch (SQLException e) {
                if (e.getErrorCode() != 5 || attempt == 4) {
                    e.printStackTrace();
                    this.logger.error("Error while inserting record into store_identity table: " + e);
                    FileBasedLogger.error("Audit", "Error while inserting record into store_identity table: " + e, "system");
                    break;
                }
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
                continue;
            }
            finally {
                SQLiteConnector.closeConnection(connection);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject insertStore(JSONObject json) {
        JSONObject result = new JSONObject();
        for (int attempt = 0; attempt < 5; ++attempt) {
            Connection connection = SQLiteConnector.getConnection();
            String checkSql = "SELECT COUNT(*) FROM store_identity WHERE store_name = ?";
            String insertSql = "INSERT INTO store_identity (store_name, private_key_file_path, cer_file_path) VALUES (?, ?, ?)";
            try {
                PreparedStatement checkStatement = connection.prepareStatement(checkSql);
                checkStatement.setString(1, json.getString("store_name"));
                ResultSet rs = checkStatement.executeQuery();
                if (rs.next() && rs.getInt(1) > 0) {
                    result.put("status", "fail");
                    result.put("msg", "Store name already exists.");
                    this.logger.info("Store name already exists.");
                    FileBasedLogger.info("Application", "Attempt to insert duplicate store name.", json.getString("user"));
                    JSONObject jSONObject = result;
                    return jSONObject;
                }
                rs.close();
                checkStatement.close();
                PreparedStatement insertStatement = connection.prepareStatement(insertSql);
                insertStatement.setString(1, json.getString("store_name"));
                insertStatement.setString(2, json.getString("private_key_file_path"));
                insertStatement.setString(3, json.getString("cer_file_path"));
                int rows = insertStatement.executeUpdate();
                insertStatement.close();
                if (rows > 0) {
                    result.put("status", "success");
                    result.put("msg", "Store inserted successfully.");
                    this.logger.info("Store data inserted successfully.");
                    FileBasedLogger.info("Application", "Store data inserted successfully.", json.getString("user"));
                    break;
                }
                result.put("status", "fail");
                result.put("msg", "Failed to insert store.");
                this.logger.info("Failed to insert store data.");
                FileBasedLogger.info("Application", "Failed to insert store data.", json.getString("user"));
                break;
            }
            catch (SQLException e) {
                if (e.getErrorCode() != 5 || attempt == 4) {
                    e.printStackTrace();
                    this.logger.error("Error inserting store: " + e);
                    FileBasedLogger.error("Application", "Error while inserting store data: ", json.getString("user"));
                    result.put("status", "error");
                    result.put("msg", "Exception occurred: " + e.getMessage());
                    break;
                }
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
                continue;
            }
            finally {
                SQLiteConnector.closeConnection(connection);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject updateStore(JSONObject json) {
        JSONObject result = new JSONObject();
        for (int attempt = 0; attempt < 5; ++attempt) {
            Connection connection = SQLiteConnector.getConnection();
            String sql = "UPDATE store_identity SET private_key_file_path = ?, cer_file_path = ? WHERE store_name = ?";
            try {
                PreparedStatement statement = connection.prepareStatement(sql);
                statement.setString(1, json.getString("private_key_file_path"));
                statement.setString(2, json.getString("cer_file_path"));
                statement.setString(3, json.getString("store_name"));
                int rows = statement.executeUpdate();
                statement.close();
                if (rows > 0) {
                    result.put("status", "success");
                    result.put("msg", "Store updated successfully.");
                    this.logger.info("store data updated successfully.");
                    FileBasedLogger.info("Application", "store data updated successfully.", json.getString("user"));
                    break;
                }
                result.put("status", "fail");
                result.put("msg", "Store not found.");
                this.logger.info("Faield to update store data.");
                FileBasedLogger.info("Application", "Failed to update store data.", json.getString("user"));
                break;
            }
            catch (SQLException e) {
                if (e.getErrorCode() != 5 || attempt == 4) {
                    e.printStackTrace();
                    this.logger.error("Error updating store: " + e);
                    FileBasedLogger.error("Application", "Error while update store data.", json.getString("user"));
                    result.put("status", "error");
                    result.put("msg", "Exception occurred: " + e.getMessage());
                    break;
                }
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
                continue;
            }
            finally {
                SQLiteConnector.closeConnection(connection);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject deleteStore(JSONObject json) {
        JSONObject result = new JSONObject();
        String storeName = json.getString("store_name");
        String user = json.getString("user");
        String storeDirPath = "/data/" + File.separator + storeName;
        File storeDir = new File(storeDirPath);
        if (storeDir.exists() && this.deleteDirectory(storeDir)) {
            for (int attempt = 0; attempt < 5; ++attempt) {
                Connection connection = SQLiteConnector.getConnection();
                String sql = "DELETE FROM store_identity WHERE store_name = ?";
                try {
                    PreparedStatement statement = connection.prepareStatement(sql);
                    statement.setString(1, storeName);
                    int rows = statement.executeUpdate();
                    statement.close();
                    if (rows > 0) {
                        result.put("status", "success");
                        result.put("msg", "Store deleted successfully.");
                        FileBasedLogger.info("Application", "Store data deleted successfully.", user);
                    } else {
                        result.put("status", "fail");
                        result.put("msg", "Store not found in database.");
                        FileBasedLogger.info("Application", "Store not found in database.", user);
                    }
                    break;
                }
                catch (SQLException e) {
                    if (e.getErrorCode() != 5 || attempt == 4) {
                        e.printStackTrace();
                        this.logger.error("Error deleting store from database: " + e);
                        FileBasedLogger.error("Application", "Error while deleting store data from database.", user);
                        result.put("status", "error");
                        result.put("msg", "Exception occurred: " + e.getMessage());
                        break;
                    }
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (InterruptedException ie) {
                        Thread.currentThread().interrupt();
                    }
                    continue;
                }
                finally {
                    SQLiteConnector.closeConnection(connection);
                }
            }
        } else {
            result.put("status", "error");
            result.put("msg", "Failed to delete directory for store: " + storeName);
            FileBasedLogger.error("Application", "Failed to delete directory for store.", user);
        }
        return result;
    }

    private boolean deleteDirectory(File directory) {
        File[] files;
        if (directory.isDirectory() && (files = directory.listFiles()) != null) {
            for (File file : files) {
                if (this.deleteDirectory(file)) continue;
                return false;
            }
        }
        return directory.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject getStoreByName(JSONObject json) {
        JSONObject result = new JSONObject();
        for (int attempt = 0; attempt < 5; ++attempt) {
            Connection connection = SQLiteConnector.getConnection();
            String sql = "SELECT * FROM store_identity WHERE store_name = ?";
            try {
                PreparedStatement statement = connection.prepareStatement(sql);
                statement.setString(1, json.getString("store_name"));
                ResultSet rs = statement.executeQuery();
                if (rs.next()) {
                    result.put("store_name", rs.getString("store_name"));
                    result.put("private_key_file_path", rs.getString("private_key_file_path"));
                    result.put("cer_file_path", rs.getString("cer_file_path"));
                    result.put("status", "success");
                    result.put("msg", "Store retrieved successfully.");
                } else {
                    result.put("status", "fail");
                    result.put("msg", "Store not found.");
                }
                rs.close();
                statement.close();
                break;
            }
            catch (SQLException e) {
                if (e.getErrorCode() != 5 || attempt == 4) {
                    e.printStackTrace();
                    this.logger.error("Error retrieving store: " + e);
                    result.put("status", "error");
                    result.put("msg", "Exception occurred: " + e.getMessage());
                    break;
                }
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
                continue;
            }
            finally {
                SQLiteConnector.closeConnection(connection);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject getAllStores() {
        JSONObject result = new JSONObject();
        JSONArray storeArray = new JSONArray();
        for (int attempt = 0; attempt < 5; ++attempt) {
            Connection connection = SQLiteConnector.getConnection();
            String sql = "SELECT * FROM store_identity";
            try {
                PreparedStatement statement = connection.prepareStatement(sql);
                ResultSet rs = statement.executeQuery();
                while (rs.next()) {
                    JSONObject store = new JSONObject();
                    store.put("store_name", rs.getString("store_name"));
                    store.put("private_key_file_path", rs.getString("private_key_file_path"));
                    store.put("cer_file_path", rs.getString("cer_file_path"));
                    storeArray.put(store);
                }
                rs.close();
                statement.close();
                if (storeArray.length() > 0) {
                    result.put("status", "success");
                    result.put("resultArray", storeArray);
                    result.put("msg", "Stores retrieved successfully.");
                    break;
                }
                result.put("status", "success");
                result.put("msg", "No stores found.");
                break;
            }
            catch (SQLException e) {
                if (e.getErrorCode() != 5 || attempt == 4) {
                    e.printStackTrace();
                    this.logger.error("Error retrieving all stores: " + e);
                    result.put("status", "error");
                    result.put("msg", "Exception occurred: " + e.getMessage());
                    break;
                }
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
                continue;
            }
            finally {
                SQLiteConnector.closeConnection(connection);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject getAllStoreNames() {
        JSONObject result = new JSONObject();
        JSONArray storeNameArray = new JSONArray();
        for (int attempt = 0; attempt < 5; ++attempt) {
            Connection connection = SQLiteConnector.getConnection();
            String sql = "SELECT store_name FROM store_identity";
            try {
                PreparedStatement statement = connection.prepareStatement(sql);
                ResultSet rs = statement.executeQuery();
                while (rs.next()) {
                    storeNameArray.put(rs.getString("store_name"));
                }
                rs.close();
                statement.close();
                if (storeNameArray.length() > 0) {
                    result.put("status", "success");
                    result.put("storeNames", storeNameArray);
                    result.put("msg", "Store names retrieved successfully.");
                    break;
                }
                result.put("status", "success");
                result.put("msg", "No store names found.");
                break;
            }
            catch (SQLException e) {
                if (e.getErrorCode() != 5 || attempt == 4) {
                    e.printStackTrace();
                    this.logger.error("Error retrieving store names: " + e);
                    result.put("status", "error");
                    result.put("msg", "Exception occurred: " + e.getMessage());
                    break;
                }
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
                continue;
            }
            finally {
                SQLiteConnector.closeConnection(connection);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject getStoreByName(String storeName) {
        JSONObject result = new JSONObject();
        Connection connection = SQLiteConnector.getConnection();
        String sql = "SELECT store_name, private_key_file_path, cer_file_path FROM store_identity WHERE store_name = ?";
        try {
            PreparedStatement statement = connection.prepareStatement(sql);
            statement.setString(1, storeName);
            ResultSet resultSet = statement.executeQuery();
            if (resultSet.next()) {
                result.put("store_name", resultSet.getString("store_name"));
                result.put("private_key_file_path", resultSet.getString("private_key_file_path"));
                result.put("cer_file_path", resultSet.getString("cer_file_path"));
                result.put("status", "success");
            } else {
                result.put("status", "fail");
                result.put("msg", "No store found with the given name.");
            }
            statement.close();
        }
        catch (SQLException e) {
            this.logger.error("Error retrieving store: " + e);
            result.put("status", "error");
            result.put("msg", "Exception occurred: " + e.getMessage());
        }
        finally {
            SQLiteConnector.closeConnection(connection);
        }
        return result;
    }

    public JSONObject applyStoreData(JSONObject json) {
        JSONObject result = new JSONObject();
        if (json.has("store_name")) {
            String storeName = json.getString("store_name");
            JSONObject storeData = this.getStoreByName(storeName);
            if (storeData.has("private_key_file_path") && storeData.has("cer_file_path")) {
                String sourceCrtFile = "/data/" + storeName + "/" + storeData.getString("cer_file_path");
                String sourcePrtFile = "/data/" + storeName + "/" + storeData.getString("private_key_file_path");
                String destinationDirectory = "/opt/apache-tomcat-9.0.85/conf/";
                String destinationCrtFile = destinationDirectory + "certificate.pem";
                String destinationPrtFile = destinationDirectory + "private.pem";
                boolean crtCopySuccess = StoreDbSetting.copyAndRenameFile(sourceCrtFile, destinationCrtFile);
                boolean prtCopySuccess = StoreDbSetting.copyAndRenameFile(sourcePrtFile, destinationPrtFile);
                if (crtCopySuccess && prtCopySuccess) {
                    result.put("status", "success");
                    result.put("msg", "Certificate and private key have been successfully updated. The system will now use the new files.");
                    return this.rebootSystem();
                }
                result.put("status", "error");
                result.put("msg", "An error occurred while updating the certificate and private key files. Please try again or check file permissions.");
            } else {
                result.put("status", "incomplete");
                result.put("msg", "The required store data is incomplete. Ensure both the private and certificate file are available for the store.");
            }
        } else {
            result.put("status", "fail");
            result.put("msg", "The 'store_name' field is missing in the input. Please provide a valid store name to proceed.");
        }
        return result;
    }

    public static boolean copyAndRenameFile(String sourceFilePath, String destinationFilePath) {
        try {
            Path sourcePath = new File(sourceFilePath).toPath();
            Path destinationPath = new File(destinationFilePath).toPath();
            if (!Files.exists(sourcePath, new LinkOption[0])) {
                System.err.println("Source file does not exist: " + sourceFilePath);
                return false;
            }
            File destinationDir = new File(destinationFilePath).getParentFile();
            if (!destinationDir.exists()) {
                destinationDir.mkdirs();
            }
            Files.copy(sourcePath, destinationPath, StandardCopyOption.REPLACE_EXISTING);
            return true;
        }
        catch (IOException e) {
            System.err.println("Error while copying file: " + e.getMessage());
            return false;
        }
    }

    public JSONObject rebootSystem() throws JSONException {
        final JSONObject json = new JSONObject();
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(5000L);
                    Process process = Runtime.getRuntime().exec("reboot");
                    int exitStatus = process.waitFor();
                    if (exitStatus == 0) {
                        StoreDbSetting.this.logger.info("Rebooting the system.");
                        FileBasedLogger.info("Application", "Rebooting the system.", "system");
                    } else {
                        StoreDbSetting.this.logger.error("Failed to reboot the system.");
                        FileBasedLogger.error("Application", "Failed to reboot the system.", "system");
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    StoreDbSetting.this.logger.error("Error occurred while rebooting the system." + e.getMessage());
                    FileBasedLogger.error("Application", "Error occurred while rebooting the system." + e.getMessage(), "system");
                    try {
                        json.put("status", "error");
                        json.put("msg", "Error occurred while rebooting the system.");
                    }
                    catch (JSONException e1) {
                        e1.printStackTrace();
                    }
                }
            }
        }).start();
        try {
            json.put("status", "success");
            json.put("msg", "Store data applied successfully.System is Rebooting. Please wait !!!");
        }
        catch (JSONException e) {
            this.logger.error("Error occurred while rebooting the system." + e.getMessage());
            FileBasedLogger.error("Application", "Error occurred while rebooting the system." + e.getMessage(), "system");
            json.put("status", "fail");
            json.put("msg", "Failed to reboot the system.");
        }
        return json;
    }

    public JSONObject sortQueryDbOperation(JSONObject json) throws JSONException {
        JSONObject ack_res = new JSONObject();
        if (json.has("operation_type")) {
            String operation_type;
            switch (operation_type = json.getString("operation_type")) {
                case "add_store_data": {
                    ack_res = this.insertStore(json);
                    ack_res.put("operation", "add_store_data");
                    break;
                }
                case "update_store_data": {
                    ack_res = this.updateStore(json);
                    ack_res.put("operation", "update_store_data");
                    break;
                }
                case "get_store_all_data": {
                    ack_res = this.getAllStores();
                    ack_res.put("operation", "get_store_all_data");
                    break;
                }
                case "get_store_list": {
                    ack_res = this.getAllStoreNames();
                    ack_res.put("operation", "get_store_list");
                    break;
                }
                case "apply_store": {
                    ack_res = this.applyStoreData(json);
                    ack_res.put("operation", "apply_store");
                    break;
                }
                case "delete_store": {
                    ack_res = this.deleteStore(json);
                    ack_res.put("operation", "delete_store");
                    break;
                }
            }
        }
        return ack_res;
    }
}

