/*
 * Decompiled with CFR 0.152.
 */
package com.tas.wp500;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.tas.wp500.IdentityStore.StoreDbSetting;
import com.tas.wp500.IptablesSetting.IptableSettingsOperations;
import com.tas.wp500.IptablesSetting.IptablesManager;
import com.tas.wp500.backup_restore.Backup;
import com.tas.wp500.backup_restore.BackupKeyDbOperation;
import com.tas.wp500.backup_restore.Restore;
import com.tas.wp500.banner.BannerService;
import com.tas.wp500.cgi_command.CGI_Command;
import com.tas.wp500.configFileDbSettings.ConfigFileDbOperation;
import com.tas.wp500.events.EventsDbOperation;
import com.tas.wp500.factory_reset.FactoryReset;
import com.tas.wp500.fileHashSettings.FileIntegrityMonitorOperation;
import com.tas.wp500.fileLogSetting.LogFileReader;
import com.tas.wp500.firmware.FirmwareUpdate;
import com.tas.wp500.jsonBuilderSettings.JsonBuilder_operation;
import com.tas.wp500.linx_command.FileReaderUtil;
import com.tas.wp500.linx_command.LinuxCommad;
import com.tas.wp500.liveValueTrigger.LiveValueTriggerOperation;
import com.tas.wp500.opc_Settings.OpcClientSettingsOperations;
import com.tas.wp500.opc_entity.OpcNode;
import com.tas.wp500.opc_ua_apis.OPCUARequester;
import com.tas.wp500.passwordSetting.PasswordPolicyDbOperation;
import com.tas.wp500.projectSetting.ProjectNameSetting;
import com.tas.wp500.protocol.startan.StratonStatusFetcher;
import com.tas.wp500.query_sort.ConfigQueries;
import com.tas.wp500.query_sort.ConfigTraficRule;
import com.tas.wp500.rsyslogSettings.Rsyslog;
import com.tas.wp500.security.CaptchaSetting;
import com.tas.wp500.services.Service;
import com.tas.wp500.smtpSettings.SmptSetting2fa;
import com.tas.wp500.smtpSettings.SmtpDemo;
import com.tas.wp500.snort.ProcessListReader;
import com.tas.wp500.snort.snortDBOperation.SnortSettings;
import com.tas.wp500.sql_lite_db.Db_opertions;
import com.tas.wp500.ssl_certificate_manager.SSLCertificateGenerator;
import com.tas.wp500.ssl_certificate_manager.ServerXmlModifier;
import com.tas.wp500.store_and_forword.StoreAndForwordDbOperations;
import com.tas.wp500.tag.TagValueSettingsOperations;
import com.tas.wp500.totpSetting.QRCodeGenerator;
import com.tas.wp500.totpSetting.TOTPAuthenticator;
import com.tas.wp500.util.LiveDataOperations;
import com.tas.wp500.wireguard.WireGuardService;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import javax.net.ssl.SSLException;
import org.apache.log4j.Logger;
import org.apache.log4j.MDC;
import org.json.JSONObject;

public class ClientHandler
implements Runnable {
    private Logger logger = Logger.getLogger(ClientHandler.class);
    public DateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    Socket ClientSocket;
    BufferedWriter output;
    JSONObject config_addr;
    String msg = "";
    BufferedReader br;
    InputStreamReader in;
    OutputStreamWriter out;
    private Service service;
    private LinuxCommad linux = LinuxCommad.getInstance();
    private FileReaderUtil fileReaderUtil = FileReaderUtil.getInstance();
    private Db_opertions db = Db_opertions.getInstance();
    private ConfigQueries config = ConfigQueries.getInstance();
    private CGI_Command cgi = CGI_Command.getInstance();
    private LiveDataOperations live = LiveDataOperations.getInstance();
    private StoreAndForwordDbOperations store = StoreAndForwordDbOperations.getInstance();
    private ConfigTraficRule configTraficRule = ConfigTraficRule.getInstance();
    private SnortSettings snort = SnortSettings.getInstance();
    private IptableSettingsOperations iptable = IptableSettingsOperations.getInstnce();
    private OpcClientSettingsOperations opc = OpcClientSettingsOperations.getInstance();
    private OPCUARequester opcReq = OPCUARequester.getInstance();
    private ObjectMapper objectMapper = new ObjectMapper();
    private TagValueSettingsOperations tag = TagValueSettingsOperations.getInstance();
    private PasswordPolicyDbOperation pw = PasswordPolicyDbOperation.getInstance();
    private WireGuardService wireguard = WireGuardService.getWireguardInstance();
    private LiveValueTriggerOperation liveValueTriggerOperation = LiveValueTriggerOperation.getInstance();
    private BannerService banner = BannerService.getInstance();
    private Backup backup = Backup.getInstance();
    private Restore restore = Restore.getInstance();
    private FirmwareUpdate firmware = FirmwareUpdate.getInstance();
    private FactoryReset factoryReset = FactoryReset.getInstance();
    private IptablesManager iptablesManager = IptablesManager.getInstance();
    private Rsyslog rsyslog = Rsyslog.getInstance();
    private TOTPAuthenticator totpAuthenticator = TOTPAuthenticator.getInstance();
    private QRCodeGenerator qrCodeGenerator = QRCodeGenerator.getInstance();
    private SmptSetting2fa smptSetting2fa = SmptSetting2fa.getInstance();
    private PasswordPolicyDbOperation passwordPolicyDbOperation = PasswordPolicyDbOperation.getInstance();
    private ServerXmlModifier serverXmlModifier = ServerXmlModifier.getInstance();
    private FileIntegrityMonitorOperation fileIntegrityMonitorOperation = FileIntegrityMonitorOperation.getInstance();
    private BackupKeyDbOperation backupKeyDbOperation = BackupKeyDbOperation.getInstance();
    private ProjectNameSetting projectNameSetting = ProjectNameSetting.getInstance();
    private StoreDbSetting storeDbSetting = StoreDbSetting.getInstance();
    private ConfigFileDbOperation configFileDbOperation = ConfigFileDbOperation.getInstance();

    public ClientHandler() {
    }

    public ClientHandler(Socket clientSocket, Service service) {
        this.ClientSocket = clientSocket;
        this.service = service;
    }

    @Override
    public void run() {
        try {
            this.in = new InputStreamReader(this.ClientSocket.getInputStream());
            this.br = new BufferedReader(this.in);
            this.out = new OutputStreamWriter(this.ClientSocket.getOutputStream());
            this.output = new BufferedWriter(this.out);
            this.msg = this.br.readLine();
            this.operation(new JSONObject(this.msg), "tcp-server");
        }
        catch (SSLException e) {
            String peerHost = this.ClientSocket.getInetAddress().getHostAddress();
            String errorMessage = "SSL/TLS handshake failed with client at " + peerHost + ": " + e.getMessage();
            this.logger.error(errorMessage, e);
            this.logger.debug("Detailed SSLException: " + errorMessage);
        }
        catch (Exception e) {
            this.logger.error("Unexpected error occurred while handling client request: " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String operation(JSONObject json, String type) {
        JSONObject ack_res;
        block406: {
            ack_res = new JSONObject();
            try {
                if (json.has("operation") && json.has("token") && json.has("user") && json.has("role")) {
                    String token = json.getString("token");
                    String user = json.getString("user");
                    String userRole = json.getString("role");
                    this.userLogin(user);
                    if (Service.USER_WISE_TOKEN.containsKey(user)) {
                        String user_stored_token = Service.USER_WISE_TOKEN.get(user);
                        if (token.equals(user_stored_token)) {
                            switch (json.getString("operation").trim()) {
                                case "health": {
                                    ack_res.put("operation", "health");
                                    ack_res.put("health", "OK");
                                    break;
                                }
                                case "add_user": {
                                    if (userRole.equalsIgnoreCase("admin")) {
                                        ack_res.put("operation", "add_user");
                                        ack_res = this.linux.addUser(json, user);
                                        this.fileIntegrityMonitorOperation.saveFileChecksumsToDB(user);
                                        break;
                                    }
                                    ack_res.put("status", "fail");
                                    ack_res.put("msg", "Access denied. Only administrators can perform operation.");
                                    break;
                                }
                                case "delete_user": {
                                    if (userRole.equalsIgnoreCase("admin")) {
                                        ack_res.put("operation", "delete_user");
                                        ack_res = this.linux.deleteUserFromLinux(json, user);
                                        break;
                                    }
                                    ack_res.put("status", "fail");
                                    ack_res.put("msg", "Access denied. Only administrators can perform operation.");
                                    break;
                                }
                                case "update_user": {
                                    if (userRole.equalsIgnoreCase("admin")) {
                                        ack_res.put("operation", "update_user");
                                        ack_res = this.db.updateUser(json, user);
                                        break;
                                    }
                                    ack_res.put("status", "fail");
                                    ack_res.put("msg", "Access denied. Only administrators can perform operation.");
                                    break;
                                }
                                case "update_user_password": {
                                    if (userRole.equalsIgnoreCase("admin")) {
                                        ack_res.put("operation", "update_user_password");
                                        ack_res = this.linux.updateUserPasswordOfLinux1(json, user);
                                        this.fileIntegrityMonitorOperation.saveFileChecksumsToDB(user);
                                        break;
                                    }
                                    ack_res.put("status", "fail");
                                    ack_res.put("msg", "Access denied. Only administrators can perform operation.");
                                    break;
                                }
                                case "update_old_password": {
                                    if (userRole.equalsIgnoreCase("admin") || userRole.equalsIgnoreCase("operator") || userRole.equalsIgnoreCase("engineer")) {
                                        ack_res.put("operation", "update_old_password");
                                        ack_res = this.db.updateOldPassword(json, user);
                                        this.fileIntegrityMonitorOperation.saveFileChecksumsToDB(user);
                                        break;
                                    }
                                    ack_res.put("status", "fail");
                                    ack_res.put("msg", "Access denied. Only administrators and operator can perform operation.");
                                    break;
                                }
                                case "update_totp": {
                                    if (userRole.equalsIgnoreCase("admin") || userRole.equalsIgnoreCase("operator") || userRole.equalsIgnoreCase("engineer")) {
                                        ack_res.put("operation", "update_totp");
                                        ack_res = this.db.updateTotpDetails(json, user);
                                        break;
                                    }
                                    ack_res.put("status", "fail");
                                    ack_res.put("msg", "Access denied. Only administrators and and Engineer operator can perform operation.");
                                    break;
                                }
                                case "get_totp_details": {
                                    if (userRole.equalsIgnoreCase("admin") || userRole.equalsIgnoreCase("operator") || userRole.equalsIgnoreCase("engineer")) {
                                        ack_res.put("operation", "get_totp_details");
                                        ack_res = this.db.getTotpDetails(json, user);
                                        break;
                                    }
                                    ack_res.put("status", "fail");
                                    ack_res.put("msg", "Access denied. Only Administrators and and Engineer Viewer can perform operation.");
                                    break;
                                }
                                case "get_user_details": {
                                    if (userRole.equalsIgnoreCase("admin") || userRole.equalsIgnoreCase("operator") || userRole.equalsIgnoreCase("engineer")) {
                                        ack_res.put("operation", "get_user_details");
                                        ack_res.put("status", this.linux.getUserDetailsoFlinux());
                                        break;
                                    }
                                    ack_res.put("status", "fail");
                                    ack_res.put("msg", "Access denied. Only Administrators and and Engineer Viewer can perform operation.");
                                    break;
                                }
                                case "get_all_user": {
                                    if (userRole.equalsIgnoreCase("admin") || userRole.equalsIgnoreCase("operator") || userRole.equalsIgnoreCase("engineer")) {
                                        ack_res.put("operation", "get_all_user");
                                        ack_res = this.db.getAllUsers(json);
                                        break;
                                    }
                                    ack_res.put("status", "fail");
                                    ack_res.put("msg", "Access denied. Only Administrators and and Engineer Viewer can perform operation.");
                                    break;
                                }
                                case "update_lan_setting": {
                                    if (userRole.equalsIgnoreCase("admin") || userRole.equalsIgnoreCase("engineer")) {
                                        ack_res = this.fileReaderUtil.UpdateLanConfiguration(json, user);
                                        ack_res.put("operation", "update_lan_setting");
                                        break;
                                    }
                                    ack_res.put("status", "fail");
                                    ack_res.put("msg", "Access denied. Only Administrators and Engineer can perform operation.");
                                    break;
                                }
                                case "get_ethernet_details": {
                                    if (userRole.equalsIgnoreCase("admin") || userRole.equalsIgnoreCase("operator") || userRole.equalsIgnoreCase("engineer")) {
                                        ack_res = this.fileReaderUtil.getEthernetDetails1(json, user);
                                        ack_res.put("operation", "get_ethernet_details");
                                        break;
                                    }
                                    ack_res.put("status", "fail");
                                    ack_res.put("msg", "Access denied. Only Administrators and and Engineer Viewer can perform operation.");
                                    break;
                                }
                                case "login": {
                                    if (userRole.equalsIgnoreCase("admin") || userRole.equalsIgnoreCase("operator") || userRole.equalsIgnoreCase("engineer")) {
                                        ack_res = this.linux.doLogin(json);
                                        ack_res.put("operation", "login");
                                        break;
                                    }
                                    ack_res.put("status", "fail");
                                    ack_res.put("msg", "Access denied. Only Administrators and and Engineer Viewer can perform operation.");
                                    break;
                                }
                                case "logout": {
                                    if (userRole.equalsIgnoreCase("admin") || userRole.equalsIgnoreCase("operator") || userRole.equalsIgnoreCase("engineer")) {
                                        ack_res = this.linux.doLogout(json);
                                        ack_res.put("operation", "logout");
                                        break;
                                    }
                                    ack_res.put("status", "fail");
                                    ack_res.put("msg", "Access denied. Only Administrators and and Engineer Viewer can perform operation.");
                                    break;
                                }
                                case "get_firewall_settings": {
                                    if (userRole.equalsIgnoreCase("admin") || userRole.equalsIgnoreCase("operator") || userRole.equalsIgnoreCase("engineer")) {
                                        ack_res = this.fileReaderUtil.fetchFirewallSettings(json);
                                        ack_res.put("operation", "get_firewall_settings");
                                        break;
                                    }
                                    ack_res.put("status", "fail");
                                    ack_res.put("msg", "Access denied. Only Administrators and and Engineer Viewer can perform operation.");
                                    break;
                                }
                                case "get_ip_tables": {
                                    if (userRole.equalsIgnoreCase("admin") || userRole.equalsIgnoreCase("operator") || userRole.equalsIgnoreCase("engineer")) {
                                        ack_res = this.linux.getListOfFirewallSettingsOfIPTables();
                                        ack_res.put("operation", "get_ip_tables");
                                        break;
                                    }
                                    ack_res.put("status", "fail");
                                    ack_res.put("msg", "Access denied. Only Administrators and and Engineer Viewer can perform operation.");
                                    break;
                                }
                                case "add_firewall_setting": {
                                    if (userRole.equalsIgnoreCase("admin")) {
                                        ack_res = this.linux.addFirewallSettings(json, user);
                                        ack_res.put("operation", "add_firewall_setting");
                                        break;
                                    }
                                    ack_res.put("status", "fail");
                                    ack_res.put("msg", "Access denied. Only Administrators can perform operation.");
                                    break;
                                }
                                case "delete_firewall_setting": {
                                    if (userRole.equalsIgnoreCase("admin")) {
                                        ack_res = this.linux.deleteOneFirewallSettings(json, user);
                                        ack_res.put("operation", "delete_firewall_setting");
                                        break;
                                    }
                                    ack_res.put("status", "fail");
                                    ack_res.put("msg", "Access denied. Only Administrators can perform operation.");
                                    break;
                                }
                                case "get_dhcp_setting": {
                                    if (userRole.equalsIgnoreCase("admin") || userRole.equalsIgnoreCase("operator") || userRole.equalsIgnoreCase("engineer")) {
                                        ack_res = this.fileReaderUtil.getDhcpSettingIp(json, user);
                                        ack_res.put("operation", "get_dhcp_setting");
                                        break;
                                    }
                                    ack_res.put("status", "fail");
                                    ack_res.put("msg", "Access denied. Only Administrators and and Engineer Viewer can perform operation.");
                                    break;
                                }
                                case "get_log_file_list": {
                                    if (userRole.equalsIgnoreCase("admin") || userRole.equalsIgnoreCase("operator") || userRole.equalsIgnoreCase("engineer")) {
                                        ack_res = this.fileReaderUtil.getLogFileList(json);
                                        ack_res.put("operation", "get_log_file_list");
                                        break;
                                    }
                                    ack_res.put("status", "fail");
                                    ack_res.put("msg", "Access denied. Only Administrators and Engineer and Viewer can perform operation.");
                                    break;
                                }
                                case "get_log_file_data": {
                                    if (userRole.equalsIgnoreCase("admin") || userRole.equalsIgnoreCase("operator") || userRole.equalsIgnoreCase("engineer")) {
                                        ack_res = this.fileReaderUtil.getLogFileData(json);
                                        ack_res.put("operation", "get_log_file_data");
                                        break;
                                    }
                                    ack_res.put("status", "fail");
                                    ack_res.put("msg", "Access denied. Only Administrators and Engineer and Viewer can perform operation.");
                                    break;
                                }
                                case "get_ntp": {
                                    if (userRole.equalsIgnoreCase("admin") || userRole.equalsIgnoreCase("operator") || userRole.equalsIgnoreCase("engineer")) {
                                        ack_res = this.fileReaderUtil.get_ntp(json);
                                        ack_res.put("operation", "get_ntp");
                                        break;
                                    }
                                    ack_res.put("status", "fail");
                                    ack_res.put("msg", "Access denied. Only Administrators and and Engineer Viewer can perform operation.");
                                    break;
                                }
                                case "update_ntp": {
                                    if (userRole.equalsIgnoreCase("admin")) {
                                        ack_res = this.fileReaderUtil.update_ntp(json, user);
                                        ack_res.put("operation", "update_ntp");
                                        break;
                                    }
                                    ack_res.put("status", "fail");
                                    ack_res.put("msg", "Access denied. Only Administrators can perform operation.");
                                    break;
                                }
                                case "protocol": {
                                    ack_res = this.config.sortQueryUingProtocol(json, user, userRole);
                                    ack_res.put("operation", "protocol");
                                    break;
                                }
                                case "CGI_get_list": {
                                    if (userRole.equalsIgnoreCase("admin") || userRole.equalsIgnoreCase("operator") || userRole.equalsIgnoreCase("engineer")) {
                                        ack_res = this.cgi.executeCGIgetListCommand(json);
                                        ack_res.put("operation", "CGI_get_list");
                                        break;
                                    }
                                    ack_res.put("status", "fail");
                                    ack_res.put("msg", "Access denied. Only Administrators and and Engineer Viewer can perform operation.");
                                    break;
                                }
                                case "CGI_read_variable_list": {
                                    if (userRole.equalsIgnoreCase("admin") || userRole.equalsIgnoreCase("operator") || userRole.equalsIgnoreCase("engineer")) {
                                        ack_res = this.cgi.readMultiplevariableUsingCGICommand(json);
                                        ack_res.put("operation", "CGI_read_variable_list");
                                        break;
                                    }
                                    ack_res.put("status", "fail");
                                    ack_res.put("msg", "Access denied. Only Administrators and and Engineer Viewer can perform operation.");
                                    break;
                                }
                                case "get_live_data": {
                                    if (userRole.equalsIgnoreCase("admin") || userRole.equalsIgnoreCase("operator") || userRole.equalsIgnoreCase("engineer")) {
                                        ack_res = this.live.getLivedata(json);
                                        ack_res.put("operation", "get_live_data");
                                        break;
                                    }
                                    ack_res.put("status", "fail");
                                    ack_res.put("msg", "Access denied. Only Administrators and and Engineer Viewer can perform operation.");
                                    break;
                                }
                                case "get_Tag_list": {
                                    if (userRole.equalsIgnoreCase("admin") || userRole.equalsIgnoreCase("operator") || userRole.equalsIgnoreCase("engineer")) {
                                        ack_res = this.live.getOnlyVariableList(json);
                                        ack_res.put("operation", "get_Tag_list");
                                        break;
                                    }
                                    ack_res.put("status", "fail");
                                    ack_res.put("msg", "Access denied. Only Administrators and Engineer and Viewer can perform operation.");
                                    break;
                                }
                                case "load_config": {
                                    if (userRole.equalsIgnoreCase("admin") || userRole.equalsIgnoreCase("engineer")) {
                                        if (this.service.stopService(user)) {
                                            this.service.startService(user);
                                            this.logger.info("Done load configuration. ");
                                            ack_res.put("Status", "load configuration done");
                                            ack_res.put("msg", "Service has been loaded successfully.");
                                        } else {
                                            ack_res.put("Status", "Error while load configuration");
                                            ack_res.put("msg", "Service failed to load.");
                                        }
                                        ack_res.put("operation", "load_config");
                                        break;
                                    }
                                    ack_res.put("status", "fail");
                                    ack_res.put("msg", "Access denied. Only Administrators and Engineer can perform operation.");
                                    break;
                                }
                                case "get_mqtt_status": {
                                    if (userRole.equalsIgnoreCase("admin") || userRole.equalsIgnoreCase("operator") || userRole.equalsIgnoreCase("engineer")) {
                                        ack_res = this.fileReaderUtil.getMqttConnectionStatus(json);
                                        ack_res.put("operation", "get_mqtt_status");
                                        break;
                                    }
                                    ack_res.put("status", "fail");
                                    ack_res.put("msg", "Access denied. Only Administrators and Engineer and Viewer can perform operation.");
                                    break;
                                }
                                case "reboot": {
                                    if (userRole.equalsIgnoreCase("admin") || userRole.equalsIgnoreCase("engineer")) {
                                        ack_res = this.live.rebootSystem(user);
                                        ack_res.put("operation", "reboot");
                                        break;
                                    }
                                    ack_res.put("status", "fail");
                                    ack_res.put("msg", "Access denied. Only Administrators and Engineer can perform operation.");
                                    break;
                                }
                                case "get_live_date_time": {
                                    if (userRole.equalsIgnoreCase("admin") || userRole.equalsIgnoreCase("operator") || userRole.equalsIgnoreCase("engineer")) {
                                        ack_res = this.live.getliveDateTimeLinux(json);
                                        ack_res.put("operation", "get_live_date_time");
                                        break;
                                    }
                                    ack_res.put("status", "fail");
                                    ack_res.put("msg", "Access denied. Only Administrators and Engineer and Viewer can perform operation.");
                                    break;
                                }
                                case "get_store_forword_data": {
                                    if (userRole.equalsIgnoreCase("admin") || userRole.equalsIgnoreCase("operator") || userRole.equalsIgnoreCase("engineer")) {
                                        ack_res = this.store.getMultipleStoreForwordData(json);
                                        ack_res.put("operation", "get_store_forword_data");
                                        break;
                                    }
                                    ack_res.put("status", "fail");
                                    ack_res.put("msg", "Access denied. Only Administrators and Engineer and Viewer can perform operation.");
                                    break;
                                }
                                case "delete_store_forword_data": {
                                    if (userRole.equalsIgnoreCase("admin") || userRole.equalsIgnoreCase("engineer")) {
                                        ack_res = this.store.deleteAllStoreForwordData();
                                        ack_res.put("operation", "delete_store_forword_data");
                                        break;
                                    }
                                    ack_res.put("status", "fail");
                                    ack_res.put("msg", "Access denied. Only Administrators and Engineer can perform operation.");
                                    break;
                                }
                                case "get_event_data": {
                                    if (userRole.equalsIgnoreCase("admin") || userRole.equalsIgnoreCase("operator") || userRole.equalsIgnoreCase("engineer")) {
                                        ack_res = EventsDbOperation.getInstance().getMultipleEventData(json);
                                        ack_res.put("operation", "get_event_data");
                                        break;
                                    }
                                    ack_res.put("status", "fail");
                                    ack_res.put("msg", " Access denied. Only Administrators and Engineer and Viewer can perform operation.");
                                    break;
                                }
                                case "set_manul_time": {
                                    if (userRole.equalsIgnoreCase("admin") || userRole.equalsIgnoreCase("engineer")) {
                                        ack_res = this.fileReaderUtil.setManulTime(json, user);
                                        ack_res.put("operation", "setNtp");
                                        break;
                                    }
                                    ack_res.put("status", "fail");
                                    ack_res.put("msg", "Access denied. Only Administrators and Engineer and engineer can perform operation.");
                                    break;
                                }
                                case "firewall_settings": {
                                    if (userRole.equalsIgnoreCase("admin") || userRole.equalsIgnoreCase("operator") || userRole.equalsIgnoreCase("engineer")) {
                                        ack_res = this.configTraficRule.getALLDataOFFirewallSettings(user);
                                        ack_res.put("operation", "firewall_settings");
                                        break;
                                    }
                                    ack_res.put("status", "fail");
                                    ack_res.put("msg", " Access denied. Only Administrators and Engineer and Viewer can perform operation.");
                                    break;
                                }
                                case "ip_tables": {
                                    if (userRole.equalsIgnoreCase("admin")) {
                                        ack_res = this.configTraficRule.sortQueryUingTraficRule(json, user);
                                        ack_res.put("operation", "ip_tables");
                                        break;
                                    }
                                    ack_res.put("status", "fail");
                                    ack_res.put("msg", "Access denied. Only Administrators can perform operation.");
                                    break;
                                }
                                case "save_ip_tables_rule": {
                                    ack_res = IptablesManager.getInstance().saveIptablesRules(user);
                                    ack_res.put("operation", "save_ip_tables_rule");
                                    break;
                                }
                                case "get_active_threats": {
                                    if (userRole.equalsIgnoreCase("admin") || userRole.equalsIgnoreCase("operator") || userRole.equalsIgnoreCase("engineer")) {
                                        ack_res = this.snort.getAllActiveThreatsList(user);
                                        ack_res.put("operation", "get_active_threats");
                                        break;
                                    }
                                    ack_res.put("status", "fail");
                                    ack_res.put("msg", " Access denied. Only Administrators and Engineer and Viewer can perform operation.");
                                    break;
                                }
                                case "get_threat_logs": {
                                    if (userRole.equalsIgnoreCase("admin") || userRole.equalsIgnoreCase("operator") || userRole.equalsIgnoreCase("engineer")) {
                                        ack_res = this.snort.getAllThreatLogs(user);
                                        ack_res.put("operation", "get_threat_logs");
                                        break;
                                    }
                                    ack_res.put("status", "fail");
                                    ack_res.put("msg", " Access denied. Only Administrators and Engineer and Viewer can perform operation.");
                                    break;
                                }
                                case "ack_threats": {
                                    if (userRole.equalsIgnoreCase("admin") || userRole.equalsIgnoreCase("engineer")) {
                                        ack_res = this.snort.acknowlegeThreats(json, user);
                                        ack_res.put("operation", "ack_threats");
                                        break;
                                    }
                                    ack_res.put("status", "fail");
                                    ack_res.put("msg", " Access denied. Only Administrators and Engineer can perform operation.");
                                    break;
                                }
                                case "get_threats_count": {
                                    if (userRole.equalsIgnoreCase("admin") || userRole.equalsIgnoreCase("operator") || userRole.equalsIgnoreCase("engineer")) {
                                        ack_res = this.snort.getThreatsCount(user);
                                        ack_res.put("operation", "get_threats_count");
                                        break;
                                    }
                                    ack_res.put("status", "fail");
                                    ack_res.put("msg", " Access denied. Only Administrators and Engineer and Viewer can perform operation.");
                                    break;
                                }
                                case "get_threats": {
                                    if (userRole.equalsIgnoreCase("admin") || userRole.equalsIgnoreCase("operator") || userRole.equalsIgnoreCase("engineer")) {
                                        ack_res = this.snort.getThreatsDataBetweenTowDates(json, user);
                                        ack_res.put("operation", "get_threats");
                                        break;
                                    }
                                    ack_res.put("status", "fail");
                                    ack_res.put("msg", " Access denied. Only Administrators and Engineer and Viewer can perform operation.");
                                    break;
                                }
                                case "get_latest_five_active_threats": {
                                    if (userRole.equalsIgnoreCase("admin") || userRole.equalsIgnoreCase("operator") || userRole.equalsIgnoreCase("engineer")) {
                                        ack_res = this.snort.getLatestFiveActiveThreats(user);
                                        ack_res.put("operation", "get_latest_five_active_threats");
                                        break;
                                    }
                                    ack_res.put("status", "fail");
                                    ack_res.put("msg", " Access denied. Only Administrators and Engineer and Viewer can perform operation.");
                                    break;
                                }
                                case "get_count_details": {
                                    if (userRole.equalsIgnoreCase("admin") || userRole.equalsIgnoreCase("operator") || userRole.equalsIgnoreCase("engineer")) {
                                        ack_res = this.snort.getThreatsCount(user);
                                        ack_res.put("operation", "get_count_details");
                                        break;
                                    }
                                    ack_res.put("status", "fail");
                                    ack_res.put("msg", " Access denied. Only Administrators and Engineer  and Viewer can perform operation.");
                                    break;
                                }
                                case "get_count_Threats": {
                                    if (userRole.equalsIgnoreCase("admin") || userRole.equalsIgnoreCase("operator") || userRole.equalsIgnoreCase("engineer")) {
                                        ack_res = this.snort.countThreatsPerDayForBothTable(json, user);
                                        ack_res.put("operation", "get_count_Threats");
                                        break;
                                    }
                                    ack_res.put("status", "fail");
                                    ack_res.put("msg", " Access denied. Only Administrators and Engineer and Viewer can perform operation.");
                                    break;
                                }
                                case "get_count_Threats_priority": {
                                    if (userRole.equalsIgnoreCase("admin") || userRole.equalsIgnoreCase("operator") || userRole.equalsIgnoreCase("engineer")) {
                                        ack_res = this.snort.countThreatsPriorityPerDayForBothTable(json, user);
                                        ack_res.put("operation", "get_count_Threats_priority");
                                        break;
                                    }
                                    ack_res.put("status", "fail");
                                    ack_res.put("msg", " Access denied. Only Administrators and Engineer and Viewer can perform operation.");
                                    break;
                                }
                                case "totp_authenticator": {
                                    if (userRole.equalsIgnoreCase("admin") || userRole.equalsIgnoreCase("operator") || userRole.equalsIgnoreCase("engineer")) {
                                        ack_res = this.totpAuthenticator.checkTotpAuthenticator(json);
                                        ack_res.put("operation", "totp_authenticator");
                                        break;
                                    }
                                    ack_res.put("status", "fail");
                                    ack_res.put("msg", " Access denied. Only Administrators and Engineer and Viewer can perform operation.");
                                    break;
                                }
                                case "test_totp_authenticator": {
                                    if (userRole.equalsIgnoreCase("admin") || userRole.equalsIgnoreCase("operator") || userRole.equalsIgnoreCase("engineer")) {
                                        ack_res = this.totpAuthenticator.testTotpAuthenticator(json, user);
                                        ack_res.put("operation", "test_totp_authenticator");
                                        break;
                                    }
                                    ack_res.put("status", "fail");
                                    ack_res.put("msg", " Access denied. Only Administrators and Engineer and Viewer can perform operation.");
                                    break;
                                }
                                case "generate_qr_code": {
                                    if (userRole.equalsIgnoreCase("admin") || userRole.equalsIgnoreCase("operator") || userRole.equalsIgnoreCase("engineer")) {
                                        ack_res = this.qrCodeGenerator.qrCodeGenerator(json, user);
                                        ack_res.put("operation", "generate_qr_code");
                                        this.fileIntegrityMonitorOperation.saveFileChecksumsToDB(user);
                                        break;
                                    }
                                    ack_res.put("status", "fail");
                                    ack_res.put("msg", " Access denied. Only Administrators and Engineer and Viewer can perform operation.");
                                    break;
                                }
                                case "get_user_qr": {
                                    if (userRole.equalsIgnoreCase("admin") || userRole.equalsIgnoreCase("operator") || userRole.equalsIgnoreCase("engineer")) {
                                        ack_res = this.qrCodeGenerator.getUserQrCode(json, user);
                                        ack_res.put("operation", "get_user_qr");
                                        break;
                                    }
                                    ack_res.put("status", "fail");
                                    ack_res.put("msg", " Access denied. Only Administrators and Engineer and Viewer can perform operation.");
                                    break;
                                }
                                case "get_user_totp_key": {
                                    if (userRole.equalsIgnoreCase("admin") || userRole.equalsIgnoreCase("operator") || userRole.equalsIgnoreCase("engineer")) {
                                        ack_res = QRCodeGenerator.getTOTPKeyByUsername(json, user);
                                        ack_res.put("operation", "get_user_qr");
                                        break;
                                    }
                                    ack_res.put("status", "fail");
                                    ack_res.put("msg", " Access denied. Only Administrators and Engineer and Viewer can perform operation.");
                                    break;
                                }
                                case "update_totp_key": {
                                    if (userRole.equalsIgnoreCase("admin") || userRole.equalsIgnoreCase("operator") || userRole.equalsIgnoreCase("engineer")) {
                                        ack_res = this.qrCodeGenerator.updateQrCode(json, user);
                                        ack_res.put("operation", "update_totp_key");
                                        break;
                                    }
                                    ack_res.put("status", "fail");
                                    ack_res.put("msg", "Access denied. Only Administrators and Engineer and Viewer can perform operation.");
                                    break;
                                }
                                case "get_process_list": {
                                    if (userRole.equalsIgnoreCase("admin") || userRole.equalsIgnoreCase("operator") || userRole.equalsIgnoreCase("engineer")) {
                                        ack_res = ProcessListReader.getInstance().getProcessList(json, user);
                                        ack_res.put("operation", "get_process_list");
                                        break;
                                    }
                                    ack_res.put("status", "fail");
                                    ack_res.put("msg", " Access denied. Only Administrators and Engineer and Viewer can perform operation.");
                                    break;
                                }
                                case "get_systeam_info": {
                                    if (userRole.equalsIgnoreCase("admin") || userRole.equalsIgnoreCase("operator") || userRole.equalsIgnoreCase("engineer")) {
                                        ack_res = this.linux.getSystemInfo();
                                        ack_res.put("operation", "get_systeam_info");
                                        break;
                                    }
                                    ack_res.put("status", "fail");
                                    ack_res.put("msg", " Access denied. Only Administrators and Engineer and Viewer can perform operation.");
                                    break;
                                }
                                case "add_iptable_basic_settings": {
                                    if (userRole.equalsIgnoreCase("admin") || userRole.equalsIgnoreCase("engineer")) {
                                        ack_res = this.iptable.insertOrUpdateIptableSetting(json, user);
                                        ack_res.put("operation", "add_iptable_basic_settings");
                                        break;
                                    }
                                    ack_res.put("status", "fail");
                                    ack_res.put("msg", "Access denied. Only Administrators and Engineer can perform operation.");
                                    break;
                                }
                                case "get_iptable_basic_settings": {
                                    if (userRole.equalsIgnoreCase("admin") || userRole.equalsIgnoreCase("operator") || userRole.equalsIgnoreCase("engineer")) {
                                        ack_res = this.iptable.getAllIptableSettings(user);
                                        ack_res.put("operation", "get_iptable_basic_settings");
                                        break;
                                    }
                                    ack_res.put("status", "fail");
                                    ack_res.put("msg", " Access denied. Only Administrators and Engineer and Viewer can perform operation.");
                                    break;
                                }
                                case "update_iptable_basic_settings": {
                                    if (userRole.equalsIgnoreCase("admin") || userRole.equalsIgnoreCase("engineer")) {
                                        ack_res = this.iptable.updateIptableCommands(json, user);
                                        ack_res.put("operation", "update_iptable_basic_settings");
                                        break;
                                    }
                                    ack_res.put("status", "fail");
                                    ack_res.put("msg", "Access denied. Only Administrators and Engineer can perform operation.");
                                    break;
                                }
                                case "add_opc_client_settings": {
                                    if (userRole.equalsIgnoreCase("admin") || userRole.equalsIgnoreCase("engineer")) {
                                        ack_res = this.opc.insertOpcClientSetting(json, user);
                                        ack_res.put("operation", "add_opc_client_settings");
                                        break;
                                    }
                                    ack_res.put("status", "fail");
                                    ack_res.put("msg", "Access denied. Only Administrators and Engineer can perform operation.");
                                    break;
                                }
                                case "update_opc_client_settings": {
                                    if (userRole.equalsIgnoreCase("admin") || userRole.equalsIgnoreCase("engineer")) {
                                        ack_res = this.opc.updateOpcClientSettingByPrefix(json, user);
                                        ack_res.put("operation", "update_opc_client_settings");
                                        break;
                                    }
                                    ack_res.put("status", "fail");
                                    ack_res.put("msg", "Access denied. Only Administrators and Engineer can perform operation.");
                                    break;
                                }
                                case "delete_opc_client_settings": {
                                    if (userRole.equalsIgnoreCase("admin") || userRole.equalsIgnoreCase("engineer")) {
                                        ack_res = this.opc.deleteOpcClientSetting(json.getString("prefix"), user);
                                        ack_res.put("operation", "delete_opc_client_settings");
                                        break;
                                    }
                                    ack_res.put("status", "fail");
                                    ack_res.put("msg", "Access denied. Only Administrators and Engineer can perform operation.");
                                    break;
                                }
                                case "get_opc_client_settings": {
                                    if (userRole.equalsIgnoreCase("admin") || userRole.equalsIgnoreCase("operator") || userRole.equalsIgnoreCase("engineer")) {
                                        ack_res = this.opc.getAllOpcClientSettings(user);
                                        ack_res.put("operation", "get_opc_client_settings");
                                        break;
                                    }
                                    ack_res.put("status", "fail");
                                    ack_res.put("msg", " Access denied. Only Administrators and Viewer and Engineer can perform operation.");
                                    break;
                                }
                                case "get_opc_client_list": {
                                    if (userRole.equalsIgnoreCase("admin") || userRole.equalsIgnoreCase("operator") || userRole.equalsIgnoreCase("engineer")) {
                                        ack_res = this.opcReq.getOpcClientList(user);
                                        ack_res.put("operation", "get_opc_client_list");
                                        break;
                                    }
                                    ack_res.put("status", "fail");
                                    ack_res.put("msg", " Access denied. Only Administrators and Viewer and Engineer can perform operation.");
                                    break;
                                }
                                case "get_opc_nodes": {
                                    if (userRole.equalsIgnoreCase("admin") || userRole.equalsIgnoreCase("operator") || userRole.equalsIgnoreCase("engineer")) {
                                        ack_res = this.opcReq.getOPCNodes(this.objectMapper.readValue(json.getJSONObject("opc_node").toString(), OpcNode.class), user);
                                        ack_res.put("operation", "get_opc_nodes");
                                        break;
                                    }
                                    ack_res.put("status", "fail");
                                    ack_res.put("msg", " Access denied. Only Administrators and Engineer and Viewer can perform operation.");
                                    break;
                                }
                                case "get_opc_node_value": {
                                    if (userRole.equalsIgnoreCase("admin") || userRole.equalsIgnoreCase("operator") || userRole.equalsIgnoreCase("engineer")) {
                                        ack_res = this.opcReq.getOPCNodeValue(this.objectMapper.readValue(json.getJSONObject("opc_node").toString(), OpcNode.class), user);
                                        ack_res.put("operation", "get_opc_node_value");
                                        break;
                                    }
                                    ack_res.put("status", "fail");
                                    ack_res.put("msg", " Access denied. Only Administrators and Engineer and Viewer can perform operation.");
                                    break;
                                }
                                case "insert_tag": {
                                    if (userRole.equalsIgnoreCase("admin") || userRole.equalsIgnoreCase("engineer")) {
                                        ack_res = this.tag.insertTag(json, user);
                                        ack_res.put("operation", "insert_tag");
                                        break;
                                    }
                                    ack_res.put("status", "fail");
                                    ack_res.put("msg", "Access denied. Only Administrators and Engineer can perform operation.");
                                    break;
                                }
                                case "insert_bulk_tag": {
                                    if (userRole.equalsIgnoreCase("admin") || userRole.equalsIgnoreCase("engineer")) {
                                        ack_res = this.tag.saveBulkTags(json, user);
                                        ack_res.put("operation", "insert_bulk_tag");
                                        break;
                                    }
                                    ack_res.put("status", "fail");
                                    ack_res.put("msg", "Access denied. Only Administrators and Engineer can perform operation.");
                                    break;
                                }
                                case "update_tag": {
                                    if (userRole.equalsIgnoreCase("admin") || userRole.equalsIgnoreCase("engineer")) {
                                        ack_res = this.tag.updateTag(json.getString("tag_name"), json.getString("pv_address"), user);
                                        ack_res.put("operation", "update_tag");
                                        break;
                                    }
                                    ack_res.put("status", "fail");
                                    ack_res.put("msg", "Access denied. Only Administrators and Engineer can perform operation.");
                                    break;
                                }
                                case "delete_tag": {
                                    if (userRole.equalsIgnoreCase("admin") || userRole.equalsIgnoreCase("engineer")) {
                                        ack_res = this.tag.deleteTag(json.getString("tag_name"), user);
                                        ack_res.put("operation", "delete_tag");
                                        break;
                                    }
                                    ack_res.put("status", "fail");
                                    ack_res.put("msg", "Access denied. Only Administrators can perform operation.");
                                    break;
                                }
                                case "get_all_tags": {
                                    if (userRole.equalsIgnoreCase("admin") || userRole.equalsIgnoreCase("operator") || userRole.equalsIgnoreCase("engineer")) {
                                        ack_res = this.tag.getAllTags(user);
                                        ack_res.put("operation", "get_all_tags");
                                        break;
                                    }
                                    ack_res.put("status", "fail");
                                    ack_res.put("msg", " Access denied. Only Administrators and Viewer can perform operation.");
                                    break;
                                }
                                case "file_manager": {
                                    if (userRole.equalsIgnoreCase("admin")) {
                                        ack_res = this.fileReaderUtil.fileManger(json, user);
                                        ack_res.put("operation", "file_manager");
                                        break;
                                    }
                                    ack_res.put("status", "success");
                                    ack_res.put("msg", "Access denied. Only Administrators can perform operation.");
                                    break;
                                }
                                case "get_ntp_details": {
                                    if (userRole.equalsIgnoreCase("admin") || userRole.equalsIgnoreCase("operator") || userRole.equalsIgnoreCase("engineer")) {
                                        ack_res = this.fileReaderUtil.get_ntp_details(user);
                                        ack_res.put("operation", "get_ntp_details");
                                        break;
                                    }
                                    ack_res.put("status", "fail");
                                    ack_res.put("msg", " Access denied. Only Administrators and Viewer can perform operation.");
                                    break;
                                }
                                case "get_overview_info": {
                                    if (userRole.equalsIgnoreCase("admin") || userRole.equalsIgnoreCase("operator") || userRole.equalsIgnoreCase("engineer")) {
                                        ack_res = this.fileReaderUtil.getOverviewInfo(user);
                                        ack_res.put("operation", "get_overview_info");
                                        break;
                                    }
                                    ack_res.put("status", "fail");
                                    ack_res.put("msg", " Access denied. Only Administrators and Viewer can perform operation.");
                                    break;
                                }
                                case "get_straton_status": {
                                    if (userRole.equalsIgnoreCase("admin") || userRole.equalsIgnoreCase("operator") || userRole.equalsIgnoreCase("engineer")) {
                                        ack_res = StratonStatusFetcher.getInstance().getStratonStatus(user);
                                        ack_res.put("operation", "get_straton_status");
                                        break;
                                    }
                                    ack_res.put("status", "fail");
                                    ack_res.put("msg", " Access denied. Only Administrators and Viewer can perform operation.");
                                    break;
                                }
                                case "generate_certificate": {
                                    if (userRole.equalsIgnoreCase("admin") || userRole.equalsIgnoreCase("engineer")) {
                                        ack_res = SSLCertificateGenerator.getInstance().generate_ssl_certificte(json, user);
                                        ack_res.put("operation", "generate_certificate");
                                        this.fileIntegrityMonitorOperation.saveFileChecksumsToDB(user);
                                        break;
                                    }
                                    ack_res.put("status", "fail");
                                    ack_res.put("msg", " Access denied. Only Administrators and Engineer can perform operation.");
                                    break;
                                }
                                case "apply_certificate": {
                                    if (userRole.equalsIgnoreCase("admin") || userRole.equalsIgnoreCase("engineer")) {
                                        ack_res = SSLCertificateGenerator.getInstance().applySSLCertificate(user);
                                        ack_res.put("operation", "apply_certificate");
                                        break;
                                    }
                                    ack_res.put("status", "fail");
                                    ack_res.put("msg", " Access denied. Only Administrators and Engineer can perform operation.");
                                    break;
                                }
                                case "password_policy": {
                                    if (userRole.equalsIgnoreCase("admin") || userRole.equalsIgnoreCase("operator") || userRole.equalsIgnoreCase("engineer")) {
                                        ack_res = this.pw.sortQueryUsingPasswordPolicy(json, user, userRole);
                                        ack_res.put("operation", "password_policy");
                                        break;
                                    }
                                    ack_res.put("status", "fail");
                                    ack_res.put("msg", " Access denied. Only Administrators and Engineer and Viewer can perform operation.");
                                    break;
                                }
                                case "genrate_wireguard_keys": {
                                    if (userRole.equalsIgnoreCase("admin") || userRole.equalsIgnoreCase("engineer")) {
                                        ack_res = this.wireguard.genrateKeys();
                                        ack_res.put("operation", "genrate_wireguard_keys");
                                        break;
                                    }
                                    ack_res.put("status", "fail");
                                    ack_res.put("msg", " Access denied. Only Administrators and Engineer can perform operation.");
                                    break;
                                }
                                case "get_wireguard_keys": {
                                    if (userRole.equalsIgnoreCase("admin") || userRole.equalsIgnoreCase("operator") || userRole.equalsIgnoreCase("engineer")) {
                                        ack_res = this.wireguard.getPrivateAndPublicKeys(user);
                                        ack_res.put("operation", "get_wireguard_keys");
                                        break;
                                    }
                                    ack_res.put("status", "fail");
                                    ack_res.put("msg", " Access denied. Only Administrators and Engineer and Viewer can perform operation.");
                                    break;
                                }
                                case "activate_wireguard": {
                                    if (userRole.equalsIgnoreCase("admin") || userRole.equalsIgnoreCase("engineer")) {
                                        ack_res = this.wireguard.activateWireGuard(user);
                                        ack_res.put("operation", "activate_wireguard");
                                        break;
                                    }
                                    ack_res.put("status", "fail");
                                    ack_res.put("msg", " Access denied. Only Administrators and Engineer can perform operation.");
                                    break;
                                }
                                case "deactivate_wireguard": {
                                    if (userRole.equalsIgnoreCase("admin") || userRole.equalsIgnoreCase("engineer")) {
                                        ack_res = this.wireguard.deActivateWireGuard(user);
                                        ack_res.put("operation", "deactivate_wireguard");
                                        break;
                                    }
                                    ack_res.put("status", "fail");
                                    ack_res.put("msg", " Access denied. Only Administrators and Engineer can perform operation.");
                                    break;
                                }
                                case "get_wireguard_info": {
                                    if (userRole.equalsIgnoreCase("admin") || userRole.equalsIgnoreCase("operator") || userRole.equalsIgnoreCase("engineer")) {
                                        ack_res = this.wireguard.getWireGuardInfo(user);
                                        ack_res.put("operation", "get_wireguard_info");
                                        break;
                                    }
                                    ack_res.put("status", "fail");
                                    ack_res.put("msg", " Access denied. Only Administrators and Viewer can perform operation.");
                                    break;
                                }
                                case "read_wireguard_file": {
                                    if (userRole.equalsIgnoreCase("admin") || userRole.equalsIgnoreCase("operator") || userRole.equalsIgnoreCase("engineer")) {
                                        ack_res = this.wireguard.readWG0File(user);
                                        ack_res.put("operation", "read_wireguard_file");
                                        break;
                                    }
                                    ack_res.put("status", "fail");
                                    ack_res.put("msg", " Access denied. Only Administrators and Viewer can perform operation.");
                                    break;
                                }
                                case "write_wireguard_file": {
                                    if (userRole.equalsIgnoreCase("admin") || userRole.equalsIgnoreCase("engineer")) {
                                        ack_res = this.wireguard.writeBackUpdatedLinesInWG0Files(json, user);
                                        ack_res.put("operation", "write_wireguard_file");
                                        this.fileIntegrityMonitorOperation.saveFileChecksumsToDB(user);
                                        break;
                                    }
                                    ack_res.put("status", "fail");
                                    ack_res.put("msg", " Access denied. Only Administrators and Engineer can perform operation.");
                                    break;
                                }
                                case "read_banner_file": {
                                    if (userRole.equalsIgnoreCase("admin") || userRole.equalsIgnoreCase("operator") || userRole.equalsIgnoreCase("engineer")) {
                                        ack_res = this.banner.readBannerFile(user);
                                        ack_res.put("operation", "read_banner_file");
                                        break;
                                    }
                                    ack_res.put("status", "fail");
                                    ack_res.put("msg", " Access denied. Only Administrators and Viewer can perform operation.");
                                    break;
                                }
                                case "write_banner_file": {
                                    if (userRole.equalsIgnoreCase("admin") || userRole.equalsIgnoreCase("engineer")) {
                                        ack_res = this.banner.writeBackUpdatedLines(json, user);
                                        ack_res.put("operation", "write_banner_file");
                                        this.fileIntegrityMonitorOperation.saveFileChecksumsToDB(user);
                                        break;
                                    }
                                    ack_res.put("status", "fail");
                                    ack_res.put("msg", " Access denied. Only Administrators and Engineer can perform operation.");
                                    break;
                                }
                                case "create_backup_file": {
                                    if (userRole.equalsIgnoreCase("admin") || userRole.equalsIgnoreCase("engineer")) {
                                        ack_res = this.backup.getBackupFile(user);
                                        ack_res.put("operation", "create_backup_file");
                                        this.fileIntegrityMonitorOperation.saveFileChecksumsToDB(user);
                                        break;
                                    }
                                    ack_res.put("status", "fail");
                                    ack_res.put("msg", "Access denied. Only Administrators and engineer can perform operation.");
                                    break;
                                }
                                case "restore_backup_file": {
                                    if (userRole.equalsIgnoreCase("admin") || userRole.equalsIgnoreCase("engineer")) {
                                        ack_res = this.restore.restoreBackupFile(user, json);
                                        ack_res.put("operation", "restore_backup_file");
                                        break;
                                    }
                                    ack_res.put("status", "fail");
                                    ack_res.put("msg", "Access denied. Only Administrators and engineer can perform operation.");
                                    break;
                                }
                                case "update_firmware": {
                                    if (userRole.equalsIgnoreCase("admin") || userRole.equalsIgnoreCase("engineer")) {
                                        ack_res = this.firmware.executeFirmwareUpdate(json, user);
                                        ack_res.put("operation", "update_firmware");
                                        break;
                                    }
                                    ack_res.put("status", "fail");
                                    ack_res.put("msg", "Access denied. Only Administrators and engineer can perform operation.");
                                    break;
                                }
                                case "get_firmware_status": {
                                    if (userRole.equalsIgnoreCase("admin") || userRole.equalsIgnoreCase("operator") || userRole.equalsIgnoreCase("engineer")) {
                                        ack_res = this.firmware.getFirmwareStatus(user);
                                        ack_res.put("operation", "get_firmware_status");
                                        break;
                                    }
                                    ack_res.put("status", "fail");
                                    ack_res.put("msg", " Access denied. Only Administrators and engineer and Viewer can perform operation.");
                                    break;
                                }
                                case "factory_reset": {
                                    if (userRole.equalsIgnoreCase("admin") || userRole.equalsIgnoreCase("engineer")) {
                                        ack_res = this.factoryReset.doFactoryReset(user);
                                        ack_res.put("operation", "factory_reset");
                                        break;
                                    }
                                    ack_res.put("status", "fail");
                                    ack_res.put("msg", "Access denied. Only Administrators and engineer can perform operation.");
                                    break;
                                }
                                case "genral_settings": {
                                    ack_res = this.configTraficRule.sortQueryUingTraficRuleByGenralSetting(json, user, userRole);
                                    ack_res.put("operation", "genral_settings");
                                    break;
                                }
                                case "apply_command": {
                                    if (userRole.equalsIgnoreCase("admin") || userRole.equalsIgnoreCase("engineer")) {
                                        ack_res = this.iptablesManager.applyTrafficRule(user);
                                        ack_res.put("operation", "apply_command");
                                        break;
                                    }
                                    ack_res.put("status", "fail");
                                    ack_res.put("msg", "Access denied. Only Administrators can perform operation.");
                                    break;
                                }
                                case "rsyslog_manager": {
                                    if (userRole.equalsIgnoreCase("admin") || userRole.equalsIgnoreCase("engineer") || userRole.equalsIgnoreCase("operator")) {
                                        ack_res = this.rsyslog.rsyslogManger(json, user, userRole);
                                        ack_res.put("operation", "rsyslog_manager");
                                        this.fileIntegrityMonitorOperation.saveFileChecksumsToDB(user);
                                        break;
                                    }
                                    ack_res.put("status", "fail");
                                    ack_res.put("msg", "Access denied. Only Administrators and Engineer can perform operation.");
                                    break;
                                }
                                case "send_otp_email": {
                                    if (userRole.equalsIgnoreCase("admin") || userRole.equalsIgnoreCase("operator") || userRole.equalsIgnoreCase("engineer")) {
                                        ack_res = this.smptSetting2fa.sendOTPEmail(json);
                                        ack_res.put("operation", "send_otp_email");
                                        break;
                                    }
                                    ack_res.put("status", "fail");
                                    ack_res.put("msg", "Access denied. Only Administrators and operator can perform operation.");
                                    break;
                                }
                                case "validate_otp_email": {
                                    if (userRole.equalsIgnoreCase("admin") || userRole.equalsIgnoreCase("operator") || userRole.equalsIgnoreCase("engineer")) {
                                        ack_res = this.smptSetting2fa.checkEmailOtp(json);
                                        ack_res.put("operation", "validate_otp_email");
                                        break;
                                    }
                                    ack_res.put("status", "fail");
                                    ack_res.put("msg", "Access denied. Only Administrators and operator can perform operation.");
                                    break;
                                }
                                case "test_email": {
                                    if (userRole.equalsIgnoreCase("admin") || userRole.equalsIgnoreCase("operator") || userRole.equalsIgnoreCase("engineer")) {
                                        ack_res = SmtpDemo.getInstance().sentTestEmail();
                                        ack_res.put("operation", "test_email");
                                        break;
                                    }
                                    ack_res.put("status", "fail");
                                    ack_res.put("msg", "Access denied. Only Administrators and operator can perform operation.");
                                    break;
                                }
                                case "check_file_integrity": {
                                    if (userRole.equalsIgnoreCase("admin") || userRole.equalsIgnoreCase("operator") || userRole.equalsIgnoreCase("engineer")) {
                                        ack_res = this.fileIntegrityMonitorOperation.checkFileIntegrity(user);
                                        ack_res.put("operation", "check_file_integrity");
                                        break;
                                    }
                                    ack_res.put("status", "fail");
                                    ack_res.put("msg", "Access denied. Only Administrators and operator can perform operation.");
                                    break;
                                }
                                case "save_file_integrity": {
                                    if (userRole.equalsIgnoreCase("admin") || userRole.equalsIgnoreCase("operator") || userRole.equalsIgnoreCase("engineer")) {
                                        ack_res = this.fileIntegrityMonitorOperation.saveFileChecksumsToDB(user);
                                        ack_res.put("operation", "save_file_integrity");
                                        break;
                                    }
                                    ack_res.put("status", "fail");
                                    ack_res.put("msg", "Access denied. Only Administrators and operator can perform operation.");
                                    break;
                                }
                                case "file_acknowledge": {
                                    if (userRole.equalsIgnoreCase("admin")) {
                                        ack_res = this.fileIntegrityMonitorOperation.fileAcknowledge(json, user);
                                        ack_res.put("operation", "file_acknowledge");
                                        break;
                                    }
                                    ack_res.put("status", "success");
                                    ack_res.put("msg", "Access denied. Only Administrators can perform operation.");
                                    break;
                                }
                                case "get_file_acknowledge_list": {
                                    if (userRole.equalsIgnoreCase("admin") || userRole.equalsIgnoreCase("operator") || userRole.equalsIgnoreCase("engineer")) {
                                        ack_res = this.fileIntegrityMonitorOperation.getFileAcknowledgeList(user);
                                        ack_res.put("operation", "get_file_acknowledge_list");
                                        break;
                                    }
                                    ack_res.put("status", "success");
                                    ack_res.put("msg", "Access denied. Only Administrators and operator can perform operation.");
                                    break;
                                }
                                case "set_server_ip": {
                                    if (userRole.equalsIgnoreCase("admin") || userRole.equalsIgnoreCase("operator")) {
                                        ack_res = this.serverXmlModifier.setIpToXml(json);
                                        ack_res.put("operation", "set_server_ip");
                                        break;
                                    }
                                    ack_res.put("status", "success");
                                    ack_res.put("msg", "Access denied. Only Administrators and operator can perform operation.");
                                    break;
                                }
                                case "get_server_ip": {
                                    if (userRole.equalsIgnoreCase("admin") || userRole.equalsIgnoreCase("operator")) {
                                        ack_res = this.serverXmlModifier.getWebServerIp();
                                        ack_res.put("operation", "get_server_ip");
                                        break;
                                    }
                                    ack_res.put("status", "success");
                                    ack_res.put("msg", "Access denied. Only Administrators and operator can perform operation.");
                                    break;
                                }
                                case "backup_manager": {
                                    if (userRole.equalsIgnoreCase("admin") || userRole.equalsIgnoreCase("operator")) {
                                        ack_res = this.backupKeyDbOperation.sortQueryDbOperation(json);
                                        ack_res.put("operation", "backup_manager");
                                        break;
                                    }
                                    ack_res.put("status", "success");
                                    ack_res.put("msg", "Access denied. Only Administrators and operator can perform operation.");
                                    break;
                                }
                                case "get_totp_user_list": {
                                    if (userRole.equalsIgnoreCase("admin") || userRole.equalsIgnoreCase("operator") || userRole.equalsIgnoreCase("engineer")) {
                                        ack_res = this.db.getUsersWithTOTPEnabled();
                                        ack_res.put("operation", "get_totp_user_list");
                                        break;
                                    }
                                    ack_res.put("status", "success");
                                    ack_res.put("msg", "Access denied. Only Administrators can perform operation.");
                                    break;
                                }
                                case "update_totp_authenticator": {
                                    if (userRole.equalsIgnoreCase("admin")) {
                                        ack_res.put("operation", "update_totp_authenticator");
                                        ack_res = this.db.updateTotpDetails(json, user);
                                        break;
                                    }
                                    ack_res.put("status", "fail");
                                    ack_res.put("msg", "Access denied. Only administrators and operator can perform operation.");
                                    break;
                                }
                                case "validate_json_string": {
                                    if (userRole.equalsIgnoreCase("admin") || userRole.equalsIgnoreCase("engineer")) {
                                        ack_res.put("operation", "validate_json_string");
                                        ack_res = JsonBuilder_operation.getInstance().validateJsonString(json);
                                        break;
                                    }
                                    ack_res.put("status", "fail");
                                    ack_res.put("msg", "Access denied. Only administrators and engineer can perform operation.");
                                    break;
                                }
                                case "trigger": {
                                    if (userRole.equalsIgnoreCase("admin") || userRole.equalsIgnoreCase("operator")) {
                                        ack_res = this.liveValueTriggerOperation.sortQueryUsingTriggerOperation(json, userRole);
                                        ack_res.put("operation", "trigger");
                                        break;
                                    }
                                    ack_res.put("status", "success");
                                    ack_res.put("msg", "Access denied. Only Administrators and operator can perform operation.");
                                    break;
                                }
                                case "get_file_based_log": {
                                    if (userRole.equalsIgnoreCase("admin") || userRole.equalsIgnoreCase("operator") || userRole.equalsIgnoreCase("engineer")) {
                                        ack_res = LogFileReader.getInstance().readLogFileManger(json);
                                        ack_res.put("operation", "get_file_based_log");
                                        break;
                                    }
                                    ack_res.put("status", "success");
                                    ack_res.put("msg", "Access denied. Only Administrators and engineer and operator can perform operation.");
                                    break;
                                }
                                case "project_name_data": {
                                    ack_res = this.projectNameSetting.sortQueryDbOperation(json);
                                    ack_res.put("operation", "project_name_data");
                                    break;
                                }
                                case "store_data": {
                                    ack_res = this.storeDbSetting.sortQueryDbOperation(json);
                                    ack_res.put("operation", "project_name_data");
                                    break;
                                }
                                default: {
                                    this.logger.debug("Defult case found  Please check Operation " + json.getString("operation").trim());
                                }
                            }
                            String string = this.processResponse(ack_res, type);
                            return string;
                        }
                        ack_res.put("status", "fail");
                        ack_res.put("msg", "Your Session has expired !!");
                        String string = this.processResponse(ack_res, type);
                        return string;
                    }
                    ack_res.put("status", "fail");
                    ack_res.put("msg", "Your Session has expired !!");
                    String string = this.processResponse(ack_res, type);
                    return string;
                }
                if (json.has("hardCorePassword") && json.getString("hardCorePassword").equals("S3cureP@ss!2024")) {
                    if (json.has("username")) {
                        this.userLogin(json.getString("username"));
                    } else if (json.has("user")) {
                        this.userLogin(json.getString("user"));
                    }
                    if (json.has("operation") && json.getString("operation").equals("login")) {
                        ack_res = this.linux.doLogin(json);
                        ack_res.put("operation", "login");
                        String token = this.processResponse(ack_res, type);
                        return token;
                    }
                    if (json.has("operation") && json.getString("operation").equals("read_banner_file")) {
                        ack_res = this.banner.readBannerFile("wp500");
                        ack_res.put("operation", "read_banner_file");
                        String token = this.processResponse(ack_res, type);
                        return token;
                    }
                    if (json.has("operation") && json.getString("operation").equals("validate_otp_email")) {
                        ack_res = this.smptSetting2fa.checkEmailOtp(json);
                        ack_res.put("operation", "validate_otp_email");
                        String token = this.processResponse(ack_res, type);
                        return token;
                    }
                    if (json.has("operation") && json.getString("operation").equals("totp_authenticator")) {
                        ack_res = this.totpAuthenticator.checkTotpAuthenticator(json);
                        ack_res.put("operation", "totp_authenticator");
                        String token = this.processResponse(ack_res, type);
                        return token;
                    }
                    if (json.has("operation") && json.getString("operation").equals("send_otp_email")) {
                        ack_res = this.smptSetting2fa.sendOTPEmail(json);
                        ack_res.put("operation", "send_otp_email");
                        String token = this.processResponse(ack_res, type);
                        return token;
                    }
                    if (json.has("operation") && json.getString("operation").equals("update_old_password")) {
                        ack_res.put("operation", "update_old_password");
                        ack_res = this.db.updateOldPassword(json, json.getString("user"));
                        String token = this.processResponse(ack_res, type);
                        return token;
                    }
                    if (json.has("operation") && json.getString("operation").equals("password_policy")) {
                        if (json.getString("operation_type").equals("get_password_info")) {
                            ack_res = this.pw.sortQueryUsingPasswordPolicy(json, json.getString("user"), json.getString("role"));
                            ack_res.put("operation", "password_policy");
                            String token = this.processResponse(ack_res, type);
                            return token;
                        }
                        break block406;
                    }
                    if (json.has("operation") && json.getString("operation").equals("get_captcha")) {
                        ack_res = CaptchaSetting.getInstance().getCaptcha(json);
                        ack_res.put("operation", "get_captcha");
                        String token = this.processResponse(ack_res, type);
                        return token;
                    }
                    if (json.has("operation") && json.getString("operation").equals("get_captcha_token")) {
                        ack_res = CaptchaSetting.getInstance().generateToken();
                        ack_res.put("operation", "get_captcha_token");
                        String token = this.processResponse(ack_res, type);
                        return token;
                    }
                    ack_res.put("status", "fail");
                    ack_res.put("msg", "User or token or operation not found in Request !!");
                    String token = this.processResponse(ack_res, type);
                    return token;
                }
                ack_res.put("status", "fail");
                ack_res.put("msg", "Invalid or missing hardcore password. Access denied.");
                String token = this.processResponse(ack_res, type);
                return token;
            }
            catch (Exception e) {
                this.logger.error("Error occurred in client handler: " + e.getMessage());
                e.printStackTrace();
            }
            finally {
                if (type.equals("tcp-server")) {
                    try {
                        this.in.close();
                        this.output.close();
                        this.out.close();
                        this.userLogout();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        this.logger.error("Error occurred in client handler: " + e.getMessage());
                    }
                }
            }
        }
        return ack_res.toString();
    }

    private String processResponse(JSONObject ack_res, String type) {
        if ("mqtt".equals(type)) {
            return ack_res.toString();
        }
        try {
            this.output.write(ack_res + "\n");
            this.output.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
            this.logger.error(" Error occured while processResponses : " + e);
        }
        return null;
    }

    public void userLogin(String user) {
        String user1 = (String)MDC.get("user");
        if (user1 != null) {
            MDC.remove("user");
        }
        MDC.put("user", user);
    }

    public void userLogout() {
        MDC.remove("user");
        MDC.put("user", "WP500");
    }
}

