/*
 * Decompiled with CFR 0.152.
 */
package com.tas.wp500;

import com.tas.wp500.IptablesSetting.GenralSettingsOperation;
import com.tas.wp500.IptablesSetting.IptableSettingsOperations;
import com.tas.wp500.IptablesSetting.IptablesManager;
import com.tas.wp500.MQTTServer;
import com.tas.wp500.TCPServer;
import com.tas.wp500.fileHashSettings.FileIntegrityMonitorOperation;
import com.tas.wp500.fileHashSettings.FileIntegrityScheduler;
import com.tas.wp500.fileLogSetting.FileBasedLogger;
import com.tas.wp500.linx_command.LinuxCommad;
import com.tas.wp500.log4jSetting.LogScheduler;
import com.tas.wp500.opc_ua_client.OpcClientExecutorClass;
import com.tas.wp500.opc_ua_server.SimpleServer;
import com.tas.wp500.services.Service;
import com.tas.wp500.smtpSettings.SmtpDbOperation;
import com.tas.wp500.snort.snortDBOperation.SnortSettings;
import com.tas.wp500.sql_lite_db.Db_opertions;
import com.tas.wp500.ssl_certificate_manager.ServerXmlModifier;
import com.tas.wp500.util.ConfigClass;
import com.tas.wp500.util.PatchVersionSetting;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.MDC;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.RollingFileAppender;
import org.json.JSONObject;

public class App {
    private static Logger logger = Logger.getLogger(App.class);
    private static SnortSettings snortSettings = SnortSettings.getInstance();
    private static LinuxCommad linux = LinuxCommad.getInstance();
    private static Db_opertions db_opertions = Db_opertions.getInstance();
    private static GenralSettingsOperation instance = GenralSettingsOperation.getInstance();
    private static SmtpDbOperation smtpDbOperation = SmtpDbOperation.getInstance();
    private static FileIntegrityMonitorOperation fileIntegrityMonitorOperation = FileIntegrityMonitorOperation.getInstance();
    public static SimpleServer simpleServer;
    private static Service service;
    private static ConfigClass configInstance;
    private static String buildType;

    public static void main(String[] args) {
        buildType = configInstance.readConfigName("build_mode");
        try {
            snortSettings.createTableSnort();
            db_opertions.createUserTable();
            Thread.sleep(100L);
            System.setProperty("org.apache.commons.logging.Log", "org.apache.commons.logging.impl.NoOpLog");
            App.setTimezone();
            App.configureLog4j();
            logger.info(" WP 500 Application started !! version :- " + PatchVersionSetting.backendVersion + " Date - " + new Date());
            FileBasedLogger.info("Application", " WP 500 Application started !! version :- " + PatchVersionSetting.backendVersion + " Date - " + new Date(), "system");
            ServerXmlModifier.getInstance().setWebIp();
            MDC.put("user", "WP500");
            JSONObject json = new JSONObject();
            json.put("username", "wp500");
            json.put("password", "Wp500@admin");
            json.put("first_name", "Admin");
            json.put("last_name", "Admin");
            json.put("user_role", "Admin");
            try {
                service = new Service();
                Thread tcpserverThread = new Thread(new TCPServer(service));
                tcpserverThread.start();
                Thread mqttServerThread = new Thread(new MQTTServer());
                mqttServerThread.start();
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.debug("Error while start service and mqtt server :" + e.getLocalizedMessage());
            }
            try {
                logger.info("Initializing OPC UA Simple Server...");
                FileBasedLogger.info("Application", "Initializing OPC UA Simple Server...", "system");
                simpleServer = new SimpleServer();
                simpleServer.init();
                logger.info("Starting up OPC UA Simple Server...");
                FileBasedLogger.info("Application", "Starting up OPC UA Simple Server...", "system");
                simpleServer.startup().get();
                Thread.sleep(2000L);
                logger.info("Establishing connection to OPC UA server...");
                FileBasedLogger.info("Application", "Establishing connection to OPC UA server...", "system");
                OpcClientExecutorClass.createAdvaitConnection();
                logger.info("OPC UA server initialization complete.");
                FileBasedLogger.info("Application", "OPC UA server initialization complete.", "system");
            }
            catch (Exception e) {
                logger.error("Error during OPC UA server initialization: ", e);
                FileBasedLogger.error("Application", "Error during OPC UA server initialization : " + e, "system");
            }
            try {
                JSONObject e = linux.addUser(json, "wp500");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        App.doDefaultConfigurationOfIpTable();
                    }
                }).start();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                Thread serviceThread = new Thread(service);
                serviceThread.start();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            LogScheduler.startLogCleanupScheduler();
            FileIntegrityScheduler scheduler = new FileIntegrityScheduler();
            scheduler.startFileIntegrityTask();
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Error occurred while starting thread in main program." + e.getLocalizedMessage());
            FileBasedLogger.info("Application", "Error occurred while starting thread in main program." + e.getLocalizedMessage(), "system");
        }
    }

    private static void configureLog4j() {
        TimeZone.setDefault(TimeZone.getTimeZone("IST"));
        RollingFileAppender fileAppender = new RollingFileAppender();
        fileAppender.setName("file");
        fileAppender.setFile(App.getLogFileName());
        String pattern = "%d{yyyy-MM-dd HH:mm:ss} , %p , %L ,--- [%t] , %c , %X{user} , %m%n";
        fileAppender.setLayout(new PatternLayout(pattern));
        fileAppender.setMaxFileSize("2MB");
        fileAppender.setMaxBackupIndex(20);
        fileAppender.setAppend(true);
        fileAppender.activateOptions();
        ConsoleAppender consoleAppender = new ConsoleAppender();
        consoleAppender.setName("console");
        consoleAppender.setLayout(new PatternLayout(pattern));
        consoleAppender.activateOptions();
        try {
            Level logLevel = "debug".equalsIgnoreCase(buildType) ? Level.DEBUG : Level.INFO;
            Logger.getRootLogger().setLevel(logLevel);
            consoleAppender.setThreshold(logLevel);
            Logger.getRootLogger().removeAllAppenders();
            Logger.getRootLogger().addAppender(fileAppender);
            Logger.getRootLogger().addAppender(consoleAppender);
        }
        catch (Exception e) {
            e.printStackTrace();
            FileBasedLogger.error("Application", "Error while configuring loggers: " + e, "system");
            logger.error("Error while configuring loggers: ", e);
        }
    }

    private static String getLogFileName() {
        String pattern = "/data/log/WP500_%s.log";
        TimeZone istTimeZone = TimeZone.getTimeZone("IST");
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss");
        dateFormat.setTimeZone(istTimeZone);
        String formattedDate = dateFormat.format(new Date());
        return String.format(pattern, formattedDate);
    }

    public static void setTimezone() {
        try {
            String line;
            ProcessBuilder processBuilder = new ProcessBuilder("timedatectl", "set-timezone", "Asia/Kolkata");
            Process process = processBuilder.start();
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((line = reader.readLine()) != null) {
            }
            int exitCode = process.waitFor();
            if (exitCode == 0) {
                logger.debug("Asia/Kolkata timezone set successfully");
            } else {
                logger.debug("Failed to set timezone");
            }
        }
        catch (IOException | InterruptedException e) {
            e.printStackTrace();
            logger.error("Error while setting the timezone: " + e.getMessage());
            FileBasedLogger.error("Application", "Error while setting the timezone: " + e.getMessage(), "system");
        }
    }

    private static void doDefaultConfigurationOfIpTable() {
        try {
            App.insertGenralSettings();
            Thread.sleep(500L);
            IptableSettingsOperations instance = IptableSettingsOperations.getInstnce();
            int sleepDuration = 100;
            List<String> iptableSettings = Arrays.asList("{\"direction\":\"iif\",\"lan_type\":\"lan0\",\"protocol\":\"tcp\",\"to_port\":\"443\",\"action\":\"accept\",\"comment\":\"TCP/SSL\"}", "{\"direction\":\"iif\",\"lan_type\":\"lan0\",\"protocol\":\"tcp\",\"to_port\":\"1200\",\"action\":\"accept\",\"comment\":\"STRATON\"}", "{\"direction\":\"iif\",\"lan_type\":\"lan0\",\"protocol\":\"tcp\",\"to_port\":\"502\",\"action\":\"accept\",\"comment\":\"MODBUS PORT\"}", "{\"direction\":\"iif\",\"lan_type\":\"lan0\",\"protocol\":\"tcp\",\"to_port\":\"22\",\"action\":\"accept\",\"comment\":\"SSH\"}", "{\"direction\":\"iif\",\"lan_type\":\"lan0\",\"protocol\":\"tcp\",\"to_port\":\"25\",\"action\":\"accept\",\"comment\":\"SMTP\"}", "{\"direction\":\"iif\",\"lan_type\":\"lan0\",\"protocol\":\"tcp\",\"to_port\":\"12686\",\"action\":\"accept\",\"comment\":\"OPC-UA SERVER\"}", "{\"direction\":\"iif\",\"lan_type\":\"lan0\",\"protocol\":\"tcp\",\"to_port\":\"5535\",\"action\":\"drop\",\"comment\":\"dns\"}", "{\"direction\":\"iif\",\"lan_type\":\"lan0\",\"protocol\":\"tcp\",\"to_port\":\"6801\",\"action\":\"accept\",\"comment\":\"wp500\"}");
            for (String setting : iptableSettings) {
                JSONObject condition = new JSONObject(setting);
                JSONObject result = instance.insertOrUpdateIptableSetting(condition, "system");
                Thread.sleep(sleepDuration);
            }
            try {
                IptablesManager.getInstance().applyButtonAction("system");
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.debug("Error : " + e);
                FileBasedLogger.error("Network", "Error while Default Configuration Of IpTable : " + e.getLocalizedMessage(), "system");
            }
        }
        catch (Exception e) {
            logger.debug("Error : " + e);
            FileBasedLogger.error("Network", "Error while Default Configuration Of IpTable : " + e.getLocalizedMessage(), "system");
            e.printStackTrace();
        }
    }

    private static void insertGenralSettings() {
        try {
            JSONObject jsonLan0 = new JSONObject();
            jsonLan0.put("input", "DROP");
            jsonLan0.put("rule_drop", "ON");
            jsonLan0.put("interface", "lan0");
            instance.insertGeneralSetting(jsonLan0, 1, "system");
            Thread.sleep(500L);
            JSONObject jsonLan1 = new JSONObject();
            jsonLan1.put("input", "DROP");
            jsonLan1.put("rule_drop", "ON");
            jsonLan1.put("interface", "lan1");
            instance.insertGeneralSetting(jsonLan1, 2, "system");
            Thread.sleep(500L);
            JSONObject jsonLan3 = new JSONObject();
            jsonLan3.put("input", "DROP");
            jsonLan3.put("rule_drop", "ON");
            jsonLan3.put("interface", "lan2");
            instance.insertGeneralSetting(jsonLan3, 3, "system");
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.debug("Error while inserting ip table genral settings : " + e);
            FileBasedLogger.error("Application", "Error while inserting ip table genral settings : " + e, "system");
        }
    }

    static {
        configInstance = ConfigClass.getInstance();
    }
}

