/*
 * Decompiled with CFR 0.152.
 */
package com.digitalpetri.strictmachine;

import com.digitalpetri.strictmachine.Fsm;
import com.digitalpetri.strictmachine.FsmContext;
import com.digitalpetri.strictmachine.dsl.ActionContext;
import com.digitalpetri.strictmachine.dsl.ActionProxy;
import com.digitalpetri.strictmachine.dsl.Transition;
import com.digitalpetri.strictmachine.dsl.TransitionAction;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.MDC;

public class StrictMachine<S, E>
implements Fsm<S, E> {
    private static final AtomicLong INSTANCE_ID = new AtomicLong(0L);
    private final long instanceId = INSTANCE_ID.getAndIncrement();
    private volatile boolean pollExecuted = false;
    private final Object queueLock = new Object();
    private final ArrayDeque<PendingEvent> eventQueue = new ArrayDeque();
    private final ArrayDeque<PendingEvent> eventShelf = new ArrayDeque();
    private final ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock(true);
    private final Map<FsmContext.Key<?>, Object> contextValues = new ConcurrentHashMap();
    private final AtomicReference<S> state = new AtomicReference();
    private final Logger logger;
    private final Map<String, String> mdc;
    private final Executor executor;
    private final ActionProxy<S, E> actionProxy;
    private final List<Transition<S, E>> transitions;
    private final List<TransitionAction<S, E>> transitionActions;
    private static final int PADDING = 24;

    public StrictMachine(Logger logger, Executor executor, ActionProxy<S, E> actionProxy, S initialState, List<Transition<S, E>> transitions, List<TransitionAction<S, E>> transitionActions) {
        this(logger, Collections.emptyMap(), executor, actionProxy, initialState, transitions, transitionActions);
    }

    public StrictMachine(Logger logger, Map<String, String> mdc, Executor executor, ActionProxy<S, E> actionProxy, S initialState, List<Transition<S, E>> transitions, List<TransitionAction<S, E>> transitionActions) {
        this.logger = logger;
        this.mdc = mdc;
        this.executor = executor;
        this.actionProxy = actionProxy;
        this.transitions = transitions;
        this.transitionActions = transitionActions;
        this.state.set(initialState);
    }

    @Override
    public S getState() {
        try {
            this.readWriteLock.readLock().lock();
            S s = this.state.get();
            return s;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    @Override
    public void fireEvent(E event) {
        this.fireEvent(event, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fireEvent(E event, Consumer<S> stateConsumer) {
        Object object = this.queueLock;
        synchronized (object) {
            this.eventQueue.add(new PendingEvent(event, stateConsumer));
            this.maybeExecutePoll();
        }
    }

    @Override
    public S fireEventBlocking(E event) throws InterruptedException {
        LinkedTransferQueue transferQueue = new LinkedTransferQueue();
        this.fireEvent(event, transferQueue::put);
        return (S)transferQueue.take();
    }

    @Override
    public <T> T getFromContext(Function<FsmContext<S, E>, T> get) {
        try {
            this.readWriteLock.writeLock().lock();
            T t = get.apply(new FsmContextImpl());
            return t;
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeExecutePoll() {
        Object object = this.queueLock;
        synchronized (object) {
            if (!this.pollExecuted && !this.eventQueue.isEmpty()) {
                this.executor.execute(new PollAndEvaluate());
                this.pollExecuted = true;
            }
        }
    }

    private static String padRight(String s) {
        return String.format("%1$-24s", s);
    }

    private class ActionContextImpl
    extends FsmContextImpl
    implements ActionContext<S, E> {
        private final S from;
        private final S to;
        private final E event;

        ActionContextImpl(S from, S to, E event) {
            this.from = from;
            this.to = to;
            this.event = event;
        }

        @Override
        public S from() {
            return this.from;
        }

        @Override
        public S to() {
            return this.to;
        }

        @Override
        public E event() {
            return this.event;
        }
    }

    private class FsmContextImpl
    implements FsmContext<S, E> {
        private FsmContextImpl() {
        }

        @Override
        public S currentState() {
            return StrictMachine.this.getState();
        }

        @Override
        public void fireEvent(E event) {
            StrictMachine.this.fireEvent(event);
        }

        @Override
        public void shelveEvent(E event) {
            try {
                StrictMachine.this.readWriteLock.writeLock().lock();
                StrictMachine.this.eventShelf.add(new PendingEvent(event, s -> {}));
            }
            finally {
                StrictMachine.this.readWriteLock.writeLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void processShelvedEvents() {
            try {
                StrictMachine.this.readWriteLock.writeLock().lock();
                Object object = StrictMachine.this.queueLock;
                synchronized (object) {
                    while (!StrictMachine.this.eventShelf.isEmpty()) {
                        StrictMachine.this.eventQueue.addFirst(StrictMachine.this.eventShelf.removeLast());
                    }
                    StrictMachine.this.maybeExecutePoll();
                }
            }
            finally {
                StrictMachine.this.readWriteLock.writeLock().unlock();
            }
        }

        @Override
        public Object get(FsmContext.Key<?> key) {
            try {
                StrictMachine.this.readWriteLock.readLock().lock();
                Object v = StrictMachine.this.contextValues.get(key);
                return v;
            }
            finally {
                StrictMachine.this.readWriteLock.readLock().unlock();
            }
        }

        @Override
        public Object remove(FsmContext.Key<?> key) {
            try {
                StrictMachine.this.readWriteLock.writeLock().lock();
                Object v = StrictMachine.this.contextValues.remove(key);
                return v;
            }
            finally {
                StrictMachine.this.readWriteLock.writeLock().unlock();
            }
        }

        @Override
        public void set(FsmContext.Key<?> key, Object value) {
            try {
                StrictMachine.this.readWriteLock.writeLock().lock();
                StrictMachine.this.contextValues.put(key, value);
            }
            finally {
                StrictMachine.this.readWriteLock.writeLock().unlock();
            }
        }

        @Override
        public long getInstanceId() {
            return StrictMachine.this.instanceId;
        }
    }

    private class PollAndEvaluate
    implements Runnable {
        private PollAndEvaluate() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            PendingEvent pending;
            Object object = StrictMachine.this.queueLock;
            synchronized (object) {
                pending = (PendingEvent)StrictMachine.this.eventQueue.poll();
                if (pending == null) {
                    return;
                }
            }
            Object event = pending.event;
            try {
                Object currState;
                StrictMachine.this.readWriteLock.writeLock().lock();
                Object nextState = currState = StrictMachine.this.state.get();
                FsmContextImpl ctx = new FsmContextImpl();
                for (Transition transition : StrictMachine.this.transitions) {
                    if (!transition.matches(ctx, currState, event)) continue;
                    nextState = transition.target();
                    break;
                }
                StrictMachine.this.state.set(nextState);
                if (StrictMachine.this.logger.isDebugEnabled()) {
                    StrictMachine.this.mdc.forEach(MDC::put);
                    try {
                        StrictMachine.this.logger.debug("[{}] {} x {} = {}", StrictMachine.this.instanceId, StrictMachine.padRight(String.format("S(%s)", currState)), StrictMachine.padRight(String.format("E(%s)", event)), StrictMachine.padRight(String.format("S'(%s)", nextState)));
                    }
                    finally {
                        StrictMachine.this.mdc.keySet().forEach(MDC::remove);
                    }
                }
                ActionContextImpl actionContext = new ActionContextImpl(currState, nextState, event);
                ArrayList<TransitionAction> matchingActions = new ArrayList<TransitionAction>();
                for (TransitionAction transitionAction2 : StrictMachine.this.transitionActions) {
                    if (!transitionAction2.matches(currState, nextState, event)) continue;
                    matchingActions.add(transitionAction2);
                }
                if (StrictMachine.this.logger.isTraceEnabled()) {
                    StrictMachine.this.mdc.forEach(MDC::put);
                    try {
                        StrictMachine.this.logger.trace("[{}] found {} matching TransitionActions", (Object)StrictMachine.this.instanceId, (Object)matchingActions.size());
                    }
                    finally {
                        StrictMachine.this.mdc.keySet().forEach(MDC::remove);
                    }
                }
                matchingActions.forEach(transitionAction -> {
                    block15: {
                        try {
                            if (StrictMachine.this.actionProxy == null) {
                                if (StrictMachine.this.logger.isTraceEnabled()) {
                                    StrictMachine.this.mdc.forEach(MDC::put);
                                    try {
                                        StrictMachine.this.logger.trace("[{}] executing TransitionAction: {}", (Object)StrictMachine.this.instanceId, transitionAction);
                                    }
                                    finally {
                                        StrictMachine.this.mdc.keySet().forEach(MDC::remove);
                                    }
                                }
                                transitionAction.execute(actionContext);
                                break block15;
                            }
                            if (StrictMachine.this.logger.isTraceEnabled()) {
                                StrictMachine.this.mdc.forEach(MDC::put);
                                try {
                                    StrictMachine.this.logger.trace("[{}] executing (via proxy) TransitionAction: {}", (Object)StrictMachine.this.instanceId, transitionAction);
                                }
                                finally {
                                    StrictMachine.this.mdc.keySet().forEach(MDC::remove);
                                }
                            }
                            StrictMachine.this.actionProxy.execute(actionContext, transitionAction::execute);
                        }
                        catch (Throwable ex) {
                            StrictMachine.this.mdc.forEach(MDC::put);
                            try {
                                StrictMachine.this.logger.warn("[{}] Uncaught Throwable executing TransitionAction: {}", StrictMachine.this.instanceId, transitionAction, ex);
                            }
                            finally {
                                StrictMachine.this.mdc.keySet().forEach(MDC::remove);
                            }
                        }
                    }
                });
            }
            finally {
                StrictMachine.this.readWriteLock.writeLock().unlock();
            }
            if (pending.stateConsumer != null) {
                pending.stateConsumer.accept(StrictMachine.this.state.get());
            }
            Object object2 = StrictMachine.this.queueLock;
            synchronized (object2) {
                if (StrictMachine.this.eventQueue.isEmpty()) {
                    StrictMachine.this.pollExecuted = false;
                } else {
                    StrictMachine.this.executor.execute(new PollAndEvaluate());
                }
            }
        }
    }

    private class PendingEvent {
        final E event;
        final Consumer<S> stateConsumer;

        PendingEvent(E event, Consumer<S> stateConsumer) {
            this.event = event;
            this.stateConsumer = stateConsumer;
        }
    }
}

